/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.Cursor;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhoodCursor;
import net.imglib2.algorithm.region.localneighborhood.Utils;

public class EllipsoidCursor<T>
extends AbstractNeighborhoodCursor<T> {
    private CursorState state;
    private CursorState nextState;
    private boolean mirrorZ;
    private int rx;
    private int ry;
    private int[] rys;
    private int[] rxs;
    private boolean doneZ = false;
    private boolean allDone;
    private boolean hasNext;
    protected int[] position;
    private final int smallAxisdim;
    private final int largeAxisDim;

    public EllipsoidCursor(AbstractNeighborhood<T> ellipsoid) {
        super(ellipsoid);
        if (ellipsoid.span[1] < ellipsoid.span[0]) {
            this.smallAxisdim = 1;
            this.largeAxisDim = 0;
        } else {
            this.smallAxisdim = 0;
            this.largeAxisDim = 1;
        }
        this.rxs = new int[(int)(ellipsoid.span[this.largeAxisDim] + 1L)];
        this.rys = new int[(int)(ellipsoid.span[2] + 1L)];
        this.reset();
    }

    public void reset() {
        this.ra.setPosition(this.neighborhood.center);
        this.state = CursorState.INITIALIZED;
        this.mirrorZ = false;
        this.doneZ = false;
        this.allDone = false;
        this.position = new int[this.numDimensions()];
        this.hasNext = true;
    }

    public void fwd() {
        switch (this.state) {
            case DRAWING_LINE: {
                this.ra.fwd(this.smallAxisdim);
                int n = this.smallAxisdim;
                this.position[n] = this.position[n] + 1;
                if (this.position[this.smallAxisdim] < this.rx) break;
                this.state = this.nextState;
                if (!this.allDone && this.ry != 0) break;
                this.hasNext = false;
                break;
            }
            case INITIALIZED: {
                Utils.getXYEllipseBounds((int)this.neighborhood.span[this.largeAxisDim], (int)this.neighborhood.span[2], this.rys);
                this.ry = this.rys[0];
                Utils.getXYEllipseBounds((int)this.neighborhood.span[this.smallAxisdim], (int)this.neighborhood.span[this.largeAxisDim], this.rxs);
                this.rx = this.rxs[0];
                this.ra.setPosition(this.neighborhood.center[this.smallAxisdim] - (long)this.rx, this.smallAxisdim);
                this.ra.setPosition(this.neighborhood.center[this.largeAxisDim], this.largeAxisDim);
                this.ra.setPosition(this.neighborhood.center[2], 2);
                this.position[this.smallAxisdim] = -this.rx;
                this.state = this.rx > 0 ? CursorState.DRAWING_LINE : CursorState.INCREMENT_Y;
                this.nextState = CursorState.INCREMENT_Y;
                break;
            }
            case INCREMENT_Y: {
                this.position[this.largeAxisDim] = -this.position[this.largeAxisDim] + 1;
                this.rx = this.rxs[this.position[this.largeAxisDim]];
                this.ra.setPosition(this.neighborhood.center[this.largeAxisDim] + (long)this.position[this.largeAxisDim], this.largeAxisDim);
                this.position[this.smallAxisdim] = -this.rx;
                this.ra.setPosition(this.neighborhood.center[this.smallAxisdim] - (long)this.rx, this.smallAxisdim);
                this.nextState = CursorState.MIRROR_Y;
                if (this.rx == 0) {
                    this.state = CursorState.MIRROR_Y;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
                break;
            }
            case MIRROR_Y: {
                this.position[this.smallAxisdim] = -this.rx;
                this.position[this.largeAxisDim] = -this.position[this.largeAxisDim];
                this.ra.setPosition(this.neighborhood.center[this.largeAxisDim] + (long)this.position[this.largeAxisDim], this.largeAxisDim);
                this.ra.setPosition(this.neighborhood.center[this.smallAxisdim] - (long)this.rx, this.smallAxisdim);
                if (this.position[this.largeAxisDim] <= -this.ry) {
                    if (this.doneZ) {
                        this.allDone = true;
                    } else if (this.neighborhood.span[2] > 0L) {
                        this.nextState = CursorState.INCREMENT_Z;
                    } else {
                        this.allDone = true;
                    }
                } else {
                    this.nextState = CursorState.INCREMENT_Y;
                }
                if (this.rx == 0) {
                    if (this.allDone) {
                        this.hasNext = false;
                        break;
                    }
                    this.state = this.nextState;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
                break;
            }
            case INCREMENT_Z: {
                if (this.mirrorZ) {
                    this.position[2] = -this.position[2];
                    this.mirrorZ = false;
                    if ((long)this.position[2] <= -this.neighborhood.span[2]) {
                        this.doneZ = true;
                    }
                } else {
                    this.position[2] = -this.position[2] + 1;
                    this.ry = this.rys[this.position[2]];
                    this.mirrorZ = true;
                }
                Utils.getXYEllipseBounds(Math.round((float)this.ry * (float)this.neighborhood.span[this.smallAxisdim] / (float)this.neighborhood.span[this.largeAxisDim]), this.ry, this.rxs);
                this.rx = this.rxs[0];
                this.ra.setPosition(this.neighborhood.center[this.smallAxisdim] - (long)this.rx, this.smallAxisdim);
                this.ra.setPosition(this.neighborhood.center[this.largeAxisDim], this.largeAxisDim);
                this.ra.setPosition(this.neighborhood.center[2] + (long)this.position[2], 2);
                this.position[this.smallAxisdim] = -this.rx;
                this.position[this.largeAxisDim] = 0;
                if (this.rx == 0) {
                    this.state = CursorState.INCREMENT_Y;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
                this.nextState = CursorState.INCREMENT_Y;
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Cursor<T> copy() {
        return new EllipsoidCursor<T>(this.neighborhood);
    }

    @Override
    public void jumpFwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    @Override
    public T next() {
        this.fwd();
        return this.get();
    }

    public int[] getRelativePosition() {
        return this.position;
    }

    public double getTheta() {
        return Math.acos((double)this.position[2] / this.getDistanceSquared());
    }

    public double getPhi() {
        return Math.atan2(this.position[1], this.position[0]);
    }

    public double getDistanceSquared() {
        double sum = 0.0;
        for (int i = 0; i < this.position.length; ++i) {
            sum += (double)(this.position[i] * this.position[i]);
        }
        return sum;
    }

    private static enum CursorState {
        DRAWING_LINE,
        INITIALIZED,
        INCREMENT_Y,
        MIRROR_Y,
        INCREMENT_Z;

    }
}

