/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import adt.Byte3DArray;
import adt.ByteProbability;
import adt.Sparse3DByteArray;
import adt.Unsparse3DByteArray;
import amira.AmiraMeshDecoder;
import amira.AmiraTable;
import ij.ImagePlus;
import ij.io.FileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oldsegmenters.SegmentatorModel;

public abstract class AutoLabeller {
    HashMap<Byte, LabelStats> stats = new LinkedHashMap<Byte, LabelStats>();
    byte[][] intensityProbabilities;
    final int labelCount;
    byte[] labelIds;
    int xMin = Integer.MAX_VALUE;
    int xMax = Integer.MIN_VALUE;
    int yMin = Integer.MAX_VALUE;
    int yMax = Integer.MIN_VALUE;
    int zMin = Integer.MAX_VALUE;
    int zMax = Integer.MIN_VALUE;

    public AutoLabeller(String summeryLocation) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(summeryLocation));
        String line = in.readLine();
        TreeSet<LabelStats> orderedSet = new TreeSet<LabelStats>();
        while (line != null) {
            LabelStats labelStats = this.readStats(line);
            orderedSet.add(labelStats);
            System.out.println("loaded " + labelStats.toString());
            line = in.readLine();
        }
        in.close();
        this.labelIds = new byte[orderedSet.size()];
        this.labelCount = this.labelIds.length;
        int index = 0;
        for (LabelStats labelStats : orderedSet) {
            System.out.println("adding " + labelStats);
            this.stats.put(labelStats.id, labelStats);
            this.labelIds[index++] = labelStats.id;
        }
        System.out.println("summary file read");
        this.calculateLabelGivenIntensityProbabilites();
        System.out.flush();
    }

    private void calculateLabelGivenIntensityProbabilites() {
        this.intensityProbabilities = new byte[256][this.labelCount];
        double[][] precicionCalc = new double[256][this.labelCount];
        for (int i = 0; i < 256; ++i) {
            LabelStats stat;
            int j;
            byte pixelIntensity = ByteProbability.INTEGER_TO_BYTE[i];
            double total = 0.0;
            double totalVolume = 0.0;
            StringBuffer buf = new StringBuffer("intesity = ").append(i).append(" ");
            for (int j2 = 0; j2 < this.labelCount; ++j2) {
                LabelStats stat2 = this.stats.get(this.labelIds[j2]);
                precicionCalc[i][j2] = stat2.getPixelProb(pixelIntensity);
                total += precicionCalc[i][j2];
                totalVolume += stat2.volumeMean;
            }
            double total2 = 0.0;
            for (j = 0; j < this.intensityProbabilities[i].length; ++j) {
                stat = this.stats.get(this.labelIds[j]);
                precicionCalc[i][j] = precicionCalc[i][j] / total;
                total2 += precicionCalc[i][j];
            }
            for (j = 0; j < this.intensityProbabilities[i].length; ++j) {
                stat = this.stats.get(this.labelIds[j]);
                double[] dArray = precicionCalc[i];
                int n = j;
                dArray[n] = dArray[n] / total2;
                this.intensityProbabilities[i][j] = ByteProbability.toByte(precicionCalc[i][j]);
                buf.append(this.intensityProbabilities[i][j]).append(" ");
            }
            System.out.println(buf);
        }
    }

    public byte[] getIntensityProbs(byte pixel) {
        return this.intensityProbabilities[pixel & 0xFF];
    }

    public byte[] getSpatialProbs(int x, int y, int z) {
        byte[] ret = new byte[this.labelCount];
        for (int i = 0; i < this.labelCount; ++i) {
            byte id = this.labelIds[i];
            LabelStats stat = this.stats.get(id);
            ret[i] = stat.spatialDistribution.get(x, y, z);
        }
        return ret;
    }

    private LabelStats readStats(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, "\t", false);
        LabelStats ret = new LabelStats();
        ret.id = Byte.parseByte(tokenizer.nextToken());
        ret.name = tokenizer.nextToken();
        ret.volumeMean = Double.parseDouble(tokenizer.nextToken());
        ret.volumeVariance = Double.parseDouble(tokenizer.nextToken());
        for (int i = 0; i < 256; ++i) {
            ret.pixelProb[i] = Double.parseDouble(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            String filename = tokenizer.nextToken();
            ImagePlus imagePlus = new ImagePlus();
            AmiraMeshDecoder d = new AmiraMeshDecoder();
            if (d.open(filename)) {
                if (d.isTable()) {
                    AmiraTable amiraTable = d.getTable();
                } else {
                    FileInfo fi = new FileInfo();
                    File file = new File(filename);
                    fi.fileName = file.getName();
                    fi.directory = file.getParent();
                    imagePlus.setFileInfo(fi);
                    imagePlus.setStack(filename, d.getStack());
                    d.parameters.setParameters(imagePlus);
                }
            }
            Byte3DArray pd = ret.id != 0 ? new Sparse3DByteArray() : new Unsparse3DByteArray(imagePlus.getWidth(), imagePlus.getHeight(), imagePlus.getStackSize());
            int width = imagePlus.getWidth();
            for (int z = 1; z <= imagePlus.getStackSize(); ++z) {
                byte[] pixels = (byte[])imagePlus.getStack().getProcessor(z).getPixels();
                for (int i = 0; i < pixels.length; ++i) {
                    byte pixel = pixels[i];
                    if (pixel == 0) continue;
                    pd.put(i % width, i / width, z, pixel);
                }
            }
            ret.spatialDistribution = pd;
            if (ret.id != 0) {
                this.xMin = Math.min(pd.getxMin(), this.xMin);
                this.xMax = Math.max(pd.getxMax(), this.xMax);
                this.yMin = Math.min(pd.getyMin(), this.yMin);
                this.yMax = Math.max(pd.getyMax(), this.yMax);
                this.zMin = Math.min(pd.getzMin(), this.zMin);
                this.zMax = Math.max(pd.getzMax(), this.zMax);
            }
            imagePlus.close();
        }
        return ret;
    }

    public abstract void segment(SegmentatorModel var1);

    public class LabelStats
    implements Comparable {
        byte id;
        String name;
        double volumeMean;
        double volumeVariance;
        Byte3DArray spatialDistribution;
        double[] pixelProb = new double[256];

        public double getPixelProb(byte pixel) {
            return this.pixelProb[pixel & 0xFF];
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.name).append(" ");
            buf.append(this.id & 0xFF).append(" ");
            buf.append("[");
            buf.append(this.spatialDistribution.getxMin()).append(", ");
            buf.append(this.spatialDistribution.getxMax()).append(", ");
            buf.append(this.spatialDistribution.getyMin()).append(", ");
            buf.append(this.spatialDistribution.getyMax()).append(", ");
            buf.append(this.spatialDistribution.getzMin()).append(", ");
            buf.append(this.spatialDistribution.getzMax()).append("]");
            return buf.toString();
        }

        public int compareTo(Object o) {
            return ((LabelStats)o).id < this.id ? 1 : -1;
        }
    }
}

