/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.reconstruct;

import edu.utexas.clm.reconstructreader.Utils;
import edu.utexas.clm.reconstructreader.reconstruct.ContourSet;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructSection;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructTranslator;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class ReconstructZTrace
implements ContourSet {
    private final int oid;
    private final String name;
    private final ArrayList<Element> polyLineList;
    private final ArrayList<Integer> polyLineOIDList;
    private final ArrayList<Integer> polyLineIDList;
    private final ReconstructTranslator translator;

    public ReconstructZTrace(Element e, ReconstructTranslator t) {
        this.translator = t;
        this.oid = this.translator.nextOID();
        this.name = e.getAttribute("name");
        this.polyLineList = new ArrayList();
        this.polyLineOIDList = new ArrayList();
        this.polyLineIDList = new ArrayList();
        this.addContour(e, null);
    }

    public void appendProjectXML(StringBuilder sb) {
        sb.append("<reconstruct_ztrace id=\"").append(this.oid).append("\" title=\"").append(this.name).append("\" expanded=\"true\">\n");
        for (int i = 0; i < this.polyLineList.size(); ++i) {
            sb.append("<polyline id=\"").append(this.polyLineIDList.get(i)).append("\" oid=\"").append(this.polyLineOIDList.get(i)).append("\"/>\n");
        }
        sb.append("</reconstruct_ztrace>\n");
    }

    public void appendXML(StringBuilder sb) {
        for (int i = 0; i < this.polyLineList.size(); ++i) {
            int j;
            Element e = this.polyLineList.get(i);
            double[] pts3D = Utils.createNodeValueVector(e.getAttribute("points"));
            double mag = this.translator.getMag();
            int n = Utils.nodeValueToVector(e.getAttribute("points"), pts3D);
            String hexColor = Utils.hexColor(e.getAttribute("border"));
            if (n != 3) {
                this.translator.log("While processing Z-Traces, expected n = 3, but n = " + n);
            }
            int[] layerID = new int[pts3D.length / n];
            double[] pts2D = new double[layerID.length * 2];
            for (j = 0; j < layerID.length; ++j) {
                pts2D[j * 2] = pts3D[j * n];
                pts2D[j * 2 + 1] = pts3D[j * n + 1];
                layerID[j] = (int)pts3D[j * n + 2];
            }
            j = 0;
            while (j < pts2D.length) {
                int n2 = j++;
                pts2D[n2] = pts2D[n2] / mag;
            }
            double[] wh = Utils.getPathExtent(pts2D);
            sb.append("<t2_polyline\noid=\"").append(this.polyLineOIDList.get(i)).append("\"\nwidth=\"").append(wh[0]).append("\"\nheight=\"").append(wh[1]).append("\"\ntransform=\"matrix(1.0,0.0,0.0,1.0,0.0,0.0)\"\ntitle=\"").append(this.name).append("\"\nlinks=\"\"\nlayer_set_id=\"").append(this.translator.getLayerSetOID()).append("\"\nstyle=\"fill:none;stroke-opacity:1.0;stroke:#").append(hexColor).append(";stroke-width:1.0px;stroke-opacity:1.0\"\nd=\"");
            Utils.appendOpenPathXML(sb, pts2D);
            sb.append("\"\nlayer_ids=\"");
            for (int id : layerID) {
                sb.append(this.translator.layerIndexToOID(id)).append(",");
            }
            sb.append("\"\n>\n</t2_polyline>\n");
        }
    }

    @Override
    public void addContour(Element e, ReconstructSection sec) {
        this.polyLineList.add(e);
        this.polyLineOIDList.add(this.translator.nextOID());
        this.polyLineIDList.add(this.translator.nextOID());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

