/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.path.Path;

public class NegativeExpression
implements Expression {
    private Expression value;

    public NegativeExpression(Expression value) {
        this.value = value;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        this.value.apply(scope, in, v -> {
            if (!v.isNumber()) {
                throw new JsonQueryTypeException("%s cannot be negated", in);
            }
            output.emit(JsonNodeUtils.asNumericNode(-v.asDouble()), null);
        });
    }

    public String toString() {
        return "-(" + this.value.toString() + ")";
    }
}

