/*
 * Decompiled with CFR 0.152.
 */
package ij3d.gui;

import customnode.CustomTriangleMesh;
import customnode.EdgeContraction;
import customnode.FullInfoMesh;
import ij.IJ;
import ij.gui.GenericDialog;
import java.awt.Button;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

public class InteractiveMeshDecimation {
    public void run(final CustomTriangleMesh ctm) {
        final FullInfoMesh fim = new FullInfoMesh(ctm.getMesh());
        final EdgeContraction ec = new EdgeContraction(fim, false);
        final GenericDialog gd = new GenericDialog("Mesh simplification"){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    super.keyPressed(e);
                }
            }
        };
        gd.addNumericField("Contract next n edges", 100.0, 0);
        final TextField tf = (TextField)gd.getNumericFields().get(0);
        gd.addMessage(ec.getVertexCount() + " remaining vertices");
        final Label label = (Label)gd.getMessage();
        gd.setModal(false);
        gd.showDialog();
        Button[] buttons = gd.getButtons();
        buttons[0].setLabel("Simplify");
        buttons[0].removeActionListener((ActionListener)gd);
        buttons[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int n = Integer.parseInt(tf.getText());
                gd.setEnabled(false);
                new Thread(){

                    @Override
                    public void run() {
                        int v = InteractiveMeshDecimation.this.simplify(ec, n);
                        gd.setEnabled(true);
                        ctm.setMesh(fim.getMesh());
                        label.setText(v + " remaining vertices");
                    }
                }.start();
            }
        });
        buttons[1].setLabel("Ok");
        buttons[1].removeActionListener((ActionListener)gd);
        buttons[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gd.dispose();
            }
        });
    }

    private int simplify(EdgeContraction ec, int n) {
        int part = n / 10;
        int last = n % 10;
        int ret = 0;
        for (int i = 0; i < 10; ++i) {
            IJ.showProgress((int)(i + 1), (int)10);
            ret = ec.removeNext(part);
        }
        if (last != 0) {
            ret = ec.removeNext(last);
        }
        IJ.showProgress((double)1.0);
        return ret;
    }
}

