/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.archipelago.image;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.SerializableCallable;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ImageBlockDeblock
implements Serializable {
    private final File inputFile;
    private final File outputFile;
    private final ArrayList<File> blockFiles;
    private final ArrayList<int[]> boxMap;
    private final int[] blockSize;
    private final int[] halfOverlap;
    private final int[] ovlpCorrection;
    private final ArrayList<Hashtable<File, File>> chunkMaps;
    private final int n;
    private int w = -1;
    private int h = -1;
    private final ImageBlockDeblock self;
    private String subfolder;

    public ImageBlockDeblock(File inFile, File outFile, int[] bs, int[] o) {
        this(inFile, outFile, bs, o, 1);
    }

    public ImageBlockDeblock(File inFile, File outFileFormat, int[] bs, int[] o, int nOutput) {
        this.n = nOutput;
        this.inputFile = new File(inFile.getAbsolutePath());
        this.outputFile = outFileFormat;
        this.blockSize = bs;
        this.blockFiles = new ArrayList();
        this.boxMap = new ArrayList();
        this.chunkMaps = new ArrayList(nOutput);
        this.halfOverlap = new int[2];
        this.ovlpCorrection = new int[2];
        this.halfOverlap[0] = o[0] / 2;
        this.halfOverlap[1] = o[1] / 2;
        this.ovlpCorrection[0] = 2 * this.halfOverlap[0] == o[0] ? 0 : 1;
        this.ovlpCorrection[1] = 2 * this.halfOverlap[1] == o[1] ? 0 : 1;
        this.self = this;
        this.subfolder = "blocks/";
        for (int i = 0; i < nOutput; ++i) {
            this.chunkMaps.add(new Hashtable());
        }
    }

    public ArrayList<File> blockFile() throws ExecutionException, InterruptedException {
        FijiArchipelago.debug("Splitting image " + this.inputFile + " into blocks");
        ImageProcessor ip = IJ.openImage((String)this.inputFile.getAbsolutePath()).getProcessor();
        this.w = ip.getWidth();
        this.h = ip.getHeight();
        int cblock = (int)Math.ceil((float)this.w / (float)this.blockSize[0]);
        int rblock = (int)Math.ceil((float)this.h / (float)this.blockSize[1]);
        if (rblock <= 1 && cblock <= 1) {
            this.blockFiles.add(this.inputFile);
        } else {
            ExecutorService localService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            int[][] pix = ip.getIntArray();
            ArrayList<Future<File>> futures = new ArrayList<Future<File>>();
            for (int c = 0; c < cblock; ++c) {
                for (int i = 0; i < rblock; ++i) {
                    int x0 = c * this.blockSize[0];
                    int x1 = Math.min(this.w, x0 + this.blockSize[0]);
                    int xo0 = Math.max(0, x0 - this.halfOverlap[0]);
                    int xo1 = Math.min(this.w, x1 + this.halfOverlap[0] + this.ovlpCorrection[0]);
                    int y0 = i * this.blockSize[1];
                    int y1 = Math.min(this.h, y0 + this.blockSize[1]);
                    int yo0 = Math.max(0, y0 - this.halfOverlap[1]);
                    int yo1 = Math.min(this.h, y1 + this.halfOverlap[1] + this.ovlpCorrection[1]);
                    this.boxMap.add(new int[]{x0, y0, x0 - xo0, y0 - yo0, x1 - x0, y1 - y0});
                    futures.add(localService.submit(new BlockCallable(xo0, xo1, yo0, yo1, pix, ip, this.inputFile)));
                }
            }
            for (Future future : futures) {
                File file = (File)future.get();
                this.blockFiles.add(file);
            }
        }
        FijiArchipelago.debug("Done with image " + this.inputFile);
        return this.blockFiles;
    }

    public File deblockFile(int idx) throws ExecutionException {
        if (this.blockFiles.isEmpty()) {
            throw new ExecutionException(new Exception("There are no blockfiles to combine. Have you run blockFiles() yet?"));
        }
        if (idx >= this.n) {
            throw new ExecutionException(this.badIndexException(idx));
        }
        if (this.blockFiles.size() == 1) {
            ImagePlus imp = IJ.openImage((String)this.getFileOrException(idx, 0).getAbsolutePath());
            IJ.save((ImagePlus)imp, (String)this.getOutputFileName(idx));
        } else {
            ImageProcessor blockIpZero = this.getFirstSliceIP(this.getFileOrException(idx, 0).getAbsolutePath());
            ImageProcessor ipOut = blockIpZero.createProcessor(this.w, this.h);
            int[][] pix = new int[this.w][this.h];
            for (int i = 0; i < this.blockFiles.size(); ++i) {
                File outChunkFile = this.getFileOrException(idx, i);
                int[] bmap = this.boxMap.get(i);
                ImageProcessor blockIp = i == 0 ? blockIpZero : this.getFirstSliceIP(outChunkFile.getAbsolutePath());
                int[][] blockPix = blockIp.getIntArray();
                for (int x = 0; x < bmap[4]; ++x) {
                    for (int y = 0; y < bmap[5]; ++y) {
                        pix[x + bmap[0]][y + bmap[1]] = blockPix[x + bmap[2]][y + bmap[3]];
                    }
                }
            }
            ipOut.setIntArray(pix);
            IJ.save((ImagePlus)new ImagePlus(this.getOutputFileName(idx), ipOut), (String)this.getOutputFileName(idx));
        }
        return this.outputFile;
    }

    public void mapChunks(File origChunk, File newChunk) {
        this.mapChunks(origChunk, newChunk, 0);
    }

    public void mapChunks(File origChunk, File newChunk, int idx) {
        this.checkIdx(idx);
        if (this.blockFiles.contains(origChunk)) {
            Hashtable<File, File> chunkTable = this.getTable(idx);
            chunkTable.put(origChunk, newChunk);
            FijiArchipelago.debug("Map " + idx + " " + origChunk + " <-> " + newChunk);
        }
    }

    public void setSubfolder(String folder) {
        this.subfolder = folder;
        if (!this.subfolder.isEmpty() && !this.subfolder.endsWith("/")) {
            this.subfolder = this.subfolder + "/";
        }
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getOutputFile(int idx) {
        return new File(this.getOutputFileName(idx));
    }

    public String getOutputFileName(int idx) {
        return String.format(this.outputFile.getAbsolutePath(), idx);
    }

    public Callable<ImageBlockDeblock> imageBlockCallable() {
        return new SerializableCallable<ImageBlockDeblock>(){

            @Override
            public ImageBlockDeblock call() throws Exception {
                ImageBlockDeblock.this.blockFile();
                return ImageBlockDeblock.this.self;
            }
        };
    }

    public Callable<ImageBlockDeblock> imageDeblockCallable() {
        return new SerializableCallable<ImageBlockDeblock>(){

            @Override
            public ImageBlockDeblock call() throws Exception {
                for (int i = 0; i < ImageBlockDeblock.this.chunkMaps.size(); ++i) {
                    ImageBlockDeblock.this.deblockFile(i);
                }
                return ImageBlockDeblock.this.self;
            }
        };
    }

    public ArrayList<File> imageBlockFiles() {
        return new ArrayList<File>(this.blockFiles);
    }

    public int numUnmappedBlocks() {
        return this.numUnmappedBlocks(0);
    }

    public int numUnmappedBlocks(int idx) {
        return this.blockFiles.size() - this.chunkMaps.get(idx).size();
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getNumOutput() {
        return this.chunkMaps.size();
    }

    private Hashtable<File, File> getTable(int idx) {
        return this.chunkMaps.get(idx);
    }

    private File getFile(int idx, int fileIdx) {
        return this.getTable(idx).get(this.blockFiles.get(fileIdx));
    }

    private File getFileOrException(int idx, int fileIdx) throws ExecutionException {
        File fc = this.getFile(idx, fileIdx);
        if (fc == null) {
            throw new ExecutionException(new Exception("No file " + fileIdx + " for index " + idx));
        }
        return fc;
    }

    private ImageProcessor getFirstSliceIP(String filename) {
        ImagePlus imp = IJ.openImage((String)filename);
        ImageStack is = imp.getImageStack();
        ImageProcessor ip = is.getProcessor(1);
        return ip == null ? imp.getProcessor() : ip;
    }

    private void checkIdx(int idx) {
        if (idx >= this.n) {
            throw this.badIndexException(idx);
        }
    }

    private RuntimeException badIndexException(int idx) {
        return new RuntimeException("This ImageBlockDeblock handles " + this.n + " 0-indexed output images. Image " + idx + " was requested.");
    }

    public class BlockCallable
    implements Callable<File> {
        final int[][] pix;
        final int x0;
        final int x1;
        final int y0;
        final int y1;
        final ImageProcessor ip;

        public BlockCallable(int x0, int x1, int y0, int y1, int[][] pix, ImageProcessor ip, File inputFile) {
            this.pix = pix;
            this.x0 = x0;
            this.x1 = x1;
            this.y0 = y0;
            this.y1 = y1;
            this.ip = ip;
        }

        private String blockFilePath(int w, int h, int x, int y) {
            String afterSlashName = ImageBlockDeblock.this.inputFile.getName();
            String directoryName = ImageBlockDeblock.this.inputFile.getParent() + "/";
            String blockDirectoryName = directoryName + ImageBlockDeblock.this.subfolder;
            File blockFolder = new File(blockDirectoryName);
            int lastDot = afterSlashName.lastIndexOf(46);
            String blockName = afterSlashName.substring(0, lastDot) + "_" + w + "x" + h + "_" + x + "_" + y + ".tif";
            if (!(blockFolder.exists() || blockFolder.mkdirs() || blockFolder.exists())) {
                FijiArchipelago.debug("Could not create directory " + blockDirectoryName);
                blockDirectoryName = directoryName;
            }
            return blockDirectoryName + blockName;
        }

        @Override
        public File call() throws Exception {
            int w = this.x1 - this.x0;
            int h = this.y1 - this.y0;
            int[][] pixBlock = new int[w][h];
            ImageProcessor ipBlock = this.ip.createProcessor(w, h);
            String filePath = this.blockFilePath(w, h, this.x0, this.y0);
            File outputFile = new File(filePath);
            if (outputFile.exists() && outputFile.lastModified() > ImageBlockDeblock.this.inputFile.lastModified()) {
                return outputFile;
            }
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    pixBlock[x][y] = this.pix[x + this.x0][y + this.y0];
                }
            }
            ipBlock.setIntArray(pixBlock);
            IJ.save((ImagePlus)new ImagePlus(filePath, ipBlock), (String)filePath);
            if (!new File(filePath).exists()) {
                throw new IOException("Could not write file to " + filePath);
            }
            FijiArchipelago.log("Successfully wrote file " + filePath);
            return outputFile;
        }
    }
}

