/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.FilePatternBlock;
import io.scif.services.FilePatternService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.Location;

public class FilePattern {
    private String pattern;
    private BrowsableLocation baseLoc;
    private boolean valid;
    private String msg;
    private int[] startIndex;
    private int[] endIndex;
    private FilePatternBlock[] blocks;
    private Location[] files;
    private boolean isRegex = false;

    public FilePattern(FilePatternService filePatternService, BrowsableLocation file, DataHandleService dataHandleService) throws IOException {
        this(file, filePatternService.findPattern(file), dataHandleService);
    }

    public FilePattern(FilePatternService filePatternService, BrowsableLocation name, BrowsableLocation dir, DataHandleService dataHandleService) throws IOException {
        this(name, filePatternService.findPattern(name, dir), dataHandleService);
    }

    public FilePattern(BrowsableLocation baseLoc, String pattern, DataHandleService dataHandleService) throws IOException {
        int i;
        this.baseLoc = baseLoc;
        this.pattern = pattern;
        this.valid = false;
        if (pattern == null) {
            this.msg = "Null pattern string.";
            return;
        }
        int len = pattern.length();
        ArrayList<Integer> lt = new ArrayList<Integer>(len);
        ArrayList<Integer> gt = new ArrayList<Integer>(len);
        int left = -1;
        while ((left = pattern.indexOf("<", left + 1)) >= 0) {
            lt.add(left);
        }
        int right = -1;
        while ((right = pattern.indexOf(">", right + 1)) >= 0) {
            gt.add(right);
        }
        int num = lt.size();
        if (num != gt.size()) {
            this.msg = "Mismatched numerical block markers.";
            return;
        }
        this.startIndex = new int[num];
        this.endIndex = new int[num];
        for (i = 0; i < num; ++i) {
            int val = (Integer)lt.get(i);
            if (i > 0 && val < this.endIndex[i - 1]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.startIndex[i] = val;
            val = (Integer)gt.get(i);
            if (val <= this.startIndex[i]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.endIndex[i] = val + 1;
        }
        this.blocks = new FilePatternBlock[num];
        for (i = 0; i < num; ++i) {
            String block = pattern.substring(this.startIndex[i], this.endIndex[i]);
            this.blocks[i] = new FilePatternBlock(block);
        }
        ArrayList<Location> fileList = new ArrayList<Location>();
        this.buildFiles("", num, fileList, dataHandleService);
        this.files = fileList.toArray(new Location[fileList.size()]);
        if (this.files.length == 0) {
            try {
                BrowsableLocation sibling = baseLoc.sibling(pattern);
                if (dataHandleService.exists((Location)sibling)) {
                    this.files = new Location[]{sibling};
                }
            }
            catch (IOException e) {
                return;
            }
        }
        this.valid = true;
    }

    public boolean isRegex() {
        return this.isRegex;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getErrorMessage() {
        return this.msg;
    }

    public Location[] getFiles() {
        return this.files;
    }

    public String[][] getElements() {
        String[][] elements = new String[this.blocks.length][];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.blocks[i].getElements();
        }
        return elements;
    }

    public int[] getCount() {
        int[] count = new int[this.blocks.length];
        for (int i = 0; i < count.length; ++i) {
            count[i] = this.blocks[i].getElements().length;
        }
        return count;
    }

    public String getBlock(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        return this.pattern.substring(this.startIndex[i], this.endIndex[i]);
    }

    public String[] getBlocks() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getBlock(i);
        }
        return s;
    }

    public String getPrefix() {
        int dot;
        int s = this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex.length > 0 ? this.startIndex[0] : ((dot = this.pattern.lastIndexOf(".")) < s ? this.pattern.length() : dot);
        return s <= e ? this.pattern.substring(s, e) : "";
    }

    public String getSuffix() {
        return this.endIndex.length > 0 ? this.pattern.substring(this.endIndex[this.endIndex.length - 1]) : this.pattern;
    }

    public String getPrefix(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        int s = i > 0 ? this.endIndex[i - 1] : this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex[i];
        return s <= e ? this.pattern.substring(s, e) : null;
    }

    public String[] getPrefixes() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getPrefix(i);
        }
        return s;
    }

    private void buildFiles(String prefix, int ndx, List<Location> fileList, DataHandleService dataHandleService) throws IOException {
        if (this.blocks.length == 0) {
            int end;
            String dir;
            BrowsableLocation patternLocation = this.baseLoc.sibling(this.pattern);
            if (dataHandleService.exists((Location)patternLocation)) {
                fileList.add((Location)patternLocation);
                return;
            }
            this.isRegex = true;
            List<Location> localfiles = null;
            int endRegex = this.pattern.indexOf(File.separator + "\\E") + 1;
            int endNotRegex = this.pattern.lastIndexOf(File.separator) + 1;
            if (this.pattern.startsWith("\\Q") && endRegex > 0 && endRegex <= endNotRegex) {
                dir = this.pattern.substring(2, endRegex);
                end = endRegex + 2;
            } else {
                dir = this.pattern.substring(0, endNotRegex);
                end = endNotRegex;
            }
            localfiles = "".equals(dir) || !dataHandleService.exists((Location)this.baseLoc.sibling(dir)) ? this.getAllFiles(this.baseLoc.parent()) : this.getAllFiles(this.baseLoc.sibling(dir));
            String basePattern = this.pattern.substring(end);
            Pattern regex = null;
            try {
                regex = Pattern.compile(basePattern);
            }
            catch (PatternSyntaxException e) {
                regex = Pattern.compile(this.pattern);
            }
            for (Location f : localfiles) {
                if (!regex.matcher(f.getName()).matches()) continue;
                fileList.add(f);
            }
        } else {
            int num = this.startIndex.length;
            int n1 = ndx == 0 ? 0 : this.endIndex[ndx - 1];
            int n2 = ndx == num ? this.pattern.length() : this.startIndex[ndx];
            String pre = this.pattern.substring(n1, n2);
            if (ndx == 0) {
                fileList.add((Location)this.baseLoc.sibling(pre + prefix));
            } else {
                String[] blockElements;
                FilePatternBlock block = this.blocks[--ndx];
                for (String element : blockElements = block.getElements()) {
                    this.buildFiles(element + pre + prefix, ndx, fileList, dataHandleService);
                }
            }
        }
    }

    private List<Location> getAllFiles(BrowsableLocation dir) throws IOException {
        ArrayList<Location> subfiles = new ArrayList<Location>();
        BrowsableLocation root = dir;
        Set children = root.children();
        for (BrowsableLocation child : children) {
            List<Location> grandChildren = this.getAllFiles(child);
            if (grandChildren.isEmpty()) {
                subfiles.add((Location)child);
                continue;
            }
            subfiles.addAll(grandChildren);
        }
        return subfiles;
    }
}

