/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.Edge;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.BasicBlockEndingStatement;
import org.renjin.compiler.ir.tac.statements.Statement;

public class ControlFlowGraph {
    private final IRBody parent;
    private final DirectedGraph<BasicBlock, Edge> graph;
    private final List<BasicBlock> basicBlocks;
    private BasicBlock entry;
    private BasicBlock exit;
    private Map<IRLabel, BasicBlock> basicBlockMap = Maps.newHashMap();

    public ControlFlowGraph(IRBody body2) {
        this.parent = body2;
        this.graph = new DirectedSparseGraph();
        this.basicBlocks = Lists.newArrayList();
        this.addBasicBlocks();
        this.linkBasicBlocks();
        this.removeDeadBlocks();
    }

    private void addBasicBlocks() {
        BasicBlock current = null;
        for (int i = 0; i < this.parent.getStatements().size(); ++i) {
            Statement stmt = this.parent.getStatements().get(i);
            if (current == null || this.parent.isLabeled(i)) {
                current = this.addNewBasicBlock(this.parent, i);
            } else {
                current.addStatement(stmt);
            }
            if (!(stmt instanceof BasicBlockEndingStatement)) continue;
            current = null;
        }
    }

    public List<BasicBlock> getLiveBasicBlocks() {
        return Collections.unmodifiableList(this.basicBlocks);
    }

    public Set<Variable> variables() {
        HashSet variables = Sets.newHashSet();
        for (BasicBlock bb : this.basicBlocks) {
            variables.addAll(bb.variables());
        }
        return Collections.unmodifiableSet(variables);
    }

    private BasicBlock addNewBasicBlock(IRBody body2, int i) {
        BasicBlock bb = BasicBlock.createWithStartAt(body2, i);
        bb.setDebugId(this.basicBlocks.size());
        this.basicBlocks.add(bb);
        this.graph.addVertex((Object)bb);
        for (IRLabel label : bb.getLabels()) {
            this.basicBlockMap.put(label, bb);
        }
        return bb;
    }

    private void linkBasicBlocks() {
        this.entry = new BasicBlock(this.parent);
        this.entry.setDebugId("entry");
        this.exit = new BasicBlock(this.parent);
        this.exit.setDebugId("exit");
        for (int i = 0; i != this.basicBlocks.size(); ++i) {
            BasicBlock bb = this.basicBlocks.get(i);
            if (bb.fallsThrough()) {
                this.graph.addEdge((Object)new Edge(false), (Object)bb, (Object)this.basicBlocks.get(i + 1));
                continue;
            }
            if (bb.returns()) {
                this.graph.addEdge((Object)new Edge(false), (Object)bb, (Object)this.exit);
                continue;
            }
            for (IRLabel targetLabel : bb.targets()) {
                BasicBlock targetBB = this.basicBlockMap.get(targetLabel);
                if (targetBB == null) {
                    throw new NullPointerException("whoops! no basic block with label '" + targetLabel + "' in IRBody " + this.parent);
                }
                int targetBBIndex = this.basicBlocks.indexOf(targetBB);
                this.graph.addEdge((Object)new Edge(targetBBIndex <= i), (Object)bb, (Object)targetBB);
            }
        }
        this.graph.addEdge((Object)new Edge(false), (Object)this.entry, (Object)this.exit);
        this.graph.addEdge((Object)new Edge(false), (Object)this.entry, (Object)this.basicBlocks.get(0));
        this.basicBlocks.add(this.entry);
        this.basicBlocks.add(this.exit);
    }

    private void removeDeadBlocks() {
        boolean changed;
        do {
            changed = false;
            for (BasicBlock vertex : Lists.newArrayList((Iterable)this.graph.getVertices())) {
                if (vertex == this.entry || this.graph.inDegree((Object)vertex) != 0) continue;
                if (this.graph.removeVertex((Object)vertex)) {
                    // empty if block
                }
                changed = true;
            }
        } while (changed);
        this.basicBlocks.retainAll(this.graph.getVertices());
        int i = 1;
        for (BasicBlock bb : this.basicBlocks) {
            if (bb == this.entry || bb == this.exit) continue;
            bb.setDebugId(i++);
        }
    }

    public List<BasicBlock> getBasicBlocks() {
        return this.basicBlocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BasicBlock bb : this.basicBlocks) {
            sb.append("\n" + bb.toString());
            if (bb.getLabels() != null) {
                sb.append(": ").append(bb.getLabels());
            }
            sb.append(" =============\n");
            sb.append(bb.statementsToString());
        }
        return sb.toString();
    }

    public Graph<BasicBlock, Edge> getGraph() {
        return this.graph;
    }

    public BasicBlock getEntry() {
        return this.entry;
    }

    public BasicBlock getExit() {
        return this.exit;
    }

    public Collection<BasicBlock> getSuccessors(BasicBlock x) {
        return this.graph.getSuccessors((Object)x);
    }

    public Collection<BasicBlock> getPredecessors(BasicBlock x) {
        return this.graph.getPredecessors((Object)x);
    }
}

