/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import org.apache.commons.math.complex.Complex;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Vector;

public class FFT {
    @Internal
    public static ComplexVector fft(IntVector x, boolean inverse) {
        return FFT.realFFT(x, inverse);
    }

    @Internal
    public static ComplexVector fft(DoubleVector x, boolean inverse) {
        return FFT.realFFT(x, inverse);
    }

    @Internal
    public static ComplexVector fft(ComplexVector x, boolean inverse) {
        DoubleFFT_1D fft2 = new DoubleFFT_1D(x.length());
        double[] array2 = new double[x.length() * 2];
        for (int i = 0; i != x.length(); ++i) {
            array2[i * 2] = x.getElementAsComplex(i).getReal();
            array2[i * 2 + 1] = x.getElementAsComplex(i).getImaginary();
        }
        if (inverse) {
            fft2.complexInverse(array2, false);
        } else {
            fft2.complexForward(array2);
        }
        return FFT.toComplex(array2);
    }

    private static ComplexVector realFFT(Vector x, boolean inverse) {
        DoubleFFT_1D fft2 = new DoubleFFT_1D(x.length());
        double[] array2 = new double[x.length() * 2];
        for (int i = 0; i != x.length(); ++i) {
            array2[i] = x.getElementAsDouble(i);
        }
        if (inverse) {
            fft2.realInverse(array2, false);
        } else {
            fft2.realForwardFull(array2);
        }
        return FFT.toComplex(array2);
    }

    private static ComplexVector toComplex(double[] array2) {
        int n = array2.length / 2;
        ComplexArrayVector.Builder result = new ComplexArrayVector.Builder(0, n);
        for (int i = 0; i != n; ++i) {
            result.add(new Complex(array2[i * 2], array2[i * 2 + 1]));
        }
        return result.build();
    }

    private static boolean isPowerOfTwo(int n) {
        return n != 0 && (n & n - 1) == 0;
    }
}

