/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.text.DecimalFormat;

public class Stack_Splitter
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getStackSize() == 1) {
            IJ.error((String)"SplitStack: Must call this plugin on image stack.");
            return;
        }
        int numStacks = imp.getStackSize();
        String sPrompt = "Number of substacks (divisor of " + numStacks + "):";
        int numSubStacks = (int)IJ.getNumber((String)sPrompt, (double)numStacks);
        if (numSubStacks == Integer.MIN_VALUE) {
            return;
        }
        if (!this.numOK(numSubStacks, numStacks)) {
            String sError = "number of substacks must divide: " + numStacks + ".";
            IJ.error((String)("SplitStack: " + sError));
        } else {
            if (!imp.lock()) {
                return;
            }
            this.processStack(imp, numSubStacks);
            imp.unlock();
        }
    }

    protected boolean numOK(int nss, int ns) {
        if (nss <= 0 || nss > ns) {
            return false;
        }
        return ns % nss == 0;
    }

    protected void processStack(ImagePlus imp, int numSubStacks) {
        int numImages = imp.getStackSize() / numSubStacks;
        if (numImages == 1) {
            this.stack2images(imp);
        } else {
            this.stack2stacks(imp, numImages, numSubStacks);
        }
    }

    protected void stack2images(ImagePlus imp) {
        String sLabel = imp.getTitle();
        String sImLabel = "";
        ImageStack stack = imp.getStack();
        int sz = stack.getSize();
        int currentSlice = imp.getCurrentSlice();
        DecimalFormat df = new DecimalFormat("0000");
        for (int n = 1; n <= sz; ++n) {
            imp.setSlice(n);
            ImageProcessor ip = imp.getProcessor();
            ImageProcessor newip = ip.createProcessor(ip.getWidth(), ip.getHeight());
            newip.setPixels(ip.getPixelsCopy());
            sImLabel = imp.getStack().getSliceLabel(n);
            if (sImLabel == null || sImLabel.length() < 1) {
                sImLabel = "slice" + df.format(n) + "_" + sLabel;
            }
            ImagePlus im = new ImagePlus(sImLabel, newip);
            im.setCalibration(imp.getCalibration());
            im.show();
        }
        imp.setSlice(currentSlice);
        if (imp.isProcessor()) {
            ImageProcessor ip = imp.getProcessor();
            ip.setPixels(ip.getPixels());
        }
        imp.setSlice(currentSlice);
    }

    protected void stack2stacks(ImagePlus imp, int numImages, int numSubStacks) {
        DecimalFormat df = new DecimalFormat("0000");
        String sBaseName = imp.getTitle();
        String sSliceLabel = "";
        ImageStack stack = imp.getStack();
        int currentSlice = imp.getCurrentSlice();
        ColorModel cm = imp.createLut().getColorModel();
        int index = 1;
        for (int nss = 1; nss <= numSubStacks; ++nss) {
            ImageStack ims = new ImageStack(stack.getWidth(), stack.getHeight(), cm);
            int n = 1;
            while (n <= numImages) {
                imp.setSlice(index);
                sSliceLabel = stack.getSliceLabel(index);
                if (sSliceLabel != null && sSliceLabel.length() < 1) {
                    sSliceLabel = "slice_" + df.format(n);
                }
                ims.addSlice(sSliceLabel, imp.getProcessor().duplicate());
                ++n;
                ++index;
            }
            String sStackName = "stk_" + df.format(nss) + "_" + sBaseName;
            ImagePlus nimp = new ImagePlus(sStackName, ims);
            nimp.setCalibration(imp.getCalibration());
            nimp.show();
        }
        imp.setSlice(currentSlice);
        if (imp.isProcessor()) {
            ImageProcessor ip = imp.getProcessor();
            ip.setPixels(ip.getPixels());
        }
        imp.setSlice(currentSlice);
    }
}

