/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public final class AWTWindows {
    private AWTWindows() {
    }

    public static void centerWindow(Window window) {
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        AWTWindows.centerWindow(new Rectangle(0, 0, s.width, s.height), window);
    }

    public static void centerWindow(Window parent, Window window) {
        AWTWindows.centerWindow(parent.getBounds(), window);
    }

    public static void centerWindow(Rectangle bounds, Window window) {
        Dimension w = window.getSize();
        int x = bounds.x + (bounds.width - w.width) / 2;
        int y = bounds.y + (bounds.height - w.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static boolean ensureSizeReasonable(Window window) {
        boolean resized;
        Dimension maxSize = AWTWindows.getMaximumSize();
        Dimension windowSize = window.getSize();
        int w = windowSize.width;
        int h = windowSize.height;
        if (w > maxSize.width) {
            w = maxSize.width;
        }
        if (h > maxSize.height) {
            h = maxSize.height;
        }
        boolean bl = resized = windowSize.width != w || windowSize.height != h;
        if (resized) {
            window.setSize(w, h);
        }
        return resized;
    }

    private static Dimension getMaximumSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(3 * screenSize.width / 4, 3 * screenSize.height / 4);
    }
}

