/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.imglib2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.cache.util.LoaderCacheAsCacheAdapter;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LabelUtils;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.ByteArrayDataBlock;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5LabelMultisetCacheLoader;

public class N5LabelMultisets {
    public static final String LABEL_MULTISETTYPE_KEY = "isLabelMultiset";

    public static boolean isLabelMultisetType(N5Reader n5, String dataset) {
        return (Boolean)Optional.ofNullable(n5.getAttribute(dataset, LABEL_MULTISETTYPE_KEY, Boolean.class)).orElse(false);
    }

    public static CachedCellImg<LabelMultisetType, VolatileLabelMultisetArray> openLabelMultiset(N5Reader n5, String dataset) {
        return N5LabelMultisets.openLabelMultiset(n5, dataset, 0L);
    }

    public static CachedCellImg<LabelMultisetType, VolatileLabelMultisetArray> openLabelMultiset(N5Reader n5, String dataset, long defaultLabelId) {
        return N5LabelMultisets.openLabelMultiset(n5, dataset, N5LabelMultisetCacheLoader.constantNullReplacement(defaultLabelId));
    }

    public static CachedCellImg<LabelMultisetType, VolatileLabelMultisetArray> openLabelMultiset(N5Reader n5, String dataset, BiFunction<CellGrid, long[], byte[]> nullReplacement) {
        return N5LabelMultisets.openLabelMultiset(n5, dataset, nullReplacement, (LoaderCache<Long, Cell<VolatileLabelMultisetArray>>)new SoftRefLoaderCache());
    }

    public static CachedCellImg<LabelMultisetType, VolatileLabelMultisetArray> openLabelMultiset(N5Reader n5, String dataset, BiFunction<CellGrid, long[], byte[]> nullReplacement, LoaderCache<Long, Cell<VolatileLabelMultisetArray>> loaderCache) {
        if (!N5LabelMultisets.isLabelMultisetType(n5, dataset)) {
            throw new N5Exception.N5IOException(dataset + " is not a label multiset dataset.");
        }
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        CellGrid grid = new CellGrid(attributes.getDimensions(), attributes.getBlockSize());
        N5LabelMultisetCacheLoader loader = new N5LabelMultisetCacheLoader(n5, dataset, nullReplacement);
        LoaderCacheAsCacheAdapter wrappedCache = new LoaderCacheAsCacheAdapter(loaderCache, (CacheLoader)loader);
        CachedCellImg cachedImg = new CachedCellImg(grid, new LabelMultisetType().getEntitiesPerPixel(), (Cache)wrappedCache, (DataAccess)new VolatileLabelMultisetArray(0, true, new long[]{-2L}));
        cachedImg.setLinkedType((NativeType)new LabelMultisetType((NativeImg)cachedImg));
        return cachedImg;
    }

    public static void saveLabelMultiset(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, int[] blockSize, Compression compression) {
        source = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)source);
        DatasetAttributes attributes = new DatasetAttributes(dimensions, blockSize, DataType.UINT8, compression);
        n5.createDataset(dataset, attributes);
        n5.setAttribute(dataset, LABEL_MULTISETTYPE_KEY, (Object)true);
        int n = dimensions.length;
        long[] max = Intervals.maxAsLongArray((Interval)source);
        long[] offset = new long[n];
        long[] gridPosition = new long[n];
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        int d = 0;
        block0: while (d < n) {
            N5LabelMultisets.cropBlockDimensions(max, offset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
            IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)source, (long[])offset, (long[])longCroppedBlockSize);
            ByteArrayDataBlock dataBlock = N5LabelMultisets.createDataBlock((RandomAccessibleInterval<LabelMultisetType>)sourceBlock, gridPosition);
            n5.writeBlock(dataset, attributes, (DataBlock)dataBlock);
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
    }

    public static void saveLabelMultiset(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, int[] blockSize, Compression compression, ExecutorService exec) throws InterruptedException, ExecutionException {
        IntervalView zeroMinSource = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)zeroMinSource);
        DatasetAttributes attributes = new DatasetAttributes(dimensions, blockSize, DataType.UINT8, compression);
        n5.createDataset(dataset, attributes);
        n5.setAttribute(dataset, LABEL_MULTISETTYPE_KEY, (Object)true);
        int n = dimensions.length;
        long[] max = Intervals.maxAsLongArray((Interval)zeroMinSource);
        long[] offset = new long[n];
        ArrayList futures = new ArrayList();
        int d = 0;
        block0: while (d < n) {
            long[] lArray = (long[])offset.clone();
            futures.add(exec.submit(() -> N5LabelMultisets.lambda$saveLabelMultiset$0(n, max, lArray, blockSize, (RandomAccessibleInterval)zeroMinSource, n5, dataset, attributes)));
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
        for (Future future : futures) {
            future.get();
        }
    }

    public static void saveLabelMultisetBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset) {
        if (!N5LabelMultisets.isLabelMultisetType((N5Reader)n5, dataset)) {
            throw new N5Exception.N5IOException(dataset + " is not a label multiset dataset.");
        }
        source = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)source);
        int n = dimensions.length;
        long[] max = Intervals.maxAsLongArray((Interval)source);
        long[] offset = new long[n];
        long[] gridPosition = new long[n];
        int[] blockSize = attributes.getBlockSize();
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        int d = 0;
        block0: while (d < n) {
            N5LabelMultisets.cropBlockDimensions(max, offset, gridOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
            IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)source, (long[])offset, (long[])longCroppedBlockSize);
            ByteArrayDataBlock dataBlock = N5LabelMultisets.createDataBlock((RandomAccessibleInterval<LabelMultisetType>)sourceBlock, gridPosition);
            n5.writeBlock(dataset, attributes, (DataBlock)dataBlock);
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
    }

    public static void saveLabelMultisetBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, DatasetAttributes attributes) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> source.min(d) / (long)blockSize[d]);
        N5LabelMultisets.saveLabelMultisetBlock(source, n5, dataset, attributes, gridOffset);
    }

    public static void saveLabelMultisetBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5LabelMultisets.saveLabelMultisetBlock(source, n5, dataset, attributes);
    }

    public static void saveLabelMultisetBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, long[] gridOffset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5LabelMultisets.saveLabelMultisetBlock(source, n5, dataset, attributes, gridOffset);
    }

    public static void saveLabelMultisetBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, long[] gridOffset, ExecutorService exec) throws InterruptedException, ExecutionException {
        if (!N5LabelMultisets.isLabelMultisetType((N5Reader)n5, dataset)) {
            throw new N5Exception.N5IOException(dataset + " is not a label multiset dataset.");
        }
        IntervalView zeroMinSource = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)zeroMinSource);
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes != null) {
            int n = dimensions.length;
            long[] max = Intervals.maxAsLongArray((Interval)zeroMinSource);
            long[] offset = new long[n];
            int[] blockSize = attributes.getBlockSize();
            ArrayList futures = new ArrayList();
            int d = 0;
            block0: while (d < n) {
                long[] lArray = (long[])offset.clone();
                futures.add(exec.submit(() -> N5LabelMultisets.lambda$saveLabelMultisetBlock$2(n, max, lArray, gridOffset, blockSize, (RandomAccessibleInterval)zeroMinSource, n5, dataset, attributes)));
                for (d = 0; d < n; ++d) {
                    int n2 = d;
                    offset[n2] = offset[n2] + (long)blockSize[d];
                    if (offset[d] <= max[d]) continue block0;
                    offset[d] = 0L;
                }
            }
            for (Future future : futures) {
                future.get();
            }
        } else {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
    }

    public static void saveLabelMultisetNonEmptyBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset, long defaultLabelId) {
        if (!N5LabelMultisets.isLabelMultisetType((N5Reader)n5, dataset)) {
            throw new N5Exception.N5IOException(dataset + " is not a label multiset dataset.");
        }
        source = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)source);
        int n = dimensions.length;
        long[] max = Intervals.maxAsLongArray((Interval)source);
        long[] offset = new long[n];
        long[] gridPosition = new long[n];
        int[] blockSize = attributes.getBlockSize();
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        int d = 0;
        block0: while (d < n) {
            N5LabelMultisets.cropBlockDimensions(max, offset, gridOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
            IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)source, (long[])offset, (long[])longCroppedBlockSize);
            ByteArrayDataBlock dataBlock = N5LabelMultisets.createNonEmptyDataBlock((RandomAccessibleInterval<LabelMultisetType>)sourceBlock, gridPosition, defaultLabelId);
            if (dataBlock != null) {
                n5.writeBlock(dataset, attributes, (DataBlock)dataBlock);
            }
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
    }

    public static void saveLabelMultisetNonEmptyBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, DatasetAttributes attributes, long defaultLabelId) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> source.min(d) / (long)blockSize[d]);
        N5LabelMultisets.saveLabelMultisetNonEmptyBlock(source, n5, dataset, attributes, gridOffset, defaultLabelId);
    }

    public static void saveLabelMultisetNonEmptyBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, long defaultLabelId) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5LabelMultisets.saveLabelMultisetNonEmptyBlock(source, n5, dataset, attributes, defaultLabelId);
    }

    public static void saveLabelMultisetNonEmptyBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset) {
        N5LabelMultisets.saveLabelMultisetNonEmptyBlock(source, n5, dataset, 0L);
    }

    public static void saveLabelMultisetNonEmptyBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, long[] gridOffset, long defaultLabelId) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5LabelMultisets.saveLabelMultisetNonEmptyBlock(source, n5, dataset, attributes, gridOffset, defaultLabelId);
    }

    public static void saveLabelMultisetNonEmptyBlock(RandomAccessibleInterval<LabelMultisetType> source, N5Writer n5, String dataset, long[] gridOffset) {
        N5LabelMultisets.saveLabelMultisetNonEmptyBlock(source, n5, dataset, gridOffset, 0L);
    }

    private static ByteArrayDataBlock createDataBlock(RandomAccessibleInterval<LabelMultisetType> source, long[] gridPosition) {
        byte[] data = LabelUtils.serializeLabelMultisetTypes((Iterable)Views.flatIterable(source), (int)((int)Intervals.numElements(source)));
        ByteArrayDataBlock dataBlock = new ByteArrayDataBlock(Intervals.dimensionsAsIntArray(source), gridPosition, data);
        return dataBlock;
    }

    private static ByteArrayDataBlock createNonEmptyDataBlock(RandomAccessibleInterval<LabelMultisetType> source, long[] gridPosition, long defaultLabelId) {
        boolean isEmpty = true;
        for (LabelMultisetType lmt : Views.iterable(source)) {
            for (LabelMultisetType.Entry entry : lmt.entrySet()) {
                isEmpty &= ((Label)entry.getElement()).id() == defaultLabelId;
            }
        }
        return isEmpty ? null : N5LabelMultisets.createDataBlock(source, gridPosition);
    }

    static void cropBlockDimensions(long[] max, long[] offset, long[] gridOffset, int[] blockDimensions, long[] croppedBlockDimensions, int[] intCroppedBlockDimensions, long[] gridPosition) {
        for (int d = 0; d < max.length; ++d) {
            croppedBlockDimensions[d] = Math.min((long)blockDimensions[d], max[d] - offset[d] + 1L);
            intCroppedBlockDimensions[d] = (int)croppedBlockDimensions[d];
            gridPosition[d] = offset[d] / (long)blockDimensions[d] + gridOffset[d];
        }
    }

    static void cropBlockDimensions(long[] max, long[] offset, int[] blockDimensions, long[] croppedBlockDimensions, int[] intCroppedBlockDimensions, long[] gridPosition) {
        for (int d = 0; d < max.length; ++d) {
            croppedBlockDimensions[d] = Math.min((long)blockDimensions[d], max[d] - offset[d] + 1L);
            intCroppedBlockDimensions[d] = (int)croppedBlockDimensions[d];
            gridPosition[d] = offset[d] / (long)blockDimensions[d];
        }
    }

    private static /* synthetic */ void lambda$saveLabelMultisetBlock$2(int n, long[] max, long[] fOffset, long[] gridOffset, int[] blockSize, RandomAccessibleInterval zeroMinSource, N5Writer n5, String dataset, DatasetAttributes attributes) {
        long[] gridPosition = new long[n];
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        N5LabelMultisets.cropBlockDimensions(max, fOffset, gridOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
        IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)zeroMinSource, (long[])fOffset, (long[])longCroppedBlockSize);
        ByteArrayDataBlock dataBlock = N5LabelMultisets.createDataBlock((RandomAccessibleInterval<LabelMultisetType>)sourceBlock, gridPosition);
        n5.writeBlock(dataset, attributes, (DataBlock)dataBlock);
    }

    private static /* synthetic */ void lambda$saveLabelMultiset$0(int n, long[] max, long[] fOffset, int[] blockSize, RandomAccessibleInterval zeroMinSource, N5Writer n5, String dataset, DatasetAttributes attributes) {
        long[] gridPosition = new long[n];
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        N5LabelMultisets.cropBlockDimensions(max, fOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
        IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)zeroMinSource, (long[])fOffset, (long[])longCroppedBlockSize);
        ByteArrayDataBlock dataBlock = N5LabelMultisets.createDataBlock((RandomAccessibleInterval<LabelMultisetType>)sourceBlock, gridPosition);
        n5.writeBlock(dataset, attributes, (DataBlock)dataBlock);
    }
}

