/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.iteration;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Cursor;
import net.imglib2.transform.integer.Slicing;

public class SlicingCursor<T>
extends AbstractEuclideanSpace
implements Cursor<T> {
    private final Cursor<T> s;
    private final int m;
    private final int[] sourceComponent;
    private final long[] tmpPosition;

    SlicingCursor(Cursor<T> source, Slicing transformToSource) {
        super(transformToSource.numSourceDimensions());
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.s = source;
        this.m = transformToSource.numTargetDimensions();
        boolean[] targetZero = new boolean[this.m];
        int[] targetComponent = new int[this.m];
        transformToSource.getComponentZero(targetZero);
        transformToSource.getComponentMapping(targetComponent);
        this.sourceComponent = new int[this.n];
        for (int d = 0; d < this.m; ++d) {
            if (transformToSource.getComponentZero(d)) continue;
            this.sourceComponent[transformToSource.getComponentMapping((int)d)] = d;
        }
        this.tmpPosition = new long[this.m];
        transformToSource.getTranslation(this.tmpPosition);
    }

    protected SlicingCursor(SlicingCursor<T> cursor) {
        super(cursor.numDimensions());
        this.s = cursor.s;
        this.m = cursor.m;
        this.sourceComponent = (int[])cursor.sourceComponent.clone();
        this.tmpPosition = (long[])cursor.tmpPosition.clone();
    }

    @Override
    public void localize(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getIntPosition(d);
        }
    }

    @Override
    public void localize(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getLongPosition(d);
        }
    }

    @Override
    public int getIntPosition(int d) {
        assert (d < this.n);
        return this.s.getIntPosition(this.sourceComponent[d]);
    }

    @Override
    public long getLongPosition(int d) {
        assert (d < this.n);
        return this.s.getLongPosition(this.sourceComponent[d]);
    }

    @Override
    public void localize(float[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getFloatPosition(d);
        }
    }

    @Override
    public void localize(double[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getDoublePosition(d);
        }
    }

    @Override
    public float getFloatPosition(int d) {
        assert (d < this.n);
        return this.s.getFloatPosition(this.sourceComponent[d]);
    }

    @Override
    public double getDoublePosition(int d) {
        assert (d < this.n);
        return this.s.getDoublePosition(this.sourceComponent[d]);
    }

    @Override
    public T get() {
        return this.s.get();
    }

    @Override
    public T getType() {
        return this.s.getType();
    }

    @Override
    public SlicingCursor<T> copy() {
        return new SlicingCursor<T>(this);
    }

    @Override
    public void jumpFwd(long steps) {
        this.s.jumpFwd(steps);
    }

    @Override
    public void fwd() {
        this.s.fwd();
    }

    @Override
    public void reset() {
        this.s.reset();
    }

    @Override
    public boolean hasNext() {
        return this.s.hasNext();
    }

    @Override
    public T next() {
        return this.s.next();
    }
}

