/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.point;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.line.StraightLine2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDTree2D {
    private Node root;
    private Comparator<Point2D> xComparator = new XComparator();
    private Comparator<Point2D> yComparator = new YComparator();

    public KDTree2D(ArrayList<Point2D> points) {
        this.root = this.makeTree(points, 0);
    }

    private Node makeTree(List<Point2D> points, int depth) {
        if (points.size() == 0) {
            return null;
        }
        int dir = depth % 2;
        if (dir == 0) {
            Collections.sort(points, this.xComparator);
        } else {
            Collections.sort(points, this.yComparator);
        }
        int n = points.size();
        int med = n / 2;
        return new Node(points.get(med), this.makeTree(points.subList(0, med), depth + 1), this.makeTree(points.subList(med + 1, n), depth + 1));
    }

    public Node getRoot() {
        return this.root;
    }

    public boolean contains(Point2D value) {
        return this.contains(value, this.root, 0);
    }

    private boolean contains(Point2D point, Node node, int depth) {
        if (node == null) {
            return false;
        }
        int dir = depth % 2;
        int res = dir == 0 ? this.xComparator.compare(point, node.point) : this.yComparator.compare(point, node.point);
        if (res < 0) {
            return this.contains(point, node.left, depth + 1);
        }
        if (res > 0) {
            return this.contains(point, node.right, depth + 1);
        }
        return true;
    }

    public Node getNode(Point2D point) {
        return this.getNode(point, this.root, 0);
    }

    private Node getNode(Point2D point, Node node, int depth) {
        if (node == null) {
            return null;
        }
        int dir = depth % 2;
        int res = dir == 0 ? this.xComparator.compare(point, node.point) : this.yComparator.compare(point, node.point);
        if (res < 0) {
            return this.getNode(point, node.left, depth + 1);
        }
        if (res > 0) {
            return this.getNode(point, node.right, depth + 1);
        }
        return node;
    }

    public void add(Point2D point) {
        this.add(point, this.root, 0);
    }

    private void add(Point2D point, Node node, int depth) {
        int dir = depth % 2;
        int res = dir == 0 ? this.xComparator.compare(point, node.point) : this.yComparator.compare(point, node.point);
        if (res < 0) {
            if (node.left == null) {
                node.left = new Node(point);
            } else {
                this.add(point, node.left, depth + 1);
            }
        }
        if (res > 0) {
            if (node.right == null) {
                node.right = new Node(point);
            } else {
                this.add(point, node.right, depth + 1);
            }
        }
    }

    public Collection<Point2D> rangeSearch(Box2D range) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        this.rangeSearch(range, points, this.root, 0);
        return points;
    }

    private void rangeSearch(Box2D range, Collection<Point2D> points, Node node, int depth) {
        int dir;
        boolean ty2;
        if (node == null) {
            return;
        }
        Point2D point = node.getPoint();
        double x = point.x();
        double y = point.y();
        boolean tx1 = range.getMinX() < x;
        boolean ty1 = range.getMinY() < y;
        boolean tx2 = x <= range.getMaxX();
        boolean bl = ty2 = y <= range.getMaxY();
        if (tx1 && tx2 && ty1 && ty2) {
            points.add(point);
        }
        if ((dir = depth % 2) == 0 ? tx1 : ty1) {
            this.rangeSearch(range, points, node.left, depth + 1);
        }
        if (dir == 0 ? tx2 : ty2) {
            this.rangeSearch(range, points, node.right, depth + 1);
        }
    }

    public Point2D nearestNeighbor(Point2D point) {
        return this.nearestNeighbor(point, this.root, this.root, 0).getPoint();
    }

    private Node nearestNeighbor(Point2D point, Node candidate, Node node, int depth) {
        StraightLine2D line;
        Node node2;
        Node node1;
        double distCand = candidate.point.distance(point);
        double dist = node.point.distance(point);
        if (dist < distCand) {
            candidate = node;
        }
        int dir = depth % 2;
        Point2D anchor = node.getPoint();
        if (dir == 0) {
            boolean b = point.x() < anchor.x();
            node1 = b ? node.left : node.right;
            node2 = b ? node.right : node.left;
            line = new StraightLine2D(anchor, new Vector2D(0.0, 1.0));
        } else {
            boolean b = point.y() < anchor.y();
            node1 = b ? node.left : node.right;
            node2 = b ? node.right : node.left;
            line = new StraightLine2D(anchor, new Vector2D(1.0, 0.0));
        }
        if (node1 != null) {
            candidate = this.nearestNeighbor(point, candidate, node1, depth + 1);
            distCand = candidate.getPoint().distance(point);
        }
        if (line.distance(point) < distCand && node2 != null) {
            candidate = this.nearestNeighbor(point, candidate, node2, depth + 1);
        }
        return candidate;
    }

    public static void main(String[] args) {
        int n = 3;
        ArrayList<Point2D> points = new ArrayList<Point2D>(n);
        points.add(new Point2D(5.0, 5.0));
        points.add(new Point2D(10.0, 10.0));
        points.add(new Point2D(20.0, 20.0));
        System.out.println("Check KDTree2D");
        KDTree2D tree = new KDTree2D(points);
        System.out.println(tree.contains(new Point2D(5.0, 5.0)));
        System.out.println(tree.contains(new Point2D(6.0, 5.0)));
    }

    public class Node {
        private Point2D point;
        private Node left;
        private Node right;

        public Node(Point2D point) {
            this.point = point;
            this.left = null;
            this.right = null;
        }

        public Node(Point2D point, Node left, Node right) {
            this.point = point;
            this.left = left;
            this.right = right;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public Node getLeftChild() {
            return this.left;
        }

        public Node getRightChild() {
            return this.right;
        }

        public boolean isLeaf() {
            return this.left == null && this.right == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XComparator
    implements Comparator<Point2D> {
        private XComparator() {
        }

        @Override
        public int compare(Point2D p1, Point2D p2) {
            if (p1.x() < p2.x()) {
                return -1;
            }
            if (p1.x() > p2.x()) {
                return 1;
            }
            return Double.compare(p1.y(), p2.y());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class YComparator
    implements Comparator<Point2D> {
        private YComparator() {
        }

        @Override
        public int compare(Point2D p1, Point2D p2) {
            if (p1.y() < p2.y()) {
                return -1;
            }
            if (p1.y() > p2.y()) {
                return 1;
            }
            return Double.compare(p1.x(), p2.x());
        }
    }
}

