/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Real1;
import edu.mines.jtk.dsp.Sampling;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class Real1Test
extends TestCase {
    static final int N = 100;
    static final double TINY = 1.1920928955078125E-4;
    static final Real1 FILL1 = Real1.fill(1.0, 100);
    static final Real1 FILL2 = Real1.fill(2.0, 100);
    static final Real1 RAMP1 = Real1.ramp(0.0, 1.0, 100);
    static final Real1 RAMP2 = Real1.ramp(0.0, 2.0, 100);

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(Real1Test.class);
        TestRunner.run((Test)suite);
    }

    public void testMath() {
        Real1 ra = RAMP1;
        Real1 rb = RAMP1;
        Real1 rc = ra.plus(rb);
        Real1 re = RAMP2;
        this.assertEquals(re, rc);
    }

    public void testResample() {
        int i1;
        int i12;
        Real1 ra = FILL1;
        Sampling sa = ra.getSampling();
        int n1 = sa.getCount();
        double d1 = sa.getDelta();
        int m1 = n1 / 3;
        Sampling sb = sa.shift((double)(-m1) * d1);
        Real1 rb = ra.resample(sb);
        float[] vb = rb.getValues();
        for (i12 = 0; i12 < m1; ++i12) {
            Real1Test.assertEquals((double)0.0, (double)vb[i12], (double)0.0);
        }
        for (i12 = m1; i12 < n1; ++i12) {
            Real1Test.assertEquals((double)1.0, (double)vb[i12], (double)0.0);
        }
        Sampling sc = sa.shift((double)m1 * d1);
        Real1 rc = ra.resample(sc);
        float[] vc = rc.getValues();
        for (i1 = 0; i1 < n1 - m1; ++i1) {
            Real1Test.assertEquals((double)1.0, (double)vc[i1], (double)0.0);
        }
        for (i1 = n1 - m1; i1 < n1; ++i1) {
            Real1Test.assertEquals((double)0.0, (double)vc[i1], (double)0.0);
        }
    }

    void assertEquals(Real1 e, Real1 a) {
        Sampling se = e.getSampling();
        Sampling sa = a.getSampling();
        Real1Test.assertTrue((boolean)sa.isEquivalentTo(se));
        float[] ve = e.getValues();
        float[] va = a.getValues();
        int n = ve.length;
        for (int i = 0; i < n; ++i) {
            Real1Test.assertEquals((double)ve[i], (double)va[i], (double)1.1920928955078125E-4);
        }
    }
}

