/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.ogl.GlTextureName;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedFrame;
import edu.mines.jtk.sgl.AxisAlignedPanel;
import edu.mines.jtk.sgl.BoxConstraint;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.util.Clips;
import edu.mines.jtk.util.Direct;
import edu.mines.jtk.util.Float3;
import edu.mines.jtk.util.MathPlus;
import edu.mines.jtk.util.SimpleFloat3;
import java.awt.image.IndexColorModel;
import java.nio.IntBuffer;
import java.util.ArrayList;

public class ImagePanel
extends AxisAlignedPanel {
    private Axis _axis;
    private Sampling _sx;
    private Sampling _sy;
    private Sampling _sz;
    private Float3 _f;
    private double _xmin;
    private double _ymin;
    private double _zmin;
    private double _xmax;
    private double _ymax;
    private double _zmax;
    private Clips _clips;
    private float _clipMin = 0.0f;
    private float _clipMax = 1.0f;
    private ColorMap _colorMap = new ColorMap((double)this._clipMin, (double)this._clipMax, ColorMap.GRAY);
    private int _ls;
    private int _lt;
    private int _ms;
    private int _mt;
    private int _ns;
    private int _nt;
    private double _ds;
    private double _dt;
    private double _fs;
    private double _ft;
    private GlTextureName[][] _tn;
    private boolean _texturesDirty = true;
    private int _kxmin;
    private int _kymin;
    private int _kzmin;
    private int _kxmax;
    private int _kymax;
    private int _kzmax;
    private int _ksmin;
    private int _ktmin;
    private int _ksmax;
    private int _ktmax;
    private int _jsmin;
    private int _jtmin;
    private int _jsmax;
    private int _jtmax;
    private IntBuffer _pixels;
    private float[][] _floats;

    public ImagePanel(float[][][] f) {
        this(new Sampling(f[0][0].length), new Sampling(f[0].length), new Sampling(f.length), f);
    }

    public ImagePanel(Sampling s1, Sampling s2, Sampling s3, float[][][] f) {
        this(s1, s2, s3, new SimpleFloat3(f));
    }

    public ImagePanel(Sampling s1, Sampling s2, Sampling s3, Float3 f) {
        this._sx = s3;
        this._sy = s2;
        this._sz = s1;
        this._f = f;
        this._clips = new Clips(this._f);
    }

    public void update() {
        this._texturesDirty = true;
        this.dirtyDraw();
    }

    @Override
    public BoxConstraint getBoxConstraint() {
        return new BoxConstraint(this._sx, this._sy, this._sz);
    }

    public void setColorModel(IndexColorModel colorModel) {
        this._colorMap.setColorModel(colorModel);
        this._texturesDirty = true;
        this.dirtyDraw();
    }

    public IndexColorModel getColorModel() {
        return this._colorMap.getColorModel();
    }

    public void setClips(double clipMin, double clipMax) {
        this._clips.setClips(clipMin, clipMax);
        this._texturesDirty = true;
        this.dirtyDraw();
    }

    public float getClipMin() {
        return this._clips.getClipMin();
    }

    public float getClipMax() {
        return this._clips.getClipMax();
    }

    public void setPercentiles(double percMin, double percMax) {
        this._clips.setPercentiles(percMin, percMax);
        this._texturesDirty = true;
        this.dirtyDraw();
    }

    public float getPercentileMin() {
        return this._clips.getPercentileMin();
    }

    public float getPercentileMax() {
        return this._clips.getPercentileMax();
    }

    public void addColorMapListener(ColorMapListener cml) {
        this._colorMap.addListener(cml);
    }

    public void removeColorMapListener(ColorMapListener cml) {
        this._colorMap.removeListener(cml);
    }

    @Override
    protected void draw(DrawContext dc) {
        this.updateClipMinMax();
        this.drawTextures();
    }

    private void updateClipMinMax() {
        float clipMin = this._clips.getClipMin();
        float clipMax = this._clips.getClipMax();
        if (this._clipMin != clipMin || this._clipMax != clipMax) {
            this._clipMin = clipMin;
            this._clipMax = clipMax;
            this._colorMap.setValueRange(this._clipMin, this._clipMax);
            this._texturesDirty = true;
        }
    }

    private void drawTextures() {
        AxisAlignedFrame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        Axis axis = frame.getAxis();
        if (this._axis != axis) {
            this.updateSampling(axis, this._sx, this._sy, this._sz);
        }
        Point3 qmin = frame.getCornerMin();
        Point3 qmax = frame.getCornerMax();
        double xmin = qmin.x;
        double ymin = qmin.y;
        double zmin = qmin.z;
        double xmax = qmax.x;
        double ymax = qmax.y;
        double zmax = qmax.z;
        if (this._xmin != xmin || this._ymin != ymin || this._zmin != zmin || this._xmax != xmax || this._ymax != ymax || this._zmax != zmax) {
            this.updateBoundsAndTextures(xmin, ymin, zmin, xmax, ymax, zmax);
        }
        if (this._texturesDirty) {
            this.updateTextures();
        }
        Gl.glShadeModel(7424);
        Gl.glEnable(3553);
        Gl.glTexEnvf(8960, 8704, 7681.0f);
        float[] v = new float[]{0.0f};
        Gl.glGetFloatv(32824, v, 0);
        float factor = v[0];
        Gl.glGetFloatv(10752, v, 0);
        float units = v[0];
        Gl.glEnable(32823);
        Gl.glPolygonOffset(factor + 1.0f, units + 1.0f);
        float sa = 0.5f / (float)this._ls;
        float ta = 0.5f / (float)this._lt;
        float sb = 1.0f / (float)this._ls;
        float tb = 1.0f / (float)this._lt;
        double xa = 0.5 * (this._xmin + this._xmax);
        double ya = 0.5 * (this._ymin + this._ymax);
        double za = 0.5 * (this._zmin + this._zmax);
        for (int jt = this._jtmin; jt <= this._jtmax; ++jt) {
            for (int js = this._jsmin; js <= this._jsmax; ++js) {
                double x1;
                double x0;
                double z1;
                double z0;
                int ks0 = js * (this._ls - 1);
                int kt0 = jt * (this._lt - 1);
                int ks1 = ks0 + this._ls - 1;
                int kt1 = kt0 + this._lt - 1;
                ks0 = MathPlus.max(this._ksmin, ks0);
                kt0 = MathPlus.max(this._ktmin, kt0);
                ks1 = MathPlus.min(this._ksmax, ks1);
                kt1 = MathPlus.min(this._ktmax, kt1);
                float s0 = sa + (float)(ks0 % (this._ls - 1)) * sb;
                float t0 = ta + (float)(kt0 % (this._lt - 1)) * tb;
                float s1 = s0 + (float)(ks1 - ks0) * sb;
                float t1 = t0 + (float)(kt1 - kt0) * tb;
                GlTextureName tn = this._tn[jt][js];
                Gl.glBindTexture(3553, tn.name());
                Gl.glBegin(9);
                if (this._axis == Axis.X) {
                    double y0 = this._fs + (double)ks0 * this._ds;
                    z0 = this._ft + (double)kt0 * this._dt;
                    double y1 = this._fs + (double)ks1 * this._ds;
                    z1 = this._ft + (double)kt1 * this._dt;
                    Gl.glTexCoord2f(s0, t0);
                    Gl.glVertex3d(xa, y0, z0);
                    Gl.glTexCoord2f(s1, t0);
                    Gl.glVertex3d(xa, y1, z0);
                    Gl.glTexCoord2f(s1, t1);
                    Gl.glVertex3d(xa, y1, z1);
                    Gl.glTexCoord2f(s0, t1);
                    Gl.glVertex3d(xa, y0, z1);
                } else if (this._axis == Axis.Y) {
                    x0 = this._fs + (double)ks0 * this._ds;
                    z0 = this._ft + (double)kt0 * this._dt;
                    x1 = this._fs + (double)ks1 * this._ds;
                    z1 = this._ft + (double)kt1 * this._dt;
                    Gl.glTexCoord2f(s0, t0);
                    Gl.glVertex3d(x0, ya, z0);
                    Gl.glTexCoord2f(s1, t0);
                    Gl.glVertex3d(x1, ya, z0);
                    Gl.glTexCoord2f(s1, t1);
                    Gl.glVertex3d(x1, ya, z1);
                    Gl.glTexCoord2f(s0, t1);
                    Gl.glVertex3d(x0, ya, z1);
                } else {
                    x0 = this._fs + (double)ks0 * this._ds;
                    double y0 = this._ft + (double)kt0 * this._dt;
                    x1 = this._fs + (double)ks1 * this._ds;
                    double y1 = this._ft + (double)kt1 * this._dt;
                    Gl.glTexCoord2f(s0, t0);
                    Gl.glVertex3d(x0, y0, za);
                    Gl.glTexCoord2f(s1, t0);
                    Gl.glVertex3d(x1, y0, za);
                    Gl.glTexCoord2f(s1, t1);
                    Gl.glVertex3d(x1, y1, za);
                    Gl.glTexCoord2f(s0, t1);
                    Gl.glVertex3d(x0, y1, za);
                }
                Gl.glEnd();
            }
        }
        Gl.glBindTexture(3553, 0);
        Gl.glDisable(3553);
    }

    private void updateSampling(Axis axis, Sampling sx, Sampling sy, Sampling sz) {
        this.disposeTextures();
        int nx = sx.getCount();
        int ny = sy.getCount();
        int nz = sz.getCount();
        double dx = sx.getDelta();
        double dy = sy.getDelta();
        double dz = sz.getDelta();
        double fx = sx.getFirst();
        double fy = sy.getFirst();
        double fz = sz.getFirst();
        this._axis = axis;
        this._sx = sx;
        this._sy = sy;
        this._sz = sz;
        this._ls = 64;
        this._lt = 64;
        if (this._axis == Axis.X) {
            this._ns = ny;
            this._ds = dy;
            this._fs = fy;
            this._nt = nz;
            this._dt = dz;
            this._ft = fz;
        } else if (this._axis == Axis.Y) {
            this._ns = nx;
            this._ds = dx;
            this._fs = fx;
            this._nt = nz;
            this._dt = dz;
            this._ft = fz;
        } else {
            this._ns = nx;
            this._ds = dx;
            this._fs = fx;
            this._nt = ny;
            this._dt = dy;
            this._ft = fy;
        }
        this._ms = 1 + (this._ns - 2) / (this._ls - 1);
        this._mt = 1 + (this._nt - 2) / (this._lt - 1);
        this._tn = new GlTextureName[this._mt][this._ms];
        this._kxmin = 0;
        this._kxmax = -1;
        this._kymin = 0;
        this._kymax = -1;
        this._kzmin = 0;
        this._kzmax = -1;
        this._ksmin = 0;
        this._ksmax = -1;
        this._ktmin = 0;
        this._ktmax = -1;
        this._jsmin = 0;
        this._jsmax = -1;
        this._jtmin = 0;
        this._jtmax = -1;
        this._pixels = Direct.newIntBuffer(this._ls * this._lt);
        this._floats = new float[this._ls][this._lt];
    }

    private void updateBoundsAndTextures(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        boolean stale;
        this._xmin = MathPlus.max(xmin, this._sx.getFirst());
        this._ymin = MathPlus.max(ymin, this._sy.getFirst());
        this._zmin = MathPlus.max(zmin, this._sz.getFirst());
        this._xmax = MathPlus.min(xmax, this._sx.getLast());
        this._ymax = MathPlus.min(ymax, this._sy.getLast());
        this._zmax = MathPlus.min(zmax, this._sz.getLast());
        int kxmin = this._sx.indexOfNearest(this._xmin);
        int kymin = this._sy.indexOfNearest(this._ymin);
        int kzmin = this._sz.indexOfNearest(this._zmin);
        int kxmax = this._sx.indexOfNearest(this._xmax);
        int kymax = this._sy.indexOfNearest(this._ymax);
        int kzmax = this._sz.indexOfNearest(this._zmax);
        if (this._axis == Axis.X) {
            stale = this._kxmin != kxmin;
            this._kxmin = kxmin;
            this._ksmin = this._kymin = kymin;
            this._ktmin = this._kzmin = kzmin;
            this._kxmax = kxmax;
            this._ksmax = this._kymax = kymax;
            this._ktmax = this._kzmax = kzmax;
        } else if (this._axis == Axis.Y) {
            stale = this._kymin != kymin;
            this._ksmin = this._kxmin = kxmin;
            this._kymin = kymin;
            this._ktmin = this._kzmin = kzmin;
            this._ksmax = this._kxmax = kxmax;
            this._kymax = kymax;
            this._ktmax = this._kzmax = kzmax;
        } else {
            stale = this._kzmin != kzmin;
            this._ksmin = this._kxmin = kxmin;
            this._ktmin = this._kymin = kymin;
            this._kzmin = kzmin;
            this._ksmax = this._kxmax = kxmax;
            this._ktmax = this._kymax = kymax;
            this._kzmax = kzmax;
        }
        int jsmin = this._ksmin / (this._ls - 1);
        int jtmin = this._ktmin / (this._lt - 1);
        int jsmax = MathPlus.max(0, this._ksmax - 1) / (this._ls - 1);
        int jtmax = MathPlus.max(0, this._ktmax - 1) / (this._lt - 1);
        ArrayList<GlTextureName> staleList = new ArrayList<GlTextureName>();
        for (int jt = this._jtmin; jt <= this._jtmax; ++jt) {
            for (int js = this._jsmin; js <= this._jsmax; ++js) {
                if (!stale && js >= jsmin && jt >= jtmin && jsmax >= js && jtmax >= jt || this._tn[jt][js] == null) continue;
                staleList.add(this._tn[jt][js]);
                this._tn[jt][js] = null;
            }
        }
        int nstale = staleList.size();
        for (int jt = jtmin; jt <= jtmax; ++jt) {
            for (int js = jsmin; js <= jsmax; ++js) {
                GlTextureName tn = this._tn[jt][js];
                if (tn != null) continue;
                tn = !staleList.isEmpty() ? (GlTextureName)staleList.remove(--nstale) : this.makeTexture();
                this._tn[jt][js] = tn;
                this.loadTexture(js, jt);
            }
        }
        while (nstale > 0) {
            GlTextureName tn = (GlTextureName)staleList.remove(--nstale);
            tn.dispose();
        }
        this._jsmin = jsmin;
        this._jtmin = jtmin;
        this._jsmax = jsmax;
        this._jtmax = jtmax;
        this._texturesDirty = false;
    }

    private void updateTextures() {
        for (int jt = this._jtmin; jt <= this._jtmax; ++jt) {
            for (int js = this._jsmin; js <= this._jsmax; ++js) {
                if (this._tn[jt][js] == null) continue;
                this.loadTexture(js, jt);
            }
        }
        this._texturesDirty = false;
    }

    private void disposeTextures() {
        if (this._tn != null) {
            for (int jt = 0; jt < this._mt; ++jt) {
                for (int js = 0; js < this._ms; ++js) {
                    GlTextureName tn = this._tn[jt][js];
                    if (tn == null) continue;
                    tn.dispose();
                }
            }
            this._tn = null;
        }
    }

    private GlTextureName makeTexture() {
        Gl.glPixelStorei(3317, 1);
        GlTextureName tn = new GlTextureName();
        Gl.glBindTexture(3553, tn.name());
        Gl.glTexParameteri(3553, 10242, 10497);
        Gl.glTexParameteri(3553, 10243, 10497);
        Gl.glTexParameteri(3553, 10240, 9729);
        Gl.glTexParameteri(3553, 10241, 9729);
        Gl.glTexImage2D(3553, 0, 6408, this._ls, this._lt, 0, 6408, 5121, this._pixels);
        Gl.glBindTexture(3553, 0);
        return tn;
    }

    private void loadTexture(int js, int jt) {
        int ks = js * (this._ls - 1);
        int kt = jt * (this._lt - 1);
        int ls = MathPlus.min(this._ls, this._ns - ks);
        int lt = MathPlus.min(this._lt, this._nt - kt);
        if (this._axis == Axis.X) {
            this._f.get12(lt, ls, kt, ks, this._kxmin, this._floats);
        } else if (this._axis == Axis.Y) {
            this._f.get13(lt, ls, kt, this._kymin, ks, this._floats);
        } else if (this._axis == Axis.Z) {
            this._f.get23(lt, ls, this._kzmin, kt, ks, this._floats);
        }
        float fscale = 255.0f / (this._clipMax - this._clipMin);
        float fshift = this._clipMin;
        IndexColorModel icm = this._colorMap.getColorModel();
        for (int is = 0; is < ls; ++is) {
            for (int it = 0; it < lt; ++it) {
                float fi = (this._floats[is][it] - fshift) * fscale;
                if (fi < 0.0f) {
                    fi = 0.0f;
                }
                if (fi > 255.0f) {
                    fi = 255.0f;
                }
                int i = (int)(fi + 0.5f);
                int r = icm.getRed(i);
                int g = icm.getGreen(i);
                int b = icm.getBlue(i);
                int a = icm.getAlpha(i);
                int p = r & 0xFF | (g & 0xFF) << 8 | (b & 0xFF) << 16 | (a & 0xFF) << 24;
                this._pixels.put(is + it * this._ls, p);
            }
        }
        Gl.glPixelStorei(3317, 1);
        GlTextureName tn = this._tn[jt][js];
        Gl.glBindTexture(3553, tn.name());
        Gl.glTexSubImage2D(3553, 0, 0, 0, this._ls, this._lt, 6408, 5121, this._pixels);
        Gl.glBindTexture(3553, 0);
    }
}

