/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import net.imglib2.AbstractWrappedLocalizable;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.type.BooleanType;

class TrueCursor<T extends BooleanType<T>>
extends AbstractWrappedLocalizable<Cursor<T>>
implements Cursor<Void> {
    private long index;
    private final long maxIndex;
    private final boolean empty;

    public TrueCursor(Cursor<T> cursor, long size) {
        super(cursor);
        this.maxIndex = size;
        this.empty = size == 0L;
        this.reset();
    }

    protected TrueCursor(TrueCursor<T> other) {
        super((Localizable)((Cursor)other.source).copyCursor());
        this.index = other.index;
        this.empty = other.empty;
        this.maxIndex = other.maxIndex;
    }

    public Void get() {
        return null;
    }

    public void jumpFwd(long steps) {
        for (long i = 0L; i < steps; ++i) {
            this.fwd();
        }
    }

    public void fwd() {
        if (this.empty) {
            return;
        }
        while (!((BooleanType)((Cursor)this.source).next()).get()) {
        }
        ++this.index;
    }

    public void reset() {
        this.index = 0L;
        ((Cursor)this.source).reset();
    }

    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public Void next() {
        this.fwd();
        return this.get();
    }

    public TrueCursor<T> copy() {
        return new TrueCursor<T>(this);
    }

    public TrueCursor<T> copyCursor() {
        return this.copy();
    }
}

