/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.neigh;

import net.imagej.Dataset;
import net.imagej.Extents;
import net.imagej.Position;
import net.imagej.plugins.commands.neigh.Neighborhood3x3Watcher;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.util.RealRect;

public class Neighborhood3x3Operation {
    private final Dataset input;
    private Img<? extends RealType<?>> inputImage;
    private Img<? extends RealType<?>> inputImageCopy;
    private final RealRect selection;
    private final Neighborhood3x3Watcher watcher;

    public Neighborhood3x3Operation(Dataset input, RealRect selection, Neighborhood3x3Watcher watcher) {
        this.input = input;
        this.watcher = watcher;
        this.selection = selection;
        if (watcher == null) {
            throw new IllegalArgumentException("neighborhood watcher cannot be null!");
        }
    }

    public void run() {
        this.checkInput();
        this.setupWorkingData();
        this.runAssignment();
    }

    private void checkInput() {
        if (this.input == null) {
            throw new IllegalArgumentException("input Dataset is null");
        }
        if (this.input.getImgPlus() == null) {
            throw new IllegalArgumentException("input Img is null");
        }
    }

    private void setupWorkingData() {
        this.inputImage = this.input.getImgPlus();
        this.inputImageCopy = this.cloneImage(this.inputImage);
    }

    private void runAssignment() {
        long[] planeDims = new long[this.inputImage.numDimensions() - 2];
        for (int i = 0; i < planeDims.length; ++i) {
            planeDims[i] = this.inputImage.dimension(i + 2);
        }
        Extents extents = new Extents(planeDims);
        Position planePos = extents.createPosition();
        if (planeDims.length == 0) {
            this.applyOperationToPlane(planePos);
        } else {
            while (planePos.hasNext()) {
                planePos.fwd();
                this.applyOperationToPlane(planePos);
            }
        }
        this.input.update();
    }

    private void applyOperationToPlane(Position planePos) {
        long[] imageDims = new long[this.inputImage.numDimensions()];
        this.inputImage.dimensions(imageDims);
        if (this.selection.width == 0.0) {
            this.selection.width = (int)imageDims[0];
        }
        if (this.selection.height == 0.0) {
            this.selection.height = (int)imageDims[1];
        }
        RandomAccess outputAccessor = this.inputImage.randomAccess();
        ExtendedRandomAccessibleInterval inputInterval = Views.extendMirrorSingle(this.inputImageCopy);
        RandomAccess extendedInput = inputInterval.randomAccess();
        this.watcher.setup();
        long[] inputPosition = new long[imageDims.length];
        long[] localInputPosition = new long[imageDims.length];
        for (int i = 2; i < inputPosition.length; ++i) {
            inputPosition[i] = planePos.getLongPosition(i - 2);
            localInputPosition[i] = planePos.getLongPosition(i - 2);
        }
        long minX = (long)this.selection.x;
        long minY = (long)this.selection.y;
        long width = (long)this.selection.width;
        long height = (long)this.selection.height;
        for (long y = minY; y < minY + height; ++y) {
            inputPosition[1] = y;
            for (long x = minX; x < minX + width; ++x) {
                inputPosition[0] = x;
                this.watcher.initializeNeighborhood(inputPosition);
                for (int dy = -1; dy <= 1; ++dy) {
                    localInputPosition[1] = inputPosition[1] + (long)dy;
                    for (int dx = -1; dx <= 1; ++dx) {
                        localInputPosition[0] = inputPosition[0] + (long)dx;
                        extendedInput.setPosition(localInputPosition);
                        double localValue = ((RealType)extendedInput.get()).getRealDouble();
                        this.watcher.visitLocation(dx, dy, localValue);
                    }
                }
                outputAccessor.setPosition(inputPosition);
                ((RealType)outputAccessor.get()).setReal(this.watcher.calcOutputValue());
            }
        }
    }

    private Img<? extends RealType<?>> cloneImage(Img image) {
        long[] dimensions = new long[image.numDimensions()];
        image.dimensions(dimensions);
        Img copyOfImg = image.factory().create(dimensions, image.firstElement());
        long[] position = new long[dimensions.length];
        Cursor cursor = image.localizingCursor();
        RandomAccess access = copyOfImg.randomAccess();
        while (cursor.hasNext()) {
            cursor.next();
            double currValue = ((RealType)cursor.get()).getRealDouble();
            cursor.localize(position);
            access.setPosition(position);
            ((RealType)access.get()).setReal(currValue);
        }
        return copyOfImg;
    }
}

