/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.process.FloatPolygon;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.imaging.Segmentation;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.OptionPanel;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import ini.trakem2.vector.VectorString3D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AreaWrapper {
    private final Area area;
    private Painter painter = null;
    private Rectangle r_old = null;
    private Displayable source = null;
    private boolean something_eroded = false;
    private Segmentation.BlowCommander blowcommander = null;
    private List<Runnable> post_mouseReleased_tasks = null;
    private static Integer controller_key = null;
    public static final int PAINT_OVERLAP = 0;
    public static final int PAINT_EXCLUDE = 1;
    public static final int PAINT_ERODE = 2;
    public static final PaintParameters PP = new PaintParameters();

    public AreaWrapper(Displayable source, Area area) {
        this.source = source;
        this.area = area;
    }

    public AreaWrapper() {
        this(null, new Area());
    }

    public AreaWrapper(Area area) {
        this(null, area);
    }

    public void setSource(Displayable source) {
        this.source = source;
    }

    public Displayable getSource() {
        return this.source;
    }

    public Area getArea() {
        return this.area;
    }

    public void putData(Area a) {
        if (this.area == a) {
            return;
        }
        this.area.reset();
        this.area.add(a);
    }

    public void add(Area wa, Layer layer) {
        try {
            this.area.add(wa.createTransformedArea(this.source.getAffineTransform().createInverse()));
            ((AreaContainer)((Object)this.source)).calculateBoundingBox(layer);
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
        }
    }

    public void subtract(Area wa, Layer layer) {
        try {
            this.area.subtract(wa.createTransformedArea(this.source.getAffineTransform().createInverse()));
            ((AreaContainer)((Object)this.source)).calculateBoundingBox(layer);
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
        }
    }

    public void add(Area a, AffineTransform to_world) {
        try {
            to_world.preConcatenate(this.source.getAffineTransform().createInverse());
            this.area.add(a.createTransformedArea(to_world));
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
        }
    }

    public void paint(Graphics2D g, AffineTransform aff, boolean fill, Color color) {
        g.setColor(color);
        if (!this.area.isEmpty()) {
            if (fill) {
                g.fill(this.area.createTransformedArea(aff));
            } else {
                g.draw(this.area.createTransformedArea(aff));
            }
        }
        if (null != this.painter) {
            try {
                this.painter.paint(g, aff, fill);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Area makeMouseBrush(int diameter, double mag) {
        Display front = Display.getFront();
        Area brush = AreaWrapper.makeBrush(diameter, mag);
        if (null == front) {
            return brush;
        }
        Point p = front.getCanvas().getCursorLoc();
        return brush.createTransformedArea(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, p.x, p.y));
    }

    public static Area makeBrush(int diameter, double mag) {
        if (diameter < 1) {
            return null;
        }
        if (mag >= 1.0) {
            return new Area(new OvalRoi(-diameter / 2, -diameter / 2, diameter, diameter).getPolygon());
        }
        int screen_diameter = (int)((double)diameter * mag);
        if (0 == screen_diameter) {
            return null;
        }
        Area brush = new Area(new OvalRoi(-screen_diameter / 2, -screen_diameter / 2, screen_diameter, screen_diameter).getPolygon());
        AffineTransform at = new AffineTransform();
        at.scale(1.0 / mag, 1.0 / mag);
        return brush.createTransformedArea(at);
    }

    public void mousePressed(MouseEvent me, Layer la, int x_p_w, int y_p_w, double mag) {
        this.mousePressed(me, la, x_p_w, y_p_w, mag, null);
    }

    /*
     * WARNING - void declaration
     */
    public void mousePressed(MouseEvent me, Layer la, int x_p_w, int y_p_w, double mag, List<Runnable> post_tasks) {
        this.post_mouseReleased_tasks = post_tasks;
        int tool = ProjectToolbar.getToolId();
        if (17 == tool) {
            if (null != controller_key) {
                return;
            }
            if (me.isShiftDown()) {
                void var16_28;
                Area bmin = null;
                Area bmax = null;
                ArrayList<Area> intersecting = new ArrayList<Area>();
                int min_area = Integer.MAX_VALUE;
                int max_area = 0;
                Map<Displayable, List<Area>> other_areas = la.getParent().findAreas(la, new Rectangle(x_p_w, y_p_w, 1, 1), true);
                for (Map.Entry<Displayable, List<Area>> entry : other_areas.entrySet()) {
                    Displayable displayable = entry.getKey();
                    for (Area a : entry.getValue()) {
                        Point2D.Double p = displayable.inverseTransformPoint(x_p_w, y_p_w);
                        Polygon polygon2 = M.findPath(a, (int)p.x, (int)p.y);
                        if (null == polygon2) continue;
                        Area bw = new Area(polygon2).createTransformedArea(displayable.at);
                        Rectangle bounds = bw.getBounds();
                        int pol_area = bounds.width * bounds.height;
                        if (pol_area < min_area) {
                            bmin = bw;
                            min_area = pol_area;
                        }
                        if (pol_area > max_area) {
                            bmax = bw;
                            max_area = pol_area;
                        }
                        intersecting.add(bw);
                    }
                }
                if (intersecting.size() > 1) {
                    Polygon polygon;
                    Area compound = new Area(bmax);
                    for (Area area : intersecting) {
                        if (bmax == area) continue;
                        compound.intersect(area);
                    }
                    if (!compound.isSingular() && null != (polygon = M.findPath(compound, x_p_w, y_p_w))) {
                        compound = new Area(polygon);
                    }
                    Rectangle rectangle = compound.getBounds();
                    int n = rectangle.width * rectangle.height;
                    if (n < min_area) {
                        min_area = n;
                        bmin = compound;
                    }
                }
                Area all = new Area();
                for (Map.Entry<Displayable, List<Area>> entry : la.getParent().findAreas(la, Display.getFront().getCanvas().getSrcRect(), true).entrySet()) {
                    for (Area ar : entry.getValue()) {
                        all.add(ar.createTransformedArea(entry.getKey().at));
                    }
                }
                Polygon polygon = M.findPath(all, x_p_w, y_p_w);
                if (null == polygon && this.source.getProject().getBooleanProperty("flood_fill_to_image_edge")) {
                    Area area = la.getPatchArea(true);
                    Rectangle bounds = area.getBounds();
                    if (0 != bounds.width && 0 != bounds.height) {
                        area.subtract(all);
                        Polygon polygon2 = M.findPath(area, x_p_w, y_p_w);
                    }
                }
                if (null != var16_28) {
                    Rectangle rectangle = var16_28.getBounds();
                    int pol_area = rectangle.width * rectangle.height;
                    if (pol_area < min_area) {
                        min_area = pol_area;
                        bmin = new Area((Shape)var16_28);
                    }
                }
                if (null != bmin) {
                    try {
                        Area area = bmin.createTransformedArea(this.source.getAffineTransform().createInverse());
                        if (me.isAltDown()) {
                            this.area.subtract(area);
                        } else {
                            this.area.add(area);
                        }
                        ((AreaContainer)((Object)this.source)).calculateBoundingBox(la);
                        Display.repaint(la, bmin.getBounds(), 1);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        IJError.print(noninvertibleTransformException);
                    }
                }
            } else {
                if (null != this.painter) {
                    this.painter.quit();
                }
                try {
                    this.painter = new Painter(this.area, mag, la, this.source, me.getModifiers());
                }
                catch (Exception e) {
                    Utils.log2("Oops: " + e);
                }
            }
        } else {
            ArrayList<Runnable> ptasks = new ArrayList<Runnable>();
            if (null != this.post_mouseReleased_tasks) {
                ptasks.addAll(this.post_mouseReleased_tasks);
                this.post_mouseReleased_tasks = null;
            }
            final Displayable src = this.source;
            ptasks.add(new Runnable(){

                @Override
                public void run() {
                    src.getLayerSet().addDataEditStep(src);
                }
            });
            if (15 == tool) {
                ptasks.add(new Runnable(){

                    @Override
                    public void run() {
                        src.getLayerSet().addDataEditStep(src);
                    }
                });
                if (Utils.isControlDown(me)) {
                    try {
                        this.blowcommander = Segmentation.blowRoi(this, la, Display.getFront().getCanvas().getSrcRect(), x_p_w, y_p_w, ptasks);
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                } else {
                    Segmentation.fastMarching(this, la, Display.getFront().getCanvas().getSrcRect(), x_p_w, y_p_w, ptasks);
                }
            } else if (18 == tool) {
                Segmentation.magicWand(this, la, Display.getFront().getCanvas().getSrcRect(), x_p_w, y_p_w, ptasks, me.isShiftDown(), me.isAltDown());
            }
        }
    }

    public void mouseDragged(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        if (null != controller_key && 77 == controller_key && ProjectToolbar.getToolId() == 17) {
            Rectangle r = this.area.getBounds();
            this.area.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x_d - x_d_old, y_d - y_d_old));
            r.add(new Rectangle(r.x + (x_d_old - x_d), r.y + (y_d_old - y_d), r.width, r.height));
            Display.getFront().getCanvas().repaint(this.source.at.createTransformedShape(r).getBounds(), 1);
            return;
        }
        if (null != this.blowcommander) {
            this.blowcommander.mouseDragged(me, la, x_p, y_p, x_d, y_d, x_d_old, y_d_old);
        }
    }

    public void mouseReleased(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        if (null != this.painter) {
            this.painter.quit();
            this.painter = null;
        }
        if (null != controller_key) {
            controller_key = null;
            return;
        }
        if (null != this.blowcommander) {
            this.blowcommander.mouseReleased(me, la, x_p, y_p, x_d, y_d, x_r, y_r);
            this.blowcommander = null;
        }
        if (null != this.post_mouseReleased_tasks) {
            for (Runnable task : this.post_mouseReleased_tasks) {
                task.run();
            }
        }
        if (this.something_eroded) {
            Display.repaint(this.source.getLayerSet());
            this.something_eroded = false;
        }
        if (null != this.r_old) {
            Display.repaint(la, this.r_old, 3, false);
            this.r_old = null;
        }
        Display.repaint(la, this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyPressed(KeyEvent ke, DisplayCanvas dc, Layer la) {
        Roi roi;
        int keyCode;
        block29: {
            keyCode = ke.getKeyCode();
            if (null != controller_key && 10 == keyCode) {
                controller_key = null;
                ke.consume();
                return;
            }
            if (77 == keyCode && ProjectToolbar.getToolId() == 17) {
                controller_key = keyCode;
                ke.consume();
                return;
            }
            try {
                switch (keyCode) {
                    case 67: {
                        DisplayCanvas.setCopyBuffer(this.source.getClass(), this.area.createTransformedArea(this.source.getAffineTransform()));
                        ke.consume();
                        return;
                    }
                    case 86: {
                        Area wa = (Area)DisplayCanvas.getCopyBuffer(this.source.getClass());
                        if (null != wa) {
                            this.source.getLayerSet().addDataEditStep(this.source);
                            this.add(wa, la);
                            ((AreaContainer)((Object)this.source)).calculateBoundingBox(la);
                            this.source.getLayerSet().addDataEditStep(this.source);
                        }
                        ke.consume();
                        return;
                    }
                    case 70: {
                        this.source.getLayerSet().addDataEditStep(this.source);
                        this.fillHoles();
                        this.source.getLayerSet().addDataEditStep(this.source);
                        ke.consume();
                        return;
                    }
                    case 88: {
                        if (this.area.isEmpty()) {
                            return;
                        }
                        this.source.getLayerSet().addDataEditStep(this.source);
                        this.area.reset();
                        ((AreaContainer)((Object)this.source)).calculateBoundingBox(la);
                        this.source.getLayerSet().addDataEditStep(this.source);
                        ke.consume();
                        return;
                    }
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
            finally {
                if (!ke.isConsumed()) break block29;
                Display.repaint(la, this.source.getBoundingBox(), 5);
                this.source.linkPatches();
                return;
            }
        }
        if (null == (roi = dc.getFakeImagePlus().getRoi())) {
            return;
        }
        switch (keyCode) {
            case 65: 
            case 68: 
            case 75: {
                if (M.isAreaROI(roi)) break;
                Utils.log("Only accepts region ROIs, not lines.");
                return;
            }
        }
        ShapeRoi sroi = new ShapeRoi(roi);
        try {
            switch (keyCode) {
                case 65: {
                    this.add(M.getArea(sroi), la);
                    ke.consume();
                    break;
                }
                case 68: {
                    this.subtract(M.getArea(sroi), la);
                    ke.consume();
                    break;
                }
            }
            if (!ke.isConsumed()) return;
            Display.repaint(la, this.source.getBoundingBox(), 5);
            this.source.linkPatches();
            return;
        }
        catch (Exception e) {
            Utils.log("Could not add ROI to area at layer " + dc.getDisplay().getLayer() + " : " + e);
        }
    }

    public void fillHoles() {
        Polygon pol = new Polygon();
        PathIterator pit = this.area.getPathIterator(null);
        while (!pit.isDone()) {
            float[] coords = new float[6];
            int seg_type = pit.currentSegment(coords);
            switch (seg_type) {
                case 0: 
                case 1: {
                    pol.addPoint((int)coords[0], (int)coords[1]);
                    break;
                }
                case 4: {
                    this.area.add(new Area(pol));
                    pol = new Polygon();
                    break;
                }
                default: {
                    Utils.log2("WARNING: unhandled seg type.");
                }
            }
            pit.next();
            if (!pit.isDone()) continue;
            break;
        }
    }

    public static class PaintParameters {
        public float default_alpha = 0.4f;
        public int paint_mode = 0;

        public boolean setup() {
            GenericDialog gd = new GenericDialog("Paint parameters");
            gd.addSlider("Default_alpha", 0.0, 100.0, (double)(this.default_alpha * 100.0f));
            String[] modes = new String[]{"Allow overlap", "Exclude others", "Erode others"};
            gd.addChoice("Paint mode", modes, modes[this.paint_mode]);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.default_alpha = (float)gd.getNextNumber();
            if (this.default_alpha > 1.0f) {
                this.default_alpha = 1.0f;
            } else if (this.default_alpha < 0.0f) {
                this.default_alpha = 0.4f;
            }
            this.paint_mode = gd.getNextChoiceIndex();
            Display.toolChanged(17);
            return true;
        }

        public OptionPanel asOptionPanel() {
            OptionPanel op = new OptionPanel();
            String[] modes = new String[]{"Allow overlap", "Exclude others", "Erode others"};
            op.addChoice("Area paint mode:", modes, this.paint_mode, new OptionPanel.ChoiceIntSetter(this, "paint_mode"));
            return op;
        }
    }

    private final class Painter
    extends Thread {
        private final Area target_area;
        private final Area area;
        private final LinkedList<Point> points;
        private volatile Point previous_p;
        private final int brush_size;
        private final Area brush;
        private final int leftClick = 16;
        private final int alt = 9;
        private final DisplayCanvas dc;
        private final int flags;
        private final boolean adding;
        private final Layer la;
        private final Displayable source;
        private final Object arealock;
        private final Object pointslock;
        private final ExecutorService accumulator;
        private final ScheduledExecutorService composer;
        private final ScheduledFuture<?> composition;
        private final Runnable interpolator;
        final AtomicBoolean quitted;

        Painter(Area area, double mag, Layer la, final Displayable source, int flags) throws Exception {
            super("AreaWrapper.Painter");
            this.points = new LinkedList();
            this.previous_p = null;
            this.leftClick = 16;
            this.alt = 9;
            this.dc = Display.getFront().getCanvas();
            this.arealock = new Object();
            this.pointslock = new Object();
            this.quitted = new AtomicBoolean(false);
            this.setPriority(5);
            this.la = la;
            this.source = source;
            this.flags = flags;
            boolean bl = this.adding = 0 == (flags & 9);
            if (this.adding) {
                this.target_area = area;
                this.area = new Area();
            } else {
                this.target_area = area;
                this.area = area;
            }
            this.brush_size = ProjectToolbar.getBrushSize();
            this.brush = AreaWrapper.makeBrush(this.brush_size, mag);
            if (null == this.brush) {
                throw new RuntimeException("Can't paint with brush of size 0.");
            }
            this.accumulator = Utils.newFixedThreadPool(1, "AreaWrapper-accumulator");
            this.composer = Executors.newScheduledThreadPool(1);
            this.interpolator = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AffineTransform at_inv;
                    ArrayList ps;
                    int n_points;
                    Object object = Painter.this.pointslock;
                    synchronized (object) {
                        n_points = Painter.this.points.size();
                        if (0 == n_points) {
                            return;
                        }
                        ps = new ArrayList(Painter.this.points);
                        Painter.this.points.clear();
                        Painter.this.points.add(ps.get(n_points - 1));
                    }
                    try {
                        at_inv = source.getAffineTransform().createInverse();
                    }
                    catch (NoninvertibleTransformException nite) {
                        IJError.print(nite);
                        return;
                    }
                    if (n_points < 2) {
                        AffineTransform atb = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, ((Point)ps.get((int)0)).x, ((Point)ps.get((int)0)).y);
                        atb.preConcatenate(at_inv);
                        Area chunk = Painter.this.slashInInts(Painter.this.brush.createTransformedArea(atb));
                        Object object2 = Painter.this.arealock;
                        synchronized (object2) {
                            if (Painter.this.adding) {
                                Painter.this.area.add(chunk);
                            } else {
                                Painter.this.area.subtract(chunk);
                            }
                        }
                        return;
                    }
                    try {
                        int[] xp = new int[ps.size()];
                        int[] yp = new int[xp.length];
                        int j = 0;
                        for (Point p : ps) {
                            xp[j] = p.x;
                            yp[j] = p.y;
                            ++j;
                        }
                        PolygonRoi proi = new PolygonRoi(xp, yp, xp.length, 6);
                        proi.fitSpline();
                        FloatPolygon fp = proi.getFloatPolygon();
                        proi = null;
                        double[] xpd = new double[fp.npoints];
                        double[] ypd = new double[fp.npoints];
                        for (int i = 0; i < xpd.length; ++i) {
                            xpd[i] = fp.xpoints[i];
                            ypd[i] = fp.ypoints[i];
                        }
                        fp = null;
                        VectorString3D vs = new VectorString3D(xpd, ypd, new double[xpd.length], false);
                        double delta = (double)Painter.this.brush_size / 10.0;
                        if (delta < 1.0) {
                            delta = 1.0;
                        }
                        vs.resample(delta);
                        xpd = vs.getPoints(0);
                        ypd = vs.getPoints(1);
                        vs = null;
                        Point po = (Point)ps.get(0);
                        xpd[0] = po.x;
                        ypd[0] = po.y;
                        po = (Point)ps.get(ps.size() - 1);
                        xpd[xpd.length - 1] = po.x;
                        ypd[ypd.length - 1] = po.y;
                        Area chunk = new Area();
                        AffineTransform atb = new AffineTransform();
                        for (int i = 0; i < xpd.length; ++i) {
                            atb.setToTranslation((int)xpd[i], (int)ypd[i]);
                            atb.preConcatenate(at_inv);
                            chunk.add(Painter.this.slashInInts(Painter.this.brush.createTransformedArea(atb)));
                        }
                        Object object3 = Painter.this.arealock;
                        synchronized (object3) {
                            if (Painter.this.adding) {
                                Painter.this.area.add(chunk);
                            } else {
                                Painter.this.area.subtract(chunk);
                            }
                        }
                        Display.repaint(Painter.this.la, 3, AreaWrapper.this.r_old, false, false);
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
            };
            this.composition = this.composer.scheduleWithFixedDelay(this.interpolator, 200L, 500L, TimeUnit.MILLISECONDS);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void paint(Graphics2D g, AffineTransform aff, boolean fill) {
            if (this.area == this.target_area) {
                return;
            }
            if (null != this.area) {
                Object object = this.arealock;
                synchronized (object) {
                    if (null == this.area) {
                        return;
                    }
                    if (fill) {
                        g.fill(this.area.createTransformedArea(aff));
                    } else {
                        g.draw(this.area.createTransformedArea(aff));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void quit() {
            block31: {
                if (this.isInterrupted()) {
                    return;
                }
                this.interrupt();
                if (this.quitted.getAndSet(true)) {
                    return;
                }
                try {
                    Area added;
                    int psize;
                    this.accumulator.shutdownNow();
                    this.composition.cancel(true);
                    this.composer.shutdown();
                    try {
                        this.composer.awaitTermination(30L, TimeUnit.SECONDS);
                        this.accumulator.awaitTermination(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Object object = this.pointslock;
                    synchronized (object) {
                        psize = this.points.size();
                    }
                    if (psize > 1) {
                        this.interpolator.run();
                    } else if (this.adding) {
                        object = this.arealock;
                        synchronized (object) {
                            this.target_area.add(this.area);
                        }
                    } else {
                        return;
                    }
                    if (!this.adding) break block31;
                    Object object2 = this.arealock;
                    synchronized (object2) {
                        added = new Area(this.target_area);
                        added.add(this.area);
                    }
                    if (0 != AreaWrapper.PP.paint_mode) {
                        Map<Displayable, List<Area>> other_areas = this.la.getParent().findAreas(this.la, added.createTransformedArea(this.source.getAffineTransform()).getBounds(), true);
                        HashMap<Displayable, 2> ops = 2 == AreaWrapper.PP.paint_mode ? new HashMap<Displayable, 2>() : null;
                        for (Map.Entry<Displayable, List<Area>> e : other_areas.entrySet()) {
                            Displayable d = e.getKey();
                            if (this.source == d) continue;
                            block21: for (final Area a : e.getValue()) {
                                if (this.area == a) continue;
                                switch (AreaWrapper.PP.paint_mode) {
                                    case 2: {
                                        AffineTransform aff = new AffineTransform(this.source.getAffineTransform());
                                        aff.preConcatenate(d.at.createInverse());
                                        final Area ta = added.createTransformedArea(aff);
                                        Rectangle ta_bounds = ta.getBounds();
                                        if (!a.getBounds().intersects(ta_bounds)) continue block21;
                                        ops.put(d, new Runnable(){

                                            @Override
                                            public void run() {
                                                a.subtract(ta);
                                            }
                                        });
                                        continue block21;
                                    }
                                    case 1: {
                                        AffineTransform aff = new AffineTransform(d.at);
                                        aff.preConcatenate(this.source.getAffineTransform().createInverse());
                                        Area q = a.createTransformedArea(aff);
                                        if (!q.getBounds().intersects(added.getBounds())) continue block21;
                                        added.subtract(q);
                                        continue block21;
                                    }
                                }
                                Utils.log2("Can't handle paint mode " + AreaWrapper.PP.paint_mode);
                            }
                        }
                        if (null != ops && ops.size() > 0) {
                            this.source.getLayerSet().addDataEditStep(ops.keySet());
                            for (Runnable r : ops.values()) {
                                r.run();
                            }
                            AreaWrapper.this.something_eroded = true;
                        }
                    }
                    object2 = this.arealock;
                    synchronized (object2) {
                        this.target_area.reset();
                        this.target_area.add(added);
                    }
                }
                catch (Exception ee) {
                    IJError.print(ee);
                }
            }
        }

        @Override
        public void run() {
            AffineTransform at_inv;
            try {
                at_inv = this.source.getAffineTransform().createInverse();
            }
            catch (NoninvertibleTransformException nite) {
                IJError.print(nite);
                return;
            }
            while (!this.isInterrupted()) {
                if (0 == (this.dc.getModifiers() & 0x10)) {
                    this.quit();
                    return;
                }
                final Point p = this.dc.getCursorLoc();
                if (p.equals(this.previous_p)) {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (!this.dc.getSrcRect().contains(p.x, p.y)) continue;
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AffineTransform aff = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, p.x, p.y);
                        aff.preConcatenate(at_inv);
                        Area slash = Painter.this.slashInInts(Painter.this.brush.createTransformedArea(aff));
                        Object object = Painter.this.arealock;
                        synchronized (object) {
                            if (0 == (Painter.this.flags & 9)) {
                                Painter.this.area.add(slash);
                            } else {
                                Painter.this.area.subtract(slash);
                            }
                        }
                        object = Painter.this.pointslock;
                        synchronized (object) {
                            Painter.this.points.add(p);
                        }
                        Rectangle copy = new Rectangle(p.x - Painter.this.brush_size / 2, p.y - Painter.this.brush_size / 2, Painter.this.brush_size, Painter.this.brush_size);
                        Display.repaint(Painter.this.la, 3, copy, false, false);
                        Object object2 = Painter.this.arealock;
                        synchronized (object2) {
                            if (null != AreaWrapper.this.r_old) {
                                copy.add(AreaWrapper.this.r_old);
                            }
                            AreaWrapper.this.r_old = copy;
                        }
                    }
                };
                try {
                    this.accumulator.submit(task);
                }
                catch (Throwable t) {
                    return;
                }
                this.previous_p = p;
            }
        }

        private final Area slashInInts(Area area) {
            int[] x = new int[400];
            int[] y = new int[400];
            int next = 0;
            PathIterator pit = area.getPathIterator(null);
            while (!pit.isDone()) {
                if (x.length == next) {
                    int[] x2 = new int[x.length + 200];
                    int[] y2 = new int[y.length + 200];
                    System.arraycopy(x, 0, x2, 0, x.length);
                    System.arraycopy(y, 0, y2, 0, y.length);
                    x = x2;
                    y = y2;
                }
                float[] coords = new float[6];
                int seg_type = pit.currentSegment(coords);
                switch (seg_type) {
                    case 0: 
                    case 1: {
                        x[next] = (int)coords[0];
                        y[next] = (int)coords[1];
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        Utils.log2("WARNING: slashInInts unhandled seg type.");
                    }
                }
                pit.next();
                if (pit.isDone()) break;
                ++next;
            }
            if (x.length == next) {
                int[] x2 = new int[next];
                int[] y2 = new int[next];
                System.arraycopy(x, 0, x2, 0, next);
                System.arraycopy(y, 0, y2, 0, next);
                x = x2;
                y = y2;
            }
            return new Area(new Polygon(x, y, next));
        }
    }
}

