/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Utils;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.List;

public class LayerStack
extends ImageStack {
    private final List<Layer> layers;
    private final int type;
    private final double scale;
    private final Class<?> clazz;
    private final int c_alphas;
    private final boolean invert;
    final Rectangle roi;
    final HashMap<Long, Long> id_cache = new HashMap();
    private ImagePlus layer_imp = null;

    public LayerStack(LayerSet layer_set, double scale, int type, Class<?> clazz, int c_alphas, boolean invert) {
        this(layer_set.getLayers(), layer_set.get2DBounds(), scale, type, clazz, c_alphas, invert);
    }

    public LayerStack(List<Layer> layers, Rectangle roi, double scale, int type, Class<?> clazz, int c_alphas, boolean invert) {
        super((int)((double)roi.width * scale), (int)((double)roi.height * scale), (ColorModel)Patch.DCM);
        if (scale <= 0.0 || scale > 1.0) {
            throw new IllegalArgumentException("Cannot operate with a scale larger than 1 or smaller or equal to 0!");
        }
        this.layers = layers;
        this.type = type;
        this.scale = scale;
        this.clazz = clazz;
        this.c_alphas = c_alphas;
        this.invert = invert;
        this.roi = new Rectangle(roi);
    }

    public LayerStack(LayerSet layer_set, double scale, int type, Class<?> clazz, int c_alphas) {
        this(layer_set, scale, type, clazz, c_alphas, false);
    }

    public void addSlice(String sliceLabel, Object pixels) {
        Utils.log("LayerStack: cannot add slices.");
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
        Utils.log("LayerStack: cannot add slices.");
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
        Utils.log("LayerStack: cannot add slices.");
    }

    public void deleteSlice(int n) {
        Utils.log("LayerStack: cannot delete slices.");
    }

    public void deleteLastSlice() {
        Utils.log("LayerStack: cannot delete slices.");
    }

    public Object getPixels(int n) {
        if (n < 1 || n > this.layers.size()) {
            return null;
        }
        return this.getProcessor(n).getPixels();
    }

    public void setPixels(Object pixels, int n) {
        Utils.log("LayerStack: cannot set pixels.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageProcessor getProcessor(int n) {
        ImageProcessor ip;
        Long cid;
        if (n < 1 || n > this.layers.size()) {
            return null;
        }
        Layer layer = this.layers.get(n - 1);
        Loader loader = layer.getProject().getLoader();
        HashMap<Long, Long> hashMap = this.id_cache;
        synchronized (hashMap) {
            cid = this.id_cache.get(layer.getId());
            if (null == cid) {
                cid = loader.getNextTempId();
                this.id_cache.put(layer.getId(), cid);
            }
        }
        Long l = cid;
        synchronized (l) {
            ImagePlus imp = loader.getCachedImagePlus(cid);
            if (null == imp || null == imp.getProcessor() || null == imp.getProcessor().getPixels()) {
                ip = loader.getFlatImage(layer, this.roi, this.scale, this.c_alphas, this.type, this.clazz, null).getProcessor();
                if (this.invert) {
                    ip.invert();
                }
                loader.cacheImagePlus(cid, new ImagePlus("", ip));
            } else {
                ip = imp.getProcessor();
            }
        }
        return ip;
    }

    public int getSize() {
        return this.layers.size();
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.layers.size()) {
            return null;
        }
        return this.layers.get(n - 1).getTitle();
    }

    public Object[] getImageArray() {
        this.layers.get(0).getProject().getLoader().releaseToFit(this.getSize() * this.getWidth() * this.getHeight() * 4 * 3);
        Object[] ia = new Object[this.getSize()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.getProcessor(i + 1).getPixels();
        }
        return ia;
    }

    public void setSliceLabel(String label, int n) {
        Utils.log("LayerStack: cannot set the slice label.");
    }

    public boolean isVirtual() {
        return true;
    }

    public boolean isHSB() {
        return false;
    }

    public boolean isRGB() {
        return false;
    }

    public void trim() {
    }

    public int getType() {
        return this.type;
    }

    public synchronized ImagePlus getImagePlus() {
        if (null == this.layer_imp) {
            this.layer_imp = new ImagePlus("LayerSet Stack", (ImageStack)this);
            Calibration cal = this.layers.get(0).getParent().getCalibrationCopy();
            cal.pixelWidth /= this.scale;
            cal.pixelHeight /= this.scale;
            cal.pixelDepth = this.layers.get(0).getThickness() * cal.pixelWidth / this.scale;
            this.layer_imp.setCalibration(cal);
        }
        return this.layer_imp;
    }
}

