/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.DirectoryChooser;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Saver;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import mpicbg.trakem2.transform.ExportUnsignedShort;
import mpicbg.trakem2.util.Downsampler;

public class ExportMultilevelTiles {
    private static Runnable makeTileRunnable(final Layer layer, final Rectangle srcRect, final double mag, final int c_alphas, final int type, final Class<?> clazz, final String file_path, final Saver saver, final int tileWidth, final int tileHeight, final boolean skip_empty_tiles, final boolean padding) {
        return new Runnable(){

            @Override
            public void run() {
                ImagePlus imp = null;
                if (srcRect.width > 0 && srcRect.height > 0) {
                    imp = layer.getProject().getLoader().getFlatImage(layer, srcRect, mag, c_alphas, type, clazz, null, true);
                    if (skip_empty_tiles && (layer.find(srcRect, true).isEmpty() || ExportMultilevelTiles.isEmptyTile(imp.getProcessor()))) {
                        return;
                    }
                } else {
                    if (skip_empty_tiles) {
                        return;
                    }
                    imp = new ImagePlus("", (ImageProcessor)new ByteProcessor(tileWidth, tileHeight));
                }
                if (padding && (imp.getWidth() < tileWidth || imp.getHeight() < tileHeight)) {
                    ImagePlus imp2 = new ImagePlus(imp.getTitle(), imp.getProcessor().createProcessor(tileWidth, tileHeight));
                    if (imp2.getType() == 4) {
                        Roi roi = new Roi(0, 0, tileWidth, tileHeight);
                        imp2.setRoi(roi);
                        imp2.getProcessor().setValue(0.0);
                        imp2.getProcessor().fill();
                    }
                    imp2.getProcessor().insert(imp.getProcessor(), 0, 0);
                    imp.flush();
                    imp = imp2;
                }
                saver.save(imp, file_path);
                imp.flush();
            }
        };
    }

    private static int[] determineClosestPowerOfTwo(int edge) {
        int[] starter = new int[]{1, 2, 3, 5};
        int[] larger = new int[starter.length];
        System.arraycopy(starter, 0, larger, 0, starter.length);
        for (int i = 0; i < larger.length; ++i) {
            while (larger[i] < edge) {
                int n = i;
                larger[n] = larger[n] * 2;
            }
        }
        int min_larger = larger[0];
        int min_i = 0;
        for (int i = 1; i < larger.length; ++i) {
            if (larger[i] >= min_larger) continue;
            min_i = i;
            min_larger = larger[i];
        }
        return new int[]{min_larger, starter[min_i]};
    }

    private static final String makeTilePath(int type, String base_dir, int section, int row, int column, int scale_pow) {
        if (!base_dir.endsWith("/")) {
            base_dir = base_dir + "/";
        }
        switch (type) {
            case 0: {
                return base_dir + section + "/" + row + "_" + column + "_" + scale_pow;
            }
            case 1: {
                return base_dir + section + "/" + scale_pow + "/" + row + "_" + column;
            }
        }
        return null;
    }

    private static final boolean isEmptyTile(ImageProcessor ip) {
        block3: {
            block2: {
                if (!(ip instanceof ByteProcessor)) break block2;
                byte[] b = (byte[])ip.getPixels();
                for (int i = 0; i < b.length; ++i) {
                    if (0 == b[i]) continue;
                    return false;
                }
                break block3;
            }
            if (!(ip instanceof ColorProcessor)) break block3;
            int[] c = (int[])ip.getPixels();
            for (int i = 0; i < c.length; ++i) {
                if (0 == (c[i] & 0xFFFFFF)) continue;
                return false;
            }
        }
        return true;
    }

    public static Bureaucrat makePrescaledTiles(Layer[] layers, Class<?> clazz, Rectangle srcRect, int c_alphas, int type, String target_dir, int strategy, Saver saver, int tileSide, int directory_structure_type, boolean skip_empty_tiles, boolean use_layer_indices, int n_threads) {
        DirectoryChooser dc;
        if (null == layers || 0 == layers.length) {
            return null;
        }
        switch (type) {
            case 0: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only export for web with 8-bit or RGB");
            }
        }
        if (null == target_dir && null == (target_dir = (dc = new DirectoryChooser("Choose target directory")).getDirectory())) {
            return null;
        }
        String dir = Utils.fixDir(target_dir);
        try {
            Worker worker;
            int largestIndex;
            int smallestIndex;
            double resolution_z_px;
            TreeMap<Integer, Layer> indices = new TreeMap<Integer, Layer>();
            ArrayList<Integer> missingIndices = new ArrayList<Integer>();
            if (1 == layers.length) {
                indices.put(0, layers[0]);
                resolution_z_px = layers[0].getZ();
                smallestIndex = 0;
                largestIndex = 0;
            } else {
                TreeMap<Double, Layer> t = new TreeMap<Double, Layer>();
                for (Layer l1 : new HashSet<Layer>(Arrays.asList(layers))) {
                    Layer l2 = (Layer)t.get(l1.getZ());
                    if (null == l2) {
                        t.put(l1.getZ(), l1);
                        continue;
                    }
                    if (l1.getDisplayables().size() <= l2.getDisplayables().size()) continue;
                    t.put(l1.getZ(), l1);
                    Utils.log("Ignoring duplicate layer: " + l2);
                }
                HashMap<Double, Integer> counts = new HashMap<Double, Integer>();
                Layer prev = (Layer)t.get(t.firstKey());
                double modeThickness = 0.0;
                int modeThicknessCount = 0;
                for (Layer la : t.tailMap(prev.getZ(), false).values()) {
                    double d = (double)((int)((la.getZ() - prev.getZ()) * 1000.0 + 0.5)) / 1000.0;
                    Integer c = (Integer)counts.get(d);
                    if (null == c) {
                        c = 0;
                    }
                    c = c + 1;
                    counts.put(d, c);
                    if (c <= modeThicknessCount) continue;
                    modeThicknessCount = c;
                    modeThickness = d;
                }
                resolution_z_px = modeThickness * prev.getParent().getCalibration().pixelWidth;
                for (Layer la : t.values()) {
                    indices.put((int)(la.getZ() / modeThickness + 0.5), la);
                }
                smallestIndex = (Integer)indices.firstKey();
                largestIndex = (Integer)indices.lastKey();
                Utils.logAll("indices: " + smallestIndex + ", " + largestIndex);
                for (int i = smallestIndex + 1; i < largestIndex; ++i) {
                    if (indices.containsKey(i)) continue;
                    missingIndices.add(i);
                }
            }
            StringBuilder sb = new StringBuilder("{");
            LayerSet ls = layers[0].getParent();
            Calibration cal = ls.getCalibration();
            sb.append("\"volume_width_px\": ").append(srcRect.width).append(',').append('\n').append("\"volume_height_px\": ").append(srcRect.height).append(',').append('\n').append("\"volume_sections\": ").append(largestIndex - smallestIndex + 1).append(',').append('\n').append("\"extension\": \"").append(saver.getExtension()).append('\"').append(',').append('\n').append("\"resolution_x\": ").append(cal.pixelWidth).append(',').append('\n').append("\"resolution_y\": ").append(cal.pixelHeight).append(',').append('\n').append("\"resolution_z\": ").append(resolution_z_px).append(',').append('\n').append("\"units\": \"").append(cal.getUnit()).append('\"').append(',').append('\n').append("\"offset_x_px\": 0,\n").append("\"offset_y_px\": 0,\n").append("\"offset_z_px\": ").append(((Layer)indices.get(indices.firstKey())).getZ() * cal.pixelWidth / cal.pixelDepth).append(',').append('\n').append("\"missing_layers\": [");
            for (Integer i : missingIndices) {
                sb.append(i - smallestIndex).append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append("]}");
            if (!Utils.saveToFile(new File(dir + "metadata.json"), sb.toString())) {
                Utils.logAll("WARNING: could not save " + dir + "metadata.json\nThe contents was:\n" + sb.toString());
            }
            switch (strategy) {
                case 0: {
                    worker = ExportMultilevelTiles.exportFromOriginals(indices, smallestIndex, dir, saver, srcRect, c_alphas, type, clazz, tileSide, directory_structure_type, use_layer_indices, skip_empty_tiles, Math.max(1, n_threads));
                    break;
                }
                case 1: {
                    worker = ExportMultilevelTiles.exportFromMipMaps(indices, smallestIndex, dir, saver, srcRect, c_alphas, type, clazz, tileSide, directory_structure_type, use_layer_indices, skip_empty_tiles, Math.max(1, n_threads));
                    break;
                }
                case 2: {
                    worker = ExportMultilevelTiles.exportFromMipMapsLayerWise(indices, smallestIndex, dir, saver, srcRect, c_alphas, type, clazz, tileSide, directory_structure_type, use_layer_indices, skip_empty_tiles, Math.max(1, n_threads));
                    break;
                }
                default: {
                    Utils.log("Unknown strategy: " + strategy);
                    return null;
                }
            }
            return Bureaucrat.createAndStart(worker, layers[0].getProject());
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    public static Worker exportFromMipMaps(final TreeMap<Integer, Layer> indices, final int smallestIndex, final String dir, final Saver saver, final Rectangle srcRect, final int c_alphas, final int type, final Class<?> clazz, final int tileSide, final int directory_structure_type, final boolean use_layer_indices, final boolean skip_empty_tiles, final int n_threads) {
        return new Worker("Creating prescaled tiles from mipmaps"){

            private void cleanUp() {
                this.finishedWorking();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.startedWorking();
                int n_procs = Math.max(1, n_threads);
                ThreadPoolExecutor exec = Utils.newFixedThreadPool(Math.max(1, n_threads), "export-for-web::mipmaps");
                LinkedList futures = new LinkedList();
                try {
                    int[] best = ExportMultilevelTiles.determineClosestPowerOfTwo(srcRect.width > srcRect.height ? srcRect.width : srcRect.height);
                    int edge_length = best[0];
                    int n_edge_tiles = edge_length / tileSide;
                    Utils.log2("srcRect: " + srcRect);
                    Utils.log2("edge_length, n_edge_tiles, best[1] " + best[0] + ", " + n_edge_tiles + ", " + best[1]);
                    double ratio = (double)srcRect.width / (double)srcRect.height;
                    double thumb_scale = ratio >= 1.0 ? 192.0 / (double)srcRect.width : 192.0 / (double)srcRect.height;
                    for (Map.Entry entry : indices.entrySet()) {
                        int index;
                        if (this.quit) {
                            this.finishedWorking();
                            return;
                        }
                        Layer layer = (Layer)entry.getValue();
                        int n = index = use_layer_indices ? layer.getParent().indexOf(layer) : (Integer)entry.getKey() - smallestIndex;
                        if (!Utils.ensure(dir + index)) {
                            this.cleanUp();
                            Utils.log("Cannot write to the desired directory: " + dir + index + "/");
                            return;
                        }
                        if (edge_length < tileSide) {
                            ExportMultilevelTiles.makeTileRunnable(layer, srcRect, 1.0, c_alphas, type, clazz, ExportMultilevelTiles.makeTilePath(directory_structure_type, dir, index, 0, 0, 0), saver, tileSide, tileSide, skip_empty_tiles, true).run();
                            continue;
                        }
                        double scale = 1.0;
                        int scale_pow = 0;
                        for (int n_et = n_edge_tiles; n_et >= best[1]; n_et /= 2) {
                            int tile_side = (int)((double)tileSide / scale);
                            for (int row = 0; row < n_et; ++row) {
                                for (int col = 0; col < n_et; ++col) {
                                    int i_tile = row * n_et + col;
                                    Utils.showProgress((double)i_tile / (double)(n_et * n_et));
                                    if (0 == i_tile % 100) {
                                        layer.getProject().getLoader().releaseToFit(tile_side * tile_side * 4 * 2);
                                    }
                                    if (this.quit) {
                                        this.cleanUp();
                                        return;
                                    }
                                    Rectangle tile_src = new Rectangle(srcRect.x + tile_side * col, srcRect.y + tile_side * row, tile_side, tile_side);
                                    if (tile_src.x + tile_src.width > srcRect.x + srcRect.width) {
                                        tile_src.width = srcRect.x + srcRect.width - tile_src.x;
                                    }
                                    if (tile_src.y + tile_src.height > srcRect.y + srcRect.height) {
                                        tile_src.height = srcRect.y + srcRect.height - tile_src.y;
                                    }
                                    while (futures.size() > n_procs * 10) {
                                        if (this.quit) {
                                            this.cleanup();
                                            return;
                                        }
                                        futures.pop().get();
                                    }
                                    Runnable task = ExportMultilevelTiles.makeTileRunnable(layer, tile_src, scale, c_alphas, type, clazz, ExportMultilevelTiles.makeTilePath(directory_structure_type, dir, index, row, col, scale_pow), saver, tileSide, tileSide, skip_empty_tiles, true);
                                    futures.add(exec.submit(task));
                                }
                            }
                            scale = 1.0 / Math.pow(2.0, ++scale_pow);
                        }
                        futures.add(exec.submit(ExportMultilevelTiles.makeTileRunnable(layer, srcRect, thumb_scale, c_alphas, type, clazz, dir + index + "/small", saver, 192, 192, false, false)));
                    }
                    Utils.wait(futures);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    exec.shutdown();
                    Utils.showProgress(1.0);
                }
                this.cleanUp();
                this.finishedWorking();
            }
        };
    }

    public static Worker exportFromMipMapsLayerWise(final TreeMap<Integer, Layer> indices, final int smallestIndex, final String dir, final Saver saver, final Rectangle srcRect, final int c_alphas, final int type, Class<?> clazz, final int tileSide, final int directory_structure_type, final boolean use_layer_indices, final boolean skip_empty_tiles, final int n_threads) {
        return new Worker("Creating prescaled tiles from mipmaps layer-wise"){

            private void cleanUp() {
                this.finishedWorking();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.startedWorking();
                try {
                    int n_procs = Math.max(1, n_threads);
                    ThreadPoolExecutor exec = Utils.newFixedThreadPool(Math.max(1, n_threads), "export-for-web::mipmaps-layer-wise", false);
                    LinkedList futures = new LinkedList();
                    int[] best = ExportMultilevelTiles.determineClosestPowerOfTwo(srcRect.width > srcRect.height ? srcRect.width : srcRect.height);
                    int edge_length = best[0];
                    int n_edge_tiles = edge_length / tileSide;
                    Area area_srcRect = new Area(srcRect);
                    for (Map.Entry e : indices.entrySet()) {
                        Layer layer = (Layer)e.getValue();
                        int index = use_layer_indices ? layer.getParent().indexOf(layer) : (Integer)e.getKey() - smallestIndex;
                        futures.add(exec.submit(new ExportLayerTiles(layer, index, dir, srcRect, type, c_alphas, best, area_srcRect, skip_empty_tiles, n_edge_tiles, tileSide, directory_structure_type, saver)));
                        while (futures.size() > n_procs * 10) {
                            futures.pop().get();
                        }
                    }
                    Utils.wait(futures);
                    exec.shutdown();
                }
                catch (Throwable t) {
                    IJError.print(t);
                    t.printStackTrace();
                }
                finally {
                    this.cleanUp();
                    this.finishedWorking();
                }
            }
        };
    }

    private static final Map<Patch, Set<Patch>> getOverlaps(List<Patch> patches) {
        HashMap<Patch, Set<Patch>> table = new HashMap<Patch, Set<Patch>>();
        for (Patch p : patches) {
            table.put(p, new HashSet());
        }
        for (int i = 0; i < patches.size(); ++i) {
            Patch p1 = patches.get(i);
            Area b1 = new Area(p1.getPerimeter(10, 10, 10, 10));
            Set s1 = (Set)table.get(p1);
            for (int j = i + 1; j < patches.size(); ++j) {
                Patch p2 = patches.get(j);
                Area b2 = new Area(p2.getPerimeter(10, 10, 10, 10));
                if (!M.intersects(b1, b2)) continue;
                s1.add(p2);
                ((Set)table.get(p2)).add(p1);
            }
        }
        return table;
    }

    public static Worker exportFromOriginals(final TreeMap<Integer, Layer> indices, final int smallestIndex, final String dir, final Saver saver, final Rectangle srcRect, final int c_alphas, final int type, final Class<?> clazz, final int tileSide, final int directory_structure_type, final boolean use_layer_indices, final boolean skip_empty_tiles, final int n_threads) {
        return new Worker("Creating prescaled tiles from original images"){

            private void cleanUp() {
                this.finishedWorking();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.startedWorking();
                try {
                    int[] best = ExportMultilevelTiles.determineClosestPowerOfTwo(srcRect.width > srcRect.height ? srcRect.width : srcRect.height);
                    int edge_length = best[0];
                    int n_edge_tiles = edge_length / tileSide;
                    Utils.log2("srcRect: " + srcRect);
                    Utils.log2("edge_length, n_edge_tiles, best[1] " + best[0] + ", " + n_edge_tiles + ", " + best[1]);
                    double ratio = (double)srcRect.width / (double)srcRect.height;
                    double thumb_scale = ratio >= 1.0 ? 192.0 / (double)srcRect.width : 192.0 / (double)srcRect.height;
                    for (Map.Entry entry : indices.entrySet()) {
                        int index;
                        if (this.quit) {
                            this.finishedWorking();
                            return;
                        }
                        Layer layer = (Layer)entry.getValue();
                        int n = index = use_layer_indices ? layer.getParent().indexOf(layer) : (Integer)entry.getKey() - smallestIndex;
                        if (!Utils.ensure(dir + index)) {
                            this.cleanUp();
                            Utils.log("Cannot write to the desired directory: " + dir + index + "/");
                            return;
                        }
                        if (edge_length < tileSide) {
                            ExportMultilevelTiles.makeTileRunnable(layer, srcRect, 1.0, c_alphas, type, clazz, ExportMultilevelTiles.makeTilePath(directory_structure_type, dir, index, 0, 0, 0), saver, tileSide, tileSide, skip_empty_tiles, true).run();
                            continue;
                        }
                        ImagePlus thumb = layer.getProject().getLoader().getFlatImage(layer, srcRect, thumb_scale, c_alphas, type, clazz, true);
                        saver.save(thumb, dir + index + "/small");
                        Loader.flush(thumb);
                        thumb = null;
                        Utils.log("Exporting from web using original images");
                        double scale = 1.0;
                        Utils.log("Export srcRect: " + srcRect);
                        ImageProcessor snapshot = null;
                        if (4 == type) {
                            Utils.log("WARNING: ignoring alpha masks for 'use original images' and 'RGB color' options");
                            snapshot = Patch.makeFlatImage(type, layer, srcRect, scale, layer.getPatches(true), Color.black, true);
                        } else if (0 == type) {
                            Utils.log("WARNING: ignoring scale for 'use original images' and '8-bit' options");
                            snapshot = ExportUnsignedShort.makeFlatImage(layer.getPatches(true), srcRect, 0.0).convertToByte(true);
                        } else {
                            Utils.log("ERROR: don't know how to generate mipmaps for type '" + type + "'");
                            this.cleanUp();
                            return;
                        }
                        int scale_pow = 0;
                        int n_et = n_edge_tiles;
                        ThreadPoolExecutor exe = Utils.newFixedThreadPool(Math.max(1, n_threads), "export-for-web::original-images");
                        ArrayList fus = new ArrayList();
                        try {
                            while (n_et >= best[1]) {
                                int x2;
                                int x1;
                                int offset1b;
                                int offset1a;
                                int y2;
                                int y1;
                                int i;
                                int height2;
                                int width2;
                                int width1;
                                Object[] p2;
                                Object[] p1;
                                ByteProcessor nextSnapshot;
                                final int snapWidth = snapshot.getWidth();
                                final int snapHeight = snapshot.getHeight();
                                final ImageProcessor source = snapshot;
                                for (int row = 0; row < n_et; ++row) {
                                    for (int col = 0; col < n_et; ++col) {
                                        final String path = ExportMultilevelTiles.makeTilePath(directory_structure_type, dir, index, row, col, scale_pow);
                                        final int tileXStart = col * tileSide;
                                        final int tileYStart = row * tileSide;
                                        final int pixelOffset = tileYStart * snapWidth + tileXStart;
                                        fus.add(exe.submit(new Callable<Boolean>(){

                                            @Override
                                            public Boolean call() {
                                                if (0 == type) {
                                                    byte[] pixels = (byte[])source.getPixels();
                                                    byte[] p = new byte[tileSide * tileSide];
                                                    int sourceIndex = pixelOffset;
                                                    for (int y = 0; y < tileSide && tileYStart + y < snapHeight; ++y) {
                                                        int offsetL = y * tileSide;
                                                        for (int x = 0; x < tileSide && tileXStart + x < snapWidth; ++x) {
                                                            p[offsetL + x] = pixels[sourceIndex];
                                                            ++sourceIndex;
                                                        }
                                                        sourceIndex = pixelOffset + y * snapWidth;
                                                    }
                                                    ByteProcessor bp = new ByteProcessor(tileSide, tileSide, p, (ColorModel)Loader.GRAY_LUT);
                                                    if (!skip_empty_tiles || !ExportMultilevelTiles.isEmptyTile((ImageProcessor)bp)) {
                                                        return saver.save(new ImagePlus(path, (ImageProcessor)bp), path);
                                                    }
                                                } else {
                                                    int[] pixels = (int[])source.getPixels();
                                                    int[] p = new int[tileSide * tileSide];
                                                    int sourceIndex = pixelOffset;
                                                    for (int y = 0; y < tileSide && tileYStart + y < snapHeight; ++y) {
                                                        int offsetL = y * tileSide;
                                                        for (int x = 0; x < tileSide && tileXStart + x < snapWidth; ++x) {
                                                            p[offsetL + x] = pixels[sourceIndex];
                                                            ++sourceIndex;
                                                        }
                                                        sourceIndex = pixelOffset + y * snapWidth;
                                                    }
                                                    ColorProcessor cp = new ColorProcessor(tileSide, tileSide, p);
                                                    if (!skip_empty_tiles || !ExportMultilevelTiles.isEmptyTile((ImageProcessor)cp)) {
                                                        return saver.save(new ImagePlus(path, (ImageProcessor)cp), path);
                                                    }
                                                }
                                                return false;
                                            }
                                        }));
                                    }
                                }
                                scale = 1.0 / Math.pow(2.0, ++scale_pow);
                                n_et /= 2;
                                Utils.wait(fus);
                                fus.clear();
                                if (0 == type) {
                                    nextSnapshot = new ByteProcessor((int)((double)srcRect.width * scale), (int)((double)srcRect.height * scale));
                                    p1 = (byte[])snapshot.getPixels();
                                    p2 = (byte[])nextSnapshot.getPixels();
                                    width1 = snapshot.getWidth();
                                    width2 = nextSnapshot.getWidth();
                                    height2 = nextSnapshot.getHeight();
                                    i = 0;
                                    y1 = 0;
                                    for (y2 = 0; y2 < height2; ++y2) {
                                        offset1a = y1 * width1;
                                        offset1b = (y1 + 1) * width1;
                                        x1 = 0;
                                        for (x2 = 0; x2 < width2; ++x2) {
                                            p2[i++] = (byte)(((p1[offset1a + x1] & 0xFF) + (p1[offset1a + x1 + 1] & 0xFF) + (p1[offset1b + x1] & 0xFF) + (p1[offset1b + x1 + 1] & 0xFF)) / 4);
                                            x1 += 2;
                                        }
                                        y1 += 2;
                                    }
                                } else {
                                    nextSnapshot = new ColorProcessor((int)((double)srcRect.width * scale), (int)((double)srcRect.height * scale));
                                    p1 = (int[])snapshot.getPixels();
                                    p2 = (int[])nextSnapshot.getPixels();
                                    width1 = snapshot.getWidth();
                                    width2 = nextSnapshot.getWidth();
                                    height2 = nextSnapshot.getHeight();
                                    i = 0;
                                    y1 = 0;
                                    for (y2 = 0; y2 < height2; ++y2) {
                                        offset1a = y1 * width1;
                                        offset1b = (y1 + 1) * width1;
                                        x1 = 0;
                                        for (x2 = 0; x2 < width2; ++x2) {
                                            byte ka = p1[offset1a + x1];
                                            byte kb = p1[offset1a + x1 + 1];
                                            byte kc = p1[offset1b + x1];
                                            byte kd = p1[offset1b + x1 + 1];
                                            p2[i++] = (((ka >> 16 & 0xFF) + (kb >> 16 & 0xFF) + (kc >> 16 & 0xFF) + (kd >> 16 & 0xFF)) / 4 << 16) + (((ka >> 8 & 0xFF) + (kb >> 8 & 0xFF) + (kc >> 8 & 0xFF) + (kd >> 8 & 0xFF)) / 4 << 8) + ((ka & 0xFF) + (kb & 0xFF) + (kc & 0xFF) + (kd & 0xFF)) / 4;
                                            x1 += 2;
                                        }
                                        y1 += 2;
                                    }
                                }
                                snapshot = nextSnapshot;
                            }
                        }
                        catch (Throwable t) {
                            IJError.print(t);
                        }
                        finally {
                            exe.shutdown();
                        }
                    }
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    Utils.showProgress(1.0);
                }
                this.cleanUp();
                this.finishedWorking();
            }
        };
    }

    private static final class II {
        private final int a;
        private final int b;

        public II(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public final int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.a;
            hash = hash * 31 + this.b;
            return hash;
        }

        public final boolean equals(Object o) {
            if (o.getClass() == II.class) {
                II other = (II)o;
                return other.a == this.a && other.b == this.b;
            }
            return false;
        }
    }

    private static class ExportLayerTiles
    implements Runnable {
        private Layer layer;
        private int index;
        private String dir;
        private Rectangle srcRect;
        private int type;
        private int c_alphas;
        private int[] best;
        private Area area_srcRect;
        private boolean skip_empty_tiles;
        private int n_edge_tiles;
        private int tileSide;
        private int directory_structure_type;
        private Saver saver;

        private ExportLayerTiles(Layer layer, int index, String dir, Rectangle srcRect, int type, int c_alphas, int[] best, Area area_srcRect, boolean skip_empty_tiles, int n_edge_tiles, int tileSide, int directory_structure_type, Saver saver) {
            this.layer = layer;
            this.index = index;
            this.dir = dir;
            this.srcRect = srcRect;
            this.type = type;
            this.c_alphas = c_alphas;
            this.best = best;
            this.area_srcRect = area_srcRect;
            this.skip_empty_tiles = skip_empty_tiles;
            this.n_edge_tiles = n_edge_tiles;
            this.tileSide = tileSide;
            this.directory_structure_type = directory_structure_type;
            this.saver = saver;
        }

        private final ImageProcessor strategySnapshot(ImageProcessor prior_snapshot, List<Patch> patches, double scale, int scale_pow) {
            ImageProcessor snapshot;
            if (null != prior_snapshot) {
                snapshot = Downsampler.downsampleImageProcessor((ImageProcessor)prior_snapshot);
                prior_snapshot.setPixels(null);
            } else {
                snapshot = this.layer.getProject().getLoader().getFlatImage(this.layer, this.srcRect, scale, this.c_alphas, this.type, Patch.class, patches, false, Color.black).getProcessor();
            }
            Rectangle tile_src = new Rectangle(0, 0, this.tileSide, this.tileSide);
            int i = 0;
            int row = 0;
            while (i < snapshot.getHeight()) {
                int j = 0;
                int col = 0;
                while (j < snapshot.getWidth()) {
                    String path = ExportMultilevelTiles.makeTilePath(this.directory_structure_type, this.dir, this.index, row, col, scale_pow);
                    tile_src.x = this.tileSide * col;
                    tile_src.y = this.tileSide * row;
                    snapshot.setRoi(tile_src);
                    ImageProcessor ip = snapshot.crop();
                    if (ip.getWidth() < this.tileSide || ip.getHeight() < this.tileSide) {
                        ImageProcessor ip2 = ip.createProcessor(this.tileSide, this.tileSide);
                        ip2.insert(ip, 0, 0);
                        ip.setPixels(null);
                        ip = ip2;
                        ip2 = null;
                    }
                    if (!this.skip_empty_tiles || !ExportMultilevelTiles.isEmptyTile(ip)) {
                        ImagePlus imp = new ImagePlus(path.substring(path.lastIndexOf("/")), ip);
                        this.saver.save(imp, path);
                        imp.flush();
                        ip = null;
                        imp = null;
                    }
                    j += this.tileSide;
                    ++col;
                }
                i += this.tileSide;
                ++row;
            }
            return snapshot;
        }

        private void strategyPatches(List<Patch> patches, Map<Patch, Set<Patch>> overlaps, double scale, int scale_pow) {
            int tile_side = (int)((double)this.tileSide / scale);
            HashSet<II> done = new HashSet<II>();
            if (patches.size() > 0) {
                LinkedList<Patch> stack = new LinkedList<Patch>();
                HashSet<Patch> pending = new HashSet<Patch>(patches);
                stack.add(patches.get(0));
                pending.remove(patches.get(0));
                while (stack.size() > 0) {
                    Patch patch = (Patch)stack.removeFirst();
                    Rectangle bounds = patch.getBoundingBox();
                    bounds.x -= this.srcRect.x;
                    bounds.y -= this.srcRect.y;
                    int gx0 = Math.max(0, bounds.x / tile_side);
                    int gy0 = Math.max(0, bounds.y / tile_side);
                    int gx1 = Math.min(this.srcRect.width / tile_side, (bounds.x + bounds.width) / tile_side);
                    int gy1 = Math.min(this.srcRect.height / tile_side, (bounds.y + bounds.height) / tile_side);
                    for (int row = gy0; row <= gy1; ++row) {
                        for (int col = gx0; col <= gx1; ++col) {
                            II coord = new II(row, col);
                            if (done.contains(coord)) continue;
                            Rectangle tile_src = new Rectangle(this.srcRect.x + tile_side * col, this.srcRect.y + tile_side * row, tile_side, tile_side);
                            if (tile_src.x + tile_src.width > this.srcRect.x + this.srcRect.width) {
                                tile_src.width = this.srcRect.x + this.srcRect.width - tile_src.x;
                            }
                            if (tile_src.y + tile_src.height > this.srcRect.y + this.srcRect.height) {
                                tile_src.height = this.srcRect.y + this.srcRect.height - tile_src.y;
                            }
                            String path = ExportMultilevelTiles.makeTilePath(this.directory_structure_type, this.dir, this.index, row, col, scale_pow);
                            ExportMultilevelTiles.makeTileRunnable(this.layer, tile_src, scale, this.c_alphas, this.type, Patch.class, path, this.saver, this.tileSide, this.tileSide, this.skip_empty_tiles, true).run();
                            done.add(coord);
                        }
                    }
                    for (Patch p : overlaps.get(patch)) {
                        if (!pending.remove(p)) continue;
                        stack.add(p);
                    }
                    if (!stack.isEmpty() || pending.isEmpty()) continue;
                    Iterator<Patch> it = pending.iterator();
                    stack.add(it.next());
                    it.remove();
                }
            }
            if (!this.skip_empty_tiles) {
                Path first_path = null;
                int i = 0;
                int row = 0;
                while (i < this.srcRect.height) {
                    int j = 0;
                    int col = 0;
                    while (j < this.srcRect.width) {
                        II coord = new II(row, col);
                        if (!done.contains(coord)) {
                            String path = ExportMultilevelTiles.makeTilePath(this.directory_structure_type, this.dir, this.index, row, col, scale_pow) + this.saver.getExtension();
                            if (null == first_path) {
                                first_path = new File(path).toPath();
                                ImagePlus black = new ImagePlus("black", (ImageProcessor)new ByteProcessor(this.tileSide, this.tileSide));
                                this.saver.save(black, path);
                                black.flush();
                            } else {
                                try {
                                    Files.copy(first_path, new File(path).toPath(), StandardCopyOption.REPLACE_EXISTING);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        j += tile_side;
                        ++col;
                    }
                    i += tile_side;
                    ++row;
                }
            }
        }

        @Override
        public void run() {
            try {
                ArrayList<Patch> patches = this.layer.getPatches(true);
                Iterator it = patches.iterator();
                while (it.hasNext()) {
                    if (M.intersects(new Area(((Patch)it.next()).getPerimeter(1, 1, 1, 1)), this.area_srcRect)) continue;
                    it.remove();
                }
                if (0 == patches.size() && this.skip_empty_tiles) {
                    Utils.log2("Skipping empty layer " + this.layer + " at index " + this.index);
                    return;
                }
                Map overlaps = ExportMultilevelTiles.getOverlaps(patches);
                ImageProcessor snapshot = null;
                double scale = 1.0;
                int scale_pow = 0;
                for (int n_et = this.n_edge_tiles; n_et >= this.best[1]; n_et /= 2) {
                    if (null != snapshot || (double)this.srcRect.width * scale * ((double)this.srcRect.height * scale) < Math.pow(2.0, 30.0)) {
                        overlaps.clear();
                        snapshot = this.strategySnapshot(snapshot, patches, scale, scale_pow);
                    } else {
                        this.strategyPatches(patches, overlaps, scale, scale_pow);
                    }
                    if (scale_pow > 0) {
                        for (Patch patch : patches) {
                            patch.getProject().getLoader().removeCached(patch.getId(), scale_pow - 1);
                        }
                    }
                    scale = 1.0 / Math.pow(2.0, ++scale_pow);
                }
                if (null != snapshot) {
                    snapshot.setPixels(null);
                }
                for (Patch patch : patches) {
                    patch.getProject().getLoader().removeCached(patch.getId());
                }
                System.out.println("COMPLETED layer at index " + this.index);
            }
            catch (Throwable t) {
                System.out.println("FAILED at exporting tiles for web for layer " + this.layer + " at index " + this.index);
                t.printStackTrace();
            }
        }
    }
}

