/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Stack;
import ini.trakem2.imaging.FloatProcessorT2;
import ini.trakem2.imaging.P;
import ini.trakem2.io.ImageSaver;
import ini.trakem2.io.RagMipMaps;
import ini.trakem2.io.RawMipMaps;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.DownsamplerMipMaps;
import ini.trakem2.persistence.FilePathRepair;
import ini.trakem2.persistence.ImageBytes;
import ini.trakem2.persistence.Loader;
import ini.trakem2.persistence.StaleFiles;
import ini.trakem2.persistence.TMLHandler;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.imageplus.FloatImagePlus;
import net.imglib2.img.imageplus.ImagePlusImgs;
import org.janelia.intensity.LinearIntensityMap;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class FSLoader
extends Loader {
    private static final double SIGMA_2 = Math.sqrt(0.75);
    private long max_id = -1L;
    private long max_blob_id = 0L;
    private final Map<Long, String> ht_paths = Collections.synchronizedMap(new HashMap());
    private String project_file_path = null;
    private String dir_mipmaps = null;
    private String dir_mipmaps_stashed = null;
    private String dir_storage = null;
    private String dir_masks = null;
    private String dir_image_storage = null;
    private Set<Patch> touched_mipmaps = Collections.synchronizedSet(new HashSet());
    private Set<Patch> mipmaps_to_remove = Collections.synchronizedSet(new HashSet());
    private String unuid = null;
    private String dir_cts = null;
    public static final Pattern ABS_PATH = Pattern.compile("^[a-zA-Z]*:/.*$|^/.*$|[a-zA-Z]:.*$");
    private static final Object FSLOCK = new Object();
    private final Map<Patch, Future<Boolean>> regenerating_mipmaps = new HashMap<Patch, Future<Boolean>>();
    private final Object gm_lock = new Object();
    final Set<Patch> cannot_regenerate = Collections.synchronizedSet(new HashSet());
    private static AtomicInteger n_regenerating = new AtomicInteger(0);
    private static ExecutorService regenerator = null;
    private static ExecutorService remover = null;
    public static ExecutorService repainter = null;
    private static int nStaticServiceThreads = FSLoader.nStaticServiceThreads();
    public static ScheduledExecutorService autosaver = null;
    public static final String[] MIPMAP_FORMATS = new String[]{".jpg", ".png", ".tif", ".raw", ".rag"};
    public static final int MIPMAP_JPEG = 0;
    public static final int MIPMAP_PNG = 1;
    public static final int MIPMAP_TIFF = 2;
    public static final int MIPMAP_RAW = 3;
    public static final int MIPMAP_RAG = 4;
    private static final int MIPMAP_HIGHEST = 4;
    private int mipmaps_format = 4;
    private String mExt = MIPMAP_FORMATS[this.mipmaps_format];
    private RWImage mmio = new RWImageRag();

    public FSLoader() {
        FSLoader.startStaticServices();
    }

    public FSLoader(String storage_folder) throws Exception {
        this();
        this.dir_storage = null == storage_folder ? super.getStorageFolder() : storage_folder;
        this.dir_storage = this.dir_storage.replace('\\', '/');
        if (!this.dir_storage.endsWith("/")) {
            this.dir_storage = this.dir_storage + "/";
        }
        if (!Loader.canReadAndWriteTo(this.dir_storage)) {
            Utils.log("WARNING can't read/write to the storage_folder at " + this.dir_storage);
            throw new Exception("Can't write to storage folder " + this.dir_storage);
        }
        this.unuid = this.createUNUId(this.dir_storage);
        this.createMipMapsDir(this.dir_storage);
        this.crashDetector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createUNUId(String dir_storage) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                if (null == dir_storage) {
                    dir_storage = System.getProperty("user.dir") + "/";
                }
                return new StringBuilder(64).append(System.currentTimeMillis()).append('.').append(Math.abs(dir_storage.hashCode())).append('.').append(Math.abs(System.getProperty("user.name").hashCode())).toString();
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return null;
    }

    private void crashDetector() {
        if (null == this.dir_mipmaps) {
            Utils.log2("Could NOT create crash detection system: null dir_mipmaps.");
            return;
        }
        File f = new File(this.dir_mipmaps + ".open.t2");
        Utils.log2("Crash detector file is " + this.dir_mipmaps + ".open.t2");
        try {
            if (f.exists()) {
                this.notifyMipMapsOutOfSynch();
            } else if (!f.createNewFile() && !this.dir_mipmaps.startsWith("http:")) {
                Utils.showMessage("WARNING: could NOT create crash detection system:\nCannot write to mipmaps folder.");
            } else {
                Utils.log2("Created crash detection system.");
            }
        }
        catch (Exception e) {
            Utils.log2("Crash detector error:" + e);
            IJError.print(e);
        }
    }

    public String getProjectXMLPath() {
        if (null == this.project_file_path) {
            return null;
        }
        return this.project_file_path.toString();
    }

    @Override
    public String getStorageFolder() {
        if (null == this.dir_storage) {
            return super.getStorageFolder();
        }
        return this.dir_storage.toString();
    }

    @Override
    public String getImageStorageFolder() {
        if (null == this.dir_image_storage) {
            String s = this.getUNUIdFolder() + "trakem2.images/";
            File f = new File(s);
            if (f.exists() && f.isDirectory() && f.canWrite()) {
                this.dir_image_storage = s;
                return this.dir_image_storage;
            }
            try {
                f.mkdirs();
                this.dir_image_storage = s;
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.getStorageFolder();
            }
        }
        return this.dir_image_storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] openFSProject(String path, boolean open_displays) {
        if (null != path) {
            path = path.replace('\\', '/');
            path = path.trim();
            int itwo = path.indexOf("//");
            while (-1 != itwo) {
                if (!(0 == itwo || 5 == itwo && "http:".equals(path.substring(0, 5)))) {
                    path = path.substring(0, itwo) + path.substring(itwo + 1);
                }
                itwo = path.indexOf("//", itwo + 1);
            }
        }
        if (null == path) {
            OpenDialog od = new OpenDialog("Select Project", OpenDialog.getDefaultDirectory(), null);
            String file = od.getFileName();
            if (null == file || file.toLowerCase().startsWith("null")) {
                return null;
            }
            String dir = od.getDirectory().replace('\\', '/');
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            this.project_file_path = dir + file;
            Utils.log2("project file path 1: " + this.project_file_path);
        } else {
            this.project_file_path = path;
            Utils.log2("project file path 2: " + this.project_file_path);
        }
        Utils.log2("Loader.openFSProject: path is " + path);
        if (null != FSLoader.getOpenProject(this.project_file_path, this)) {
            Utils.showMessage("The project is already open.");
            return null;
        }
        Object[] data = null;
        String lcFilePath = this.project_file_path.toLowerCase();
        if (lcFilePath.matches(".*(\\.xml|\\.xml\\.gz)")) {
            InputStream i_stream = null;
            TMLHandler handler = new TMLHandler(this.project_file_path, this);
            if (handler.isUnreadable()) {
                handler = null;
            } else {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setValidating(false);
                    factory.setXIncludeAware(false);
                    SAXParser parser = factory.newSAXParser();
                    i_stream = FSLoader.isURL(this.project_file_path) ? new URL(this.project_file_path).openStream() : new BufferedInputStream(new FileInputStream(this.project_file_path));
                    if (lcFilePath.endsWith(".gz")) {
                        i_stream = new GZIPInputStream(i_stream);
                    }
                    InputSource input_source = new InputSource(i_stream);
                    parser.parse(input_source, (DefaultHandler)handler);
                }
                catch (FileNotFoundException fnfe) {
                    Utils.log("ERROR: File not found: " + path);
                    handler = null;
                }
                catch (Exception e) {
                    IJError.print(e);
                    handler = null;
                }
                finally {
                    if (null != i_stream) {
                        try {
                            i_stream.close();
                        }
                        catch (Exception e) {
                            IJError.print(e);
                        }
                    }
                }
            }
            if (null == handler) {
                Utils.showMessage("Error when reading the project .xml file.");
                return null;
            }
            data = handler.getProjectData(open_displays);
        }
        if (null == data) {
            Utils.showMessage("Error when parsing the project .xml file.");
            return null;
        }
        this.crashDetector();
        return data;
    }

    private static final synchronized Project getOpenProject(String project_file_path, Loader caller) {
        if (null == v_loaders) {
            return null;
        }
        Loader[] lo = v_loaders.toArray(new Loader[0]);
        for (int i = 0; i < lo.length; ++i) {
            if (lo[i].equals(caller) || !(lo[i] instanceof FSLoader) || null == ((FSLoader)lo[i]).project_file_path || !((FSLoader)lo[i]).project_file_path.equals(project_file_path)) continue;
            return Project.findProject(lo[i]);
        }
        return null;
    }

    public static final Project getOpenProject(String project_file_path) {
        return FSLoader.getOpenProject(project_file_path, null);
    }

    public static final int nStaticServiceThreads() {
        int np = Runtime.getRuntime().availableProcessors();
        if (np > 2) {
            --np;
        }
        return np;
    }

    public static final void restartMipMapThreads(int n_threads) {
        if (null != regenerator && !regenerator.isShutdown()) {
            regenerator.shutdown();
        }
        regenerator = Utils.newFixedThreadPool(Math.max(1, n_threads), "regenerator");
        Utils.logAll("Restarted mipmap Executor Service for all projects with " + n_threads + " threads.");
    }

    private static void startStaticServices() {
        if (null == regenerator || regenerator.isShutdown()) {
            regenerator = Utils.newFixedThreadPool(1, "regenerator");
        }
        if (null == repainter || repainter.isShutdown()) {
            repainter = Utils.newFixedThreadPool(nStaticServiceThreads, "repainter");
        }
        if (null == remover || remover.isShutdown()) {
            remover = Utils.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()), "mipmap remover");
        }
        if (null == autosaver || autosaver.isShutdown()) {
            autosaver = Executors.newScheduledThreadPool(1);
        }
    }

    private static void destroyStaticServices() {
        if (null != regenerator) {
            regenerator.shutdownNow();
        }
        if (null != remover) {
            remover.shutdownNow();
        }
        if (null != repainter) {
            repainter.shutdownNow();
        }
        if (null != autosaver) {
            autosaver.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        File f;
        super.destroy();
        Utils.showStatus("", false);
        this.touched_mipmaps.addAll(this.mipmaps_to_remove);
        HashSet<Patch> touched = new HashSet<Patch>();
        Set<Patch> set = this.touched_mipmaps;
        synchronized (set) {
            touched.addAll(this.touched_mipmaps);
        }
        for (Patch p : touched) {
            File f2 = new File(this.getAbsolutePath(p));
            Utils.log2("Removing mipmaps for " + p);
            this.removeMipMaps(FSLoader.createIdPath(Long.toString(p.getId()), f2.getName(), this.mExt), (int)p.getWidth(), (int)p.getHeight());
        }
        if (null != this.dir_mipmaps && !this.dir_mipmaps.equals(this.dir_storage) && (f = new File(this.dir_mipmaps)).isDirectory() && 0 == f.list(new FilenameFilter(){

            @Override
            public boolean accept(File fdir, String name) {
                File file = new File(FSLoader.this.dir_mipmaps + name);
                return !file.isHidden() && '.' != name.charAt(0);
            }
        }).length) {
            try {
                f.delete();
            }
            catch (Exception e) {
                Utils.log("Could not remove empty trakem2.mipmaps directory.");
            }
        }
        try {
            File fm = new File(this.dir_mipmaps + ".open.t2");
            if (!fm.delete()) {
                Utils.log2("WARNING: could not delete crash detector file .open.t2 from trakem2.mipmaps folder at " + this.dir_mipmaps);
            }
        }
        catch (Exception e) {
            Utils.log2("WARNING: crash detector file trakem.mipmaps/.open.t2 may NOT have been deleted.");
            IJError.print(e);
        }
        if (null == ControlWindow.getProjects() || 1 == ControlWindow.getProjects().size()) {
            FSLoader.destroyStaticServices();
        }
        if (null == this.project_file_path) {
            Utils.log2("Removing unuid dir, since project was never saved.");
            f = new File(this.getUNUIdFolder());
            if (null != this.dir_mipmaps) {
                Utils.removePrefixedFiles(f, "trakem2.mipmaps", null);
            }
            if (null != this.dir_masks) {
                Utils.removePrefixedFiles(f, "trakem2.masks", null);
            }
            Utils.removePrefixedFiles(f, "features.ser", null);
            Utils.removePrefixedFiles(f, "pointmatches.ser", null);
            if (f.isDirectory()) {
                try {
                    if (!f.delete()) {
                        Utils.log2("Could not delete unuid directory: likely not empty!");
                    }
                }
                catch (Exception e) {
                    Utils.log2("Could not delete unuid directory: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextId() {
        long nid = -1L;
        Object object = this.db_lock;
        synchronized (object) {
            nid = ++this.max_id;
        }
        return nid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextBlobId() {
        long nid = 0L;
        Object object = this.db_lock;
        synchronized (object) {
            nid = ++this.max_blob_id;
        }
        return nid;
    }

    @Override
    public double[][][] fetchBezierArrays(long id) {
        return null;
    }

    @Override
    public ArrayList<?> fetchPipePoints(long id) {
        return null;
    }

    @Override
    public ArrayList<?> fetchBallPoints(long id) {
        return null;
    }

    @Override
    public Area fetchArea(long area_list_id, long layer_id) {
        return null;
    }

    @Override
    public ImagePlus fetchImagePlus(Patch p) {
        return (ImagePlus)this.fetchImage(p, 3);
    }

    @Override
    public ImageProcessor fetchImageProcessor(Patch p) {
        return (ImageProcessor)this.fetchImage(p, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object fetchImage(Patch p, int format) {
        int ia;
        ImagePlus imp = null;
        ImageProcessor ip = null;
        String slice = null;
        String path = null;
        long n_bytes = 0L;
        Loader.ImageLoadingLock plock = null;
        Object object = this.db_lock;
        synchronized (object) {
            try {
                imp = this.mawts.get(p.getId());
                path = this.getAbsolutePath(p);
                int i_sl = -1;
                if (null != path) {
                    i_sl = path.lastIndexOf("-----#slice=");
                }
                if (-1 != i_sl && null != imp) {
                    ia = Integer.parseInt(path.substring(i_sl + 12));
                    if (ia > imp.getNSlices()) return null;
                    if (null == imp.getStack() || null == imp.getStack().getPixels(ia)) {
                        this.mawts.removeImagePlus(p.getId());
                        imp = null;
                    } else {
                        imp.setSlice(ia);
                        switch (format) {
                            case 0: {
                                return imp.getStack().getProcessor(ia);
                            }
                            case 3: {
                                return imp;
                            }
                        }
                        Utils.log("FSLoader.fetchImage: Unknown format " + format);
                        return null;
                    }
                }
                if (null != imp) {
                    switch (format) {
                        case 0: {
                            return imp.getProcessor();
                        }
                        case 3: {
                            return imp;
                        }
                    }
                    Utils.log("FSLoader.fetchImage: Unknown format " + format);
                    return null;
                }
                if (-1 != i_sl) {
                    slice = path.substring(i_sl);
                    path = path.substring(0, i_sl);
                }
                plock = this.getOrMakeImageLoadingLock(path);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
                return null;
            }
        }
        object = plock;
        synchronized (object) {
            imp = this.mawts.get(p.getId());
            if (null == imp && !p.isPreprocessed() && null != (imp = this.mawts.get(path))) {
                this.mawts.put(p.getId(), imp, (int)Math.max(p.getWidth(), p.getHeight()));
            }
            if (null != imp) {
                switch (format) {
                    case 0: {
                        if (null == slice) return imp.getProcessor();
                        return imp.getStack().getProcessor(Integer.parseInt(slice.substring(12)));
                    }
                    case 3: {
                        if (null == slice) return imp;
                        imp.setSlice(Integer.parseInt(slice.substring(12)));
                        return imp;
                    }
                }
                Utils.log("FSLoader.fetchImage: Unknown format " + format);
                return null;
            }
            n_bytes = this.estimateImageFileSize(p, 0);
            this.releaseToFit(n_bytes);
            imp = this.openImage(path);
            imp = this.preProcess(p, imp, n_bytes);
            Object object2 = this.db_lock;
            synchronized (object2) {
                try {
                    if (null == imp) {
                        if (!this.hs_unloadable.contains(p)) {
                            Utils.log("FSLoader.fetchImagePlus: no image exists for patch  " + p + "  at path " + path);
                            this.hs_unloadable.add(p);
                        }
                        if (ControlWindow.isGUIEnabled()) {
                            FilePathRepair.add(p);
                        }
                        this.removeImageLoadingLock(plock);
                        return null;
                    }
                    if (null != slice) {
                        ia = Integer.parseInt(slice.substring(12));
                        imp.setSlice(ia);
                        if (0 == format) {
                            ip = imp.getStack().getProcessor(ia);
                        }
                    } else if (0 == format) {
                        ip = imp.getProcessor();
                    }
                    this.mawts.put(p.getId(), imp, (int)Math.max(p.getWidth(), p.getHeight()));
                    this.removeImageLoadingLock(plock);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                switch (format) {
                    case 0: {
                        return ip;
                    }
                    case 3: {
                        return imp;
                    }
                }
                Utils.log("FSLoader.fetchImage: Unknown format " + format);
                return null;
            }
        }
    }

    @Override
    public ByteProcessor fetchImageMask(Patch p) {
        return p.getAlphaMask();
    }

    @Override
    public final synchronized String getMasksFolder() {
        if (null == this.dir_masks) {
            this.createMasksFolder();
        }
        return this.dir_masks;
    }

    private final synchronized void createMasksFolder() {
        File f;
        if (null == this.dir_masks) {
            this.dir_masks = this.getUNUIdFolder() + "trakem2.masks/";
        }
        if ((f = new File(this.dir_masks)).exists() && f.isDirectory()) {
            return;
        }
        try {
            f.mkdirs();
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    @Override
    public final synchronized String getCoordinateTransformsFolder() {
        if (null == this.dir_cts) {
            this.createCoordinateTransformsFolder();
        }
        return this.dir_cts;
    }

    private final synchronized void createCoordinateTransformsFolder() {
        File f;
        if (null == this.dir_cts) {
            this.dir_cts = this.getUNUIdFolder() + "trakem2.cts/";
        }
        if ((f = new File(this.dir_cts)).exists() && f.isDirectory()) {
            return;
        }
        try {
            f.mkdirs();
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    @Override
    public Object[] fetchLabel(DLabel label) {
        return null;
    }

    @Override
    public synchronized ImagePlus fetchOriginal(Patch patch) {
        String original_path = patch.getOriginalPath();
        if (null == original_path) {
            return null;
        }
        this.releaseToFit(this.estimateImageFileSize(patch, 0));
        try {
            return this.openImage(original_path);
        }
        catch (Throwable t) {
            IJError.print(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addToDatabase(DBObject ob) {
        Object object = this.db_lock;
        synchronized (object) {
            this.setChanged(true);
            long id = ob.getId();
            if (id > this.max_id) {
                this.max_id = id;
            }
            if (ob.getClass() == Patch.class) {
                Patch p = (Patch)ob;
                if (p.hasCoordinateTransform()) {
                    this.max_blob_id = Math.max(p.getCoordinateTransformId(), this.max_blob_id);
                }
                if (p.hasAlphaMask()) {
                    this.max_blob_id = Math.max(p.getAlphaMaskId(), this.max_blob_id);
                }
            }
        }
        return true;
    }

    @Override
    public boolean updateInDatabase(DBObject ob, String key) {
        this.setChanged(true);
        if (ob.getClass() == Patch.class) {
            Patch p = (Patch)ob;
            if (key.equals("tiff_working")) {
                return null != this.setImageFile(p, this.fetchImagePlus(p));
            }
        }
        return true;
    }

    @Override
    public boolean updateInDatabase(DBObject ob, Set<String> keys) {
        this.setChanged(true);
        if (ob.getClass() == Patch.class) {
            Patch p = (Patch)ob;
            if (keys.contains("tiff_working")) {
                return null != this.setImageFile(p, this.fetchImagePlus(p));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFromDatabase(DBObject ob) {
        Object object = this.db_lock;
        synchronized (object) {
            this.setChanged(true);
            long loid = ob.getId();
            Utils.log2("removing " + Project.getName(ob.getClass()) + " " + ob);
            if (ob.getClass() == Patch.class) {
                try {
                    Patch p = (Patch)ob;
                    if (!ob.getProject().getBooleanProperty("keep_mipmaps")) {
                        this.removeMipMaps(p);
                    }
                    this.ht_paths.remove(p.getId());
                    this.mawts.remove(loid);
                    this.cannot_regenerate.remove(p);
                    this.flushMipMaps(p.getId());
                    this.touched_mipmaps.remove(p);
                    return true;
                }
                catch (Throwable t) {
                    this.handleCacheError(t);
                }
            }
        }
        return true;
    }

    @Override
    public String setImageFile(Patch p, ImagePlus imp) {
        if (null == imp) {
            return null;
        }
        try {
            String fipath;
            FileInfo fi;
            String path = this.getAbsolutePath(p);
            String slice = null;
            if (null != path) {
                int i_sl = path.lastIndexOf("-----#slice=");
                if (-1 != i_sl) {
                    slice = path.substring(i_sl);
                    path = path.substring(0, i_sl);
                }
            } else if (!imp.changes && null != (fi = imp.getOriginalFileInfo()) && null != fi.directory && null != fi.fileName && new File(fipath = fi.directory.replace('\\', '/') + "/" + fi.fileName).exists()) {
                this.updatePaths(p, fipath, null != slice);
                this.cacheAll(p, imp);
                Utils.log2("Reusing image file: path exists for fileinfo at " + fipath);
                return fipath;
            }
            if (null != path) {
                String path2;
                String tag;
                String starting_path = path;
                String filename = path.substring(path.lastIndexOf(47) + 1);
                if (filename.endsWith(".tif")) {
                    filename = filename.substring(0, filename.length() - 3);
                }
                if (!filename.endsWith(tag = ".id" + p.getId() + ".")) {
                    filename = filename + tag.substring(1);
                }
                filename = filename + "tif";
                path = this.getImageStorageFolder() + filename;
                if (path.equals(p.getOriginalPath())) {
                    File file = null;
                    int i = 1;
                    int itag = path.lastIndexOf(tag);
                    do {
                        path = path.substring(0, itag) + "." + i + tag + "tif";
                        ++i;
                    } while ((file = new File(path)).exists());
                }
                if (null != (path2 = super.exportImage(p, imp, path, true))) {
                    this.updatePaths(p, path2, null != slice);
                    this.cacheAll(p, imp);
                    this.hs_unloadable.remove(p);
                    return path2;
                }
                Utils.log("WARNING could not save image at " + path);
                this.updatePaths(p, starting_path, null != slice);
                return null;
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return null;
    }

    private void cacheAll(Patch p, ImagePlus imp) {
        if (p.isStack()) {
            for (Patch pa : p.getStackPatches()) {
                this.cache(pa, imp);
            }
        } else {
            this.cache(p, imp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePaths(Patch patch, String new_path, boolean is_stack) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                String old_path = this.getAbsolutePath(patch);
                if (is_stack) {
                    old_path = old_path.substring(0, old_path.lastIndexOf("-----#slice"));
                    for (Patch p : patch.getStackPatches()) {
                        long pid = p.getId();
                        String str = this.ht_paths.get(pid);
                        int isl = str.lastIndexOf("-----#slice=");
                        this.updatePatchPath(p, new_path + str.substring(isl));
                    }
                } else {
                    Utils.log2("path to set: " + new_path);
                    Utils.log2("path before: " + this.ht_paths.get(patch.getId()));
                    this.updatePatchPath(patch, new_path);
                    Utils.log2("path after: " + this.ht_paths.get(patch.getId()));
                }
                this.mawts.updateImagePlusPath(old_path, new_path);
            }
            catch (Throwable e) {
                IJError.print(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAbsolutePath(Patch patch) {
        Patch patch2 = patch;
        synchronized (patch2) {
            String abs_path = patch.getCurrentPath();
            if (null != abs_path) {
                return abs_path;
            }
            String path = this.ht_paths.get(patch.getId());
            if (null == path) {
                return null;
            }
            int i_sl = path.lastIndexOf("-----#slice=");
            String slice = null;
            if (-1 != i_sl) {
                slice = path.substring(i_sl);
                path = path.substring(0, i_sl);
            }
            if (null == (path = this.getAbsolutePath(path))) {
                Utils.log("Path for patch " + patch + " does not exist: " + path);
                return null;
            }
            if (null != slice) {
                path = path + slice;
            }
            patch.cacheCurrentPath(path);
            return path;
        }
    }

    public String getAbsolutePath(String path) {
        if (FSLoader.isRelativePath(path) && !FSLoader.isURL(path = this.getParentFolder() + path) && !new File(path).exists()) {
            return null;
        }
        return path;
    }

    @Override
    public final String getImageFilePath(Patch p) {
        String path = this.getAbsolutePath(p);
        if (null == path) {
            return null;
        }
        int i = path.lastIndexOf("-----#slice");
        return -1 == i ? path : path.substring(0, i);
    }

    public static final boolean isURL(String path) {
        return null != path && 0 == path.indexOf("http://");
    }

    public static final boolean isRelativePath(String path) {
        return !ABS_PATH.matcher(path).matches();
    }

    @Override
    public void addedPatchFrom(String path, Patch patch) {
        if (null == path) {
            Utils.log("Null path for patch: " + patch);
            return;
        }
        this.updatePatchPath(patch, path);
    }

    private final void updatePatchPath(Patch patch, String path) {
        int start;
        int n = FSLoader.isURL(path = path.replace('\\', '/')) ? 6 : (start = IJ.isWindows() ? 3 : 1);
        while (-1 != path.indexOf("//", start)) {
            path = path.substring(0, start) + path.substring(start).replace("//", "/");
        }
        patch.cacheCurrentPath(FSLoader.isRelativePath(path) ? this.getParentFolder() + path : path);
        path = this.makeRelativePath(path);
        this.ht_paths.put(patch.getId(), path);
    }

    public static String asSafePath(String name) {
        return name.trim().replace('/', '-').replace(' ', '_').replace('\\', '-');
    }

    @Override
    public String save(Project project, XMLOptions options) {
        String result = null;
        if (null == this.project_file_path) {
            String xml_path = super.saveAs(project, null, options);
            if (null == xml_path) {
                return null;
            }
            this.project_file_path = xml_path;
            ControlWindow.updateTitle(project);
            result = this.project_file_path;
        } else {
            File fxml = new File(this.project_file_path);
            result = super.export(project, fxml, options);
        }
        if (null != result) {
            Utils.logAll(Utils.now() + " Saved " + project);
            this.touched_mipmaps.clear();
        }
        return result;
    }

    @Override
    public String saveAs(Project project, XMLOptions options) {
        String path = super.saveAs(project, null, options);
        if (null != path) {
            this.project_file_path = path;
            Utils.log2("After saveAs, new xml path is: " + path);
            this.touched_mipmaps.clear();
        }
        ControlWindow.updateTitle(project);
        Display.updateTitle(project);
        return path;
    }

    @Override
    public String saveAs(String path, XMLOptions options) {
        Project project;
        File fxml;
        if (null == path) {
            Utils.log("Cannot save on null path.");
            return null;
        }
        String path2 = path;
        String extension = ".xml";
        if (!path2.endsWith(extension)) {
            if (path2.endsWith(".xml.gz")) {
                extension = ".xml.gz";
            } else {
                path2 = path2 + extension;
            }
        }
        if (!(fxml = new File(path2)).canWrite()) {
            String path3 = path2;
            path2 = this.getStorageFolder() + fxml.getName();
            Utils.logAll("WARNING can't write to " + path3 + "\n  --> will write instead to " + path2);
            fxml = new File(path2);
        }
        if (!options.overwriteXMLFile) {
            int i = 1;
            while (fxml.exists()) {
                String parent = fxml.getParent().replace('\\', '/');
                if (!parent.endsWith("/")) {
                    parent = parent + "/";
                }
                String name = fxml.getName();
                name = name.substring(0, name.length() - 4);
                path2 = parent + name + "-" + i + extension;
                fxml = new File(path2);
                ++i;
            }
        }
        if (null != (path2 = super.saveAs(project = Project.findProject(this), path2, options))) {
            this.project_file_path = path2;
            Utils.logAll("After saveAs, new xml path is: " + path2);
            ControlWindow.updateTitle(project);
            this.touched_mipmaps.clear();
        }
        return path2;
    }

    @Override
    public String getPath(Patch patch) {
        return this.ht_paths.get(patch.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<Long, String> getPathsCopy() {
        Map<Long, String> map = this.ht_paths;
        synchronized (map) {
            return Collections.synchronizedMap(new HashMap<Long, String>(this.ht_paths));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void makeAllPathsRelativeTo(String xml_path, Project project) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                for (Map.Entry<Long, String> e : this.ht_paths.entrySet()) {
                    e.setValue(FSLoader.makeRelativePath(xml_path, e.getValue()));
                }
                for (Stack st : project.getRootLayerSet().getAll(Stack.class)) {
                    String path2;
                    String path = st.getFilePath();
                    if (FSLoader.isRelativePath(path) || path.equals(path2 = this.makeRelativePath(st.getFilePath()))) continue;
                    st.setFilePath(path2);
                }
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restorePaths(Map<Long, String> copy, String mipmaps_folder, String storage_folder) {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.dir_mipmaps = mipmaps_folder;
                this.dir_storage = storage_folder;
                this.ht_paths.clear();
                this.ht_paths.putAll(copy);
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
    }

    @Override
    public String makeRelativePath(String path) {
        return FSLoader.makeRelativePath(this.project_file_path, path);
    }

    private static String makeRelativePath(String project_file_path, String path) {
        if (null == project_file_path) {
            return path;
        }
        if (null == path) {
            return null;
        }
        path = path.replace('\\', '/');
        String slice = null;
        int isl = path.lastIndexOf("-----#slice");
        if (-1 != isl) {
            slice = path.substring(isl);
            path = path.substring(0, isl);
        }
        if (FSLoader.isRelativePath(path)) {
            if (-1 != isl) {
                path = path + slice;
            }
            return path;
        }
        String xdir = new File(project_file_path).getParentFile().getAbsolutePath();
        if (IJ.isWindows()) {
            xdir = xdir.replace('\\', '/');
            path = path.replace('\\', '/');
        }
        if (!xdir.endsWith("/")) {
            xdir = xdir + "/";
        }
        if (path.startsWith(xdir)) {
            path = path.substring(xdir.length());
        }
        if (-1 != isl) {
            path = path + slice;
        }
        return path;
    }

    @Override
    public void setupMenuItems(JMenu menu, final Project project) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FSLoader.this.saveTask(project, ae.getActionCommand());
            }
        };
        JMenuItem item = new JMenuItem("Save");
        item.addActionListener(listener);
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 0, true));
        item = new JMenuItem("Save as...");
        item.addActionListener(listener);
        menu.add(item);
        JMenu adv = new JMenu("Advanced");
        item = new JMenuItem("Save as... without coordinate transforms");
        item.addActionListener(listener);
        adv.add(item);
        item = new JMenuItem("Delete stale files...");
        item.addActionListener(listener);
        adv.add(item);
        menu.add(adv);
        menu.addSeparator();
    }

    @Override
    protected Patch importStackAsPatches(Project project, Layer first_layer, double x, double y, ImagePlus imp_stack, boolean as_copy, String filepath) {
        Utils.log2("FSLoader.importStackAsPatches filepath=" + filepath);
        String target_dir = null;
        if (as_copy) {
            DirectoryChooser dc = new DirectoryChooser("Folder to save images");
            target_dir = dc.getDirectory();
            if (null == target_dir) {
                return null;
            }
            if (IJ.isWindows()) {
                target_dir = target_dir.replace('\\', '/');
            }
            if (target_dir.length() - 1 != target_dir.lastIndexOf(47)) {
                target_dir = target_dir + "/";
            }
        }
        double pos_x = Double.MAX_VALUE != x ? x : (double)(first_layer.getLayerWidth() / 2.0f - (float)(imp_stack.getWidth() / 2));
        double pos_y = Double.MAX_VALUE != y ? y : (double)(first_layer.getLayerHeight() / 2.0f - (float)(imp_stack.getHeight() / 2));
        double thickness = first_layer.getThickness();
        String title = Utils.removeExtension(imp_stack.getTitle()).replace(' ', '_');
        Utils.showProgress(0.0);
        Patch previous_patch = null;
        int n = imp_stack.getStackSize();
        ImageStack stack = imp_stack.getStack();
        boolean virtual = stack.isVirtual();
        VirtualStack vs = virtual ? (VirtualStack)stack : null;
        for (int i = 1; i <= n; ++i) {
            Layer layer = first_layer;
            double z = first_layer.getZ() + (double)(i - 1) * thickness;
            if (i > 1) {
                layer = first_layer.getParent().getLayer(z, thickness, true);
            }
            if (null == layer) {
                Utils.log("Display.importStack: could not create new layers.");
                return null;
            }
            String patch_path = null;
            ImagePlus imp_patch_i = null;
            if (virtual) {
                String vs_dir = vs.getDirectory().replace('\\', '/');
                if (!vs_dir.endsWith("/")) {
                    vs_dir = vs_dir + "/";
                }
                String iname = vs.getFileName(i);
                patch_path = vs_dir + iname;
                Utils.log2("virtual stack: patch path is " + patch_path);
                this.releaseToFit(new File(patch_path).length() * 3L);
                Utils.log2(i + " : " + patch_path);
                imp_patch_i = this.openImage(patch_path);
            } else {
                ImageProcessor ip = stack.getProcessor(i);
                if (as_copy) {
                    ip = ip.duplicate();
                }
                imp_patch_i = new ImagePlus(title + "__slice=" + i, ip);
            }
            String label = stack.getSliceLabel(i);
            if (null == label) {
                label = "";
            }
            Patch patch = null;
            if (as_copy) {
                patch_path = target_dir + this.cleanSlashes(imp_patch_i.getTitle()) + ".zip";
                ImageSaver.saveAsZip(imp_patch_i, patch_path);
                patch = new Patch(project, label + " " + title + " " + i, pos_x, pos_y, imp_patch_i);
            } else if (virtual) {
                patch = new Patch(project, label, pos_x, pos_y, imp_patch_i);
            } else {
                patch_path = filepath + "-----#slice=" + i;
                AffineTransform atp = new AffineTransform();
                atp.translate(pos_x, pos_y);
                patch = new Patch(project, this.getNextId(), label + " " + title + " " + i, imp_stack.getWidth(), imp_stack.getHeight(), imp_stack.getWidth(), imp_stack.getHeight(), imp_stack.getType(), false, imp_stack.getProcessor().getMin(), imp_stack.getProcessor().getMax(), atp);
                patch.addToDatabase();
            }
            Utils.log2("B: " + i + " : " + patch_path);
            this.addedPatchFrom(patch_path, patch);
            if (!as_copy && !virtual) {
                if (virtual) {
                    this.cache(patch, imp_patch_i);
                } else {
                    this.cache(patch, imp_stack);
                }
            }
            if (this.isMipMapsRegenerationEnabled()) {
                this.regenerateMipMaps(patch);
            }
            if (null != previous_patch) {
                patch.link(previous_patch);
            }
            layer.add(patch);
            previous_patch = patch;
            Utils.showProgress((double)i * (1.0 / (double)n));
        }
        Utils.showProgress(1.0);
        return previous_patch;
    }

    private final String cleanSlashes(String s) {
        return s.replace('\\', '-').replace('/', '-');
    }

    public void parseXMLOptions(HashMap<String, String> ht_attributes) {
        int mipmaps_format;
        String s_mipmaps_format;
        File f;
        String ob = ht_attributes.remove("storage_folder");
        if (null != ob) {
            String sf = ob.replace('\\', '/');
            if (FSLoader.isRelativePath(sf)) {
                sf = this.getParentFolder() + sf;
            }
            if (FSLoader.isURL(sf)) {
                Utils.log2("Can't have an URL as the path of a storage folder.");
            } else {
                f = new File(sf);
                if (f.exists() && f.isDirectory()) {
                    this.dir_storage = sf;
                } else {
                    Utils.log2("storage_folder was not found or is invalid: " + ob);
                }
            }
        }
        if (null == this.dir_storage) {
            this.dir_storage = this.getParentFolder();
            if (null == this.dir_storage || FSLoader.isURL(this.dir_storage)) {
                this.dir_storage = null;
            }
            if (null == this.dir_storage && ControlWindow.isGUIEnabled()) {
                Utils.log2("Asking user for a storage folder in a dialog.");
                DirectoryChooser dc = new DirectoryChooser("REQUIRED: select a storage folder");
                this.dir_storage = dc.getDirectory();
            }
            if (null == this.dir_storage) {
                IJ.showMessage((String)"TrakEM2 requires a storage folder.\nTemporarily your home directory will be used.");
                this.dir_storage = System.getProperty("user.home");
            }
        }
        if (null != this.dir_storage) {
            if (IJ.isWindows()) {
                this.dir_storage = this.dir_storage.replace('\\', '/');
            }
            if (!this.dir_storage.endsWith("/")) {
                this.dir_storage = this.dir_storage + "/";
            }
        }
        Utils.log2("storage folder is " + this.dir_storage);
        ob = ht_attributes.remove("mipmaps_folder");
        if (null != ob) {
            String mf = ob.replace('\\', '/');
            if (FSLoader.isRelativePath(mf)) {
                mf = this.getParentFolder() + mf;
            }
            if (FSLoader.isURL(mf)) {
                this.dir_mipmaps = mf;
            } else {
                f = new File(mf);
                if (f.exists() && f.isDirectory()) {
                    this.dir_mipmaps = mf;
                } else {
                    Utils.log2("mipmaps_folder was not found or is invalid: " + ob);
                }
            }
        }
        if (null != (ob = ht_attributes.remove("mipmaps_regen"))) {
            this.mipmaps_regen = Boolean.parseBoolean(ob);
        }
        if (null != (ob = ht_attributes.get("n_mipmap_threads"))) {
            int n_threads = Math.max(1, Integer.parseInt(ob));
            FSLoader.restartMipMapThreads(n_threads);
        }
        this.unuid = ht_attributes.remove("unuid");
        if (ControlWindow.isGUIEnabled() && null == this.unuid) {
            this.obtainUNUIdFolder();
        }
        if (null == this.dir_mipmaps) {
            this.createMipMapsDir(this.dir_storage);
            if (null != this.dir_mipmaps && ControlWindow.isGUIEnabled() && null != IJ.getInstance()) {
                this.notifyMipMapsOutOfSynch();
            }
        }
        if (null != this.dir_mipmaps && !this.dir_mipmaps.endsWith("/")) {
            this.dir_mipmaps = this.dir_mipmaps + "/";
        }
        Utils.log2("mipmaps folder is " + this.dir_mipmaps);
        if (null == this.unuid) {
            IJ.log((String)"OLD VERSION DETECTED: your trakem2\nproject has been updated to the new format.\nPlease SAVE IT to avoid regenerating\ncached data when reopening it.");
            Utils.log2("Creating unuid for project " + this);
            this.unuid = this.createUNUId(this.dir_storage);
            this.fixStorageFolders();
            Utils.log2("Now mipmaps folder is " + this.dir_mipmaps);
            if (null != this.dir_masks) {
                Utils.log2("Now masks folder is " + this.dir_masks);
            }
        }
        if (null != (s_mipmaps_format = ht_attributes.remove("mipmaps_format")) && (mipmaps_format = Integer.parseInt(s_mipmaps_format.trim())) >= 0 && mipmaps_format < MIPMAP_FORMATS.length) {
            Utils.log2("Set mipmap format to " + mipmaps_format);
            this.setMipMapFormat(mipmaps_format);
        }
    }

    private void notifyMipMapsOutOfSynch() {
        Utils.log2("'ok' dialog to explain that mipmaps may be in disagreement with the XML file.");
        Utils.showMessage("TrakEM2 detected a crash", "TrakEM2 detected a crash. Image mipmap files may be out of synch.\n\nIf you where editing images when the crash occurred,\nplease right-click and run 'Project - Regenerate all mipmaps'");
    }

    @Override
    public Bureaucrat regenerateMipMaps(final Collection<? extends Displayable> patches) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Regenerating mipmaps"){

            @Override
            public void exec() {
                ArrayList<Future<Boolean>> fus = new ArrayList<Future<Boolean>>();
                for (Displayable displayable : patches) {
                    if (displayable.getClass() != Patch.class) continue;
                    fus.add(displayable.getProject().getLoader().regenerateMipMaps((Patch)displayable));
                }
                for (Future future : fus) {
                    try {
                        if (null == future) continue;
                        future.get();
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
            }
        }, Project.findProject(this));
    }

    @Override
    public void insertXMLOptions(StringBuilder sb_body, String indent) {
        sb_body.append(indent).append("unuid=\"").append(this.unuid).append("\"\n");
        if (null != this.dir_mipmaps) {
            sb_body.append(indent).append("mipmaps_folder=\"").append(this.makeRelativePath(this.dir_mipmaps)).append("\"\n");
        }
        if (null != this.dir_storage) {
            sb_body.append(indent).append("storage_folder=\"").append(this.makeRelativePath(this.dir_storage)).append("\"\n");
        }
        sb_body.append(indent).append("mipmaps_format=\"").append(this.mipmaps_format).append("\"\n");
    }

    @Override
    public final String getParentFolder() {
        return this.project_file_path.substring(0, this.project_file_path.lastIndexOf(47) + 1);
    }

    @Override
    public String getMipMapsFolder() {
        return this.dir_mipmaps;
    }

    public static final Object grabPixels(BufferedImage bi) {
        PixelGrabber pg = new PixelGrabber(bi, 0, 0, bi.getWidth(), bi.getHeight(), false);
        try {
            pg.grabPixels();
            return pg.getPixels();
        }
        catch (InterruptedException e) {
            IJError.print(e);
            return null;
        }
    }

    private final BufferedImage createCroppedAlpha(BufferedImage alpha, BufferedImage outside) {
        if (null == outside) {
            return alpha;
        }
        int width = outside.getWidth();
        int height = outside.getHeight();
        byte[] o = (byte[])FSLoader.grabPixels(outside);
        if (null == o) {
            return null;
        }
        byte[] a = null == alpha ? o : (byte[])FSLoader.grabPixels(alpha);
        for (int i = 0; i < o.length; ++i) {
            if ((o[i] & 0xFF) >= 255) continue;
            a[i] = 0;
        }
        BufferedImage thresholded = new BufferedImage(width, height, 13, Loader.GRAY_LUT);
        thresholded.getRaster().setDataElements(0, 0, width, height, a);
        return thresholded;
    }

    private static final byte[] gaussianBlurResizeInHalf(FloatProcessorT2 source) {
        new GaussianBlur().blurFloat((FloatProcessor)source, SIGMA_2, SIGMA_2, 0.01);
        source.halfSizeInPlace();
        return (byte[])source.convertToByte(false).getPixels();
    }

    @Override
    public void queueForMipmapRemoval(Patch p, boolean yes) {
        if (yes) {
            this.touched_mipmaps.add(p);
        } else {
            this.touched_mipmaps.remove(p);
        }
    }

    @Override
    public void tagForMipmapRemoval(Patch p, boolean yes) {
        if (yes) {
            this.mipmaps_to_remove.add(p);
        } else {
            this.mipmaps_to_remove.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean generateMipMaps(Patch patch) {
        Utils.log2("mipmaps for " + patch);
        String path = this.getAbsolutePath(patch);
        if (null == path) {
            Utils.log("generateMipMaps: null path for Patch " + patch);
            this.cannot_regenerate.add(patch);
            return false;
        }
        if (this.hs_unloadable.contains(patch)) {
            FilePathRepair.add(patch);
            return false;
        }
        Object object = this.gm_lock;
        synchronized (object) {
            try {
                if (null == this.dir_mipmaps) {
                    this.createMipMapsDir(null);
                }
                if (null == this.dir_mipmaps || FSLoader.isURL(this.dir_mipmaps)) {
                    return false;
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        this.touched_mipmaps.add(patch);
        this.removeSerializedFeatures(patch);
        this.removeSerializedPointMatches(patch);
        long alpha_mask_id = patch.getAlphaMaskId();
        int resizing_mode = patch.getProject().getMipMapsMode();
        try {
            block100: {
                block102: {
                    FloatProcessorT2 outside;
                    int first_mipmap_level_saved;
                    int h;
                    int w;
                    String filename;
                    ImageProcessor ip;
                    int type;
                    ByteProcessor outside_mask;
                    ByteProcessor alpha_mask;
                    block103: {
                        boolean written;
                        FloatProcessorT2 outside2;
                        block101: {
                            alpha_mask = null;
                            outside_mask = null;
                            type = patch.getType();
                            this.releaseToFit((long)(patch.getOWidth() * patch.getOHeight() * 4) + MIN_FREE_BYTES);
                            Patch.PatchImage pai = patch.createTransformedImage();
                            if (null == pai || null == pai.target) {
                                Utils.log("Can't regenerate mipmaps for patch " + patch);
                                this.cannot_regenerate.add(patch);
                                boolean bl = false;
                                return bl;
                            }
                            ip = pai.target;
                            alpha_mask = pai.mask;
                            outside_mask = pai.outside;
                            pai = null;
                            filename = FSLoader.createMipMapRelPath(patch, this.mExt);
                            w = ip.getWidth();
                            h = ip.getHeight();
                            double min = patch.getMin();
                            double max = patch.getMax();
                            if (-1.0 == min && -1.0 == max) {
                                switch (type) {
                                    case 0: 
                                    case 3: 
                                    case 4: {
                                        patch.setMinAndMax(0.0, 255.0);
                                        break;
                                    }
                                    case 1: {
                                        ((ShortProcessor)ip).findMinAndMax();
                                        patch.setMinAndMax(ip.getMin(), ip.getMax());
                                        break;
                                    }
                                    case 2: {
                                        ((FloatProcessor)ip).findMinAndMax();
                                        patch.setMinAndMax(ip.getMin(), ip.getMax());
                                    }
                                }
                                min = patch.getMin();
                                max = patch.getMax();
                            }
                            ip.setMinAndMax(min, max);
                            if (ByteProcessor.class == ip.getClass() && 0.0 != min && 255.0 != max) {
                                byte[] b = (byte[])ip.getPixels();
                                double scale = 255.0 / (max - min);
                                for (int i = 0; i < b.length; ++i) {
                                    int val = b[i] & 0xFF;
                                    b[i] = (double)val < min ? (byte)0 : (byte)Math.min(255.0, ((double)val - min) * scale);
                                }
                            }
                            if (ip.isColorLut() || type == 3) {
                                ip = ip.convertToRGB();
                                type = 4;
                            }
                            first_mipmap_level_saved = patch.getProject().getFirstMipMapLevelSaved();
                            if (6 != resizing_mode) break block101;
                            long t0 = System.currentTimeMillis();
                            ImageBytes[] b = DownsamplerMipMaps.create(patch, type, ip, alpha_mask, outside_mask);
                            long t1 = System.currentTimeMillis();
                            for (int i = 0; i < b.length; ++i) {
                                if (i < first_mipmap_level_saved) {
                                    if (null == b[i]) continue;
                                    CachingThread.storeForReuse(b[i].c);
                                    continue;
                                }
                                boolean written2 = this.mmio.save(this.getLevelDir(this.dir_mipmaps, i) + filename, b[i].c, b[i].width, b[i].height, 0.85f);
                                if (written2) continue;
                                Utils.log("Failed to save mipmap with area downsampling at level=" + i + " for patch " + patch);
                                this.cannot_regenerate.add(patch);
                                break;
                            }
                            long t2 = System.currentTimeMillis();
                            System.out.println("MipMaps with area downsampling: creation took " + (t1 - t0) + "ms, saving took " + (t2 - t1) + "ms, total: " + (t2 - t0) + "ms\n");
                            break block100;
                        }
                        if (3 != resizing_mode) break block102;
                        if (4 != type) break block103;
                        this.releaseToFit(w * h * 4 * 10);
                        ColorProcessor cp = (ColorProcessor)ip;
                        FloatProcessorT2 red = new FloatProcessorT2(w, h, 0.0, 255.0);
                        cp.toFloat(0, (FloatProcessor)red);
                        FloatProcessorT2 green = new FloatProcessorT2(w, h, 0.0, 255.0);
                        cp.toFloat(1, (FloatProcessor)green);
                        FloatProcessorT2 blue = new FloatProcessorT2(w, h, 0.0, 255.0);
                        cp.toFloat(2, (FloatProcessor)blue);
                        FloatProcessorT2 alpha = null != alpha_mask ? new FloatProcessorT2(alpha_mask) : null;
                        if (null != outside_mask) {
                            outside2 = new FloatProcessorT2(outside_mask);
                            if (null == alpha) {
                                alpha = outside2;
                                alpha_mask = outside_mask;
                            }
                        } else {
                            outside2 = null;
                        }
                        String target_dir0 = this.getLevelDir(this.dir_mipmaps, 0);
                        if (Thread.currentThread().isInterrupted()) {
                            boolean bl = false;
                            return bl;
                        }
                        if (0 == first_mipmap_level_saved && !(written = null == alpha ? this.mmio.save((ImageProcessor)cp, target_dir0 + filename, 0.85f, false) : this.mmio.save(target_dir0 + filename, P.asRGBABytes((int[])cp.getPixels(), (byte[])alpha_mask.getPixels(), null == outside2 ? null : (byte[])outside_mask.getPixels()), w, h, 0.85f))) {
                            Utils.log("Failed to save mipmap for COLOR_RGB, 'alpha = " + (Object)((Object)alpha) + "', level = 0  for  patch " + patch);
                            this.cannot_regenerate.add(patch);
                        }
                        int k = 0;
                        do {
                            byte[] a;
                            String target_dir;
                            if (Thread.currentThread().isInterrupted()) {
                                boolean e = false;
                                return e;
                            }
                            if (null == (target_dir = this.getLevelDir(this.dir_mipmaps, ++k))) break block100;
                            byte[] r = FSLoader.gaussianBlurResizeInHalf(red);
                            byte[] g = FSLoader.gaussianBlurResizeInHalf(green);
                            byte[] b = FSLoader.gaussianBlurResizeInHalf(blue);
                            byte[] byArray = a = null == alpha ? null : FSLoader.gaussianBlurResizeInHalf(alpha);
                            if (null != outside2) {
                                byte[] o = alpha != outside2 ? FSLoader.gaussianBlurResizeInHalf(outside2) : a;
                                for (int i = 0; i < o.length; ++i) {
                                    if ((o[i] & 0xFF) == 255) continue;
                                    a[i] = 0;
                                }
                            }
                            w = red.getWidth();
                            h = red.getHeight();
                            if (first_mipmap_level_saved < k) continue;
                            if (null == alpha) {
                                if (this.mmio.save(target_dir + filename, new byte[][]{r, g, b}, w, h, 0.85f)) continue;
                                Utils.log("Failed to save mipmap for COLOR_RGB, 'alpha = " + (Object)((Object)alpha) + "', level = " + k + " for  patch " + patch);
                                this.cannot_regenerate.add(patch);
                            } else {
                                if (this.mmio.save(target_dir + filename, new byte[][]{r, g, b, a}, w, h, 0.85f)) continue;
                                Utils.log("Failed to save mipmap for COLOR_RGB, 'alpha = " + (Object)((Object)alpha) + "', level = " + k + " for  patch " + patch);
                                this.cannot_regenerate.add(patch);
                            }
                            break block100;
                        } while (w >= 32 && h >= 32);
                        break block100;
                    }
                    long t0 = System.currentTimeMillis();
                    this.releaseToFit(w * h * 4 * 10);
                    if (Thread.currentThread().isInterrupted()) {
                        boolean green = false;
                        return green;
                    }
                    FloatProcessorT2 fp = new FloatProcessorT2((FloatProcessor)ip.convertToFloat());
                    if (0 == type) {
                        fp.setMinMax(0.0, 255.0);
                    } else {
                        fp.setMinAndMax(patch.getMin(), patch.getMax());
                    }
                    FloatProcessorT2 alpha = null != alpha_mask ? new FloatProcessorT2(alpha_mask) : null;
                    if (null != outside_mask) {
                        outside = new FloatProcessorT2(outside_mask);
                        if (null == alpha) {
                            alpha = outside;
                            alpha_mask = outside_mask;
                        }
                    } else {
                        outside = null;
                    }
                    int k = 0;
                    do {
                        if (Thread.currentThread().isInterrupted()) {
                            boolean target_dir0 = false;
                            return target_dir0;
                        }
                        if (0 != k) {
                            FSLoader.gaussianBlurResizeInHalf(fp);
                            if (null != alpha) {
                                FSLoader.gaussianBlurResizeInHalf(alpha);
                                if (alpha != outside && outside != null) {
                                    FSLoader.gaussianBlurResizeInHalf(outside);
                                }
                            }
                        }
                        w = fp.getWidth();
                        h = fp.getHeight();
                        String target_dir = this.getLevelDir(this.dir_mipmaps, k);
                        if (null == target_dir) break;
                        if (k < first_mipmap_level_saved) {
                            ++k;
                            continue;
                        }
                        if (null != alpha) {
                            if (!this.mmio.save(target_dir + filename, new byte[][]{fp.getScaledBytePixels(), P.merge(alpha.getBytePixels(), null == outside ? null : outside.getBytePixels())}, w, h, 0.85f)) {
                                Utils.log("Failed to save mipmap for GRAY8, 'alpha = " + (Object)((Object)alpha) + "', level = " + k + " for  patch " + patch);
                                this.cannot_regenerate.add(patch);
                                break;
                            }
                        } else if (!this.mmio.save(target_dir + filename, new byte[][]{fp.getScaledBytePixels()}, w, h, 0.85f)) {
                            Utils.log("Failed to save mipmap for GRAY8, 'alpha = " + (Object)((Object)alpha) + "', level = " + k + " for  patch " + patch);
                            this.cannot_regenerate.add(patch);
                            break;
                        }
                        ++k;
                    } while (fp.getWidth() >= 32 && fp.getHeight() >= 32);
                    long t1 = System.currentTimeMillis();
                    System.out.println("MipMaps took " + (t1 - t0));
                    break block100;
                }
                Utils.log("ERROR: unknown image resizing mode for mipmaps: " + resizing_mode);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            Utils.log("*** ERROR: Can't generate mipmaps for patch " + patch);
            IJError.print(e);
            this.cannot_regenerate.add(patch);
            boolean bl = false;
            return bl;
        }
        finally {
            this.flushMipMaps(patch.getId());
            if (null != patch.getLayer()) {
                try {
                    patch.getLayer().getParent().removeFromOffscreens(patch.getLayer());
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
            Object e = this.gm_lock;
            synchronized (e) {
                this.regenerating_mipmaps.remove(patch);
            }
            if (patch.getAlphaMaskId() != alpha_mask_id) {
                Utils.log2("Alpha mask changed: resubmitting mipmap regeneration for " + patch);
                this.regenerateMipMaps(patch);
            }
        }
    }

    public boolean removeSerializedFeatures(Patch patch) {
        File f = new File(this.getUNUIdFolder() + "features.ser/" + FSLoader.createIdPath(Long.toString(patch.getId()), "features", ".ser"));
        if (f.exists()) {
            try {
                return f.delete();
            }
            catch (Exception e) {
                IJError.print(e);
                return false;
            }
        }
        return true;
    }

    public boolean removeSerializedPointMatches(Patch patch) {
        String ser = this.getUNUIdFolder() + "pointmatches.ser/";
        File fser = new File(ser);
        if (!fser.exists() || !fser.isDirectory()) {
            return true;
        }
        boolean success = true;
        String sid = Long.toString(patch.getId());
        ArrayList<String> removed_paths = new ArrayList<String>();
        if (sid.length() < 2) {
            success = Utils.removePrefixedFiles(fser, sid + "_", removed_paths);
        } else {
            String sid_ = sid + "_";
            int len = sid_.length();
            StringBuilder dd = new StringBuilder();
            for (int i = 1; i <= len; ++i) {
                dd.append(sid_.charAt(i - 1));
                if (0 != i % 2 || len == i) continue;
                dd.append('/');
            }
            String med = dd.toString();
            int last_slash = med.lastIndexOf(47);
            File med_parent = new File(ser + med.substring(0, last_slash + 1));
            success = Utils.removePrefixedFiles(med_parent, last_slash == med.length() - 2 ? "_" : med.substring(med.length() - 2), removed_paths);
        }
        block1: for (String path : removed_paths) {
            if (IJ.isWindows()) {
                path = path.replace('\\', '/');
            }
            File f = new File(path);
            int idot = path.lastIndexOf(".pointmatches.ser");
            if (idot < 0) {
                Utils.log2("Not a pointmatches.ser file: can't process " + path);
                continue;
            }
            int ifolder = path.indexOf("pointmatches.ser/");
            if (ifolder < 0) {
                Utils.log2("Not in pointmatches.ser/ folder:" + path);
                continue;
            }
            String dir = path.substring(0, ifolder + 17);
            String name = path.substring(dir.length(), idot);
            Utils.log2("name: " + name);
            name = name.replaceAll("/", "");
            int iunderscore = name.indexOf(95);
            if (-1 == iunderscore) {
                Utils.log2("No underscore: can't process " + path);
                continue;
            }
            name = FSLoader.createIdPath(name.substring(iunderscore + 1) + '_' + name.substring(0, iunderscore), "pointmatches", ".ser");
            f = new File(dir + name);
            if (f.exists()) {
                if (!f.delete()) {
                    Utils.log2("Could not delete " + f.getAbsolutePath());
                    success = false;
                    continue;
                }
                Utils.log2("Deleted pointmatches file " + name);
                int islash = name.lastIndexOf(47);
                String dirname = name;
                while (islash > -1) {
                    dirname = dirname.substring(0, islash);
                    if (!Utils.removeFile(new File(dir + dirname))) continue block1;
                    islash = dirname.lastIndexOf(47);
                }
                continue;
            }
            Utils.log2("File does not exist: " + dir + name);
        }
        return success;
    }

    public Bureaucrat generateMipMaps(final Collection<Displayable> patches, final boolean overwrite) {
        if (null == patches || 0 == patches.size()) {
            return null;
        }
        if (null == this.dir_mipmaps) {
            this.createMipMapsDir(null);
        }
        if (FSLoader.isURL(this.dir_mipmaps)) {
            Utils.log("Mipmaps folder is an URL, can't save files into it.");
            return null;
        }
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Generating MipMaps"){

            @Override
            public void exec() {
                this.setAsBackground(true);
                Utils.log2("starting mipmap generation ..");
                try {
                    ArrayList fus = new ArrayList();
                    for (Displayable displ : patches) {
                        if (displ.getClass() != Patch.class) continue;
                        Patch pa = (Patch)displ;
                        boolean ow = overwrite;
                        if (!overwrite) {
                            int w = (int)pa.getWidth();
                            int h = (int)pa.getHeight();
                            int level = 0;
                            String filename = new File(FSLoader.this.getAbsolutePath(pa)).getName() + "." + pa.getId() + FSLoader.this.mExt;
                            do {
                                w /= 2;
                                h /= 2;
                                if (new File(FSLoader.this.dir_mipmaps + ++level + "/" + filename).exists()) continue;
                                ow = true;
                                break;
                            } while (w >= 32 && h >= 32);
                        }
                        if (!ow) continue;
                        fus.add(FSLoader.this.regenerateMipMaps(pa));
                    }
                    Utils.wait(fus);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }, patches.iterator().next().getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getLevelDir(String dir_mipmaps, int level) {
        Object object = FSLOCK;
        synchronized (object) {
            String path = dir_mipmaps + level + '/';
            if (FSLoader.isURL(dir_mipmaps)) {
                return path;
            }
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                return path;
            }
            try {
                file.mkdir();
                return path;
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
        }
    }

    @Override
    public String getUNUIdFolder() {
        return this.getStorageFolder() + "trakem2." + this.unuid + '/';
    }

    private String obtainUNUIdFolder() {
        YesNoCancelDialog yn = ControlWindow.makeYesNoCancelDialog("Old .xml version!", "The loaded XML file does not contain an UNUId. Select a shared UNUId folder?\nShould look similar to: trakem2.12345678.12345678.12345678");
        if (!yn.yesPressed()) {
            return null;
        }
        DirectoryChooser dc = new DirectoryChooser("Select UNUId folder");
        String unuid_dir = dc.getDirectory();
        String unuid_dir_name = new File(unuid_dir).getName();
        Utils.log2("Selected UNUId folder: " + unuid_dir + "\n with name: " + unuid_dir_name);
        if (null != unuid_dir) {
            String dir_storage;
            if (IJ.isWindows()) {
                unuid_dir = unuid_dir.replace('\\', '/');
            }
            if (!unuid_dir_name.startsWith("trakem2.")) {
                Utils.logAll("Invalid UNUId folder: must start with \"trakem2.\". Try again or cancel.");
                return this.obtainUNUIdFolder();
            }
            String[] nums = unuid_dir_name.split("\\.");
            if (nums.length != 4) {
                Utils.logAll("Invalid UNUId folder: needs trakem + 3 number blocks. Try again or cancel.");
                return this.obtainUNUIdFolder();
            }
            for (int i = 1; i < nums.length; ++i) {
                try {
                    Long.parseLong(nums[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    Utils.logAll("Invalid UNUId folder: at least one block is not a number. Try again or cancel.");
                    return this.obtainUNUIdFolder();
                }
            }
            String unuid = unuid_dir_name.substring(8);
            if (unuid.endsWith("/")) {
                unuid = unuid.substring(0, unuid.length() - 1);
            }
            this.unuid = unuid;
            if (!unuid_dir.endsWith("/")) {
                unuid_dir = unuid_dir + "/";
            }
            if (!(dir_storage = new File(unuid_dir).getParent().replace('\\', '/')).endsWith("/")) {
                dir_storage = dir_storage + "/";
            }
            this.dir_storage = dir_storage;
            this.dir_mipmaps = unuid_dir + "trakem2.mipmaps/";
            return unuid_dir;
        }
        return null;
    }

    private boolean createMipMapsDir(String parent_path) {
        block20: {
            File file;
            if (null == this.unuid) {
                this.unuid = this.createUNUId(parent_path);
            }
            if (null == parent_path) {
                DirectoryChooser dc;
                if (null != this.dir_storage) {
                    File f = new File(this.getUNUIdFolder() + "/trakem2.mipmaps");
                    if (!f.exists()) {
                        try {
                            if (f.mkdir()) {
                                this.dir_mipmaps = f.getAbsolutePath().replace('\\', '/');
                                if (!this.dir_mipmaps.endsWith("/")) {
                                    this.dir_mipmaps = this.dir_mipmaps + "/";
                                }
                                return true;
                            }
                        }
                        catch (Exception exception) {}
                    } else if (f.isDirectory()) {
                        this.dir_mipmaps = f.getAbsolutePath().replace('\\', '/');
                        if (!this.dir_mipmaps.endsWith("/")) {
                            this.dir_mipmaps = this.dir_mipmaps + "/";
                        }
                        return true;
                    }
                }
                if (null == (parent_path = (dc = new DirectoryChooser("Select MipMaps parent directory")).getDirectory())) {
                    return false;
                }
                if (IJ.isWindows()) {
                    parent_path = parent_path.replace('\\', '/');
                }
                if (!parent_path.endsWith("/")) {
                    parent_path = parent_path + "/";
                }
            }
            if ((file = new File(parent_path)).exists()) {
                if (file.isDirectory()) {
                    this.dir_mipmaps = parent_path + "trakem2." + this.unuid + "/trakem2.mipmaps/";
                    try {
                        File f = new File(this.dir_mipmaps);
                        f.mkdirs();
                        if (!f.exists()) {
                            Utils.log("Could not create trakem2.mipmaps!");
                            return false;
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        IJError.print(e);
                        return false;
                    }
                }
                Utils.showMessage("Selected parent path is not a directory. Please choose another one.");
                return this.createMipMapsDir(null);
            }
            Utils.showMessage("Parent path does not exist. Please select a new one.");
            return this.createMipMapsDir(null);
        }
        return true;
    }

    @Override
    public void setMipMapsRegeneration(boolean b) {
        super.setMipMapsRegeneration(b);
        if (null != this.dir_mipmaps_stashed && null == this.dir_mipmaps) {
            this.dir_mipmaps = this.dir_mipmaps_stashed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushMipMaps(boolean forget_dir_mipmaps) {
        if (null == this.dir_mipmaps) {
            return;
        }
        Object object = this.db_lock;
        synchronized (object) {
            try {
                if (forget_dir_mipmaps) {
                    this.dir_mipmaps_stashed = this.dir_mipmaps;
                    this.dir_mipmaps = null;
                }
                this.mawts.removeAndFlushAll();
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushMipMaps(long id) {
        if (null == this.dir_mipmaps) {
            return;
        }
        Object object = this.db_lock;
        synchronized (object) {
            try {
                this.mawts.removeAndFlushPyramid(id);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
            }
        }
    }

    @Override
    public Future<Boolean> removeMipMaps(Patch p) {
        return this.removeMipMaps(p, this.mExt);
    }

    private Future<Boolean> removeMipMaps(final Patch p, final String extension) {
        if (null == this.dir_mipmaps) {
            return null;
        }
        final int width = (int)p.getWidth();
        final int height = (int)p.getHeight();
        return remover.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    String path = FSLoader.this.getAbsolutePath(p);
                    if (null == path) {
                        Utils.log2("Remover: null path for Patch " + p);
                        return false;
                    }
                    FSLoader.this.removeMipMaps(FSLoader.createIdPath(Long.toString(p.getId()), new File(path).getName(), extension), width, height);
                    FSLoader.this.flushMipMaps(p.getId());
                    return true;
                }
                catch (Exception e) {
                    IJError.print(e);
                    return false;
                }
            }
        });
    }

    private void removeMipMaps(String filename, int width, int height) {
        int w = width;
        int h = height;
        int k = 0;
        do {
            File f;
            if ((f = new File(this.dir_mipmaps + k + '/' + filename)).exists()) {
                try {
                    if (!f.delete()) {
                        Utils.log2("Could not remove file " + f.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
            ++k;
        } while ((w /= 2) >= 32 && (h /= 2) >= 32);
    }

    @Override
    public boolean usesMipMapsFolder() {
        return null != this.dir_mipmaps;
    }

    @Override
    public int getClosestMipMapLevel(Patch patch, int level, int max_level) {
        if (null == this.dir_mipmaps) {
            return 0;
        }
        try {
            String path = this.getAbsolutePath(patch);
            if (null == path) {
                return Integer.MAX_VALUE;
            }
            String filename = new File(path).getName() + this.mExt;
            if (FSLoader.isURL(this.dir_mipmaps)) {
                if (level <= 0) {
                    return 0;
                }
                if (level > max_level) {
                    return max_level;
                }
                return level;
            }
            do {
                File f;
                if (!(f = new File(this.dir_mipmaps + level + '/' + filename)).exists()) continue;
                return level;
            } while (--level >= 0);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return 0;
    }

    @Override
    public boolean checkMipMapFileExists(Patch p, double magnification) {
        if (null == this.dir_mipmaps) {
            return false;
        }
        int level = FSLoader.getMipMapLevel(magnification, FSLoader.maxDim(p));
        if (FSLoader.isURL(this.dir_mipmaps)) {
            return true;
        }
        return new File(this.dir_mipmaps + level + "/" + new File(this.getAbsolutePath(p)).getName() + "." + p.getId() + this.mExt).exists();
    }

    @Override
    protected MipMapImage fetchMipMapAWT(Patch patch, int level, long n_bytes) {
        return this.fetchMipMapAWT(patch, level, n_bytes, 0);
    }

    public final MipMapImage fetchMipMap(Patch patch, int level, long n_bytes) {
        int max_level = FSLoader.getHighestMipMapLevel(patch);
        if (level > max_level) {
            level = max_level;
        }
        double scale = Math.pow(2.0, level);
        String filename = this.getInternalFileName(patch);
        if (null == filename) {
            Utils.log2("null internal filename!");
            return null;
        }
        String path = this.dir_mipmaps + level + '/' + FSLoader.createIdPath(Long.toString(patch.getId()), filename, this.mExt);
        if (patch.hasAlphaChannel()) {
            BufferedImage img = this.mmio.open(path);
            return img == null ? null : new MipMapImage(img, scale, scale);
        }
        if (patch.paintsWithFalseColor()) {
            BufferedImage img = this.mmio.open(path);
            return img == null ? null : new MipMapImage(img, scale, scale);
        }
        switch (patch.getType()) {
            case 0: 
            case 1: 
            case 2: {
                BufferedImage img = this.mmio.openGrey(path);
                return img == null ? null : new MipMapImage(img, scale, scale);
            }
        }
        BufferedImage img = this.mmio.open(path);
        return img == null ? null : new MipMapImage(img, scale, scale);
    }

    private final MipMapImage fetchMipMapAWT(Patch patch, int level, long n_bytes, int retries) {
        if (null == this.dir_mipmaps) {
            Utils.log2("null dir_mipmaps");
            return null;
        }
        while (retries < 3) {
            try {
                MipMapImage mipMap = this.fetchMipMap(patch, level, n_bytes);
                if (null != mipMap) {
                    return mipMap;
                }
                if (!this.mipmaps_regen) {
                    return null;
                }
                if (this.cannot_regenerate.contains(patch)) {
                    Utils.log("Cannot regenerate mipmaps for patch " + patch);
                    return null;
                }
                double scale = 1.0 / Math.pow(2.0, level);
                if (level < 0 || !((double)patch.getWidth() * scale >= 32.0) || !((double)patch.getHeight() * scale >= 32.0) || !this.isMipMapsRegenerationEnabled()) continue;
                this.regenerateMipMaps(patch);
                return new MipMapImage(REGENERATING, patch.getWidth() / (float)REGENERATING.getWidth(), patch.getHeight() / (float)REGENERATING.getHeight());
            }
            catch (OutOfMemoryError oome) {
                Utils.log2("fetchMipMapAWT: recovering from OutOfMemoryError");
                this.recoverOOME();
                Thread.yield();
                return this.fetchMipMapAWT(patch, level, n_bytes, retries + 1);
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Future<Boolean> regenerateMipMaps(final Patch patch) {
        if (!this.isMipMapsRegenerationEnabled()) {
            this.flushMipMaps(patch.getId());
            return new DONE();
        }
        Object object = this.gm_lock;
        synchronized (object) {
            try {
                Future<Boolean> fu = this.regenerating_mipmaps.get(patch);
                if (null != fu) {
                    return fu;
                }
                n_regenerating.incrementAndGet();
                Utils.log2("SUBMITTING to regen " + patch);
                Utils.showStatus("Regenerating mipmaps (" + n_regenerating.get() + " to go)");
                final Future<Boolean> removing = this.removeMipMaps(patch);
                fu = regenerator.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        boolean b = false;
                        try {
                            if (null != removing) {
                                removing.get();
                            }
                            Utils.showStatus("Regenerating mipmaps (" + n_regenerating.get() + " to go)");
                            b = FSLoader.this.generateMipMaps(patch);
                            Display.repaint(patch.getLayer());
                            Display.updatePanel(patch.getLayer(), patch);
                            Utils.showStatus("");
                        }
                        catch (Exception e) {
                            IJError.print(e);
                        }
                        n_regenerating.decrementAndGet();
                        return b;
                    }
                });
                this.regenerating_mipmaps.put(patch, fu);
                return fu;
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
        }
    }

    @Override
    public long estimateImageFileSize(Patch p, int level) {
        if (level > 0) {
            double scale = 1.0 / Math.pow(2.0, level);
            return (long)((double)p.getWidth() * scale * (double)p.getHeight() * scale * 5.0 + 1024.0);
        }
        long size = (long)(p.getWidth() * p.getHeight());
        int bytes_per_pixel = 1;
        int type = p.getType();
        switch (type) {
            case 2: {
                bytes_per_pixel = 5;
                break;
            }
            case 1: {
                bytes_per_pixel = 3;
            }
            case 4: {
                bytes_per_pixel = 4;
                break;
            }
            case 0: 
            case 3: {
                bytes_per_pixel = 1;
                String path = this.ht_paths.get(p.getId());
                if (null == path || !path.endsWith(this.mExt)) break;
                bytes_per_pixel = 5;
                break;
            }
            default: {
                bytes_per_pixel = 5;
            }
        }
        return size * (long)bytes_per_pixel + 1024L;
    }

    @Override
    public String makeProjectName() {
        if (null == this.project_file_path || 0 == this.project_file_path.length()) {
            return super.makeProjectName();
        }
        String name = new File(this.project_file_path).getName();
        int i_dot = name.lastIndexOf(46);
        if (-1 == i_dot) {
            return name;
        }
        if (0 == i_dot) {
            return super.makeProjectName();
        }
        return name.substring(0, i_dot);
    }

    @Override
    public String handlePathlessImage(ImagePlus imp) {
        FileInfo fi = imp.getOriginalFileInfo();
        if (null == fi) {
            fi = imp.getFileInfo();
        }
        if (null == fi.fileName || fi.fileName.equals("")) {
            fi.fileName = "img_" + System.currentTimeMillis() + ".tif";
        }
        if (!fi.fileName.endsWith(".tif")) {
            fi.fileName = fi.fileName + ".tif";
        }
        fi.directory = this.dir_storage;
        if (imp.getNSlices() > 1) {
            new FileSaver(imp).saveAsTiffStack(this.dir_storage + fi.fileName);
        } else {
            new FileSaver(imp).saveAsTiff(this.dir_storage + fi.fileName);
        }
        Utils.log2("Saved a copy into the storage folder:\n" + this.dir_storage + fi.fileName);
        return this.dir_storage + fi.fileName;
    }

    public boolean fixStorageFolders() {
        try {
            if (null == this.unuid) {
                Utils.log2("No unuid for project!");
                return false;
            }
            String unuid_folder = this.getUNUIdFolder();
            File fdir = new File(unuid_folder);
            if (!fdir.exists() && !fdir.mkdir()) {
                Utils.log2("Could not create folder " + unuid_folder);
                return false;
            }
            String new_dir_mipmaps = unuid_folder + "trakem2.mipmaps/";
            fdir = new File(new_dir_mipmaps);
            if (!fdir.mkdir()) {
                Utils.log2("Could not create folder " + new_dir_mipmaps);
                return false;
            }
            String dir_mipmaps = this.getMipMapsFolder();
            for (String name : new File(dir_mipmaps).list()) {
                String level_dir = dir_mipmaps + name + '/';
                File f = new File(level_dir);
                if (!f.isDirectory() || f.isHidden()) continue;
                for (String mm : f.list()) {
                    int last_dot;
                    if (!mm.endsWith(this.mExt) || -1 == (last_dot = mm.lastIndexOf(46))) continue;
                    int prev_last_dot = mm.lastIndexOf(46, last_dot - 1);
                    String id = mm.substring(prev_last_dot + 1, last_dot);
                    String filename = mm.substring(0, prev_last_dot);
                    File oldf = new File(level_dir + mm);
                    File newf = new File(new_dir_mipmaps + name + '/' + FSLoader.createIdPath(id, filename, this.mExt));
                    File fd = newf.getParentFile();
                    fd.mkdirs();
                    if (!fd.exists()) {
                        Utils.log2("Could not create parent dir " + fd.getAbsolutePath());
                        continue;
                    }
                    if (oldf.renameTo(newf)) continue;
                    Utils.log2("Could not move mipmap file " + oldf.getAbsolutePath() + " to " + newf.getAbsolutePath());
                }
            }
            this.dir_mipmaps = new_dir_mipmaps;
            Utils.removeFile(new File(dir_mipmaps));
            String masks_folder = this.getStorageFolder() + "trakem2.masks/";
            File fmasks = new File(masks_folder);
            this.dir_masks = null;
            if (fmasks.exists()) {
                String new_dir_masks = unuid_folder + "trakem2.masks/";
                File[] fmask_files = fmasks.listFiles();
                if (null != fmask_files) {
                    for (File fmask : fmask_files) {
                        int last_dot;
                        String name = fmask.getName();
                        if (!name.endsWith(".zip") || -1 == (last_dot = name.lastIndexOf(46))) continue;
                        int prev_last_dot = name.lastIndexOf(46, last_dot - 1);
                        String id = name.substring(prev_last_dot + 1, last_dot);
                        String filename = name.substring(0, prev_last_dot);
                        File newf = new File(new_dir_masks + FSLoader.createIdPath(id, filename, ".zip"));
                        File fd = newf.getParentFile();
                        fd.mkdirs();
                        if (!fd.exists()) {
                            Utils.log2("Could not create parent dir " + fd.getAbsolutePath());
                            continue;
                        }
                        if (fmask.renameTo(newf)) continue;
                        Utils.log2("Could not move mask file " + fmask.getAbsolutePath() + " to " + newf.getAbsolutePath());
                    }
                }
                this.dir_masks = new_dir_masks;
                Utils.removeFile(fmasks);
            }
            return true;
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    public static final String createMipMapRelPath(Patch p, String ext) {
        return FSLoader.createIdPath(Long.toString(p.getId()), new File(p.getCurrentPath()).getName(), ext);
    }

    public static final String createIdPath(String sid, String filename, String ext) {
        StringBuilder sf = new StringBuilder(sid.length() * 3 / 2 + 1);
        int len = sid.length();
        for (int i = 1; i <= len; ++i) {
            sf.append(sid.charAt(i - 1));
            if (0 != i % 2 || len == i) continue;
            sf.append('/');
        }
        return sf.append('.').append(filename).append(ext).toString();
    }

    @Override
    public String getUNUId() {
        return this.unuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MipMapImage fetchDataImage(Patch p, double mag) {
        Future<Boolean> fu = null;
        MipMapImage mipMap = null;
        Object object = this.gm_lock;
        synchronized (object) {
            fu = this.regenerating_mipmaps.get(p);
        }
        if (null == fu) {
            mipMap = this.fetchImage(p, mag);
            if (Loader.REGENERATING != mipMap.image) {
                return mipMap;
            }
            object = this.gm_lock;
            synchronized (object) {
                fu = this.regenerating_mipmaps.get(p);
            }
        }
        if (null != fu) {
            try {
                if (!fu.get().booleanValue()) {
                    Utils.log("Loader.fetchDataImage: could not regenerate mipmaps and get an image for patch " + p);
                    return new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
                }
                mipMap = this.fetchImage(p, mag);
                if (Loader.isSignalImage(mipMap.image)) {
                    return new MipMapImage(p.createTransformedImage().createImage(p.getMin(), p.getMax()), 1.0, 1.0);
                }
                return mipMap;
            }
            catch (Throwable e) {
                IJError.print(e);
            }
        }
        Utils.log("Loader.fetchDataImage: could not get a data image for patch " + p);
        return new MipMapImage(NOT_FOUND, p.getWidth() / (float)NOT_FOUND.getWidth(), p.getHeight() / (float)NOT_FOUND.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImagePlus fetchImagePlus(Stack stack) {
        ImagePlus imp = null;
        String path = null;
        Loader.ImageLoadingLock plock = null;
        Object object = this.db_lock;
        synchronized (object) {
            try {
                imp = this.mawts.get(stack.getId());
                if (null != imp) {
                    return imp;
                }
                path = stack.getFilePath();
                plock = this.getOrMakeImageLoadingLock(stack.getId(), 0);
            }
            catch (Throwable t) {
                this.handleCacheError(t);
                return null;
            }
        }
        object = plock;
        synchronized (object) {
            ImagePlus imagePlus;
            block21: {
                imp = this.mawts.get(stack.getId());
                if (null != imp) {
                    Object object2 = this.db_lock;
                    synchronized (object2) {
                        this.removeImageLoadingLock(plock);
                        return imp;
                    }
                }
                this.releaseToFit(stack.estimateImageFileSize());
                imp = this.openImage(this.getAbsolutePath(path));
                Object object3 = this.db_lock;
                synchronized (object3) {
                    try {
                        if (null == imp) {
                            if (!this.hs_unloadable.contains(stack)) {
                                Utils.log("FSLoader.fetchImagePlus: no image exists for stack  " + stack + "  at path " + path);
                                this.hs_unloadable.add(stack);
                            }
                            imagePlus = null;
                            break block21;
                        }
                        this.mawts.put(stack.getId(), imp, (int)Math.max(stack.getWidth(), stack.getHeight()));
                        break block22;
                    }
                    catch (Exception e) {
                        IJError.print(e);
                        break block22;
                    }
                }
            }
            return imagePlus;
            {
                block22: {
                    finally {
                        this.removeImageLoadingLock(plock);
                    }
                }
                return imp;
            }
        }
    }

    @Override
    public boolean deleteStaleFiles(boolean coordinate_transforms, boolean alpha_masks) {
        boolean b = true;
        Project project = Project.findProject(this);
        if (coordinate_transforms) {
            boolean bl = b = b && StaleFiles.deleteCoordinateTransforms(project);
        }
        if (alpha_masks) {
            b = b && StaleFiles.deleteAlphaMasks(project);
        }
        return b;
    }

    private RWImage newMipMapRWImage() {
        switch (this.mipmaps_format) {
            case 0: {
                return new RWImageJPG();
            }
            case 1: {
                return new RWImagePNG();
            }
            case 2: {
                return new RWImageTIFF();
            }
            case 3: {
                return new RWImageRaw();
            }
            case 4: {
                return new RWImageRag();
            }
        }
        return null;
    }

    @Override
    public final int getMipMapFormat() {
        return this.mipmaps_format;
    }

    @Override
    public final boolean setMipMapFormat(int format) {
        switch (format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mipmaps_format = format;
                this.mExt = MIPMAP_FORMATS[this.mipmaps_format];
                this.mmio = this.newMipMapRWImage();
                return true;
            }
        }
        Utils.log("Ignoring unknown mipmap format: " + format);
        return false;
    }

    @Override
    public Bureaucrat updateMipMapsFormat(final int old_format, int new_format) {
        if (old_format < 0 || old_format > 4) {
            Utils.log("Invalid old format for mipmaps!");
            return null;
        }
        if (!this.setMipMapFormat(new_format)) {
            Utils.log("Invalid new format for mipmaps!");
            return null;
        }
        final Project project = Project.findProject(this);
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Updating mipmaps format"){

            @Override
            public void exec() {
                try {
                    ArrayList fus = new ArrayList();
                    String ext = MIPMAP_FORMATS[old_format];
                    for (Layer la : project.getRootLayerSet().getLayers()) {
                        for (Displayable p : la.getDisplayables(Patch.class)) {
                            fus.add(FSLoader.this.removeMipMaps((Patch)p, ext));
                        }
                    }
                    Utils.wait(fus);
                    fus.clear();
                    for (Layer la : project.getRootLayerSet().getLayers()) {
                        for (Displayable p : la.getDisplayables(Patch.class)) {
                            fus.add(FSLoader.this.regenerateMipMaps((Patch)p));
                        }
                    }
                    Utils.wait(fus);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }, project);
    }

    @Override
    protected boolean mapIntensities(Patch p, ImagePlus imp) {
        ArrayImg img;
        String path = this.getUNUIdFolder() + "trakem2.its/" + FSLoader.createIdPath(Long.toString(p.getId()), "it", ".tif");
        if (!new File(path).exists()) {
            return false;
        }
        ImagePlus coefficients = new Opener().openImage(path);
        if (coefficients == null) {
            return false;
        }
        ImageProcessor ip = imp.getProcessor();
        LinearIntensityMap map = new LinearIntensityMap((FloatImagePlus)ImagePlusImgs.from((ImagePlus)coefficients));
        long[] dims = new long[]{imp.getWidth(), imp.getHeight()};
        switch (p.getType()) {
            case 0: 
            case 3: {
                img = ArrayImgs.unsignedBytes((byte[])((byte[])ip.getPixels()), (long[])dims);
                break;
            }
            case 1: {
                img = ArrayImgs.unsignedShorts((short[])((short[])ip.getPixels()), (long[])dims);
                break;
            }
            case 4: {
                img = ArrayImgs.argbs((int[])((int[])ip.getPixels()), (long[])dims);
                break;
            }
            case 2: {
                img = ArrayImgs.floats((float[])((float[])ip.getPixels()), (long[])dims);
                break;
            }
            default: {
                img = null;
            }
        }
        if (img == null) {
            return false;
        }
        map.run(img);
        return true;
    }

    @Override
    public boolean clearIntensityMap(Patch p) {
        File coefficients = new File(this.getUNUIdFolder() + "trakem2.its/" + FSLoader.createIdPath(Long.toString(p.getId()), "it", ".tif"));
        return coefficients.delete();
    }

    private final class RWImageRag
    extends RWImage {
        private RWImageRag() {
        }

        @Override
        final BufferedImage open(String path) {
            return RagMipMaps.read(path);
        }

        @Override
        final BufferedImage openGrey(String path) {
            return ImageSaver.asGrey(RagMipMaps.read(path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean save(String path, byte[][] b, int width, int height, float quality) {
            try {
                boolean bl = RagMipMaps.save(path, b, width, height);
                return bl;
            }
            finally {
                CachingThread.storeForReuse(b);
            }
        }
    }

    private final class RWImageRaw
    extends RWImage {
        private RWImageRaw() {
        }

        @Override
        final BufferedImage open(String path) {
            return RawMipMaps.read(path);
        }

        @Override
        final BufferedImage openGrey(String path) {
            return ImageSaver.asGrey(RawMipMaps.read(path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean save(String path, byte[][] b, int width, int height, float quality) {
            try {
                boolean bl = RawMipMaps.save(path, b, width, height);
                return bl;
            }
            finally {
                CachingThread.storeForReuse(b);
            }
        }
    }

    private final class RWImageTIFF
    extends RWImage {
        private RWImageTIFF() {
        }

        @Override
        final boolean save(ImageProcessor ip, String path, float quality, boolean as_grey) {
            return ImageSaver.saveAsTIFF(ip, path, as_grey);
        }

        @Override
        final boolean save(BufferedImage bi, String path, float quality, boolean as_grey) {
            return ImageSaver.saveAsTIFF(bi, path, as_grey);
        }

        @Override
        final BufferedImage openGrey(String path) {
            return ImageSaver.openGreyTIFF(path);
        }

        @Override
        final BufferedImage open(String path) {
            return ImageSaver.openTIFF(path, true);
        }

        @Override
        final boolean save(String path, byte[][] b, int width, int height, float quality) {
            switch (b.length) {
                case 1: {
                    return ImageSaver.saveAsTIFF(ImageSaver.createGrayImage(b[0], width, height), path, false);
                }
                case 2: {
                    return ImageSaver.saveAsTIFF(ImageSaver.createARGBImage(P.blend(b[0], b[1]), width, height), path, false);
                }
                case 3: {
                    return ImageSaver.saveAsTIFF(ImageSaver.createRGBImage(P.blend(b[0], b[1], b[2]), width, height), path, false);
                }
                case 4: {
                    return ImageSaver.saveAsTIFF(ImageSaver.createARGBImage(P.blend(b[0], b[1], b[2], b[3]), width, height), path, false);
                }
            }
            return false;
        }
    }

    private final class RWImagePNG
    extends RWImage {
        private RWImagePNG() {
        }

        @Override
        final boolean save(ImageProcessor ip, String path, float quality, boolean as_grey) {
            return ImageSaver.saveAsPNG(ip, path);
        }

        @Override
        final boolean save(BufferedImage bi, String path, float quality, boolean as_grey) {
            return ImageSaver.saveAsPNG(bi, path);
        }

        @Override
        final BufferedImage open(String path) {
            return ImageSaver.openImage(path, true);
        }

        @Override
        final BufferedImage openGrey(String path) {
            return ImageSaver.openGreyImage(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        final boolean save(String path, byte[][] b, int width, int height, float quality) {
            Image bi = null;
            try {
                switch (b.length) {
                    case 1: {
                        bi = ImageSaver.createGrayImage(b[0], width, height);
                        boolean bl = ImageSaver.saveAsPNG((BufferedImage)bi, path);
                        return bl;
                    }
                    case 2: {
                        bi = ImageSaver.createARGBImage(P.blend(b[0], b[1]), width, height);
                        boolean bl = ImageSaver.saveAsPNG((BufferedImage)bi, path);
                        return bl;
                    }
                    case 3: {
                        bi = ImageSaver.createRGBImage(P.blend(b[0], b[1], b[2]), width, height);
                        boolean bl = ImageSaver.saveAsPNG((BufferedImage)bi, path);
                        return bl;
                    }
                    case 4: {
                        bi = ImageSaver.createARGBImage(P.blend(b[0], b[1], b[2], b[3]), width, height);
                        boolean bl = ImageSaver.saveAsPNG((BufferedImage)bi, path);
                        return bl;
                    }
                }
                return false;
            }
            finally {
                if (null != bi) {
                    bi.flush();
                    CachingThread.storeArrayForReuse(bi);
                }
            }
        }
    }

    private final class RWImageJPG
    extends RWImage {
        private RWImageJPG() {
        }

        @Override
        final boolean save(ImageProcessor ip, String path, float quality, boolean as_grey) {
            return ImageSaver.saveAsJpeg(ip, path, quality, as_grey);
        }

        @Override
        final boolean save(BufferedImage bi, String path, float quality, boolean as_grey) {
            return ImageSaver.saveAsJpeg(bi, path, quality, as_grey);
        }

        @Override
        final BufferedImage open(String path) {
            return ImageSaver.openImage(path, true);
        }

        @Override
        final BufferedImage openGrey(String path) {
            return ImageSaver.open(path, true);
        }

        @Override
        final boolean save(String path, byte[][] b, int width, int height, float quality) {
            switch (b.length) {
                case 1: {
                    return ImageSaver.saveAsGreyJpeg(b[0], width, height, path, quality);
                }
                case 2: {
                    return ImageSaver.saveAsJpegAlpha(ImageSaver.createARGBImage(P.blend(b[0], b[1]), width, height), path, quality);
                }
                case 3: {
                    return ImageSaver.saveAsJpeg(ImageSaver.createRGBImage(P.blend(b[0], b[1], b[2]), width, height), path, quality, false);
                }
                case 4: {
                    return ImageSaver.saveAsJpegAlpha(ImageSaver.createARGBImage(P.blend(b[0], b[1], b[2], b[3]), width, height), path, quality);
                }
            }
            return false;
        }
    }

    private abstract class RWImage {
        private RWImage() {
        }

        boolean save(ImageProcessor ip, String path, float quality, boolean as_grey) {
            if (as_grey) {
                ip = ip.convertToByte(false);
            }
            if (ip instanceof ByteProcessor) {
                return this.save(path, new byte[][]{(byte[])ip.getPixels()}, ip.getWidth(), ip.getHeight(), quality);
            }
            if (ip instanceof ColorProcessor) {
                int[] p = (int[])ip.getPixels();
                byte[] r = new byte[p.length];
                byte[] g = new byte[p.length];
                byte[] b = new byte[p.length];
                byte[] a = new byte[p.length];
                for (int i = 0; i < p.length; ++i) {
                    int x = p[i];
                    r[i] = (byte)(x >> 16 & 0xFF);
                    g[i] = (byte)(x >> 8 & 0xFF);
                    b[i] = (byte)(x & 0xFF);
                    a[i] = (byte)(x >> 24 & 0xFF);
                }
                return this.save(path, new byte[][]{r, g, b, a}, ip.getWidth(), ip.getHeight(), quality);
            }
            return false;
        }

        boolean save(BufferedImage bi, String path, float quality, boolean as_grey) {
            switch (bi.getType()) {
                case 10: {
                    return this.save((ImageProcessor)new ByteProcessor(bi), path, quality, false);
                }
            }
            if (as_grey) {
                return this.save((ImageProcessor)new ByteProcessor(bi), path, quality, false);
            }
            return this.save((ImageProcessor)new ColorProcessor((Image)bi), path, quality, false);
        }

        abstract boolean save(String var1, byte[][] var2, int var3, int var4, float var5);

        abstract BufferedImage open(String var1);

        abstract BufferedImage openGrey(String var1);
    }

    private static final class DONE
    implements Future<Boolean> {
        private DONE() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            return true;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

