/*
 * Decompiled with CFR 0.152.
 */
package mpi.fruitfly.math;

import java.awt.Point;
import java.util.Vector;
import mpi.fruitfly.math.Quicksortable;

public class General {
    public static final double M_2PI = Math.PI * 2;

    public static double sq(double a) {
        return a * a;
    }

    public static float sq(float a) {
        return a * a;
    }

    public static int ldu(int v) {
        int c = 0;
        do {
            ++c;
        } while ((v >>= 1) > 1);
        return c;
    }

    public static int flipInRange(int a, int mod) {
        int p = 2 * mod;
        if (a < 0) {
            a = p + a % p;
        }
        if (a >= p) {
            a %= p;
        }
        if (a >= mod) {
            a = mod - a % mod - 1;
        }
        return a;
    }

    public static int sign(double value) {
        if (value < 0.0) {
            return -1;
        }
        return 1;
    }

    public static boolean isApproxEqual(double a, double b, double threshold) {
        if (a == b) {
            return true;
        }
        return a + threshold > b && a - threshold < b;
    }

    public static double computeCorrelationCoefficient(double[] X1, double[] X2) {
        if (X1 == null || X2 == null) {
            return Double.NaN;
        }
        if (X1.length != X2.length) {
            return Double.NaN;
        }
        int length = X1.length;
        if (length == 0) {
            return Double.NaN;
        }
        double avgX1 = 0.0;
        double avgX2 = 0.0;
        for (int pos = 0; pos < length; ++pos) {
            avgX1 += X1[pos];
            avgX2 += X2[pos];
        }
        avgX1 /= (double)length;
        avgX2 /= (double)length;
        double covar = 0.0;
        double varX1 = 0.0;
        double varX2 = 0.0;
        for (int pos = 0; pos < length; ++pos) {
            double distX1 = X1[pos] - avgX1;
            double distX2 = X2[pos] - avgX2;
            covar += distX1 * distX2;
            varX1 += distX1 * distX1;
            varX2 += distX2 * distX2;
        }
        varX1 /= (double)length;
        varX2 /= (double)length;
        varX1 = Math.sqrt(varX1);
        varX2 = Math.sqrt(varX2);
        double R = (covar /= (double)length) / (varX1 * varX2);
        return R;
    }

    public static int min(int a, int b) {
        if (a > b) {
            return b;
        }
        return a;
    }

    public static double min(double a, double b) {
        if (a > b) {
            return b;
        }
        return a;
    }

    public static float min(float a, float b) {
        if (a > b) {
            return b;
        }
        return a;
    }

    public static int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static float max(float a, float b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static double max(double a, double b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static int offsetToPowerOf2(int size) {
        int offset = 0;
        int power = 2;
        while (power < size) {
            if ((power *= 2) == size) {
                return 0;
            }
            offset = power - size;
        }
        return offset;
    }

    public static double gLog(double z, double c) {
        if (c == 0.0) {
            return z;
        }
        return General.Log10((z + Math.sqrt(z * z + c * c)) / 2.0);
    }

    public static double gLogInv(double w, double c) {
        if (c == 0.0) {
            return w;
        }
        return General.Exp10(w) - c * c * General.Exp10(-w) / 4.0;
    }

    public static double Log10(double x) {
        if (x > 0.0) {
            return Math.log(x) / Math.log(10.0);
        }
        return 0.0;
    }

    public static double Exp10(double x) {
        return Math.pow(10.0, x);
    }

    public static int pow(int a, int b) {
        if (b == 0) {
            return 1;
        }
        if (b == 1) {
            return a;
        }
        int result = a;
        for (int i = 1; i < b; ++i) {
            result *= a;
        }
        return result;
    }

    public static double computeTurkeyBiAverage(double[] conc) {
        return General.computeTurkeyBiAverage(conc, null, 5.0);
    }

    public static double computeTurkeyBiAverage(double[] conc, double c) {
        return General.computeTurkeyBiAverage(conc, null, c);
    }

    public static double computeTurkeyBiAverage(double[] conc, double[] W, double c) {
        if (W == null) {
            W = new double[conc.length];
            for (int i = 0; i < W.length; ++i) {
                W[i] = 1.0;
            }
        }
        double avgConc = 0.0;
        double sumW = 0.0;
        for (int i = 0; i < conc.length; ++i) {
            avgConc += W[i] * conc[i];
            sumW += W[i];
        }
        avgConc /= sumW;
        double SD = 0.0;
        for (int i = 0; i < conc.length; ++i) {
            SD += W[i] * Math.pow(conc[i] - avgConc, 2.0);
        }
        SD = Math.sqrt(SD / sumW);
        double[] u = new double[conc.length];
        for (int i = 0; i < u.length; ++i) {
            double e = Math.abs(0.01 * conc[i]);
            u[i] = W[i] * (conc[i] - avgConc) / (c * SD + e);
        }
        double[] tb = new double[conc.length];
        for (int i = 0; i < conc.length; ++i) {
            tb[i] = Math.abs(u[i]) > 1.0 ? 0.0 : Math.pow(1.0 - u[i] * u[i], 2.0);
        }
        double concTB = 0.0;
        double temp = 0.0;
        for (int i = 0; i < conc.length; ++i) {
            concTB += tb[i] * conc[i];
            temp += tb[i];
        }
        return concTB / temp;
    }

    public static double computeTurkeyBiMedian(double[] concinput, double c) {
        double[] conc = (double[])concinput.clone();
        double medianConc = General.computeMedian(conc);
        double SD = 0.0;
        double[] SDValues = new double[conc.length];
        for (int i = 0; i < conc.length; ++i) {
            SDValues[i] = Math.abs(conc[i] - medianConc);
        }
        SD = General.computeMedian(SDValues);
        double[] u = new double[conc.length];
        for (int i = 0; i < u.length; ++i) {
            double e = Math.abs(0.01 * conc[i]);
            u[i] = (conc[i] - medianConc) / (c * SD + e);
        }
        double[] tb = new double[conc.length];
        for (int i = 0; i < conc.length; ++i) {
            tb[i] = Math.abs(u[i]) > 1.0 ? 0.0 : Math.pow(1.0 - u[i] * u[i], 2.0);
        }
        double concTB = 0.0;
        double temp = 0.0;
        for (int i = 0; i < conc.length; ++i) {
            concTB += tb[i] * conc[i];
            temp += tb[i];
        }
        return concTB / temp;
    }

    public static float computeTurkeyBiMedian(float[] concinput, float c) {
        float[] conc = (float[])concinput.clone();
        float medianConc = General.computeMedian(conc);
        float SD = 0.0f;
        float[] SDValues = new float[conc.length];
        for (int i = 0; i < conc.length; ++i) {
            SDValues[i] = Math.abs(conc[i] - medianConc);
        }
        SD = General.computeMedian(SDValues);
        float[] u = new float[conc.length];
        for (int i = 0; i < u.length; ++i) {
            float e = (float)Math.abs(0.01 * (double)conc[i]);
            u[i] = (conc[i] - medianConc) / (c * SD + e);
        }
        float[] tb = new float[conc.length];
        for (int i = 0; i < conc.length; ++i) {
            tb[i] = Math.abs(u[i]) > 1.0f ? 0.0f : (float)Math.pow(1.0f - u[i] * u[i], 2.0);
        }
        float concTB = 0.0f;
        float temp = 0.0f;
        for (int i = 0; i < conc.length; ++i) {
            concTB += tb[i] * conc[i];
            temp += tb[i];
        }
        return concTB / temp;
    }

    public static double[] computeTurkeyBiMedianWeights(double[] concinput, double c) {
        double[] conc = (double[])concinput.clone();
        double medianConc = General.computeMedian(conc);
        double SD = 0.0;
        double[] SDValues = new double[conc.length];
        for (int i = 0; i < conc.length; ++i) {
            SDValues[i] = Math.abs(conc[i] - medianConc);
        }
        SD = General.computeMedian(SDValues);
        double[] u = new double[conc.length];
        for (int i = 0; i < u.length; ++i) {
            double e = Math.abs(0.01 * conc[i]);
            u[i] = (conc[i] - medianConc) / (c * SD + e);
        }
        double[] tb = new double[conc.length];
        for (int i = 0; i < conc.length; ++i) {
            tb[i] = Math.abs(u[i]) > 1.0 ? 0.0 : Math.pow(1.0 - u[i] * u[i], 2.0);
        }
        return tb;
    }

    public static double computeMedian(double[] values) {
        double[] temp = (double[])values.clone();
        int length = temp.length;
        General.quicksort(temp, 0, length - 1);
        double median = length % 2 == 1 ? temp[length / 2] : (temp[length / 2] + temp[length / 2 - 1]) / 2.0;
        temp = null;
        return median;
    }

    public static float computeMedian(float[] values) {
        float[] temp = (float[])values.clone();
        int length = temp.length;
        General.quicksort(temp, 0, length - 1);
        float median = length % 2 == 1 ? temp[length / 2] : (temp[length / 2] + temp[length / 2 - 1]) / 2.0f;
        temp = null;
        return median;
    }

    public static void quicksort(double[] data, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        double x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                double temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            General.quicksort(data, left, j);
        }
        if (i < right) {
            General.quicksort(data, i, right);
        }
    }

    public static void quicksort(float[] data, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        float x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                float temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            General.quicksort(data, left, j);
        }
        if (i < right) {
            General.quicksort(data, i, right);
        }
    }

    public static void quicksort(Quicksortable[] data, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        double x = data[(left + right) / 2].getQuicksortValue();
        while (true) {
            if (data[i].getQuicksortValue() < x) {
                ++i;
                continue;
            }
            while (x < data[j].getQuicksortValue()) {
                --j;
            }
            if (i <= j) {
                Quicksortable temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            General.quicksort(data, left, j);
        }
        if (i < right) {
            General.quicksort(data, i, right);
        }
    }

    public static void quicksort(Vector data, int left, int right) {
        if (data == null || data.size() < 2) {
            return;
        }
        int i = left;
        int j = right;
        double x = ((Quicksortable)data.get((left + right) / 2)).getQuicksortValue();
        while (true) {
            if (((Quicksortable)data.get(i)).getQuicksortValue() < x) {
                ++i;
                continue;
            }
            while (x < ((Quicksortable)data.get(j)).getQuicksortValue()) {
                --j;
            }
            if (i <= j) {
                Quicksortable temp = (Quicksortable)data.get(i);
                data.set(i, data.get(j));
                data.set(j, temp);
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            General.quicksort(data, left, j);
        }
        if (i < right) {
            General.quicksort(data, i, right);
        }
    }

    public static void quicksort(float[] data, Point[] sortAlso, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        float x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                float temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                Point temp2 = sortAlso[i];
                sortAlso[i] = sortAlso[j];
                sortAlso[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            General.quicksort(data, sortAlso, left, j);
        }
        if (i < right) {
            General.quicksort(data, sortAlso, i, right);
        }
    }

    public static void quicksort(double[] data, int[] sortAlso, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        double x = data[(left + right) / 2];
        while (true) {
            if (data[i] < x) {
                ++i;
                continue;
            }
            while (x < data[j]) {
                --j;
            }
            if (i <= j) {
                double temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                int temp2 = sortAlso[i];
                sortAlso[i] = sortAlso[j];
                sortAlso[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            General.quicksort(data, sortAlso, left, j);
        }
        if (i < right) {
            General.quicksort(data, sortAlso, i, right);
        }
    }
}

