/*
 * Decompiled with CFR 0.152.
 */
package levelsets.ij;

import ij.IJ;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import levelsets.algorithm.Coordinate;
import levelsets.algorithm.DeferredByteArray3D;
import levelsets.algorithm.DeferredObjectArray3D;

public class StateContainer {
    protected static int TILE_SIZE = 5;
    protected int avg_grey = -1;
    protected int x_size;
    protected int y_size;
    protected int z_size;
    boolean insideout = false;
    protected int roi_z;
    DeferredObjectArray3D<States> d_map = null;
    States[][][] s_map = null;
    ArrayList<Coordinate> c_map = null;
    Roi roi_map = null;

    public void setROI(Roi roi, int x, int y, int z, int curr_z) {
        this.roi_map = roi;
        this.x_size = x;
        this.y_size = y;
        this.z_size = z == 0 ? 1 : z;
        this.roi_z = curr_z;
    }

    public void setExpansionToInside(boolean insideout) {
        this.insideout = insideout;
    }

    public void setFastMarching(DeferredByteArray3D statemap, int avg_grey) {
        this.d_map = new DeferredObjectArray3D<Object>(statemap.getXLength(), statemap.getYLength(), statemap.getZLength(), statemap.getTileSize(), null);
        for (int x = 0; x < statemap.getXLength(); ++x) {
            for (int y = 0; y < statemap.getYLength(); ++y) {
                block7: for (int z = 0; z < statemap.getZLength(); ++z) {
                    switch (statemap.get(x, y, z)) {
                        case 1: {
                            this.d_map.set(x, y, z, States.ZERO);
                            continue block7;
                        }
                        case 2: {
                            this.d_map.set(x, y, z, States.INSIDE);
                            continue block7;
                        }
                        case 0: {
                            this.d_map.set(x, y, z, States.OUTSIDE);
                        }
                    }
                }
            }
        }
        this.avg_grey = avg_grey;
        this.x_size = this.d_map.getXLength();
        this.y_size = this.d_map.getYLength();
        this.z_size = this.d_map.getZLength();
    }

    public void setSparseField(int[][][] state) {
        this.s_map = new States[state.length][state[0].length][state[0][0].length];
        for (int z = 0; z < state[0][0].length; ++z) {
            for (int y = 0; y < state[0].length; ++y) {
                for (int x = 0; x < state.length; ++x) {
                    this.s_map[x][y][z] = state[x][y][z] == 0 ? States.ZERO : (state[x][y][z] < 0 ? States.INSIDE : States.OUTSIDE);
                }
            }
        }
        this.x_size = state.length;
        this.y_size = state[0].length;
        this.z_size = state[0][0].length;
    }

    public DeferredObjectArray3D<States> getForSparseField() {
        if (this.d_map != null) {
            return this.d_map;
        }
        if (this.roi_map != null) {
            return this.roi2dmap();
        }
        if (this.c_map != null || this.s_map != null) {
            // empty if block
        }
        return null;
    }

    public ArrayList<Coordinate> getForFastMarching() {
        return this.roi2points();
    }

    public ImageProcessor[] getIPMask() {
        int z;
        ByteProcessor[] bp = new ByteProcessor[this.z_size];
        for (int i = 0; i < this.z_size; ++i) {
            bp[i] = new ByteProcessor(this.x_size, this.y_size);
        }
        if (this.s_map != null) {
            for (z = 0; z < this.s_map[0][0].length; ++z) {
                byte[] pixels = (byte[])bp[z].getPixels();
                for (int y = 0; y < this.s_map[0].length; ++y) {
                    for (int x = 0; x < this.s_map.length; ++x) {
                        pixels[y * this.x_size + x] = this.s_map[x][y][z] == States.ZERO ? 0 : (this.s_map[x][y][z] == States.INSIDE ? 0 : -1);
                    }
                }
            }
            return bp;
        }
        if (this.roi_map != null) {
            this.d_map = this.roi2dmap();
        }
        if (this.d_map != null) {
            for (z = 0; z < this.d_map.getZLength(); ++z) {
                byte[] pixels = (byte[])bp[z].getPixels();
                for (int y = 0; y < this.d_map.getYLength(); ++y) {
                    for (int x = 0; x < this.d_map.getXLength(); ++x) {
                        pixels[y * this.x_size + x] = this.d_map.get(x, y, z) == States.ZERO ? 0 : (this.d_map.get(x, y, z) == States.INSIDE ? 0 : -1);
                    }
                }
            }
            return bp;
        }
        return null;
    }

    public ArrayList<Coordinate> getXYZ(boolean zero_crossing_only) {
        ArrayList<Coordinate> xyz = new ArrayList<Coordinate>(100);
        if (this.s_map != null) {
            for (int z = 0; z < this.s_map[0][0].length; ++z) {
                for (int y = 0; y < this.s_map[0].length; ++y) {
                    for (int x = 0; x < this.s_map.length; ++x) {
                        if (this.s_map[x][y][z] == States.ZERO) {
                            xyz.add(new Coordinate(x, y, z));
                            continue;
                        }
                        if (this.s_map[x][y][z] != States.INSIDE || zero_crossing_only) continue;
                        xyz.add(new Coordinate(x, y, z));
                    }
                }
            }
            return xyz;
        }
        if (this.roi_map != null) {
            this.d_map = this.roi2dmap();
        }
        if (this.d_map != null) {
            for (int z = 0; z < this.d_map.getZLength(); ++z) {
                for (int y = 0; y < this.d_map.getYLength(); ++y) {
                    for (int x = 0; x < this.d_map.getXLength(); ++x) {
                        if (this.d_map.get(x, y, z) == States.ZERO) {
                            xyz.add(new Coordinate(x, y, z));
                            continue;
                        }
                        if (this.d_map.get(x, y, z) != States.INSIDE || zero_crossing_only) continue;
                        xyz.add(new Coordinate(x, y, z));
                    }
                }
            }
            return xyz;
        }
        return null;
    }

    public int getZeroGreyValue() {
        return this.avg_grey;
    }

    protected ArrayList<Coordinate> roi2points() {
        if (this.c_map != null) {
            return this.c_map;
        }
        if (this.roi_map != null) {
            this.c_map = new ArrayList(10);
            if (this.roi_map instanceof PolygonRoi) {
                PolygonRoi roi_p = (PolygonRoi)this.roi_map;
                Rectangle roi_r = roi_p.getBounds();
                int[] xp = roi_p.getXCoordinates();
                int[] yp = roi_p.getYCoordinates();
                for (int i = 0; i < roi_p.getNCoordinates(); ++i) {
                    this.c_map.add(new Coordinate(roi_r.x + xp[i], roi_r.y + yp[i], this.roi_z - 1));
                }
                return this.c_map;
            }
        }
        return null;
    }

    protected DeferredObjectArray3D<States> roi2dmap() {
        if (this.roi_map == null) {
            return null;
        }
        States outside = States.OUTSIDE;
        States inside = States.INSIDE;
        if (this.insideout) {
            outside = States.INSIDE;
            inside = States.OUTSIDE;
        }
        this.d_map = new DeferredObjectArray3D<States>(this.x_size, this.y_size, this.z_size, TILE_SIZE, outside);
        ByteProcessor mask = (ByteProcessor)this.roi_map.getMask();
        Rectangle roi_r = this.roi_map.getBounds();
        int x_start = roi_r.x;
        int x_end = roi_r.x + roi_r.width;
        int y_start = roi_r.y;
        int y_end = roi_r.y + roi_r.height;
        int px_zero = 0;
        int px_inside = 0;
        boolean grey_zero = false;
        boolean grey_inside = false;
        if (mask == null) {
            IJ.log((String)"Note: ROI is rectangle, parsing borders");
            int z = this.roi_z - 1;
            for (int y = y_start; y < y_end; ++y) {
                for (int x = x_start; x < x_end; ++x) {
                    if (x == x_start || y == y_start || x == x_end - 1 || y == y_end - 1) {
                        this.d_map.set(x, y, z, States.ZERO);
                        ++px_zero;
                        continue;
                    }
                    this.d_map.set(x, y, z, inside);
                    ++px_inside;
                }
            }
        } else {
            IJ.log((String)"Note: ROI is shape, parsing shape");
            int z = this.roi_z - 1;
            for (int y = 0; y < roi_r.height; ++y) {
                for (int x = 0; x < roi_r.width; ++x) {
                    int mask_pt = mask.get(x, y);
                    if (mask_pt == 0) continue;
                    boolean border = false;
                    if (x == 0 || y == 0 || x == roi_r.width - 1 || y == roi_r.height - 1) {
                        border = true;
                    } else {
                        int mask_b = (mask.get(x - 1, y) & 1) + (mask.get(x + 1, y) & 1) + (mask.get(x, y - 1) & 1) + (mask.get(x, y + 1) & 1);
                        if (mask_b != 4) {
                            border = true;
                        }
                    }
                    if (border) {
                        this.d_map.set(x + x_start, y + y_start, z, States.ZERO);
                        ++px_zero;
                        continue;
                    }
                    this.d_map.set(x + x_start, y + y_start, z, inside);
                    ++px_inside;
                }
            }
        }
        return this.d_map;
    }

    public static enum States {
        INSIDE,
        ZERO,
        OUTSIDE;

    }
}

