/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TranslationDirection;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.TransformEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class MoveConstrainedAction
extends AbstractSelectedAction {
    private TranslationDirection dir;

    public MoveConstrainedAction(DrawingEditor editor, TranslationDirection dir) {
        super(editor);
        this.dir = dir;
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getView().getSelectionCount() > 0) {
            Rectangle2D.Double r = null;
            HashSet<Figure> transformedFigures = new HashSet<Figure>();
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                transformedFigures.add(f);
                if (r == null) {
                    r = f.getBounds();
                    continue;
                }
                r.add(f.getBounds());
            }
            if (transformedFigures.isEmpty()) {
                return;
            }
            Point2D.Double p0 = new Point2D.Double(r.x, r.y);
            if (this.getView().getConstrainer() != null) {
                this.getView().getConstrainer().translateRectangle(r, this.dir);
            } else {
                switch (this.dir) {
                    case NORTH: {
                        r.y -= 1.0;
                        break;
                    }
                    case SOUTH: {
                        r.y += 1.0;
                        break;
                    }
                    case WEST: {
                        r.x -= 1.0;
                        break;
                    }
                    case EAST: {
                        r.x += 1.0;
                    }
                }
            }
            AffineTransform tx = new AffineTransform();
            tx.translate(r.x - p0.x, r.y - p0.y);
            for (Figure f : transformedFigures) {
                f.willChange();
                f.transform(tx);
                f.changed();
            }
            this.fireUndoableEditHappened(new TransformEdit(transformedFigures, tx));
        }
    }

    public static class South
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedSouth";

        public South(DrawingEditor editor) {
            super(editor, TranslationDirection.SOUTH);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }

    public static class North
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedNorth";

        public North(DrawingEditor editor) {
            super(editor, TranslationDirection.NORTH);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }

    public static class West
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedWest";

        public West(DrawingEditor editor) {
            super(editor, TranslationDirection.WEST);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }

    public static class East
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedEast";

        public East(DrawingEditor editor) {
            super(editor, TranslationDirection.EAST);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }
}

