/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.geom.Point2D;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.io.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.io.ImageOutputFormat;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.pert.PertFactory;
import org.jhotdraw.samples.pert.PertPanel;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLDOMInput;
import org.jhotdraw.xml.NanoXMLDOMOutput;

public class PertApplet
extends JApplet {
    private static final String NAME = "JHotDraw Pert";
    private PertPanel drawingPanel;
    private ButtonGroup toolButtonGroup;

    @Override
    public String getParameter(String name) {
        try {
            return super.getParameter(name);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected String getVersion() {
        return PertApplet.class.getPackage().getImplementationVersion();
    }

    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            PopupFactory.setSharedInstance(new PopupFactory());
        }
        catch (Throwable e) {
            // empty catch block
        }
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        String[] labels = this.getAppletInfo().split("\n");
        for (int i = 0; i < labels.length; ++i) {
            c.add(new JLabel(labels[i].length() == 0 ? " " : labels[i]));
        }
        new Worker<Drawing>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Drawing construct() throws IOException {
                Drawing result;
                System.out.println("getParameter.datafile:" + PertApplet.this.getParameter("datafile"));
                if (PertApplet.this.getParameter("data") != null) {
                    NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new PertFactory(), new StringReader(PertApplet.this.getParameter("data")));
                    result = (Drawing)domi.readObject(0);
                } else if (PertApplet.this.getParameter("datafile") != null) {
                    URL url = new URL(PertApplet.this.getDocumentBase(), PertApplet.this.getParameter("datafile"));
                    InputStream in = url.openConnection().getInputStream();
                    try {
                        NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new PertFactory(), in);
                        result = (Drawing)domi.readObject(0);
                    }
                    finally {
                        in.close();
                    }
                } else {
                    result = null;
                }
                return result;
            }

            @Override
            protected void done(Drawing result) {
                Container c = PertApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                c.add(PertApplet.this.drawingPanel = new PertPanel());
                PertApplet.this.initComponents();
                if (result != null) {
                    PertApplet.this.setDrawing(result);
                }
            }

            @Override
            protected void failed(Throwable value) {
                Container c = PertApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                c.add(PertApplet.this.drawingPanel = new PertPanel());
                value.printStackTrace();
                PertApplet.this.initComponents();
                PertApplet.this.getDrawing().add(new TextFigure(value.toString()));
                value.printStackTrace();
            }

            @Override
            protected void finished() {
                Container c = PertApplet.this.getContentPane();
                PertApplet.this.initDrawing(PertApplet.this.getDrawing());
                c.validate();
            }
        }.start();
    }

    private void setDrawing(Drawing d) {
        this.drawingPanel.setDrawing(d);
    }

    private Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    private void initDrawing(Drawing d) {
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat(new PertFactory());
        inputFormats.add(ioFormat);
        outputFormats.add(ioFormat);
        outputFormats.add(new ImageOutputFormat());
        d.setInputFormats(inputFormats);
        d.setOutputFormats(outputFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String text) {
        if (text != null && text.length() > 0) {
            StringReader in = new StringReader(text);
            try {
                NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new PertFactory(), in);
                this.setDrawing((Drawing)domi.readObject(0));
            }
            catch (Throwable e) {
                this.getDrawing().removeAllChildren();
                TextFigure tf = new TextFigure();
                tf.setText(e.getMessage());
                tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                this.getDrawing().add(tf);
                e.printStackTrace();
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() {
        CharArrayWriter out = new CharArrayWriter();
        try {
            NanoXMLDOMOutput domo = new NanoXMLDOMOutput(new PertFactory());
            domo.writeObject(this.getDrawing());
            domo.save(out);
        }
        catch (IOException e) {
            TextFigure tf = new TextFigure();
            tf.setText(e.getMessage());
            tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
            this.getDrawing().add(tf);
            e.printStackTrace();
        }
        finally {
            out.close();
        }
        return out.toString();
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}};
    }

    @Override
    public String getAppletInfo() {
        return "JHotDraw Pert\nVersion " + this.getVersion() + "\n\nCopyright 1996-2010 (c) by the original authors of JHotDraw and all its contributors" + "\nThis software is licensed under LGPL or" + "\nCreative Commons 3.0 BY";
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("JHotDraw Pert Applet");
                f.setDefaultCloseOperation(3);
                PertApplet a = new PertApplet();
                f.getContentPane().add(a);
                a.init();
                f.setSize(500, 400);
                f.setVisible(true);
                a.start();
            }
        });
    }
}

