/*
 * Decompiled with CFR 0.152.
 */
package org.siox.example;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import org.siox.example.CursorFactory;
import org.siox.example.ImagePane;
import org.siox.example.ScrollDisplay;

public class ControlJPanel
extends JPanel {
    private static final int NO_IMAGE_LOADED_STATUS = 0;
    private static final int IMAGE_LOADED_STATUS = 1;
    private static final int DRAGGING_ROI_STATUS = 2;
    private static final int ROI_CANDIDATE_STATUS = 3;
    private static final int ROI_DEFINED_STATUS = 4;
    private static final int FG_ADDED_STATUS = 5;
    private static final int SEGMENTATED_STATUS = 6;
    private final Action applySelectionAction = new ApplySelectionAction();
    private final Action startSioxAction = new SegmentationAction();
    private final JPanel roiJPanel = new JPanel(new GridBagLayout());
    private final JPanel segJPanel = new JPanel(new GridBagLayout());
    private final JPanel drbJPanel = new JPanel(new GridBagLayout());
    private final JLabel selectModeJLabel = new JLabel("Selection mode:");
    private final JLabel smoothJLabel = new JLabel("Smoothing:");
    private final JLabel brushsizeJLabel = new JLabel("Brush size:");
    private final JLabel brushtypeJLabel = new JLabel("Brush shape:");
    private final JLabel fgOrBgJLabel = new JLabel("Add Known ");
    private final JButton applyJButton = new JButton(this.applySelectionAction);
    private final JButton segmentateJButton = new JButton(this.startSioxAction);
    private final JRadioButton fgJRadioButton = new JRadioButton("Foreground");
    private final JRadioButton bgJRadioButton = new JRadioButton("Background");
    private final JSlider smoothness = new JSlider(0, 10, 6);
    private final JSlider brushsize = new JSlider(0, 31, 14);
    private final JSlider addThreshold = new JSlider(0, 100, 100);
    private final JSlider subThreshold = new JSlider(0, 100, 0);
    private final JCheckBox multipart = new JCheckBox("Allow multiple foreground components", false);
    private final JRadioButton rectJRadioButton = new JRadioButton("Rectangle");
    private final JRadioButton ellipJRadioButton = new JRadioButton("Ellipse");
    private final JRadioButton lassoJRadioButton = new JRadioButton("Lasso");
    private final JRadioButton addJRadioButton = new JRadioButton("add");
    private final JRadioButton subJRadioButton = new JRadioButton("subtract");
    private final JRadioButton diskJRadioButton = new JRadioButton("Disk");
    private final JRadioButton squareJRadioButton = new JRadioButton("Square");
    private ScrollDisplay scrollDisplay;
    private Component imageWindow;
    private JDesktopPane jDesktopPane = null;
    private final ArrayList arrayListOfWindowListener = new ArrayList();
    private final ArrayList arrayListOfJifListener = new ArrayList();
    private int status = 0;
    private boolean checkForUnsavedChanges = true;

    public ControlJPanel() {
        super(new BorderLayout());
        JPanel controlsBox = new JPanel(new GridBagLayout());
        this.roiJPanel.setBorder(BorderFactory.createTitledBorder("1. Select Region of Interest"));
        this.segJPanel.setBorder(BorderFactory.createTitledBorder("2. Initial Segmentation"));
        this.drbJPanel.setBorder(BorderFactory.createTitledBorder("3. Detail Refinement Brush"));
        ButtonGroup selectModeButtonGroup = new ButtonGroup();
        selectModeButtonGroup.add(this.rectJRadioButton);
        selectModeButtonGroup.add(this.ellipJRadioButton);
        selectModeButtonGroup.add(this.lassoJRadioButton);
        this.rectJRadioButton.setSelected(true);
        String selectModeTooltip = "Selection Mode for choosing Area of Interest.";
        this.selectModeJLabel.setToolTipText("Selection Mode for choosing Area of Interest.");
        this.rectJRadioButton.setToolTipText("Selection Mode for choosing Area of Interest.");
        this.ellipJRadioButton.setToolTipText("Selection Mode for choosing Area of Interest.");
        this.lassoJRadioButton.setToolTipText("Selection Mode for choosing Area of Interest.");
        this.roiJPanel.add((Component)this.selectModeJLabel, ControlJPanel.getGbc(0, 0, 1, false, false));
        this.roiJPanel.add((Component)this.rectJRadioButton, ControlJPanel.getGbc(1, 0, 1, false, false));
        this.roiJPanel.add((Component)this.ellipJRadioButton, ControlJPanel.getGbc(2, 0, 1, false, false));
        this.roiJPanel.add((Component)this.lassoJRadioButton, ControlJPanel.getGbc(3, 0, 1, false, false));
        GridBagConstraints applyGc = ControlJPanel.getGbc(0, 3, 4, false, false);
        applyGc.anchor = 10;
        this.roiJPanel.add((Component)this.applyJButton, applyGc);
        ButtonGroup fgOrBgButtonGroup = new ButtonGroup();
        fgOrBgButtonGroup.add(this.fgJRadioButton);
        fgOrBgButtonGroup.add(this.bgJRadioButton);
        this.fgJRadioButton.setSelected(true);
        String fgOrBgTooltip = "Add Selection as Known Foreground/Background.";
        this.fgOrBgJLabel.setToolTipText("Add Selection as Known Foreground/Background.");
        this.fgJRadioButton.setToolTipText("Add Selection as Known Foreground/Background.");
        this.bgJRadioButton.setToolTipText("Add Selection as Known Foreground/Background.");
        this.segJPanel.add((Component)this.fgOrBgJLabel, ControlJPanel.getGbc(0, 0, 1, false, false));
        this.segJPanel.add((Component)this.fgJRadioButton, ControlJPanel.getGbc(1, 0, 1, false, false));
        this.segJPanel.add((Component)this.bgJRadioButton, ControlJPanel.getGbc(2, 0, 1, false, false));
        this.multipart.setToolTipText("Use All Foreground Components of at Least a Fourth of the Biggest Connected Component.");
        this.smoothness.setToolTipText("Number of Smoothing Cycles in Postprocessing.");
        this.smoothness.setPaintTicks(true);
        this.smoothness.setMinorTickSpacing(1);
        this.smoothness.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.segJPanel.add((Component)this.multipart, ControlJPanel.getGbc(0, 1, 3, false, true));
        this.segJPanel.add((Component)this.smoothJLabel, ControlJPanel.getGbc(0, 2, 3, false, true));
        this.segJPanel.add((Component)this.smoothness, ControlJPanel.getGbc(1, 2, 2, false, true));
        GridBagConstraints segGc = ControlJPanel.getGbc(0, 3, 3, false, false);
        segGc.anchor = 10;
        this.segJPanel.add((Component)this.segmentateJButton, segGc);
        ButtonGroup drbButtonGroup = new ButtonGroup();
        drbButtonGroup.add(this.addJRadioButton);
        drbButtonGroup.add(this.subJRadioButton);
        ActionListener drbModeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlJPanel.this.addThreshold.setEnabled(ControlJPanel.this.addJRadioButton.isSelected());
                ControlJPanel.this.subThreshold.setEnabled(ControlJPanel.this.subJRadioButton.isSelected());
            }
        };
        this.addJRadioButton.addActionListener(drbModeListener);
        this.subJRadioButton.addActionListener(drbModeListener);
        this.subJRadioButton.setSelected(true);
        String drbTooltip = "Additive or Subtractive Alpha Brush to Improve Edges or Highly Detailed Regions.";
        this.addJRadioButton.setToolTipText("Additive or Subtractive Alpha Brush to Improve Edges or Highly Detailed Regions.");
        this.subJRadioButton.setToolTipText("Additive or Subtractive Alpha Brush to Improve Edges or Highly Detailed Regions.");
        this.addThreshold.setToolTipText("Threshold Defining Subpixel Granularity for Additive Refinement Brush.");
        this.subThreshold.setToolTipText("Threshold Defining Subpixel Granularity for Subrtractive Refinement Brush.");
        this.addThreshold.setPaintTicks(true);
        this.addThreshold.setMinorTickSpacing(5);
        this.addThreshold.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.subThreshold.setPaintTicks(true);
        this.subThreshold.setMinorTickSpacing(5);
        this.subThreshold.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.drbJPanel.add((Component)this.subJRadioButton, ControlJPanel.getGbc(0, 1, 1, false, false));
        this.drbJPanel.add((Component)this.subThreshold, ControlJPanel.getGbc(1, 1, 2, false, true));
        this.drbJPanel.add((Component)this.addJRadioButton, ControlJPanel.getGbc(0, 2, 1, false, false));
        this.drbJPanel.add((Component)this.addThreshold, ControlJPanel.getGbc(1, 2, 2, false, true));
        this.drbJPanel.add(Box.createVerticalStrut(6), ControlJPanel.getGbc(0, 3, 1, false, false));
        JPanel brushJPanel = new JPanel(new GridBagLayout());
        String brushsizeTooltip = "Size of Brush for Foregroung/Background and Detail Refinement.";
        this.brushsizeJLabel.setToolTipText("Size of Brush for Foregroung/Background and Detail Refinement.");
        this.brushsize.setToolTipText("Size of Brush for Foregroung/Background and Detail Refinement.");
        this.brushsize.setPaintTicks(true);
        this.brushsize.setMinorTickSpacing(1);
        this.brushsize.setMajorTickSpacing(10);
        this.brushsize.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.brushsize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControlJPanel.this.updateBrushCursor();
            }
        });
        String brushtypeTooltip = "Shape of Brush for Foregroung/Background and Detail Refinement.";
        this.brushtypeJLabel.setToolTipText("Shape of Brush for Foregroung/Background and Detail Refinement.");
        this.diskJRadioButton.setToolTipText("Shape of Brush for Foregroung/Background and Detail Refinement.");
        this.squareJRadioButton.setToolTipText("Shape of Brush for Foregroung/Background and Detail Refinement.");
        ButtonGroup brushshapeButtonGroup = new ButtonGroup();
        brushshapeButtonGroup.add(this.diskJRadioButton);
        brushshapeButtonGroup.add(this.squareJRadioButton);
        ActionListener brushshapebModeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlJPanel.this.updateBrushCursor();
            }
        };
        this.diskJRadioButton.addActionListener(brushshapebModeListener);
        this.squareJRadioButton.addActionListener(brushshapebModeListener);
        this.diskJRadioButton.setSelected(true);
        brushJPanel.add((Component)this.brushsizeJLabel, ControlJPanel.getGbc(0, 0, 1, false, false));
        brushJPanel.add((Component)this.brushsize, ControlJPanel.getGbc(1, 0, 2, false, true));
        brushJPanel.add((Component)this.brushtypeJLabel, ControlJPanel.getGbc(0, 1, 1, false, false));
        brushJPanel.add((Component)this.diskJRadioButton, ControlJPanel.getGbc(1, 1, 1, false, false));
        brushJPanel.add((Component)this.squareJRadioButton, ControlJPanel.getGbc(2, 1, 1, false, false));
        controlsBox.add((Component)this.roiJPanel, ControlJPanel.getGbc(0, 0, 1, false, true));
        controlsBox.add((Component)this.segJPanel, ControlJPanel.getGbc(0, 1, 1, false, true));
        controlsBox.add((Component)this.drbJPanel, ControlJPanel.getGbc(0, 2, 1, false, true));
        controlsBox.add((Component)brushJPanel, ControlJPanel.getGbc(0, 3, 1, false, true));
        this.add((Component)controlsBox, "East");
        this.arrayListOfWindowListener.add(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ControlJPanel.this.closeImage();
            }
        });
        this.arrayListOfJifListener.add(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                ControlJPanel.this.closeImage();
            }
        });
        this.updateComponentEnabling();
    }

    public void enableCheckForUnsavedChanges(boolean on) {
        this.checkForUnsavedChanges = on;
    }

    public boolean closeImage() {
        Component window = this.imageWindow;
        ScrollDisplay sd = this.scrollDisplay;
        if (window == null || sd == null) {
            return true;
        }
        if (this.checkForUnsavedChanges && this.hasUnsavedChanges() && !ControlJPanel.showConfirmDialog(window, "Confirm", "There are unsaved changes to the image.\nDiscard changes?")) {
            return false;
        }
        this.imageWindow = null;
        this.scrollDisplay = null;
        this.status = 0;
        this.reset();
        if (window instanceof JDialog) {
            ((JDialog)window).dispose();
        } else {
            ((JInternalFrame)window).hide();
            ((JInternalFrame)window).dispose();
        }
        return true;
    }

    public JDesktopPane getDesktopPane(JDesktopPane jDesktopPane) {
        return jDesktopPane;
    }

    public void setDesktopPane(JDesktopPane jDesktopPane) {
        this.jDesktopPane = jDesktopPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageWindowListener(WindowListener windowListener) {
        ArrayList arrayList = this.arrayListOfWindowListener;
        synchronized (arrayList) {
            this.arrayListOfWindowListener.add(windowListener);
            Component window = this.imageWindow;
            if (window instanceof Window) {
                ((Window)window).addWindowListener(windowListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeImageWindowListener(WindowListener windowListener) {
        ArrayList arrayList = this.arrayListOfWindowListener;
        synchronized (arrayList) {
            Component window = this.imageWindow;
            if (window instanceof Window) {
                ((Window)window).removeWindowListener(windowListener);
            }
            return this.arrayListOfWindowListener.remove(windowListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageWindowListener(InternalFrameListener windowListener) {
        ArrayList arrayList = this.arrayListOfJifListener;
        synchronized (arrayList) {
            this.arrayListOfJifListener.add(windowListener);
            Component window = this.imageWindow;
            if (window instanceof JInternalFrame) {
                ((JInternalFrame)window).addInternalFrameListener(windowListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeImageWindowListener(InternalFrameListener windowListener) {
        ArrayList arrayList = this.arrayListOfJifListener;
        synchronized (arrayList) {
            Component window = this.imageWindow;
            if (window instanceof JInternalFrame) {
                ((JInternalFrame)window).removeInternalFrameListener(windowListener);
            }
            return this.arrayListOfJifListener.remove(windowListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openImage(String title, BufferedImage image) {
        try {
            ScrollDisplay sd = this.scrollDisplay;
            if (sd != null) {
                this.reset();
                this.scrollDisplay = null;
                this.status = 1;
            }
            Component window = this.imageWindow;
            this.imageWindow = null;
            if (window instanceof JDialog) {
                ((JDialog)window).dispose();
            } else if (window instanceof JInternalFrame) {
                ((JInternalFrame)window).dispose();
            }
            ScrollDisplay newScrollDisplay = new ScrollDisplay(image);
            this.status = 1;
            SelectionHandler mil = new SelectionHandler();
            newScrollDisplay.getImagePane().addMouseListener(mil);
            newScrollDisplay.getImagePane().addMouseMotionListener(mil);
            JDesktopPane desktop = this.jDesktopPane;
            this.scrollDisplay = newScrollDisplay;
            if (desktop != null) {
                JInternalFrame jif = new JInternalFrame(title, true, true, true, false);
                jif.setDefaultCloseOperation(0);
                ArrayList arrayList = this.arrayListOfJifListener;
                synchronized (arrayList) {
                    InternalFrameListener[] jifListeners = this.arrayListOfJifListener.toArray(new InternalFrameListener[0]);
                    for (int i = 0; i < jifListeners.length; ++i) {
                        jif.addInternalFrameListener(jifListeners[i]);
                    }
                }
                jif.getContentPane().add(newScrollDisplay);
                jif.pack();
                desktop.add(jif);
                jif.setLocation(50, 50);
                this.imageWindow = jif;
                jif.show();
            } else {
                Container ancestor = this.getTopLevelAncestor();
                Frame frame = ancestor instanceof Frame ? (Frame)ancestor : null;
                JDialog jDialog = new JDialog(frame, title);
                jDialog.setDefaultCloseOperation(0);
                ArrayList arrayList = this.arrayListOfWindowListener;
                synchronized (arrayList) {
                    WindowListener[] winListeners = this.arrayListOfWindowListener.toArray(new WindowListener[0]);
                    for (int i = 0; i < winListeners.length; ++i) {
                        jDialog.addWindowListener(winListeners[i]);
                    }
                }
                jDialog.getContentPane().add(newScrollDisplay);
                jDialog.pack();
                this.imageWindow = jDialog;
                jDialog.show();
            }
            this.imageWindow.setFocusable(true);
            this.imageWindow.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        if (ControlJPanel.this.status == 3) {
                            ControlJPanel.this.applyJButton.doClick();
                        } else if (ControlJPanel.this.status == 5) {
                            ControlJPanel.this.segmentateJButton.doClick();
                        }
                    }
                }
            });
        }
        finally {
            this.updateComponentEnabling();
        }
    }

    private void updateComponentEnabling() {
        Color onColor = UIManager.getColor("TitledBorder.titleColor");
        Color offColor = UIManager.getColor("Label.disabledForeground");
        boolean roiPhase = this.status >= 1 && this.status <= 3;
        boolean roiCandidatePhase = this.status == 3;
        String colorRcName = roiPhase ? "Label.disabledForeground" : "TitledBorder.titleColor";
        ((TitledBorder)this.roiJPanel.getBorder()).setTitleColor(roiPhase ? onColor : offColor);
        this.selectModeJLabel.setEnabled(roiPhase);
        this.rectJRadioButton.setEnabled(roiPhase);
        this.ellipJRadioButton.setEnabled(roiPhase);
        this.lassoJRadioButton.setEnabled(roiPhase);
        this.applySelectionAction.setEnabled(roiCandidatePhase);
        this.roiJPanel.repaint();
        boolean addPhase = this.status == 4 || this.status == 5;
        ((TitledBorder)this.segJPanel.getBorder()).setTitleColor(addPhase ? onColor : offColor);
        this.startSioxAction.setEnabled(this.status == 5);
        this.smoothness.setEnabled(addPhase);
        this.multipart.setEnabled(addPhase);
        this.smoothJLabel.setEnabled(addPhase);
        this.fgOrBgJLabel.setEnabled(addPhase);
        this.fgJRadioButton.setEnabled(addPhase);
        this.bgJRadioButton.setEnabled(this.status == 5);
        if (!this.bgJRadioButton.isEnabled()) {
            this.fgJRadioButton.setSelected(true);
        }
        this.segJPanel.repaint();
        boolean drbPhase = this.status == 6;
        ((TitledBorder)this.drbJPanel.getBorder()).setTitleColor(drbPhase ? onColor : offColor);
        this.addJRadioButton.setEnabled(drbPhase);
        this.subJRadioButton.setEnabled(drbPhase);
        this.addThreshold.setEnabled(drbPhase && this.addJRadioButton.isSelected());
        this.subThreshold.setEnabled(drbPhase && this.subJRadioButton.isSelected());
        this.drbJPanel.repaint();
        boolean brushActive = addPhase || drbPhase;
        this.brushsizeJLabel.setEnabled(brushActive);
        this.brushsize.setEnabled(brushActive);
        this.brushtypeJLabel.setEnabled(brushActive);
        this.squareJRadioButton.setEnabled(brushActive);
        this.diskJRadioButton.setEnabled(brushActive);
        if (this.status != 0) {
            this.updateBrushCursor();
        }
    }

    private void updateBrushCursor() {
        boolean brushActive;
        Component window = this.imageWindow;
        ScrollDisplay sd = this.scrollDisplay;
        if (window == null || sd == null) {
            return;
        }
        boolean bl = brushActive = this.status >= 4 && this.status <= 6;
        if (brushActive) {
            int sz = 2 * this.brushsize.getValue() + 1;
            float scale = (float)sd.getImagePane().getZoomScale();
            Cursor defCurs = Cursor.getDefaultCursor();
            Cursor c = this.squareJRadioButton.isSelected() ? CursorFactory.createFilledSquareCursor(sz, scale, defCurs) : CursorFactory.createDiskCursor(sz, scale, defCurs);
            window.setCursor(c);
        } else {
            window.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean hasUnsavedChanges() {
        ScrollDisplay sd = this.scrollDisplay;
        return sd != null && sd.getImagePane().hasUnsavedChanges();
    }

    public boolean storeCurrentImageTo(File outfile, boolean needToConfirmOverwrite) {
        Component window = this.imageWindow;
        ScrollDisplay sd = this.scrollDisplay;
        if (window == null || sd == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        if (needToConfirmOverwrite && outfile.exists() && !ControlJPanel.showConfirmDialog(window, "Confirm", "File " + outfile.getName() + " exists already.\nOverwrite?")) {
            return false;
        }
        try {
            sd.getImagePane().storeCurrentImage(outfile);
        }
        catch (SecurityException e) {
            ControlJPanel.showErrorDialog(window, "I/O Error", "Not allowed to save image to " + outfile + ".", false);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            ControlJPanel.showErrorDialog(window, "I/O Error", "Saving image to " + outfile + " failed.", false);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void reset() {
        ScrollDisplay sd = this.scrollDisplay;
        this.fgJRadioButton.setSelected(true);
        this.subJRadioButton.setSelected(true);
        this.diskJRadioButton.setSelected(true);
        this.subThreshold.setValue(0);
        this.addThreshold.setValue(100);
        if (sd != null) {
            sd.setConf(0.0f);
            sd.getImagePane().resetPane();
        }
        if (this.status != 0) {
            this.status = 1;
        }
        this.updateComponentEnabling();
    }

    public Action createZoomAction(int factor, boolean zoomIn) {
        return new ZoomAction(factor, zoomIn);
    }

    public Action createSetBgAction(Icon tileIcon, String name, Icon smallIcon) {
        return new SetBgAction(tileIcon, name, smallIcon);
    }

    public Action createSetBgAction(Color color, String name) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        ColorIcon tileIcon = new ColorIcon(color, size.width, size.height);
        ColorIcon smallIcon = new ColorIcon(color, 16, 16);
        return new SetBgAction(tileIcon, name, smallIcon);
    }

    public Action createSetRulerAction(int type) {
        return new SetRulerAction(type);
    }

    private static void showErrorDialog(Component window, String title, String msg, boolean warning) {
        int type;
        int n = type = warning ? 2 : 0;
        if (window instanceof JInternalFrame) {
            JOptionPane.showInternalMessageDialog(window, msg, title, type);
        } else {
            JOptionPane.showMessageDialog(window, msg, title, type);
        }
    }

    private static boolean showConfirmDialog(Component window, String title, String msg) {
        int answer = window instanceof JInternalFrame ? JOptionPane.showInternalConfirmDialog(window, msg, title, 2, 3) : JOptionPane.showConfirmDialog(window, msg, title, 2, 3);
        return 0 == answer;
    }

    private static GridBagConstraints getGbc(int x, int y, int width, boolean vFill, boolean hFill) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6, 6, 5, 5);
        c.anchor = 17;
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = width;
        if (vFill) {
            c.fill = 3;
            c.weighty = 1.0;
        }
        if (hFill) {
            c.fill = hFill ? 1 : 2;
            c.weightx = 1.0;
        }
        return c;
    }

    private static class ColorIcon
    implements Icon {
        private final Color c;
        private final int w;
        private final int h;

        ColorIcon(Color c, int w, int h) {
            this.c = c;
            this.w = w;
            this.h = h;
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }

        @Override
        public void paintIcon(Component comp, Graphics graphics, int x, int y) {
            Graphics g = graphics.create();
            g.setColor(this.c);
            g.fillRect(x, y, this.w, this.h);
            g.dispose();
        }
    }

    private class SelectionHandler
    extends MouseInputAdapter {
        private int lastX = -1;
        private int lastY = -1;

        private SelectionHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                ImagePane imagePane = ControlJPanel.this.scrollDisplay.getImagePane();
                if (ControlJPanel.this.status == 1 || ControlJPanel.this.status == 3) {
                    ControlJPanel.this.status = 2;
                    int x = imagePane.unzoomX(e.getX());
                    int y = imagePane.unzoomY(e.getY());
                    String mode = ControlJPanel.this.rectJRadioButton.isSelected() ? "Rectangle" : (ControlJPanel.this.ellipJRadioButton.isSelected() ? "Ellipse" : "Lasso");
                    imagePane.startSelection(x, y, mode);
                } else if (ControlJPanel.this.status == 4 || ControlJPanel.this.status == 5) {
                    this.fgOrBgBrushing(imagePane.unzoomX(e.getX()), imagePane.unzoomY(e.getY()));
                } else if (ControlJPanel.this.status == 6) {
                    this.detailRefinementBrushing(imagePane.unzoomX(e.getX()), imagePane.unzoomY(e.getY()));
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ImagePane imagePane = ControlJPanel.this.scrollDisplay.getImagePane();
            int x = imagePane.unzoomX(e.getX());
            int y = imagePane.unzoomY(e.getY());
            if (ControlJPanel.this.status == 2) {
                imagePane.selectTo(x, y);
            } else if (ControlJPanel.this.status == 5 || ControlJPanel.this.status == 4) {
                this.fgOrBgBrushing(x, y);
            } else if (ControlJPanel.this.status == 6) {
                this.detailRefinementBrushing(x, y);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            this.lastY = -1;
            this.lastX = -1;
            if (ControlJPanel.this.status == 2) {
                ControlJPanel.this.status = 3;
                ControlJPanel.this.updateComponentEnabling();
                ImagePane imagePane = ControlJPanel.this.scrollDisplay.getImagePane();
                int x = imagePane.unzoomX(e.getX());
                int y = imagePane.unzoomY(e.getY());
                ControlJPanel.this.scrollDisplay.getImagePane().selectTo(x, y);
            } else if (ControlJPanel.this.status == 4 || ControlJPanel.this.status == 5) {
                ControlJPanel.this.status = 5;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ControlJPanel.this.updateBrushCursor();
        }

        private void fgOrBgBrushing(int x, int y) {
            int size = 2 * ControlJPanel.this.brushsize.getValue() + 1;
            if (this.lastX < 0) {
                this.lastX = x;
                this.lastY = y;
            }
            Area area = ControlJPanel.this.squareJRadioButton.isSelected() ? CursorFactory.getAreaBrushedByRect(this.lastX, this.lastY, x, y, size, size) : CursorFactory.getAreaBrushedByDisk(this.lastX, this.lastY, x, y, size);
            float alpha = ControlJPanel.this.fgJRadioButton.isSelected() ? 1.0f : 0.0f;
            ControlJPanel.this.scrollDisplay.setConf(area, alpha);
            this.lastX = x;
            this.lastY = y;
            if (ControlJPanel.this.status == 4) {
                ControlJPanel.this.status = 5;
                ControlJPanel.this.updateComponentEnabling();
            }
        }

        private void detailRefinementBrushing(int x, int y) {
            int size = 2 * ControlJPanel.this.brushsize.getValue() + 1;
            if (this.lastX < 0) {
                this.lastX = x;
                this.lastY = y;
            }
            Area area = ControlJPanel.this.squareJRadioButton.isSelected() ? CursorFactory.getAreaBrushedByRect(this.lastX, this.lastY, x, y, size, size) : CursorFactory.getAreaBrushedByDisk(this.lastX, this.lastY, x, y, size);
            boolean add = ControlJPanel.this.addJRadioButton.isSelected();
            float alpha = (float)(add ? ControlJPanel.this.addThreshold : ControlJPanel.this.subThreshold).getValue() / 100.0f;
            ControlJPanel.this.scrollDisplay.subpixelRefine(area, add, alpha);
            this.lastX = x;
            this.lastY = y;
        }
    }

    private class SetRulerAction
    extends AbstractAction {
        private final int type;

        SetRulerAction(int type) {
            this.type = type;
            switch (type) {
                case -1: {
                    this.putValue("Name", "No Ruler");
                    break;
                }
                case 0: {
                    this.putValue("Name", "Empty Ruler");
                    break;
                }
                case 1: {
                    this.putValue("Name", "Metric Ruler");
                    break;
                }
                case 2: {
                    this.putValue("Name", "Inch Ruler");
                    break;
                }
                case 3: {
                    this.putValue("Name", "Pixel Ruler");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid ruler type: " + type);
                }
            }
            this.putValue("ShortDescription", "Set Image Display Ruler.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component window = ControlJPanel.this.imageWindow;
            ScrollDisplay sd = ControlJPanel.this.scrollDisplay;
            if (window == null || sd == null) {
                Toolkit.getDefaultToolkit().beep();
            } else if (sd.setRuler(this.type)) {
                if (window instanceof JDialog) {
                    ((JDialog)window).pack();
                } else if (window instanceof JInternalFrame) {
                    ((JInternalFrame)window).pack();
                }
            } else {
                sd.repaint();
            }
        }
    }

    private class SetBgAction
    extends AbstractAction {
        private final Icon tileIcon;

        SetBgAction(Icon tileIcon, String name, Icon smallIcon) {
            super(name);
            this.tileIcon = tileIcon;
            this.putValue("ShortDescription", "Set Image Background.");
            if (smallIcon != null) {
                this.putValue("SmallIcon", smallIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollDisplay sd = ControlJPanel.this.scrollDisplay;
            if (sd == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                sd.getImagePane().setBackgroundTile(this.tileIcon);
            }
        }
    }

    private class ZoomAction
    extends AbstractAction {
        private final int zoomFactor;
        private final boolean zoomIn;

        ZoomAction(int factor, boolean zoomIn) {
            super(zoomIn ? factor + ":1" : "1:" + factor);
            if (factor < 1) {
                throw new IllegalArgumentException("nonpositive zoom factor: " + factor);
            }
            this.zoomFactor = factor;
            this.zoomIn = zoomIn;
            if (this.zoomFactor == 1) {
                this.putValue("ShortDescription", "Zoom Shown Image.");
            } else {
                this.putValue("ShortDescription", zoomIn ? "Zoom into Image by Factor " + this.zoomFactor + "." : "Zoom out of Image by Factor " + this.zoomFactor + ".");
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollDisplay sd = ControlJPanel.this.scrollDisplay;
            if (sd == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                sd.setZoom(this.zoomFactor, this.zoomIn);
                ControlJPanel.this.updateBrushCursor();
            }
        }
    }

    private class SegmentationAction
    extends AbstractAction {
        SegmentationAction() {
            super("Segmentate");
            this.putValue("ShortDescription", "Start SIOX Segmentation.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component window = ControlJPanel.this.imageWindow;
            ScrollDisplay sd = ControlJPanel.this.scrollDisplay;
            if (window == null || sd == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            ControlJPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                sd.segmentate(ControlJPanel.this.smoothness.getValue(), ControlJPanel.this.multipart.isSelected());
            }
            catch (IllegalStateException e) {
                ControlJPanel.showErrorDialog(window, "Sorry", "Segmentation needs nonempty foreground definition.", true);
                return;
            }
            finally {
                ControlJPanel.this.setCursor(Cursor.getDefaultCursor());
            }
            ControlJPanel.this.status = 6;
            ControlJPanel.this.updateComponentEnabling();
        }
    }

    private class ApplySelectionAction
    extends AbstractAction {
        ApplySelectionAction() {
            super("Apply Selection");
            this.putValue("ShortDescription", "Apply Selection as Area of Interst.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollDisplay sd = ControlJPanel.this.scrollDisplay;
            if (sd == null || ControlJPanel.this.status != 3) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            sd.applySelection(0.5f);
            sd.getImagePane().clearSelection();
            ControlJPanel.this.status = 4;
            ControlJPanel.this.updateComponentEnabling();
        }
    }
}

