/*
 * Decompiled with CFR 0.152.
 */
package org.siox.example;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import org.siox.example.ScrollDisplay;

public class JRuler
extends JComponent
implements Icon,
SwingConstants {
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    private static final Font SUBTEXT_FONT = UIManager.getLookAndFeelDefaults().getFont("Menu.acceleratorFont");
    private static final int MAJOR_TICKLENGTH = 10;
    private static final int MINOR_TICKLENGTH = 5;
    public static final int NO_UNITS = 0;
    public static final int METRIC_UNITS = 1;
    public static final int INCH_UNITS = 2;
    public static final int PIXEL_UNITS = 3;
    private final ScrollDisplay scrollDisplay;
    private int sizeForMarks;
    private final int rulerLength;
    public final int orientation;
    private final int maxScale;
    private int unitMode;

    protected JRuler(ScrollDisplay scrollDisplay, int orientation, int unitMode, int maxScale) {
        this.scrollDisplay = scrollDisplay;
        this.orientation = orientation;
        this.maxScale = maxScale;
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation: " + orientation);
        }
        this.setUnit(unitMode);
        this.setFont(SUBTEXT_FONT);
        this.setForeground(UIManager.getColor("Label.foreground"));
        FontMetrics fm = this.getFontMetrics(SUBTEXT_FONT);
        this.rulerLength = orientation == 0 ? scrollDisplay.getImagePane().getImageWidth() : scrollDisplay.getImagePane().getImageHeight();
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return this.orientation == 0 ? new Dimension(this.maxScale * this.rulerLength, this.sizeForMarks) : new Dimension(this.sizeForMarks, this.maxScale * this.rulerLength);
    }

    public void setUnit(int unitMode) {
        if (unitMode != 0 && unitMode != 1 && unitMode != 2 && unitMode != 3) {
            throw new IllegalArgumentException("invalid mode: " + unitMode);
        }
        this.unitMode = unitMode;
        this.repaint();
    }

    public int getUnit() {
        return this.unitMode;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        FontMetrics fm = this.getFontMetrics(font);
        this.sizeForMarks = this.orientation == 0 ? 12 + fm.getHeight() : 12 + Math.max(fm.stringWidth("1888"), fm.stringWidth("0 pix"));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int pixLength;
        int valueOffset;
        int paintOffset;
        int unitsPerMajorTick;
        int minorPerMajorTicks;
        int pixPerMajorTick;
        if (this.unitMode == 0) {
            return;
        }
        Rectangle rect = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics();
        double scale = this.scrollDisplay.getImagePane().getZoomScale();
        if (scale > (double)this.maxScale) {
            return;
        }
        if (this.unitMode == 1) {
            pixPerMajorTick = (int)((double)DOTS_PER_INCH * scale / 2.54);
            minorPerMajorTicks = 2;
            unitsPerMajorTick = 1;
        } else if (this.unitMode == 2) {
            pixPerMajorTick = (int)((double)DOTS_PER_INCH * scale);
            minorPerMajorTicks = 4;
            unitsPerMajorTick = 1;
        } else if (scale < 4.0) {
            pixPerMajorTick = (int)(100.0 * scale);
            minorPerMajorTicks = 10;
            unitsPerMajorTick = 100;
        } else {
            pixPerMajorTick = (int)(10.0 * scale);
            minorPerMajorTicks = 10;
            unitsPerMajorTick = 10;
        }
        if (pixPerMajorTick < 2) {
            return;
        }
        if (pixPerMajorTick / minorPerMajorTicks < 2) {
            minorPerMajorTicks = 1;
        }
        if (this.orientation == 0) {
            paintOffset = this.scrollDisplay.getImagePane().getInnerXMargin();
            valueOffset = paintOffset > 0 ? 0 : this.scrollDisplay.getViewport().getViewPosition().x;
            pixLength = this.scrollDisplay.getViewport().getWidth();
        } else {
            paintOffset = this.scrollDisplay.getImagePane().getInnerYMargin();
            valueOffset = paintOffset > 0 ? 0 : this.scrollDisplay.getViewport().getViewPosition().y;
            pixLength = this.scrollDisplay.getViewport().getHeight();
        }
        int pixPerMinorTick = Math.max(1, pixPerMajorTick / minorPerMajorTicks);
        int minorStart = valueOffset / pixPerMinorTick * pixPerMinorTick;
        int majorStart = valueOffset / pixPerMajorTick * pixPerMajorTick;
        int rectEnd = (valueOffset / pixPerMinorTick + 1) * pixPerMinorTick + pixLength;
        int end = Math.min(1 + (int)((double)this.rulerLength * scale), rectEnd);
        int nextLabel = Integer.MIN_VALUE;
        for (int pos = minorStart; pos < majorStart; pos += pixPerMinorTick) {
            this.drawTick(g, pos + paintOffset, 5);
        }
        block1: for (int i = majorStart; i < end; i += pixPerMajorTick) {
            int n = i / pixPerMajorTick * unitsPerMajorTick;
            if (i + paintOffset >= nextLabel) {
                nextLabel = this.drawLabel(g, i + paintOffset, n, unitsPerMajorTick);
            }
            this.drawTick(g, i + paintOffset, 10);
            int to = Math.min(i + pixPerMajorTick, end);
            for (int k = 1; k < minorPerMajorTicks; ++k) {
                int atUnit = n + k * unitsPerMajorTick / minorPerMajorTicks;
                int pos = i + k * pixPerMajorTick / minorPerMajorTicks;
                if (pos > end) continue block1;
                this.drawTick(g, pos + paintOffset, 5);
            }
        }
    }

    private int drawLabel(Graphics g, int tickPos, int no, int unitsPerTick) {
        FontMetrics fm = g.getFontMetrics();
        if (no == 0) {
            String label;
            String string = this.unitMode == 1 ? "0 cm" : (label = this.unitMode == 2 ? "0 in" : "0 pix");
            if (this.orientation == 0) {
                g.drawString(label, tickPos, this.sizeForMarks - 10 - 3);
                return tickPos + fm.stringWidth(label + "_") + 2;
            }
            int xoff = this.sizeForMarks - (13 + fm.stringWidth(label));
            if (xoff + fm.stringWidth(label) >= this.sizeForMarks) {
                xoff = this.sizeForMarks - fm.stringWidth(label) - 1;
            }
            int yoff = fm.getAscent();
            g.drawString(label, Math.max(0, xoff), tickPos + yoff);
            return tickPos + fm.getHeight() + (yoff + 1) / 2 + 2;
        }
        String label = Integer.toString(no);
        if (this.orientation == 0) {
            int off = fm.stringWidth(label) / 2;
            g.drawString(label, tickPos - off, this.sizeForMarks - 10 - 3);
            return tickPos + fm.stringWidth(label + " ");
        }
        int xoff = this.sizeForMarks - 10 - 3 - fm.stringWidth(label);
        int yoff = (g.getFontMetrics().getAscent() + 1) / 2;
        g.drawString(label, Math.max(0, xoff), tickPos + yoff);
        return tickPos + fm.getHeight();
    }

    private void drawTick(Graphics g, int pos, int length) {
        if (this.orientation == 0) {
            g.drawLine(pos, this.sizeForMarks - 1, pos, this.sizeForMarks - length - 1);
        } else {
            g.drawLine(this.sizeForMarks - 1, pos, this.sizeForMarks - length - 1, pos);
        }
    }

    @Override
    public int getIconWidth() {
        return this.orientation == 0 ? this.rulerLength : this.getPreferredSize().width;
    }

    @Override
    public int getIconHeight() {
        return this.orientation == 0 ? this.getPreferredSize().height : this.rulerLength;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Font f = g.getFont();
        g.translate(x, y);
        g.setFont(this.getFont());
        this.paintComponent(g);
        g.setFont(f);
        g.translate(-x, -y);
    }
}

