/*
 * Decompiled with CFR 0.152.
 */
package siox;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.siox.SioxSegmentator;
import siox.SegmentationInfo;

public class Load_Segmentation
implements PlugIn {
    SegmentationInfo sioxInfo = null;
    private SioxSegmentator siox = null;

    public Load_Segmentation() {
    }

    public Load_Segmentation(ImagePlus img, String filename) {
        this.sioxInfo = this.readFileInfo(filename);
    }

    private SegmentationInfo readFileInfo(String filename) {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        SegmentationInfo sioxInfo = null;
        try {
            fis = new FileInputStream(filename);
            in = new ObjectInputStream(fis);
            sioxInfo = (SegmentationInfo)in.readObject();
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return sioxInfo;
    }

    public void run(String args) {
        ImagePlus imRef = IJ.getImage();
        if (null == this.siox && !this.setup()) {
            return;
        }
        ImagePlus out = this.execute(imRef);
        if (null != out) {
            out.show();
        }
    }

    public boolean setup() {
        GenericDialogPlus gd = new GenericDialogPlus("Load SIOX segmentator");
        gd.addFileField("SIOX segmentator file:", "", 50);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        String segmentatorFileName = gd.getNextString();
        this.sioxInfo = this.readFileInfo(segmentatorFileName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus execute(ImagePlus imRef) {
        Load_Segmentation load_Segmentation = this;
        synchronized (load_Segmentation) {
            if (null == this.siox) {
                this.siox = new SioxSegmentator(imRef.getWidth(), imRef.getHeight(), null, this.sioxInfo.getBgSignature(), this.sioxInfo.getFgSignature());
            }
        }
        int w = imRef.getWidth();
        int h = imRef.getHeight();
        ImageStack outputStack = new ImageStack(w, h, null);
        FloatProcessor confMatrix = new FloatProcessor(w, h);
        float[] confMatrixArray = (float[])confMatrix.getPixels();
        int size = imRef.getImageStack().getSize();
        for (int i = 0; i < size; ++i) {
            IJ.showStatus((String)("Segmenting image " + (i + 1) + "/" + size));
            IJ.showProgress((double)((double)(i + 1) / (double)size));
            Arrays.fill(confMatrixArray, 0.5f);
            boolean success = false;
            ColorProcessor image = (ColorProcessor)imRef.getImageStack().getProcessor(i + 1);
            try {
                success = this.siox.applyPrecomputedSignatures((int[])image.getPixels(), confMatrixArray, this.sioxInfo.getSmoothness(), this.sioxInfo.getSizeFactorToKeep());
            }
            catch (IllegalStateException ex) {
                IJ.error((String)"Siox Segmentation", (String)"ERROR: foreground signature does not exist.");
            }
            if (!success) {
                IJ.error((String)"Siox Segmentation", (String)("The segmentation failed on image " + i + 1 + "!"));
            }
            ByteProcessor result = (ByteProcessor)confMatrix.convertToByte(false);
            result.multiply(255.0);
            if (!Prefs.blackBackground) {
                result.invert();
            }
            outputStack.addSlice(imRef.getImageStack().getSliceLabel(i + 1), result.duplicate());
        }
        IJ.showStatus((String)"Segmentation done!");
        IJ.showProgress((double)1.0);
        return new ImagePlus("Segmented stack", outputStack);
    }
}

