/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

final class SimpleCollections {
    private SimpleCollections() {
    }

    static Object[] toArray(List<?> list) {
        Object[] array = new Object[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    static <A> A[] toArray(List<?> list, A[] a) {
        A[] array = a.length >= list.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    static <E> boolean add(List<E> list, E o) {
        list.add(list.size(), o);
        return true;
    }

    static boolean remove(List<?> list, Object o) {
        int index = list.indexOf(o);
        if (index < 0) {
            return false;
        }
        list.remove(index);
        return true;
    }

    static boolean containsAll(Collection<?> collection, Collection<?> c) {
        for (Object o : c) {
            if (collection.contains(o)) continue;
            return false;
        }
        return true;
    }

    static <E> boolean addAll(Collection<E> collection, Collection<? extends E> c) {
        boolean changed = false;
        for (E o : c) {
            changed |= collection.add(o);
        }
        return changed;
    }

    static <E> boolean addAll(List<E> list, int index, Collection<? extends E> c) {
        int i = index;
        for (E o : c) {
            list.add(i++, o);
        }
        return c.size() > 0;
    }

    static boolean removeAll(Collection<?> collection, Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= collection.remove(o);
        }
        return changed;
    }

    static boolean retainAll(Collection<?> collection, Collection<?> c) {
        List absent = collection.stream().filter(o -> !c.contains(o)).collect(Collectors.toList());
        return collection.removeAll(absent);
    }

    static int indexOf(List<?> list, Object o) {
        for (int i = 0; i < list.size(); ++i) {
            if (!Objects.equals(list.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    static int lastIndexOf(List<?> list, Object o) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!Objects.equals(list.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    static <E> ListIterator<E> listIterator(final List<E> list, final int index) {
        return new ListIterator<E>(){
            private int i;
            private int last;
            {
                this.i = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.i < list.size();
            }

            @Override
            public E next() {
                this.last = this.i++;
                return list.get(this.last);
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public E previous() {
                this.last = --this.i;
                return list.get(this.i);
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public void remove() {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                list.remove(this.last);
                this.last = -1;
            }

            @Override
            public void set(E e) {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                list.set(this.last, e);
            }

            @Override
            public void add(E e) {
                list.add(this.i++, e);
                this.last = -1;
            }
        };
    }

    static <E> List<E> subList(final List<E> list, final int fromIndex, final int toIndex) {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return list.get(index + fromIndex);
            }

            @Override
            public int size() {
                return toIndex - fromIndex;
            }
        };
    }
}

