/*
 * Decompiled with CFR 0.152.
 */
package jitk.spline;

import java.io.Serializable;
import java.util.Arrays;
import jitk.spline.TransformInverseGradientDescent;
import jitk.spline.XfmUtils;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThinPlateR2LogRSplineKernelTransform
implements Serializable {
    private static final long serialVersionUID = -972934724062617822L;
    protected final int ndims;
    protected DMatrix1Row dMatrix;
    protected double[][] aMatrix;
    protected double[] bVector;
    protected double stiffness = 0.0;
    protected boolean wMatrixComputeD = false;
    protected boolean computeAffine = true;
    protected int nLandmarks;
    protected final double[][] sourceLandmarks;
    protected double[] weights;
    protected double[] tmpDisplacement;
    protected static final double EPS = 1.0E-8;
    final DMatrix1Row I;
    final DMatrixD1 tmp;
    protected static Logger logger = LoggerFactory.getLogger(ThinPlateR2LogRSplineKernelTransform.class);

    public ThinPlateR2LogRSplineKernelTransform(int ndims) {
        this.ndims = ndims;
        this.sourceLandmarks = null;
        this.nLandmarks = 0;
        this.tmpDisplacement = new double[ndims];
        this.I = ThinPlateR2LogRSplineKernelTransform.buildIdentity(ndims);
        this.tmp = new DMatrixRMaj(ndims, ndims);
    }

    public ThinPlateR2LogRSplineKernelTransform(int ndims, double[][] srcPts, double[][] tgtPts) {
        this(ndims, srcPts, tgtPts, true);
    }

    public ThinPlateR2LogRSplineKernelTransform(int ndims, float[][] srcPts, float[][] tgtPts) {
        this(ndims, srcPts, tgtPts, true);
    }

    public ThinPlateR2LogRSplineKernelTransform(int ndims, double[][] srcPts, double[][] tgtPts, boolean computeAffine) {
        this.ndims = ndims;
        this.sourceLandmarks = srcPts;
        this.computeAffine = computeAffine;
        this.nLandmarks = this.sourceLandmarks != null && this.sourceLandmarks.length > 0 ? srcPts[0].length : 0;
        this.I = ThinPlateR2LogRSplineKernelTransform.buildIdentity(ndims);
        this.tmp = new DMatrixRMaj(ndims, ndims);
        this.computeW(this.buildDisplacements(tgtPts));
    }

    public ThinPlateR2LogRSplineKernelTransform(int ndims, float[][] srcPts, float[][] tgtPts, boolean computeAffine) {
        this.ndims = ndims;
        this.computeAffine = computeAffine;
        this.sourceLandmarks = new double[ndims][this.nLandmarks];
        this.nLandmarks = this.sourceLandmarks != null && this.sourceLandmarks.length > 0 ? srcPts[0].length : 0;
        for (int i = 0; i < this.nLandmarks; ++i) {
            for (int d = 0; d < ndims; ++d) {
                this.sourceLandmarks[d][i] = srcPts[d][i];
            }
        }
        this.I = ThinPlateR2LogRSplineKernelTransform.buildIdentity(ndims);
        this.tmp = new DMatrixRMaj(ndims, ndims);
        this.computeW(this.buildDisplacements(tgtPts));
    }

    public ThinPlateR2LogRSplineKernelTransform(int ndims, double[][] srcPts, double[][] tgtPts, double[] weights) {
        this(ndims, srcPts, tgtPts);
        this.setWeights(weights);
    }

    public ThinPlateR2LogRSplineKernelTransform(double[][] srcPts, double[][] aMatrix, double[] bVector, double[] dMatrixData) {
        this.ndims = srcPts.length;
        this.nLandmarks = srcPts != null && srcPts.length > 0 ? srcPts[0].length : 0;
        this.sourceLandmarks = srcPts;
        this.aMatrix = aMatrix;
        this.bVector = bVector;
        this.I = ThinPlateR2LogRSplineKernelTransform.buildIdentity(this.ndims);
        this.tmp = new DMatrixRMaj(this.ndims, this.ndims);
        this.dMatrix = new DMatrixRMaj(this.ndims, this.nLandmarks);
        this.dMatrix.setData(dMatrixData);
    }

    private static DMatrixRMaj buildIdentity(int ndims) {
        DMatrixRMaj I = new DMatrixRMaj(ndims, ndims);
        CommonOps_DDRM.setIdentity((DMatrix1Row)I);
        return I;
    }

    public int getNumLandmarks() {
        return this.nLandmarks;
    }

    public int getNumDims() {
        return this.ndims;
    }

    public double[][] getSourceLandmarks() {
        return this.sourceLandmarks;
    }

    public double[][] getAffine() {
        return this.aMatrix;
    }

    public double[] getTranslation() {
        return this.bVector;
    }

    public double[] getKnotWeights() {
        return this.dMatrix.getData();
    }

    private void setWeights(double[] weights) {
        if (weights == null) {
            return;
        }
        if (weights.length != this.nLandmarks) {
            this.weights = weights;
        } else {
            logger.error("weights have length (" + weights.length + ") but tmust have length equal to number of landmarks " + this.nLandmarks);
        }
    }

    public void setDoAffine(boolean estimateAffine) {
        this.computeAffine = estimateAffine;
    }

    protected DMatrixRMaj computeReflexiveG() {
        DMatrixRMaj gMatrix = new DMatrixRMaj(this.ndims, this.ndims);
        CommonOps_DDRM.fill((DMatrixD1)gMatrix, (double)0.0);
        for (int i = 0; i < this.ndims; ++i) {
            gMatrix.set(i, i, this.stiffness);
        }
        return gMatrix;
    }

    public static double normSqrd(double[] v) {
        double nrm = 0.0;
        for (int i = 0; i < v.length; ++i) {
            nrm += v[i] * v[i];
        }
        return nrm;
    }

    public DMatrixRMaj buildDisplacements(double[][] targetLandmarks) {
        int i;
        DMatrixRMaj yMatrix = this.computeAffine ? new DMatrixRMaj(this.ndims * (this.nLandmarks + this.ndims + 1), 1) : new DMatrixRMaj(this.ndims * this.nLandmarks, 1);
        for (i = 0; i < this.nLandmarks; ++i) {
            for (int j = 0; j < this.ndims; ++j) {
                yMatrix.set(i * this.ndims + j, 0, targetLandmarks[j][i] - this.sourceLandmarks[j][i]);
            }
        }
        if (this.computeAffine) {
            for (i = 0; i < this.ndims * (this.ndims + 1); ++i) {
                yMatrix.set(this.nLandmarks * this.ndims + i, 0, 0.0);
            }
        }
        return yMatrix;
    }

    public DMatrixRMaj buildDisplacements(float[][] targetLandmarks) {
        int i;
        DMatrixRMaj yMatrix = this.computeAffine ? new DMatrixRMaj(this.ndims * (this.nLandmarks + this.ndims + 1), 1) : new DMatrixRMaj(this.ndims * this.nLandmarks, 1);
        for (i = 0; i < this.nLandmarks; ++i) {
            for (int j = 0; j < this.ndims; ++j) {
                yMatrix.set(i * this.ndims + j, 0, (double)targetLandmarks[j][i] - this.sourceLandmarks[j][i]);
            }
        }
        if (this.computeAffine) {
            for (i = 0; i < this.ndims * (this.ndims + 1); ++i) {
                yMatrix.set(this.nLandmarks * this.ndims + i, 0, 0.0);
            }
        }
        return yMatrix;
    }

    protected void computeW(DMatrixRMaj yMatrix) {
        LinearSolverDense solver;
        DMatrixRMaj wMatrix;
        DMatrixRMaj pMatrix;
        this.dMatrix = new DMatrixRMaj(this.ndims, this.nLandmarks);
        DMatrixRMaj kMatrix = new DMatrixRMaj(this.ndims * this.nLandmarks, this.ndims * this.nLandmarks);
        if (this.computeAffine) {
            this.aMatrix = new double[this.ndims][this.ndims];
            this.bVector = new double[this.ndims];
            pMatrix = new DMatrixRMaj(this.ndims * this.nLandmarks, this.ndims * (this.ndims + 1));
            wMatrix = new DMatrixRMaj(this.ndims * this.nLandmarks + this.ndims * (this.ndims + 1), 1);
        } else {
            wMatrix = new DMatrixRMaj(this.ndims * this.nLandmarks, 1);
            pMatrix = null;
        }
        DMatrixRMaj lMatrix = this.computeL(kMatrix, pMatrix);
        if (this.nLandmarks < this.ndims * this.ndims) {
            logger.debug("pseudo inverse solver");
            solver = LinearSolverFactory_DDRM.pseudoInverse((boolean)false);
        } else {
            logger.debug("linear solver");
            solver = LinearSolverFactory_DDRM.linear((int)lMatrix.numCols);
        }
        solver.setA(lMatrix);
        solver.solve(yMatrix, wMatrix);
        this.reorganizeW(wMatrix);
    }

    protected DMatrixRMaj computeL(DMatrixRMaj kMatrix, DMatrixRMaj pMatrix) {
        this.computeK(kMatrix);
        if (this.computeAffine) {
            this.computeP(pMatrix);
            DMatrixRMaj lMatrix = new DMatrixRMaj(this.ndims * (this.nLandmarks + this.ndims + 1), this.ndims * (this.nLandmarks + this.ndims + 1));
            CommonOps_DDRM.insert((DMatrix)kMatrix, (DMatrix)lMatrix, (int)0, (int)0);
            CommonOps_DDRM.insert((DMatrix)pMatrix, (DMatrix)lMatrix, (int)0, (int)kMatrix.getNumCols());
            CommonOps_DDRM.transpose((DMatrixRMaj)pMatrix);
            CommonOps_DDRM.insert((DMatrix)pMatrix, (DMatrix)lMatrix, (int)kMatrix.getNumRows(), (int)0);
            CommonOps_DDRM.insert((DMatrix)kMatrix, (DMatrix)lMatrix, (int)0, (int)0);
            return lMatrix;
        }
        return kMatrix;
    }

    protected void computeP(DMatrixD1 pMatrix) {
        for (int i = 0; i < this.nLandmarks; ++i) {
            for (int d = 0; d < this.ndims; ++d) {
                CommonOps_DDRM.scale((double)this.sourceLandmarks[d][i], (DMatrixD1)this.I, (DMatrixD1)this.tmp);
                CommonOps_DDRM.insert((DMatrix)this.tmp, (DMatrix)pMatrix, (int)(i * this.ndims), (int)(d * this.ndims));
            }
            CommonOps_DDRM.insert((DMatrix)this.I, (DMatrix)pMatrix, (int)(i * this.ndims), (int)(this.ndims * this.ndims));
        }
    }

    protected void computeK(DMatrixRMaj kMatrix) {
        double[] res = new double[this.ndims];
        DMatrixRMaj Gbase = this.computeReflexiveG();
        DMatrixRMaj G = Gbase.copy();
        for (int i = 0; i < this.nLandmarks; ++i) {
            CommonOps_DDRM.insert((DMatrix)Gbase, (DMatrix)kMatrix, (int)(i * this.ndims), (int)(i * this.ndims));
            for (int j = i + 1; j < this.nLandmarks; ++j) {
                this.srcPtDisplacement(i, j, res);
                this.computeG(res, G);
                CommonOps_DDRM.insert((DMatrix)G, (DMatrix)kMatrix, (int)(i * this.ndims), (int)(j * this.ndims));
                CommonOps_DDRM.insert((DMatrix)G, (DMatrix)kMatrix, (int)(j * this.ndims), (int)(i * this.ndims));
            }
        }
    }

    protected void reorganizeW(DMatrixRMaj wMatrix) {
        int i;
        int ci = 0;
        for (i = 0; i < this.nLandmarks; ++i) {
            for (int d = 0; d < this.ndims; ++d) {
                this.dMatrix.set(d, i, wMatrix.get(ci, 0));
                ++ci;
            }
        }
        if (this.computeAffine) {
            for (int j = 0; j < this.ndims; ++j) {
                for (i = 0; i < this.ndims; ++i) {
                    this.aMatrix[i][j] = wMatrix.get(ci, 0);
                    ++ci;
                }
            }
            for (int k = 0; k < this.ndims; ++k) {
                this.bVector[k] = wMatrix.get(ci, 0);
                ++ci;
            }
        }
    }

    public void computeG(double[] pt, DMatrixRMaj mtx) {
        double r = Math.sqrt(ThinPlateR2LogRSplineKernelTransform.normSqrd(pt));
        double nrm = ThinPlateR2LogRSplineKernelTransform.r2Logr(r);
        CommonOps_DDRM.setIdentity((DMatrix1Row)mtx);
        CommonOps_DDRM.scale((double)nrm, (DMatrixD1)mtx);
    }

    public void computeG(double[] pt, DMatrixRMaj mtx, double w) {
        this.computeG(pt, mtx);
        CommonOps_DDRM.scale((double)w, (DMatrixD1)mtx);
    }

    public void computeDeformationContribution(double[] thispt, double[] result) {
        double[] tmpDisplacement = new double[this.ndims];
        for (int i = 0; i < this.ndims; ++i) {
            result[i] = 0.0;
            tmpDisplacement[i] = 0.0;
        }
        int di = 0;
        for (int lnd = 0; lnd < this.nLandmarks; ++lnd) {
            this.srcPtDisplacement(lnd, thispt, tmpDisplacement);
            double nrm = ThinPlateR2LogRSplineKernelTransform.r2LogrFromDisplacement(tmpDisplacement);
            for (int d = 0; d < this.ndims; ++d) {
                int n = d;
                result[n] = result[n] + nrm * this.dMatrix.get(d, di);
            }
            ++di;
        }
    }

    public double[][] r2LogrDerivative(double[] p) {
        double[][] derivativeMatrix = new double[this.ndims][this.ndims];
        double[] tmpDisplacement = new double[this.ndims];
        Arrays.fill(tmpDisplacement, 0.0);
        int lmi = 0;
        for (int lnd = 0; lnd < this.nLandmarks; ++lnd) {
            this.srcPtDisplacement(lnd, p, tmpDisplacement);
            double r2 = ThinPlateR2LogRSplineKernelTransform.normSqrd(tmpDisplacement);
            double r = Math.sqrt(r2);
            if (r < 1.0E-8) continue;
            double term1 = r * (2.0 * Math.log(r) + 1.0) / Math.sqrt(r2);
            for (int d = 0; d < this.ndims; ++d) {
                for (int j = 0; j < this.ndims; ++j) {
                    double multiplier = term1 * -tmpDisplacement[j];
                    double[] dArray = derivativeMatrix[j];
                    int n = d;
                    dArray[n] = dArray[n] + multiplier * this.dMatrix.get(d, lmi);
                }
            }
            ++lmi;
        }
        return derivativeMatrix;
    }

    public double[][] jacobian(double[] p) {
        double[][] D = this.r2LogrDerivative(p);
        if (this.aMatrix != null) {
            for (int i = 0; i < this.ndims; ++i) {
                for (int j = 0; j < this.ndims; ++j) {
                    if (i == j) {
                        double[] dArray = D[i];
                        int n = j;
                        dArray[n] = dArray[n] + (1.0 + this.aMatrix[i][j]);
                        continue;
                    }
                    double[] dArray = D[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.aMatrix[i][j];
                }
            }
        }
        return D;
    }

    public void stepInDerivativeDirection(double[][] derivative, double[] start, double[] dest, double stepLength) {
        for (int i = 0; i < this.ndims; ++i) {
            dest[i] = start[i];
            for (int j = 0; j < this.ndims; ++j) {
                dest[i] = derivative[i][j] * stepLength;
            }
        }
    }

    public void printXfmBacks2d(int maxx, int maxy, int delx, int dely) {
        double[] pt = new double[2];
        double[] result = new double[2];
        for (int x = 0; x < maxx; x += delx) {
            for (int y = 0; y < maxy; y += dely) {
                pt[0] = x;
                pt[1] = y;
                this.apply(pt, result);
                System.out.println("( " + x + ", " + y + " )  ->  ( " + result[0] + ", " + result[0] + " )");
            }
        }
    }

    public double[] transformPointAffine(double[] pt) {
        int i;
        double[] result = new double[this.ndims];
        for (i = 0; i < this.ndims; ++i) {
            for (int j = 0; j < this.ndims; ++j) {
                int n = i;
                result[n] = result[n] + this.aMatrix[i][j] * pt[j];
            }
        }
        for (i = 0; i < this.ndims; ++i) {
            int n = i;
            result[n] = result[n] + (this.bVector[i] + pt[i]);
        }
        return result;
    }

    public void apply(double[] pt, double[] result) {
        this.apply(pt, result, false);
    }

    public void apply(double[] pt, double[] result, boolean debug) {
        int i;
        if (this.dMatrix == null) {
            for (int j = 0; j < this.ndims; ++j) {
                result[j] = pt[j];
            }
            return;
        }
        this.computeDeformationContribution(pt, result);
        if (this.aMatrix != null) {
            for (i = 0; i < this.ndims; ++i) {
                for (int j = 0; j < this.ndims; ++j) {
                    int n = i;
                    result[n] = result[n] + this.aMatrix[i][j] * pt[j];
                }
            }
        } else {
            for (i = 0; i < this.ndims; ++i) {
                int n = i;
                result[n] = result[n] + pt[i];
            }
        }
        if (this.bVector != null) {
            for (i = 0; i < this.ndims; ++i) {
                int n = i;
                result[n] = result[n] + (this.bVector[i] + pt[i]);
            }
        }
    }

    public double[] apply(double[] pt) {
        double[] result = new double[this.ndims];
        this.apply(pt, result);
        return result;
    }

    public void applyInPlace(double[] pt) {
        double[] tmp = new double[this.ndims];
        this.apply(pt, tmp);
        for (int i = 0; i < this.ndims; ++i) {
            pt[i] = tmp[i];
        }
    }

    public IndexDistancePair closestTargetLandmarkAndDistance(double[] target) {
        int idx = -1;
        double distSqr = Double.MAX_VALUE;
        double thisDist = 0.0;
        double[] err = new double[this.ndims];
        for (int l = 0; l < this.nLandmarks; ++l) {
            this.tgtPtDisplacement(l, target, err);
            thisDist = ThinPlateR2LogRSplineKernelTransform.normSqrd(err);
            if (!(thisDist < distSqr)) continue;
            distSqr = thisDist;
            idx = l;
        }
        return new IndexDistancePair(idx, distSqr);
    }

    public double[] initialGuessAtInverse(double[] target) {
        IndexDistancePair lmAndDist = this.closestTargetLandmarkAndDistance(target);
        logger.trace("nearest landmark error: " + lmAndDist.distance);
        int idx = lmAndDist.index;
        logger.trace("initial guess by landmark: " + idx);
        double[] initialGuess = new double[this.ndims];
        for (int i = 0; i < this.ndims; ++i) {
            initialGuess[i] = this.sourceLandmarks[i][idx];
        }
        logger.trace("initial guess by affine ");
        double[] initialGuessAffine = this.aMatrix != null ? this.inverseGuessAffineInv(target) : target;
        double[] resL = this.apply(initialGuess);
        double[] resA = this.apply(initialGuessAffine);
        for (int i = 0; i < this.ndims; ++i) {
            int n = i;
            resL[n] = resL[n] - target[i];
            int n2 = i;
            resA[n2] = resA[n2] - target[i];
        }
        double errL = ThinPlateR2LogRSplineKernelTransform.normSqrd(resL);
        double errA = ThinPlateR2LogRSplineKernelTransform.normSqrd(resA);
        logger.trace("landmark guess error: " + errL);
        logger.trace("affine guess error  : " + errA);
        if (errA < errL) {
            logger.trace("Using affine initialization");
            initialGuess = initialGuessAffine;
        } else {
            logger.trace("Using landmark initialization");
        }
        return initialGuess;
    }

    public double[] inverseGuessAffineInv(double[] target) {
        DMatrixRMaj mtx = new DMatrixRMaj(this.ndims + 1, this.ndims + 1);
        DMatrixRMaj vec = new DMatrixRMaj(this.ndims + 1, 1);
        for (int i = 0; i < this.ndims; ++i) {
            for (int j = 0; j < this.ndims; ++j) {
                if (i == j) {
                    mtx.set(i, j, 1.0 + this.aMatrix[i][j]);
                    continue;
                }
                mtx.set(i, j, this.aMatrix[i][j]);
            }
            mtx.set(i, this.ndims, this.bVector[i]);
            vec.set(i, 0, target[i]);
        }
        mtx.set(this.ndims, this.ndims, 1.0);
        vec.set(this.ndims, 0, 1.0);
        DMatrixRMaj res = new DMatrixRMaj(this.ndims + 1, 1);
        CommonOps_DDRM.solve((DMatrixRMaj)mtx, (DMatrixRMaj)vec, (DMatrixRMaj)res);
        DMatrixRMaj test = new DMatrixRMaj(this.ndims + 1, 1);
        CommonOps_DDRM.mult((DMatrix1Row)mtx, (DMatrix1Row)res, (DMatrix1Row)test);
        logger.trace("test result: " + test);
        double[] resOut = new double[this.ndims];
        System.arraycopy(res.data, 0, resOut, 0, this.ndims);
        return resOut;
    }

    public double inverse(double[] target, double[] result, double tolerance, int maxIters) {
        assert (tolerance > 0.0);
        double[] guess = this.initialGuessAtInverse(target);
        double error = this.inverseTol(target, guess, tolerance, maxIters);
        for (int d = 0; d < this.ndims; ++d) {
            result[d] = guess[d];
        }
        return error;
    }

    public double[] inverse(double[] target, double tolerance) {
        double[] out = new double[this.ndims];
        this.inverse(target, out, tolerance, 100000);
        return out;
    }

    public double inverseTol(double[] target, double[] guess, double tolerance, int maxIters) {
        double c = 1.0E-4;
        double beta = 0.7;
        double error = 999.0 * tolerance;
        double[] guessXfm = new double[this.ndims];
        this.apply(guess, guessXfm);
        double[][] mtx = this.jacobian(guess);
        TransformInverseGradientDescent inv = new TransformInverseGradientDescent(this.ndims, this);
        inv.setTarget(target);
        inv.setEstimate(guess);
        inv.setEstimateXfm(guessXfm);
        inv.setJacobian(mtx);
        double t0 = error = inv.getError();
        double t = 1.0;
        for (int k = 0; error >= tolerance && k < maxIters; ++k) {
            logger.trace("iteration : " + k);
            mtx = this.jacobian(guess);
            inv.setJacobian(mtx);
            inv.computeDirection();
            logger.trace("initial step size: " + t0);
            t = inv.backtrackingLineSearch(1.0E-4, 0.7, 15, t0);
            logger.trace("final step size  : " + t);
            if (t == 0.0) break;
            inv.updateEstimate(t);
            inv.updateError();
            TransformInverseGradientDescent.copyVectorIntoArray(inv.getEstimate(), guess);
            this.apply(guess, guessXfm);
            t0 = error;
            inv.setEstimateXfm(guessXfm);
            error = inv.getError();
            logger.trace("guess       : " + XfmUtils.printArray(guess));
            logger.trace("guessXfm    : " + XfmUtils.printArray(guessXfm));
            logger.trace("error vector: " + XfmUtils.printArray(inv.getErrorVector().data));
            logger.trace("error       : " + NormOps_DDRM.normP2((DMatrixRMaj)inv.getErrorVector()));
            logger.trace("abs error   : " + error);
            logger.trace("");
        }
        return error;
    }

    protected void srcPtDisplacement(int i, int j, double[] res) {
        for (int d = 0; d < this.ndims; ++d) {
            res[d] = this.sourceLandmarks[d][i] - this.sourceLandmarks[d][j];
        }
    }

    protected void srcPtDisplacement(int i, double[] pt, double[] res) {
        for (int d = 0; d < this.ndims; ++d) {
            res[d] = this.sourceLandmarks[d][i] - pt[d];
        }
    }

    protected void tgtPtDisplacement(int i, double[] pt, double[] res) {
        this.apply(pt, res);
        for (int d = 0; d < this.ndims; ++d) {
            int n = d;
            res[n] = res[n] - pt[d];
        }
    }

    public static double r2Logr(double r) {
        double nrm = 0.0;
        if (r > 1.0E-8) {
            nrm = r * r * Math.log(r);
        }
        return nrm;
    }

    public static double r2LogrFromDisplacement(double[] displacement) {
        double s = 0.0;
        for (int d = 0; d < displacement.length; ++d) {
            s += displacement[d] * displacement[d];
        }
        if (s <= 1.0E-8) {
            return 0.0;
        }
        return 0.5 * s * Math.log(s);
    }

    private static class IndexDistancePair {
        final int index;
        final double distance;

        public IndexDistancePair(int i, double d) {
            this.index = i;
            this.distance = d;
        }
    }
}

