/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import ij.IJ;
import ij.ImageJ;
import ij3d.Pipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public class MeshMaker {
    private static final float phi = (1.0f + (float)Math.sqrt(5.0)) / 2.0f;
    private static final float[][] icosahedron = new float[][]{{phi, 1.0f, 0.0f}, {-phi, 1.0f, 0.0f}, {phi, -1.0f, 0.0f}, {-phi, -1.0f, 0.0f}, {1.0f, 0.0f, phi}, {1.0f, 0.0f, -phi}, {-1.0f, 0.0f, phi}, {-1.0f, 0.0f, -phi}, {0.0f, phi, 1.0f}, {0.0f, -phi, 1.0f}, {0.0f, phi, -1.0f}, {0.0f, -phi, -1.0f}};
    private static final int[][] icosfaces = new int[][]{{0, 8, 4}, {0, 5, 10}, {2, 4, 9}, {2, 11, 5}, {1, 6, 8}, {1, 10, 7}, {3, 9, 6}, {3, 7, 11}, {0, 10, 8}, {1, 8, 10}, {2, 9, 11}, {3, 11, 9}, {4, 2, 0}, {5, 0, 2}, {6, 1, 3}, {7, 3, 1}, {8, 6, 4}, {9, 4, 6}, {10, 5, 7}, {11, 7, 5}};

    public static void main(String[] args) {
        new ImageJ();
        IJ.runPlugIn((String)"ij3d.Mesh_Maker", (String)"");
    }

    public static List<Point3f> createSphere(double x, double y, double z, double r) {
        return MeshMaker.createSphere(x, y, z, r, 12, 12);
    }

    public static List<Point3f> createSphere(double x, double y, double z, double r, int meridians, int parallels) {
        double[][][] globe = MeshMaker.generateGlobe(meridians, parallels);
        for (int j = 0; j < globe.length; ++j) {
            for (int k = 0; k < globe[0].length; ++k) {
                globe[j][k][0] = globe[j][k][0] * r + x;
                globe[j][k][1] = globe[j][k][1] * r + y;
                globe[j][k][2] = globe[j][k][2] * r + z;
            }
        }
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        for (int j = 0; j < globe.length - 1; ++j) {
            for (int k = 0; k < globe[0].length - 1; ++k) {
                if (j != globe.length - 2) {
                    list.add(new Point3f((float)globe[j + 1][k + 1][0], (float)globe[j + 1][k + 1][1], (float)globe[j + 1][k + 1][2]));
                    list.add(new Point3f((float)globe[j][k][0], (float)globe[j][k][1], (float)globe[j][k][2]));
                    list.add(new Point3f((float)globe[j + 1][k][0], (float)globe[j + 1][k][1], (float)globe[j + 1][k][2]));
                }
                if (j == 0) continue;
                list.add(new Point3f((float)globe[j][k][0], (float)globe[j][k][1], (float)globe[j][k][2]));
                list.add(new Point3f((float)globe[j + 1][k + 1][0], (float)globe[j + 1][k + 1][1], (float)globe[j + 1][k + 1][2]));
                list.add(new Point3f((float)globe[j][k + 1][0], (float)globe[j][k + 1][1], (float)globe[j][k + 1][2]));
            }
        }
        return list;
    }

    public static List<Point3f> createQuadSphere(double x, double y, double z, double r, int meridians, int parallels) {
        double[][][] globe = MeshMaker.generateGlobe(meridians, parallels);
        for (int j = 0; j < globe.length; ++j) {
            for (int k = 0; k < globe[0].length; ++k) {
                globe[j][k][0] = globe[j][k][0] * r + x;
                globe[j][k][1] = globe[j][k][1] * r + y;
                globe[j][k][2] = globe[j][k][2] * r + z;
            }
        }
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        for (int j = 0; j < globe.length - 1; ++j) {
            for (int k = 0; k < globe[0].length - 1; ++k) {
                list.add(new Point3f((float)globe[j][k][0], (float)globe[j][k][1], (float)globe[j][k][2]));
                list.add(new Point3f((float)globe[j + 1][k][0], (float)globe[j + 1][k][1], (float)globe[j + 1][k][2]));
                list.add(new Point3f((float)globe[j + 1][k + 1][0], (float)globe[j + 1][k + 1][1], (float)globe[j + 1][k + 1][2]));
                list.add(new Point3f((float)globe[j][k + 1][0], (float)globe[j][k + 1][1], (float)globe[j][k + 1][2]));
            }
        }
        return list;
    }

    public static double[][][] generateGlobe(int meridians, int parallels) {
        if (meridians < 3) {
            meridians = 3;
        }
        if (parallels < 3) {
            parallels = 3;
        }
        double angle_increase = Math.PI * 2 / (double)meridians;
        double temp_angle = 0.0;
        double[][] xy_points = new double[meridians + 1][2];
        xy_points[0][0] = 1.0;
        xy_points[0][1] = 0.0;
        for (int m = 1; m < meridians; ++m) {
            temp_angle = angle_increase * (double)m;
            xy_points[m][0] = Math.cos(temp_angle);
            xy_points[m][1] = Math.sin(temp_angle);
        }
        xy_points[xy_points.length - 1][0] = 1.0;
        xy_points[xy_points.length - 1][1] = 0.0;
        angle_increase = Math.PI / (double)parallels;
        double[][][] xyz = new double[parallels + 1][xy_points.length][3];
        for (int p = 1; p < xyz.length - 1; ++p) {
            double radius = Math.sin(angle_increase * (double)p);
            double Z = Math.cos(angle_increase * (double)p);
            for (int mm = 0; mm < xyz[0].length - 1; ++mm) {
                xyz[p][mm][0] = xy_points[mm][0] * radius;
                xyz[p][mm][1] = xy_points[mm][1] * radius;
                xyz[p][mm][2] = Z;
            }
            xyz[p][xyz[0].length - 1][0] = xyz[p][0][0];
            xyz[p][xyz[0].length - 1][1] = xyz[p][0][1];
            xyz[p][xyz[0].length - 1][2] = xyz[p][0][2];
        }
        for (int ns = 0; ns < xyz[0].length; ++ns) {
            xyz[0][ns][0] = 0.0;
            xyz[0][ns][1] = 0.0;
            xyz[0][ns][2] = 1.0;
            xyz[xyz.length - 1][ns][0] = 0.0;
            xyz[xyz.length - 1][ns][1] = 0.0;
            xyz[xyz.length - 1][ns][2] = -1.0;
        }
        return xyz;
    }

    public static List<Point3f> createTube(double[] x, double[] y, double[] z, double[] r, int parallels, boolean do_resample) {
        return Pipe.generateTriangles(Pipe.makeTube(x, y, z, r, 1, parallels, do_resample, null, null, null), 1.0, null, null);
    }

    public static List<Point3f> createDisc(double x, double y, double z, double nx, double ny, double nz, double radius, int edgePoints) {
        double az;
        double ay;
        double ax;
        double scale;
        if (Math.abs(nx) >= Math.abs(ny)) {
            scale = 1.0 / Math.sqrt(nx * nx + nz * nz);
            ax = -nz * scale;
            ay = 0.0;
            az = nx * scale;
        } else {
            scale = 1.0 / Math.sqrt(ny * ny + nz * nz);
            ax = 0.0;
            ay = nz * scale;
            az = -ny * scale;
        }
        double bx = ay * nz - az * ny;
        double by = az * nx - ax * nz;
        double bz = ax * ny - ay * nx;
        double bScale = 1.0 / Math.sqrt(bx * bx + by * by + bz * bz);
        bx *= bScale;
        by *= bScale;
        bz *= bScale;
        double[] circleX = new double[edgePoints + 1];
        double[] circleY = new double[edgePoints + 1];
        double[] circleZ = new double[edgePoints + 1];
        for (int i = 0; i < edgePoints + 1; ++i) {
            double angle = (double)(i * 2) * Math.PI / (double)edgePoints;
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            circleX[i] = x + radius * c * ax + radius * s * bx;
            circleY[i] = y + radius * c * ay + radius * s * by;
            circleZ[i] = z + radius * c * az + radius * s * bz;
        }
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        Point3f centre = new Point3f((float)x, (float)y, (float)z);
        for (int i = 0; i < edgePoints; ++i) {
            Point3f t2 = new Point3f((float)circleX[i], (float)circleY[i], (float)circleZ[i]);
            Point3f t3 = new Point3f((float)circleX[i + 1], (float)circleY[i + 1], (float)circleZ[i + 1]);
            list.add(centre);
            list.add(t2);
            list.add(t3);
            list.add(centre);
            list.add(t3);
            list.add(t2);
        }
        return list;
    }

    public static final List<Point3f> createIcosahedron(int subdivisions, float radius) {
        ArrayList<Point3f> ps = new ArrayList<Point3f>();
        for (int i = 0; i < icosfaces.length; ++i) {
            for (int k = 0; k < 3; ++k) {
                ps.add(new Point3f(icosahedron[icosfaces[i][k]]));
            }
        }
        while (subdivisions-- > 0) {
            ArrayList<Point3f> sub = new ArrayList<Point3f>();
            for (int i = 0; i < ps.size(); i += 3) {
                Point3f p0 = (Point3f)ps.get(i);
                Point3f p1 = (Point3f)ps.get(i + 1);
                Point3f p2 = (Point3f)ps.get(i + 2);
                Point3f p01 = new Point3f((p0.x + p1.x) / 2.0f, (p0.y + p1.y) / 2.0f, (p0.z + p1.z) / 2.0f);
                Point3f p02 = new Point3f((p0.x + p2.x) / 2.0f, (p0.y + p2.y) / 2.0f, (p0.z + p2.z) / 2.0f);
                Point3f p12 = new Point3f((p1.x + p2.x) / 2.0f, (p1.y + p2.y) / 2.0f, (p1.z + p2.z) / 2.0f);
                sub.add(p0);
                sub.add(p01);
                sub.add(p02);
                sub.add(new Point3f(p01));
                sub.add(p1);
                sub.add(p12);
                sub.add(new Point3f(p12));
                sub.add(p2);
                sub.add(new Point3f(p02));
                sub.add(new Point3f(p01));
                sub.add(new Point3f(p12));
                sub.add(new Point3f(p02));
            }
            ps = sub;
        }
        Vector3f v = new Vector3f();
        for (Point3f p : ps) {
            v.set((Tuple3f)p);
            v.normalize();
            v.scale(radius);
            p.set((Tuple3f)v);
        }
        return ps;
    }

    public static final List<Point3f> copyTranslated(List<Point3f> ps, float dx, float dy, float dz) {
        HashMap<Point3f, Point3f> m = new HashMap<Point3f, Point3f>();
        ArrayList<Point3f> verts = new ArrayList<Point3f>();
        for (Point3f p : ps) {
            Point3f p2 = (Point3f)m.get(p);
            if (null == p2) {
                p2 = new Point3f(p.x + dx, p.y + dy, p.z + dz);
                m.put(p, p2);
            }
            verts.add(p2);
        }
        return verts;
    }
}

