/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.export.ProgressWriter;
import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarpData;
import bigwarp.BigWarpExporter;
import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public class BigWarpRealExporter<T extends RealType<T> & NativeType<T>>
extends BigWarpExporter<T> {
    private final T baseType;

    public BigWarpRealExporter(BigWarpData<T> bwData, List<ConverterSetup> convSetups, Interpolation interp, T baseType, boolean needConversion, ProgressWriter progress) {
        super(bwData, convSetups, interp, progress);
        this.baseType = baseType;
    }

    public BigWarpRealExporter(BigWarpData<T> bwData, List<ConverterSetup> convSetups, Interpolation interp, T baseType, ProgressWriter progress) {
        this(bwData, convSetups, interp, baseType, false, progress);
    }

    public static <T> boolean isTypeListFullyConsistent(List<SourceAndConverter<T>> sources, int[] movingSourceIndexList) {
        Object baseType = sources.get(movingSourceIndexList[0]).getSpimSource().getType();
        for (int i = 1; i < movingSourceIndexList.length; ++i) {
            int idx = movingSourceIndexList[i];
            Object type = sources.get(idx).getSpimSource().getType();
            if (baseType.getClass().equals(type.getClass())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isTypeListFullyConsistent(List<SourceAndConverter<T>> sources, List<Integer> movingSourceIndexList) {
        Object baseType = sources.get(movingSourceIndexList.get(0)).getSpimSource().getType();
        for (int i = 1; i < movingSourceIndexList.size(); ++i) {
            int idx = movingSourceIndexList.get(i);
            Object type = sources.get(idx).getSpimSource().getType();
            if (baseType.getClass().equals(type.getClass())) continue;
            return false;
        }
        return true;
    }

    @Override
    public RandomAccessibleInterval<T> exportRai() {
        ArrayList raiList = new ArrayList();
        int numChannels = this.singleChannelNoStack ? 1 : this.bwData.numMovingSources();
        for (int i = 0; i < numChannels; ++i) {
            raiList.add(this.exportRai(this.bwData.getMovingSourceForExport(i).getSpimSource()));
        }
        if (this.singleChannelNoStack) {
            return (RandomAccessibleInterval)raiList.get(0);
        }
        return Views.stack(raiList);
    }

    @Override
    public RandomAccessibleInterval<?> exportRai(Source<?> src) {
        this.buildTotalRenderTransform();
        AffineTransform3D srcXfm = new AffineTransform3D();
        src.getSourceTransform(0, 0, srcXfm);
        RealRandomAccessible raiRaw = src.getInterpolatedSource(0, 0, this.interp);
        AffineTransform3D pixelToPhysical = this.pixelRenderToPhysical.copy().inverse();
        pixelToPhysical.concatenate(srcXfm);
        AffineRandomAccessible rai = RealViews.affine((RealRandomAccessible)raiRaw, (AffineGet)pixelToPhysical);
        return Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)rai), (Interval)this.outputInterval);
    }

    @Override
    public boolean isRGB() {
        return false;
    }

    @Override
    public ImagePlus export() {
        int numChannels = this.bwData.numMovingSources();
        RandomAccessibleInterval<T> raiStack = this.exportRai();
        FinalVoxelDimensions voxdim = new FinalVoxelDimensions(this.unit, new double[]{this.resolutionTransform.get(0, 0), this.resolutionTransform.get(1, 1), this.resolutionTransform.get(2, 2)});
        ImagePlus ip = null;
        if (this.isVirtual) {
            ip = ImageJFunctions.wrap((RandomAccessibleInterval)Views.translateInverse(raiStack, (long[])Intervals.minAsLongArray(raiStack)), (String)"warped_moving_image");
            ip.setDimensions(numChannels, (int)raiStack.dimension(2), 1);
        } else if (this.nThreads == 1) {
            ip = BigWarpRealExporter.copyToImageStack(raiStack, raiStack, this.progress);
        } else {
            ImagePlusImgFactory factory = new ImagePlusImgFactory((NativeType)this.baseType);
            if (this.outputInterval.numDimensions() == 3) {
                long[] dimensions = new long[]{this.outputInterval.dimension(0), this.outputInterval.dimension(1), numChannels, this.outputInterval.dimension(2)};
                FinalInterval destIntervalPerm = new FinalInterval(dimensions);
                RandomAccessibleInterval<T> img = this.copyToImageStack(raiStack, (Interval)destIntervalPerm, factory, this.nThreads);
                ip = ((ImagePlusImg)img).getImagePlus();
            } else if (this.outputInterval.numDimensions() == 2) {
                long[] dimensions = new long[]{this.outputInterval.dimension(0), this.outputInterval.dimension(1), numChannels, 1L};
                FinalInterval destIntervalPerm = new FinalInterval(dimensions);
                RandomAccessibleInterval img = this.copyToImageStack(Views.addDimension((RandomAccessible)Views.extendMirrorDouble(raiStack)), (Interval)destIntervalPerm, factory, this.nThreads);
                ip = ((ImagePlusImg)img).getImagePlus();
            }
        }
        ip.getCalibration().pixelWidth = voxdim.dimension(0);
        ip.getCalibration().pixelHeight = voxdim.dimension(1);
        ip.getCalibration().pixelDepth = voxdim.dimension(2);
        ip.getCalibration().setUnit(voxdim.unit());
        if (this.offsetTransform != null) {
            ip.getCalibration().xOrigin = this.offsetTransform.get(0, 3);
            ip.getCalibration().yOrigin = this.offsetTransform.get(1, 3);
            ip.getCalibration().zOrigin = this.offsetTransform.get(2, 3);
        }
        ip.setTitle(this.bwData.getMovingSource(0).getSpimSource().getName() + this.nameSuffix);
        return ip;
    }

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus copyToImageStack(RandomAccessible<T> rai, Interval itvl, ProgressWriter progress) {
        MixedTransformView raip = rai.numDimensions() > 3 ? Views.permute(rai, (int)2, (int)3) : rai;
        long[] dimensions = new long[itvl.numDimensions()];
        for (int d = 0; d < itvl.numDimensions(); ++d) {
            dimensions[d] = d == 2 && itvl.numDimensions() > 3 ? itvl.dimension(3) : (d == 3 && itvl.numDimensions() > 3 ? itvl.dimension(2) : itvl.dimension(d));
        }
        NumericType t = (NumericType)rai.randomAccess().get();
        ImagePlusImgFactory factory = new ImagePlusImgFactory((NativeType)t);
        ImagePlusImg target = factory.create(dimensions);
        long[] dims = new long[target.numDimensions()];
        target.dimensions(dims);
        long N = Intervals.numElements((Dimensions)itvl);
        PlanarCursor c = target.cursor();
        RandomAccess ra = raip.randomAccess();
        double k = 0.0;
        while (c.hasNext()) {
            c.fwd();
            ra.setPosition((Localizable)c);
            ((NumericType)c.get()).set((Type)ra.get());
            if (k % 10000.0 == 0.0) {
                progress.setProgress(k / (double)N);
            }
            k += 1.0;
        }
        progress.setProgress(1.0);
        try {
            return target.getImagePlus();
        }
        catch (ImgLibException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus copyToImageStack(RealRandomAccessible<T> rai, Interval itvl) {
        long[] dimensions = new long[itvl.numDimensions()];
        itvl.dimensions(dimensions);
        NumericType t = (NumericType)rai.realRandomAccess().get();
        ImagePlusImgFactory factory = new ImagePlusImgFactory((NativeType)t);
        ImagePlusImg target = factory.create((Dimensions)itvl);
        double k = 0.0;
        long N = dimensions[0] * dimensions[1] * dimensions[2];
        PlanarCursor c = target.cursor();
        RealRandomAccess ra = rai.realRandomAccess();
        while (c.hasNext()) {
            c.fwd();
            ra.setPosition((Localizable)c);
            ((NumericType)c.get()).set((Type)ra.get());
            if (k % 10000.0 == 0.0) {
                IJ.showProgress((double)(k / (double)N));
            }
            k += 1.0;
        }
        IJ.showProgress((double)1.1);
        try {
            return target.getImagePlus();
        }
        catch (ImgLibException e) {
            e.printStackTrace();
            return null;
        }
    }
}

