/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.display.projector.IterableIntervalProjector2D;
import net.imglib2.view.RandomAccessibleIntervalCursor;
import net.imglib2.view.Views;

public class MultithreadedIterableIntervalProjector2D<A, B>
extends IterableIntervalProjector2D<A, B> {
    final ExecutorService service;
    private final int dimX;
    private final int dimY;
    private final int nTasks;

    public MultithreadedIterableIntervalProjector2D(int dimX, int dimY, RandomAccessible<A> source, IterableInterval<B> target, Converter<? super A, B> converter, ExecutorService service, int nTasks) {
        super(dimX, dimY, source, target, converter);
        this.service = service;
        this.dimX = dimX;
        this.dimY = dimY;
        this.nTasks = nTasks;
    }

    public MultithreadedIterableIntervalProjector2D(int dimX, int dimY, RandomAccessible<A> source, IterableInterval<B> target, Converter<? super A, B> converter, ExecutorService service) {
        this(dimX, dimY, source, target, converter, service, Runtime.getRuntime().availableProcessors());
    }

    public void map() {
        for (int d = 0; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[this.dimX] = this.target.min(0);
        this.min[this.dimY] = this.target.min(1);
        this.max[this.dimX] = this.target.max(0);
        this.max[this.dimY] = this.target.max(1);
        final IterableInterval ii = Views.iterable((RandomAccessibleInterval)Views.interval((RandomAccessible)this.source, (Interval)new FinalInterval(this.min, this.max)));
        final long portionSize = this.target.size() / (long)this.nTasks;
        ArrayList<1> tasks = new ArrayList<1>();
        final AtomicInteger ai = new AtomicInteger();
        for (int t = 0; t < this.nTasks; ++t) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    long stepsTaken;
                    int i = ai.getAndIncrement();
                    Cursor targetCursor = MultithreadedIterableIntervalProjector2D.this.target.localizingCursor();
                    RandomAccess sourceRandomAccess = MultithreadedIterableIntervalProjector2D.this.source.randomAccess();
                    sourceRandomAccess.setPosition(MultithreadedIterableIntervalProjector2D.this.position);
                    Cursor sourceCursor = ii.cursor();
                    targetCursor.jumpFwd((long)i * portionSize);
                    sourceCursor.jumpFwd((long)i * portionSize);
                    if (MultithreadedIterableIntervalProjector2D.this.target.iterationOrder().equals(ii.iterationOrder()) && !(sourceCursor instanceof RandomAccessibleIntervalCursor)) {
                        for (stepsTaken = 0L; i != MultithreadedIterableIntervalProjector2D.this.nTasks - 1 && stepsTaken < portionSize || i == MultithreadedIterableIntervalProjector2D.this.nTasks - 1 && targetCursor.hasNext(); ++stepsTaken) {
                            MultithreadedIterableIntervalProjector2D.this.converter.convert(sourceCursor.next(), targetCursor.next());
                        }
                    } else if (MultithreadedIterableIntervalProjector2D.this.target.iterationOrder() instanceof FlatIterationOrder) {
                        long cr = -MultithreadedIterableIntervalProjector2D.this.target.dimension(0);
                        long width = MultithreadedIterableIntervalProjector2D.this.target.dimension(0);
                        long height = MultithreadedIterableIntervalProjector2D.this.target.dimension(1);
                        long initX = (long)i * portionSize % width;
                        long initY = (long)i * portionSize / width;
                        long endX = i == MultithreadedIterableIntervalProjector2D.this.nTasks - 1 ? width : (initX + (long)(i + 1) * portionSize) % width;
                        long endY = i == MultithreadedIterableIntervalProjector2D.this.nTasks - 1 ? height - 1L : (initX + (long)(i + 1) * portionSize) / width;
                        sourceRandomAccess.setPosition(initX, MultithreadedIterableIntervalProjector2D.this.dimX);
                        sourceRandomAccess.setPosition(initY, MultithreadedIterableIntervalProjector2D.this.dimY);
                        for (long y = initY; y <= endY; ++y) {
                            for (long x = y == initY ? initX : 0L; x < (y == endY ? endX : width); ++x) {
                                targetCursor.fwd();
                                MultithreadedIterableIntervalProjector2D.this.converter.convert(sourceRandomAccess.get(), targetCursor.get());
                                sourceRandomAccess.fwd(MultithreadedIterableIntervalProjector2D.this.dimX);
                            }
                            sourceRandomAccess.move(cr, MultithreadedIterableIntervalProjector2D.this.dimX);
                            sourceRandomAccess.fwd(MultithreadedIterableIntervalProjector2D.this.dimY);
                        }
                    } else {
                        while (i != MultithreadedIterableIntervalProjector2D.this.nTasks - 1 && stepsTaken < portionSize || i == MultithreadedIterableIntervalProjector2D.this.nTasks - 1 && targetCursor.hasNext()) {
                            ++stepsTaken;
                            Object b = targetCursor.next();
                            sourceRandomAccess.setPosition(targetCursor.getLongPosition(0), MultithreadedIterableIntervalProjector2D.this.dimX);
                            sourceRandomAccess.setPosition(targetCursor.getLongPosition(1), MultithreadedIterableIntervalProjector2D.this.dimY);
                            MultithreadedIterableIntervalProjector2D.this.converter.convert(sourceRandomAccess.get(), b);
                        }
                    }
                    return null;
                }
            });
        }
        try {
            List futures = this.service.invokeAll(tasks);
            for (Future f : futures) {
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

