/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.ArrayList;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;

public class CalibrationUtils {
    public static void copyCalibrationToImagePlus(ImgPlus<?> imgPlus, ImagePlus imp) {
        CalibratedAxis axis;
        Calibration calibration = imp.getCalibration();
        int xIndex = imgPlus.dimensionIndex(Axes.X);
        int yIndex = imgPlus.dimensionIndex(Axes.Y);
        int zIndex = imgPlus.dimensionIndex(Axes.Z);
        int tIndex = imgPlus.dimensionIndex(Axes.TIME);
        if (xIndex >= 0) {
            calibration.pixelWidth = imgPlus.averageScale(xIndex);
            axis = (CalibratedAxis)imgPlus.axis(xIndex);
            calibration.xOrigin = axis.calibratedValue(0.0);
            calibration.setXUnit(axis.unit());
        }
        if (yIndex >= 0) {
            calibration.pixelHeight = imgPlus.averageScale(yIndex);
            axis = (CalibratedAxis)imgPlus.axis(yIndex);
            calibration.yOrigin = axis.calibratedValue(0.0);
            calibration.setYUnit(axis.unit());
        }
        if (zIndex >= 0) {
            calibration.pixelDepth = imgPlus.averageScale(zIndex);
            axis = (CalibratedAxis)imgPlus.axis(zIndex);
            calibration.zOrigin = axis.calibratedValue(0.0);
            calibration.setZUnit(axis.unit());
        }
        if (tIndex >= 0) {
            calibration.frameInterval = imgPlus.averageScale(tIndex);
            calibration.setTimeUnit(((CalibratedAxis)imgPlus.axis(tIndex)).unit());
        }
    }

    public static CalibratedAxis[] getNonTrivialAxes(ImagePlus image) {
        ArrayList<DefaultLinearAxis> result = new ArrayList<DefaultLinearAxis>();
        Calibration calibration = image.getCalibration();
        result.add(new DefaultLinearAxis(Axes.X, calibration.getXUnit(), calibration.pixelWidth, calibration.xOrigin));
        result.add(new DefaultLinearAxis(Axes.Y, calibration.getYUnit(), calibration.pixelHeight, calibration.yOrigin));
        if (image.getNChannels() > 1) {
            result.add(new DefaultLinearAxis(Axes.CHANNEL));
        }
        if (image.getNSlices() > 1) {
            result.add(new DefaultLinearAxis(Axes.Z, calibration.getZUnit(), calibration.pixelDepth, calibration.zOrigin));
        }
        if (image.getNFrames() > 1) {
            result.add(new DefaultLinearAxis(Axes.TIME, calibration.getTimeUnit(), calibration.frameInterval));
        }
        return result.toArray(new CalibratedAxis[0]);
    }
}

