/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImageStack;
import ij.process.ImageProcessor;

class ImageStackUtils {
    private ImageStackUtils() {
    }

    public static ImageStack duplicate(ImageStack original) {
        return ImageStackUtils.crop(original, 0, 0, 0, original.getWidth(), original.getHeight(), original.getSize());
    }

    public static ImageStack crop(ImageStack stack, int x, int y, int z, int width, int height, int depth) {
        if (x < 0 || y < 0 || z < 0 || x + width > stack.getWidth() || y + height > stack.getHeight() || z + depth > stack.getSize()) {
            throw new IllegalArgumentException("Argument out of range");
        }
        ImageStack result = new ImageStack(width, height, stack.getColorModel());
        for (int i = z; i < z + depth; ++i) {
            ImageProcessor ip = stack.getProcessor(i + 1);
            ip.setRoi(x, y, width, height);
            result.addSlice(stack.getSliceLabel(i + 1), ip.crop());
        }
        return result;
    }

    public static ImageStack convertToFloat(ImageStack stack) {
        ImageStack result = new ImageStack(stack.getWidth(), stack.getHeight(), stack.getColorModel());
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor ip = stack.getProcessor(i);
            result.addSlice(stack.getSliceLabel(i), ip.convertToFloat());
        }
        return result;
    }
}

