/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.AbstractMetadata;
import io.scif.Format;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.Metadata;
import io.scif.filters.MetadataWrapper;
import java.io.IOException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public abstract class AbstractMetadataWrapper
extends AbstractMetadata
implements MetadataWrapper {
    private Metadata meta;

    public AbstractMetadataWrapper() {
        this((Metadata)null);
    }

    public AbstractMetadataWrapper(Metadata metadata) {
        this.meta = metadata;
    }

    @Override
    public Metadata unwrap() {
        return this.meta;
    }

    @Override
    public void wrap(Metadata meta) {
        this.meta = meta;
        this.setSourceLocation(meta.getSourceLocation());
        this.setSource(meta.getSource());
        this.populateImageMetadata();
    }

    @Override
    public MetaTable getTable() {
        return this.meta.getTable();
    }

    @Override
    public void setTable(MetaTable table, boolean passUp) {
        super.setTable(table);
        if (passUp) {
            this.meta.setTable(table);
        }
    }

    @Override
    public void add(ImageMetadata meta, boolean passUp) {
        super.add(meta);
        if (passUp) {
            this.meta.add(meta);
        }
    }

    @Override
    public void add(ImageMetadata meta) {
        this.add(meta, true);
    }

    @Override
    public void setSource(DataHandle<Location> source) {
        if (source != null) {
            this.meta.setSourceLocation((Location)source.get());
        }
        super.setSource(source);
        this.meta.setSource(source);
    }

    @Override
    public void setSourceLocation(Location loc) {
        super.setSourceLocation(loc);
        this.meta.setSourceLocation(loc);
    }

    @Override
    public void populateImageMetadata() {
        this.meta.populateImageMetadata();
    }

    @Override
    public Format getFormat() {
        return this.meta.getFormat();
    }

    @Override
    public String getFormatName() {
        return this.meta.getFormatName();
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.meta.close(fileOnly);
    }
}

