/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.AxisGuesser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.FilePattern;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.FileStitcherMetadata;
import io.scif.filters.Filter;
import io.scif.filters.MetadataWrapper;
import io.scif.io.location.TestImgLocation;
import io.scif.services.FilePatternService;
import io.scif.services.InitializeService;
import java.io.IOException;
import java.util.Arrays;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.TypedAxis;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.DummyLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Filter.class)
public class FileStitcher
extends AbstractReaderFilter {
    @Parameter
    private InitializeService initializeService;
    @Parameter
    private FilePatternService filePatternService;
    @Parameter
    private DataHandleService dataHandleService;
    private boolean patternIds = false;
    private boolean doNotChangePattern = false;
    private long[] planesPerFile;
    private FilePattern pattern;
    private boolean noStitch;
    private long totalPlanes = -1L;
    private Location[] localFiles;

    public FileStitcher() {
        this(false);
    }

    public FileStitcher(boolean patternIds) {
        super((Class<? extends MetadataWrapper>)FileStitcherMetadata.class);
        this.setUsingPatternIds(patternIds);
    }

    public void setUsingPatternIds(boolean patternIds) {
        this.patternIds = patternIds;
    }

    public boolean isUsingPatternIds() {
        return this.patternIds;
    }

    public void setCanChangePattern(boolean doChange) {
        this.doNotChangePattern = !doChange;
    }

    public boolean canChangePattern() {
        return !this.doNotChangePattern;
    }

    public FilePattern getFilePattern() {
        return this.pattern;
    }

    public FilePattern findPattern(BrowsableLocation id) throws IOException {
        return new FilePattern(id, this.filePatternService.findPattern(this.asBrowsable((Location)id)), this.dataHandleService);
    }

    public String[] findPatterns(BrowsableLocation id) throws IOException {
        if (!this.patternIds) {
            return this.filePatternService.findImagePatterns(this.asBrowsable((Location)id));
        }
        if (this.doNotChangePattern) {
            return new String[]{id.getName()};
        }
        this.patternIds = false;
        String[] patterns = this.findPatterns(this.asBrowsable(new FilePattern(this.filePatternService, id, this.dataHandleService).getFiles()[0]));
        if (patterns.length == 0) {
            patterns = new String[]{id.getName()};
        } else {
            FilePattern test = new FilePattern(id, patterns[0], this.dataHandleService);
            if (test.getFiles().length == 0) {
                patterns = new String[]{id.getName()};
            }
        }
        this.patternIds = true;
        return patterns;
    }

    @Override
    public void setSource(Location source, SCIFIOConfig config) throws IOException {
        this.setSourceHelper(source, config);
    }

    @Override
    public void setSource(DataHandle<Location> source, SCIFIOConfig config) throws IOException {
        this.setSourceHelper((Location)source.get(), config);
    }

    @Override
    protected void setSourceHelper(Location source, SCIFIOConfig config) {
        BrowsableLocation browsableSource = this.asBrowsable(source);
        try {
            String[] patterns;
            this.cleanUp();
            this.log().debug((Object)("initFile: " + browsableSource));
            FilePattern fp = new FilePattern(this.filePatternService, browsableSource, this.dataHandleService);
            this.patternIds = !this.patternIds ? fp.isValid() && fp.getFiles().length > 1 : !this.dataHandleService.exists((Location)browsableSource);
            boolean mustGroup = false;
            if (this.patternIds) {
                mustGroup = fp.isValid() && ((Reader)this.getParent()).fileGroupOption(fp.getFiles()[0]) == 0;
            } else {
                boolean bl = mustGroup = ((Reader)this.getParent()).fileGroupOption((Location)browsableSource) == 0;
            }
            if (mustGroup) {
                this.noStitch = true;
                ((Reader)this.getParent()).close();
                if (this.patternIds && fp.isValid()) {
                    ((Reader)this.getParent()).setSource(fp.getFiles()[0], config);
                } else {
                    ((Reader)this.getParent()).setSource((Location)browsableSource, config);
                }
                return;
            }
            if (fp.isRegex()) {
                this.setCanChangePattern(false);
            }
            if ((patterns = this.findPatterns(browsableSource)).length == 0) {
                patterns = new String[]{browsableSource.getName()};
            }
            if (!(fp = new FilePattern(browsableSource, patterns[0], this.dataHandleService)).isValid()) {
                throw new FormatException("Invalid file pattern: " + fp.getPattern());
            }
            Reader reader = (Reader)this.getParent();
            ImageMetadata firstImgMeta = reader.getMetadata().get(0);
            AxisType[] dimOrder = (AxisType[])firstImgMeta.getAxes().stream().map(TypedAxis::type).toArray(AxisType[]::new);
            long sizeZ = firstImgMeta.getAxisLength(Axes.Z);
            long sizeT = firstImgMeta.getAxisLength(Axes.TIME);
            long sizeC = firstImgMeta.getAxisLength(Axes.CHANNEL);
            boolean certain = firstImgMeta.isOrderCertain();
            AxisGuesser ag = new AxisGuesser(fp, dimOrder, sizeZ, sizeT, sizeC, certain);
            FileStitcherMetadata meta = (FileStitcherMetadata)this.getMetadata();
            ImageMetadata imgMeta = firstImgMeta.copy();
            AxisType[] types = ag.getAxisTypes();
            int[] count = fp.getCount();
            for (int i = 0; i < types.length; ++i) {
                imgMeta.setAxisLength(types[i], (long)count[i]);
            }
            imgMeta.setName(fp.getPattern());
            meta.setImgMeta(imgMeta);
            meta.setSourceLocation(fp.getFiles()[0]);
            boolean nPixelsFiles = true;
            if (fp.getFiles().length == 1) {
                this.noStitch = true;
                return;
            }
            String msg = " Please rename your files or disable file stitching.";
            if (!fp.isValid()) {
                throw new FormatException("Invalid " + (this.patternIds ? "file pattern" : "filename") + " (" + browsableSource.getName() + "): " + fp.getErrorMessage() + " Please rename your files or disable file stitching.");
            }
            this.localFiles = fp.getFiles();
            if (this.localFiles == null) {
                throw new FormatException("No files matching pattern (" + fp.getPattern() + "). " + " Please rename your files or disable file stitching.");
            }
            this.planesPerFile = new long[this.localFiles.length];
            for (int i = 0; i < this.localFiles.length; ++i) {
                Location file = this.localFiles[i];
                if (file instanceof DummyLocation || file instanceof TestImgLocation) continue;
                if (!this.dataHandleService.exists(file)) {
                    throw new FormatException("File #" + i + " (" + file + ") does not exist.");
                }
                Reader r = (Reader)this.getParent();
                r.setSource(this.localFiles[i], config);
                if (r.getImageCount() != 1) {
                    this.cleanUp();
                    throw new FormatException("Only one image per source file is supported! \n But " + file.toString() + " contains: " + r.getImageCount());
                }
                this.planesPerFile[i] = r.getPlaneCount(0);
            }
            this.totalPlanes = Arrays.stream(this.planesPerFile).sum();
            this.pattern = fp;
        }
        catch (FormatException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isCompatible(Class<?> c) {
        return ByteArrayReader.class.isAssignableFrom(c);
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return this.totalPlanes;
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        Plane plane = this.createPlane(this.getMetadata().get(imageIndex), bounds);
        return this.openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        Plane bp;
        if (this.noStitch) {
            return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, bounds, new SCIFIOConfig(this.getContext()).groupableSetGroupFiles(false));
        }
        if (plane == null) {
            throw new IllegalArgumentException("Provided plane was null!");
        }
        if (imageIndex != 0) {
            throw new FormatException("only single image sources are supported!");
        }
        if (!this.isCompatible(plane.getClass())) {
            bp = new ByteArrayPlane();
            bp.populate(plane);
            ((ByteArrayPlane)bp).setData(new byte[plane.getBytes().length]);
        } else {
            bp = plane;
        }
        int[] adjustedIndex = this.computeFileIndex(planeIndex);
        if (adjustedIndex[0] < this.localFiles.length && (long)adjustedIndex[1] < this.planesPerFile[imageIndex]) {
            Reader r = (Reader)this.getParent();
            r.setSource(this.localFiles[adjustedIndex[0]]);
            return r.openPlane(0, adjustedIndex[1], bp, bounds, config);
        }
        Arrays.fill(bp.getBytes(), (byte)0);
        return bp;
    }

    public double getPriority() {
        return 3.0;
    }

    private int[] computeFileIndex(long planeIndex) {
        int fileIndex = 0;
        long visitedPlanes = 0L;
        long localIndex = planeIndex;
        int[] outIndex = new int[2];
        while (true) {
            if ((visitedPlanes += this.planesPerFile[fileIndex]) - 1L >= planeIndex) break;
            localIndex -= this.planesPerFile[fileIndex];
            ++fileIndex;
        }
        outIndex[0] = fileIndex;
        outIndex[1] = (int)localIndex;
        return outIndex;
    }

    private BrowsableLocation asBrowsable(Location loc) {
        if (loc instanceof BrowsableLocation) {
            return (BrowsableLocation)loc;
        }
        throw new IllegalArgumentException("The provided location is not browsable!");
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.patternIds = false;
        this.doNotChangePattern = false;
        this.planesPerFile = null;
        this.pattern = null;
        this.noStitch = false;
    }
}

