/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

import io.scif.FormatException;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.JPEG2000Codec;
import io.scif.codec.JPEG2000CodecOptions;
import io.scif.codec.JPEGCodec;
import io.scif.codec.LZWCodec;
import io.scif.codec.LuraWaveCodec;
import io.scif.codec.NikonCodec;
import io.scif.codec.PackbitsCodec;
import io.scif.codec.PassthroughCodec;
import io.scif.codec.ZlibCodec;
import io.scif.enumeration.CodedEnum;
import io.scif.enumeration.EnumException;
import io.scif.formats.tiff.IFD;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum TiffCompression implements CodedEnum
{
    DEFAULT_UNCOMPRESSED(0, PassthroughCodec.class, "Uncompressed"),
    UNCOMPRESSED(1, PassthroughCodec.class, "Uncompressed"),
    CCITT_1D(2, null, "CCITT Group 3 1-Dimensional Modified Huffman"),
    GROUP_3_FAX(3, null, "CCITT T.4 bi-level encoding (Group 3 Fax)"),
    GROUP_4_FAX(4, null, "CCITT T.6 bi-level encoding (Group 4 Fax)"),
    LZW(5, LZWCodec.class, "LZW"),
    OLD_JPEG(6, JPEGCodec.class, "Old JPEG"),
    JPEG(7, JPEGCodec.class, "JPEG"),
    PACK_BITS(32773, PackbitsCodec.class, "PackBits"),
    PROPRIETARY_DEFLATE(32946, ZlibCodec.class, "Deflate (Zlib)"),
    DEFLATE(8, ZlibCodec.class, "Deflate (Zlib)"),
    THUNDERSCAN(32809, null, "Thunderscan"),
    JPEG_2000(33003, JPEG2000Codec.class, "JPEG-2000"){

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = true;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    JPEG_2000_LOSSY(33004, JPEG2000Codec.class, "JPEG-2000 Lossy"){

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = false;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    ALT_JPEG2000(33005, JPEG2000Codec.class, "JPEG-2000"){

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = true;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    ALT_JPEG(33007, JPEGCodec.class, "JPEG"),
    OLYMPUS_JPEG2000(34712, JPEG2000Codec.class, "JPEG-2000"){

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
            return this.getCompressionCodecOptions(ifd, null);
        }

        @Override
        public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
            CodecOptions options = super.getCompressionCodecOptions(ifd, opt);
            options.lossless = true;
            JPEG2000CodecOptions j2k = JPEG2000CodecOptions.getDefaultOptions(options);
            if (opt instanceof JPEG2000CodecOptions) {
                JPEG2000CodecOptions o = (JPEG2000CodecOptions)opt;
                j2k.numDecompositionLevels = o.numDecompositionLevels;
                j2k.resolution = o.resolution;
                if (o.codeBlockSize != null) {
                    j2k.codeBlockSize = o.codeBlockSize;
                }
                if (o.quality > 0.0) {
                    j2k.quality = o.quality;
                }
            }
            return j2k;
        }
    }
    ,
    NIKON(34713, NikonCodec.class, "Nikon"),
    LURAWAVE(65535, LuraWaveCodec.class, "LuraWave");

    private int code;
    private Class<? extends Codec> codecClass;
    private String codecName;
    private static final Map<Integer, TiffCompression> lookup;

    private static Map<Integer, TiffCompression> getCompressionMap() {
        HashMap<Integer, TiffCompression> lookup = new HashMap<Integer, TiffCompression>();
        for (TiffCompression v : EnumSet.allOf(TiffCompression.class)) {
            lookup.put(v.getCode(), v);
        }
        return lookup;
    }

    private TiffCompression(int code, Class<? extends Codec> codecClass, String codecName) {
        this.code = code;
        this.codecClass = codecClass;
        this.codecName = codecName;
    }

    public static TiffCompression get(int code) {
        TiffCompression toReturn = lookup.get(code);
        if (toReturn == null) {
            throw new EnumException("Unable to find TiffCompresssion with code: " + code);
        }
        return toReturn;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public byte[] decompress(CodecService codecService, byte[] input, CodecOptions options) throws FormatException {
        if (this.codecClass == null) {
            throw new UnsupportedCompressionException("Sorry, " + this.getCodecName() + " compression mode is not supported");
        }
        Codec codec = codecService.getCodec(this.codecClass);
        return codec.decompress(input, options);
    }

    public CodecOptions getCompressionCodecOptions(IFD ifd) throws FormatException {
        return this.getCompressionCodecOptions(ifd, null);
    }

    public CodecOptions getCompressionCodecOptions(IFD ifd, CodecOptions opt) throws FormatException {
        if (ifd == null) {
            throw new IllegalArgumentException("No IFD specified.");
        }
        if (opt == null) {
            opt = CodecOptions.getDefaultOptions();
        }
        CodecOptions options = new CodecOptions(opt);
        options.width = (int)ifd.getImageWidth();
        options.height = (int)ifd.getImageLength();
        options.bitsPerSample = ifd.getBitsPerSample()[0];
        options.channels = ifd.getSamplesPerPixel();
        options.littleEndian = ifd.isLittleEndian();
        options.interleaved = true;
        options.signed = false;
        return options;
    }

    public byte[] compress(CodecService codecService, byte[] input, CodecOptions options) throws FormatException {
        if (this.codecClass == null) {
            throw new FormatException("Sorry, " + this.getCodecName() + " compression mode is not supported");
        }
        Codec codec = codecService.getCodec(this.codecClass);
        return codec.compress(input, options);
    }

    static {
        lookup = TiffCompression.getCompressionMap();
    }
}

