/*
 * Decompiled with CFR 0.152.
 */
package io.scif.labeling.utils;

import io.scif.config.SCIFIOConfig;
import io.scif.img.ImgIOException;
import io.scif.img.ImgSaver;
import java.nio.file.Paths;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgView;
import net.imglib2.type.numeric.RealType;
import org.scijava.Context;

public class LabelingUtil {
    public static final String LBL_ENDING = ".lbl.json";
    public static final String TIF_ENDING = ".tif";
    public static final int VERSION = 3;

    public static <T extends RealType<T>> void saveAsTiff(Context context, String filename, RandomAccessibleInterval<T> rai) {
        try {
            new ImgSaver(context).saveImg(filename, ImgView.wrap(rai, null), new SCIFIOConfig().writerSetFailIfOverwriting(false));
        }
        catch (ImgIOException | IncompatibleTypeException e) {
            e.printStackTrace();
        }
    }

    public static String getFilePathWithExtension(String filename, String extension, String path) {
        path = path == null ? "" : path;
        String actualFilename = Paths.get(filename, new String[0]).getFileName().toString();
        if (actualFilename.endsWith(extension)) {
            return Paths.get(path, actualFilename).toString();
        }
        int index = actualFilename.lastIndexOf(".");
        return Paths.get(path, actualFilename.substring(0, index == -1 ? actualFilename.length() : index).concat(extension)).toString();
    }
}

