/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.HessianDetector;
import fiji.plugin.trackmate.detection.LogDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.cli.Configurator;
import ij.ImagePlus;
import java.util.Map;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class HessianDetectorFactory<T extends RealType<T> & NativeType<T>>
extends LogDetectorFactory<T> {
    public static final String DETECTOR_KEY = "HESSIAN_DETECTOR";
    public static final String NAME = "Hessian detector";
    public static final String INFO_TEXT = "<html>This detector is based on computing the determinant of the <br>Hessian matrix of the image to detector bright blobs.  <p>It can be configured with a different spots size in XY and Z. <br>It can also return a normalized quality value, scaled from 0 <br>to 1 for the spots of each time-point.<p>As discussed in Mikolajczyk et al.(2005), this detector has <br>a better edge response elimination than the LoG detector and is <br>suitable for detect spots in images with many strong edges.</html>";

    @Override
    public SpotDetector<T> getDetector(ImgPlus<T> img, Map<String, Object> settings, Interval interval, int frame) {
        double radiusXY = (Double)settings.get("RADIUS");
        double radiusZ = (Double)settings.get("RADIUS_Z");
        double thresholdQuality = (Double)settings.get("THRESHOLD");
        boolean doSubpixel = (Boolean)settings.get("DO_SUBPIXEL_LOCALIZATION");
        boolean normalize = (Boolean)settings.get("NORMALIZE");
        double[] calibration = TMUtils.getSpatialCalibration(img);
        int channel = (Integer)settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval<T> imFrame = DetectionUtils.prepareFrameImg(img, channel, frame);
        HessianDetector detector = new HessianDetector(Views.extendMirrorDouble(imFrame), interval, calibration, radiusXY, radiusZ, thresholdQuality, normalize, doSubpixel);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public boolean forbidMultithreading() {
        return true;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public HessianDetectorCLI getConfigurator(ImagePlus imp) {
        int nChannels = imp == null ? 1 : imp.getNChannels();
        String units = imp == null ? "no image" : imp.getCalibration().getUnit();
        return new HessianDetectorCLI(nChannels, units);
    }

    public static class HessianDetectorCLI
    extends LogDetectorFactory.LogDetectorCLI {
        public HessianDetectorCLI(int nChannels, String units) {
            super(nChannels, units);
            Configurator.DoubleArgument diameterZ = ((Configurator.DoubleAdder)((Configurator.DoubleAdder)((Configurator.DoubleAdder)((Configurator.DoubleAdder)((Configurator.DoubleAdder)this.addDoubleArgument().key("RADIUS_Z")).name("Diameter along Z")).units(units)).defaultValue(8.0)).help("The diameter of the objects to detect along the Z axis.")).get();
            this.setDisplayTranslator(diameterZ, r -> r * 2.0, d -> d / 2.0);
            this.arguments.remove(diameterZ);
            this.arguments.add(2, diameterZ);
            ((Configurator.FlagAdder)((Configurator.FlagAdder)((Configurator.FlagAdder)((Configurator.FlagAdder)this.addFlag().key("NORMALIZE")).name("Normalize quality values")).defaultValue(false)).help("If true, the quality value of each spot is normalized to be between 0 and 1, where 1 is the best quality in the time-point.")).get();
        }
    }
}

