/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection.util;

import fiji.plugin.trackmate.detection.util.SquareNeighborhoodCursor3x3;
import java.util.Iterator;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class SquareNeighborhood3x3<T>
implements Positionable,
IterableInterval<T> {
    private final RandomAccessibleInterval<T> source;
    private final long[] center;
    private final ExtendedRandomAccessibleInterval<T, RandomAccessibleInterval<T>> extendedSource;

    public SquareNeighborhood3x3(RandomAccessibleInterval<T> source, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        this.source = source;
        this.center = new long[source.numDimensions()];
        this.extendedSource = Views.extend(source, outOfBounds);
    }

    public int numDimensions() {
        return this.source.numDimensions();
    }

    public void fwd(int d) {
        int n = d;
        this.center[n] = this.center[n] + 1L;
    }

    public void bck(int d) {
        int n = d;
        this.center[n] = this.center[n] - 1L;
    }

    public void move(int distance, int d) {
        this.center[d] = this.center[d] + (long)distance;
    }

    public void move(long distance, int d) {
        this.center[d] = this.center[d] + distance;
    }

    public void move(Localizable localizable) {
        for (int i = 0; i < this.source.numDimensions(); ++i) {
            this.center[i] = this.center[i] + localizable.getLongPosition(i);
        }
    }

    public void move(int[] distance) {
        for (int i = 0; i < distance.length; ++i) {
            this.center[i] = this.center[i] + (long)distance[i];
        }
    }

    public void move(long[] distance) {
        for (int i = 0; i < distance.length; ++i) {
            this.center[i] = this.center[i] + distance[i];
        }
    }

    public void setPosition(Localizable localizable) {
        localizable.localize(this.center);
    }

    public void setPosition(int[] position) {
        for (int i = 0; i < position.length; ++i) {
            this.center[i] = position[i];
        }
    }

    public void setPosition(long[] position) {
        System.arraycopy(position, 0, this.center, 0, this.center.length);
    }

    public void setPosition(int position, int d) {
        this.center[d] = position;
    }

    public void setPosition(long position, int d) {
        this.center[d] = position;
    }

    public long size() {
        return 9L;
    }

    public T firstElement() {
        RandomAccess ra = this.source.randomAccess();
        ra.setPosition(this.center);
        return (T)ra.get();
    }

    public Object iterationOrder() {
        return this;
    }

    public double realMin(int d) {
        return this.center[d] - 1L;
    }

    public void realMin(double[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.center[d] - 1L;
        }
    }

    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.center.length; ++d) {
            min.setPosition(this.center[d] - 1L, d);
        }
    }

    public double realMax(int d) {
        return this.center[d] + 1L;
    }

    public void realMax(double[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.center[d] + 1L;
        }
    }

    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.center.length; ++d) {
            max.setPosition(this.center[d] + 1L, d);
        }
    }

    public long min(int d) {
        return this.center[d] - 1L;
    }

    public void min(long[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.center[d] - 1L;
        }
    }

    public void min(Positionable min) {
        for (int d = 0; d < this.center.length; ++d) {
            min.setPosition(this.center[d] - 1L, d);
        }
    }

    public long max(int d) {
        return this.center[d] + 1L;
    }

    public void max(long[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.center[d] + 1L;
        }
    }

    public void max(Positionable max) {
        for (int d = 0; d < this.center.length; ++d) {
            max.setPosition(this.center[d] + 1L, d);
        }
    }

    public void dimensions(long[] dimensions) {
        dimensions[0] = 3L;
        dimensions[1] = 3L;
        for (int d = 2; d < dimensions.length; ++d) {
            dimensions[d] = 1L;
        }
    }

    public long dimension(int d) {
        if (d < 2) {
            return 3L;
        }
        return 1L;
    }

    public SquareNeighborhoodCursor3x3<T> cursor() {
        return new SquareNeighborhoodCursor3x3<T>(this.extendedSource, this.center);
    }

    public SquareNeighborhoodCursor3x3<T> localizingCursor() {
        return new SquareNeighborhoodCursor3x3<T>(this.extendedSource, this.center);
    }

    public Iterator<T> iterator() {
        return new SquareNeighborhoodCursor3x3<T>(this.extendedSource, this.center);
    }
}

