/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import fiji.plugin.trackmate.SpotRoi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ConvexHull {
    private static List<Point> makeHull(List<Point> points) {
        ArrayList<Point> newPoints = new ArrayList<Point>(points);
        Collections.sort(newPoints);
        return ConvexHull.makeHullPresorted(newPoints);
    }

    private static List<Point> makeHullPresorted(List<Point> points) {
        if (points.size() <= 1) {
            return new ArrayList<Point>(points);
        }
        ArrayList<Point> upperHull = new ArrayList<Point>();
        for (Point p : points) {
            while (upperHull.size() >= 2) {
                Point q = (Point)upperHull.get(upperHull.size() - 1);
                Point r = (Point)upperHull.get(upperHull.size() - 2);
                if (!((q.x - r.x) * (p.y - r.y) >= (q.y - r.y) * (p.x - r.x))) break;
                upperHull.remove(upperHull.size() - 1);
            }
            upperHull.add(p);
        }
        upperHull.remove(upperHull.size() - 1);
        ArrayList<Point> lowerHull = new ArrayList<Point>();
        for (int i = points.size() - 1; i >= 0; --i) {
            Point p = points.get(i);
            while (lowerHull.size() >= 2) {
                Point q = (Point)lowerHull.get(lowerHull.size() - 1);
                Point r = (Point)lowerHull.get(lowerHull.size() - 2);
                if (!((q.x - r.x) * (p.y - r.y) >= (q.y - r.y) * (p.x - r.x))) break;
                lowerHull.remove(lowerHull.size() - 1);
            }
            lowerHull.add(p);
        }
        lowerHull.remove(lowerHull.size() - 1);
        if (upperHull.size() != 1 || !upperHull.equals(lowerHull)) {
            upperHull.addAll(lowerHull);
        }
        return upperHull;
    }

    public static SpotRoi convexHull(SpotRoi roi) {
        ArrayList<Point> points = new ArrayList<Point>(roi.x.length);
        for (int i = 0; i < roi.x.length; ++i) {
            points.add(new Point(roi.x[i], roi.y[i]));
        }
        List<Point> hull = ConvexHull.makeHull(points);
        double[] xhull = new double[hull.size()];
        double[] yhull = new double[hull.size()];
        for (int i = 0; i < yhull.length; ++i) {
            xhull[i] = hull.get((int)i).x;
            yhull[i] = hull.get((int)i).y;
        }
        return new SpotRoi(xhull, yhull);
    }

    private static final class Point
    implements Comparable<Point> {
        public final double x;
        public final double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Point)) {
                return false;
            }
            Point other = (Point)obj;
            return this.x == other.x && this.y == other.y;
        }

        @Override
        public int compareTo(Point other) {
            if (this.x != other.x) {
                return Double.compare(this.x, other.x);
            }
            return Double.compare(this.y, other.y);
        }
    }
}

