/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.FeatureDisplaySelector;
import fiji.plugin.trackmate.gui.displaysettings.ConfigTrackMateDisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.WrapLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;

public class ConfigureViewsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color BORDER_COLOR = new Color(192, 192, 192);

    public ConfigureViewsPanel(DisplaySettings ds, FeatureDisplaySelector featureSelector, String spaceUnits, Action launchTrackSchemeAction, Action showTrackTablesAction, Action showSpotTableAction, Action launchLabKitAction) {
        this.setPreferredSize(new Dimension(300, 521));
        this.setSize(300, 500);
        GridBagLayout layout = new GridBagLayout();
        layout.columnWeights = new double[]{1.0, 1.0};
        layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.setLayout(layout);
        JLabel lblDisplayOptions = new JLabel();
        lblDisplayOptions.setText("Display options");
        lblDisplayOptions.setFont(Fonts.BIG_FONT);
        lblDisplayOptions.setHorizontalAlignment(2);
        GridBagConstraints gbcLabelDisplayOptions = new GridBagConstraints();
        gbcLabelDisplayOptions.gridwidth = 1;
        gbcLabelDisplayOptions.fill = 1;
        gbcLabelDisplayOptions.insets = new Insets(5, 5, 5, 5);
        gbcLabelDisplayOptions.gridx = 0;
        gbcLabelDisplayOptions.gridy = 0;
        this.add((Component)lblDisplayOptions, gbcLabelDisplayOptions);
        JFrame editor = ConfigTrackMateDisplaySettings.editor(ds, "Configure the display settings used in this current session.", "TrackMate display settings");
        editor.setLocationRelativeTo(this.getParent());
        editor.setDefaultCloseOperation(1);
        JButton btnEditSettings = new JButton("Edit settings", Icons.EDIT_SETTINGS_ICON);
        btnEditSettings.addActionListener(e -> editor.setVisible(!editor.isVisible()));
        GridBagConstraints gbcBtnEditSettings = new GridBagConstraints();
        gbcBtnEditSettings.fill = 0;
        gbcBtnEditSettings.insets = new Insets(5, 5, 5, 5);
        gbcBtnEditSettings.anchor = 13;
        gbcBtnEditSettings.gridx = 1;
        gbcBtnEditSettings.gridy = 0;
        this.add((Component)btnEditSettings, gbcBtnEditSettings);
        JCheckBox chkboxDisplaySpots = new JCheckBox();
        chkboxDisplaySpots.setText("Display spots");
        chkboxDisplaySpots.setFont(Fonts.FONT);
        GridBagConstraints gbcCheckBoxDisplaySpots = new GridBagConstraints();
        gbcCheckBoxDisplaySpots.anchor = 11;
        gbcCheckBoxDisplaySpots.fill = 2;
        gbcCheckBoxDisplaySpots.insets = new Insets(0, 5, 0, 5);
        gbcCheckBoxDisplaySpots.gridx = 0;
        gbcCheckBoxDisplaySpots.gridy = 1;
        this.add((Component)chkboxDisplaySpots, gbcCheckBoxDisplaySpots);
        JCheckBox chkboxDisplaySpotsAsRois = new JCheckBox();
        chkboxDisplaySpotsAsRois.setText("as ROIs");
        GridBagConstraints gbcChkboxDisplaySpotsAsRois = new GridBagConstraints();
        gbcChkboxDisplaySpotsAsRois.insets = new Insets(0, 0, 0, 5);
        gbcChkboxDisplaySpotsAsRois.anchor = 13;
        gbcChkboxDisplaySpotsAsRois.gridx = 1;
        gbcChkboxDisplaySpotsAsRois.gridy = 1;
        this.add((Component)chkboxDisplaySpotsAsRois, gbcChkboxDisplaySpotsAsRois);
        chkboxDisplaySpotsAsRois.setFont(Fonts.FONT);
        chkboxDisplaySpotsAsRois.addActionListener(e -> ds.setSpotDisplayedAsRoi(chkboxDisplaySpotsAsRois.isSelected()));
        chkboxDisplaySpotsAsRois.setSelected(ds.isSpotDisplayedAsRoi());
        JPanel panelSpotOptions = new JPanel();
        panelSpotOptions.setBorder(new LineBorder(BORDER_COLOR, 1, true));
        GridBagConstraints gbcPanelSpotOptions = new GridBagConstraints();
        gbcPanelSpotOptions.gridwidth = 2;
        gbcPanelSpotOptions.insets = new Insets(0, 5, 5, 5);
        gbcPanelSpotOptions.fill = 1;
        gbcPanelSpotOptions.gridx = 0;
        gbcPanelSpotOptions.gridy = 2;
        this.add((Component)panelSpotOptions, gbcPanelSpotOptions);
        GridBagLayout gblPanelSpotOptions = new GridBagLayout();
        gblPanelSpotOptions.columnWeights = new double[]{0.0, 1.0};
        gblPanelSpotOptions.rowWeights = new double[]{0.0, 0.0};
        panelSpotOptions.setLayout(gblPanelSpotOptions);
        JLabel lblSpotRadius = new JLabel("Spot display radius ratio:");
        lblSpotRadius.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblSpotRadius = new GridBagConstraints();
        gbcLblSpotRadius.anchor = 13;
        gbcLblSpotRadius.insets = new Insets(5, 5, 0, 5);
        gbcLblSpotRadius.gridx = 0;
        gbcLblSpotRadius.gridy = 0;
        panelSpotOptions.add((Component)lblSpotRadius, gbcLblSpotRadius);
        JFormattedTextField ftfSpotRadius = new JFormattedTextField();
        GuiUtils.selectAllOnFocus(ftfSpotRadius);
        ftfSpotRadius.setHorizontalAlignment(0);
        ftfSpotRadius.setFont(Fonts.SMALL_FONT);
        ftfSpotRadius.setMinimumSize(new Dimension(80, 20));
        ftfSpotRadius.setColumns(5);
        GridBagConstraints gbcFtfSpotRadius = new GridBagConstraints();
        gbcFtfSpotRadius.insets = new Insets(5, 0, 0, 0);
        gbcFtfSpotRadius.anchor = 17;
        gbcFtfSpotRadius.gridx = 1;
        gbcFtfSpotRadius.gridy = 0;
        panelSpotOptions.add((Component)ftfSpotRadius, gbcFtfSpotRadius);
        JLabel lblSpotName = new JLabel("Display spot names:");
        lblSpotName.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblSpotName = new GridBagConstraints();
        gbcLblSpotName.anchor = 13;
        gbcLblSpotName.insets = new Insets(0, 0, 0, 5);
        gbcLblSpotName.gridx = 0;
        gbcLblSpotName.gridy = 1;
        panelSpotOptions.add((Component)lblSpotName, gbcLblSpotName);
        JCheckBox chkboxSpotNames = new JCheckBox();
        GridBagConstraints gbcChkboxSpotNames = new GridBagConstraints();
        gbcChkboxSpotNames.anchor = 17;
        gbcChkboxSpotNames.gridx = 1;
        gbcChkboxSpotNames.gridy = 1;
        panelSpotOptions.add((Component)chkboxSpotNames, gbcChkboxSpotNames);
        JPanel selectorForSpots = featureSelector.createSelectorForSpots();
        GridBagConstraints gbcCmbboxSpotColor = new GridBagConstraints();
        gbcCmbboxSpotColor.insets = new Insets(0, 5, 5, 5);
        gbcCmbboxSpotColor.fill = 1;
        gbcCmbboxSpotColor.gridwidth = 2;
        gbcCmbboxSpotColor.gridx = 0;
        gbcCmbboxSpotColor.gridy = 3;
        panelSpotOptions.add((Component)selectorForSpots, gbcCmbboxSpotColor);
        JCheckBox chkboxDisplayTracks = new JCheckBox();
        chkboxDisplayTracks.setText("Display tracks");
        chkboxDisplayTracks.setFont(Fonts.FONT);
        GridBagConstraints gbcCheckBoxDisplayTracks = new GridBagConstraints();
        gbcCheckBoxDisplayTracks.anchor = 11;
        gbcCheckBoxDisplayTracks.fill = 2;
        gbcCheckBoxDisplayTracks.insets = new Insets(5, 5, 0, 5);
        gbcCheckBoxDisplayTracks.gridx = 0;
        gbcCheckBoxDisplayTracks.gridy = 3;
        this.add((Component)chkboxDisplayTracks, gbcCheckBoxDisplayTracks);
        JComboBox<DisplaySettings.TrackDisplayMode> cmbboxTrackDisplayMode = new JComboBox<DisplaySettings.TrackDisplayMode>(DisplaySettings.TrackDisplayMode.values());
        GridBagConstraints gbc_cmbboxTrackDisplayMode = new GridBagConstraints();
        gbc_cmbboxTrackDisplayMode.fill = 2;
        gbc_cmbboxTrackDisplayMode.insets = new Insets(5, 0, 0, 5);
        gbc_cmbboxTrackDisplayMode.gridx = 1;
        gbc_cmbboxTrackDisplayMode.gridy = 3;
        this.add(cmbboxTrackDisplayMode, gbc_cmbboxTrackDisplayMode);
        cmbboxTrackDisplayMode.setFont(Fonts.SMALL_FONT);
        cmbboxTrackDisplayMode.addActionListener(e -> ds.setTrackDisplayMode((DisplaySettings.TrackDisplayMode)((Object)((Object)cmbboxTrackDisplayMode.getSelectedItem()))));
        cmbboxTrackDisplayMode.setSelectedItem((Object)ds.getTrackDisplayMode());
        JPanel panelTrackOptions = new JPanel();
        panelTrackOptions.setBorder(new LineBorder(BORDER_COLOR, 1, true));
        GridBagConstraints gbcPanelTrackOptions = new GridBagConstraints();
        gbcPanelTrackOptions.gridwidth = 2;
        gbcPanelTrackOptions.insets = new Insets(0, 5, 5, 5);
        gbcPanelTrackOptions.fill = 1;
        gbcPanelTrackOptions.gridx = 0;
        gbcPanelTrackOptions.gridy = 4;
        this.add((Component)panelTrackOptions, gbcPanelTrackOptions);
        GridBagLayout gblPanelTrackOptions = new GridBagLayout();
        gblPanelTrackOptions.columnWeights = new double[]{0.0, 0.0, 1.0};
        gblPanelTrackOptions.rowWeights = new double[]{0.0, 0.0};
        panelTrackOptions.setLayout(gblPanelTrackOptions);
        JLabel lblFadeTracks = new JLabel("Fade tracks in time:");
        lblFadeTracks.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblFadeTracks = new GridBagConstraints();
        gbcLblFadeTracks.anchor = 13;
        gbcLblFadeTracks.insets = new Insets(0, 5, 0, 5);
        gbcLblFadeTracks.gridx = 0;
        gbcLblFadeTracks.gridy = 0;
        panelTrackOptions.add((Component)lblFadeTracks, gbcLblFadeTracks);
        JCheckBox chkboxFadeTracks = new JCheckBox();
        GridBagConstraints gbcChckbxFadeTracks = new GridBagConstraints();
        gbcChckbxFadeTracks.insets = new Insets(0, 0, 0, 5);
        gbcChckbxFadeTracks.anchor = 17;
        gbcChckbxFadeTracks.gridx = 1;
        gbcChckbxFadeTracks.gridy = 0;
        panelTrackOptions.add((Component)chkboxFadeTracks, gbcChckbxFadeTracks);
        JLabel lblFadeRange = new JLabel("Fade range:");
        lblFadeRange.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblFadeRange = new GridBagConstraints();
        gbcLblFadeRange.anchor = 13;
        gbcLblFadeRange.insets = new Insets(0, 0, 0, 5);
        gbcLblFadeRange.gridx = 0;
        gbcLblFadeRange.gridy = 1;
        panelTrackOptions.add((Component)lblFadeRange, gbcLblFadeRange);
        int fadeTrackRange = Math.min(1000, Math.max(1, ds.getFadeTrackRange()));
        SpinnerNumberModel fadeTrackDepthModel = new SpinnerNumberModel(fadeTrackRange, 1, 1000, 1);
        JSpinner spinnerFadeRange = new JSpinner(fadeTrackDepthModel);
        spinnerFadeRange.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcSpinnerFadeRange = new GridBagConstraints();
        gbcSpinnerFadeRange.insets = new Insets(0, 0, 0, 5);
        gbcSpinnerFadeRange.anchor = 17;
        gbcSpinnerFadeRange.gridx = 1;
        gbcSpinnerFadeRange.gridy = 1;
        panelTrackOptions.add((Component)spinnerFadeRange, gbcSpinnerFadeRange);
        JLabel lblFadeRangeUnits = new JLabel("time-points");
        lblFadeRangeUnits.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcFadeRangeUnit = new GridBagConstraints();
        gbcFadeRangeUnit.anchor = 17;
        gbcFadeRangeUnit.gridx = 2;
        gbcFadeRangeUnit.gridy = 1;
        panelTrackOptions.add((Component)lblFadeRangeUnits, gbcFadeRangeUnit);
        JPanel selectorForTracks = featureSelector.createSelectorForTracks();
        GridBagConstraints gbcCmbboxTrackColor = new GridBagConstraints();
        gbcCmbboxTrackColor.insets = new Insets(5, 5, 5, 5);
        gbcCmbboxTrackColor.fill = 1;
        gbcCmbboxTrackColor.gridwidth = 3;
        gbcCmbboxTrackColor.gridx = 0;
        gbcCmbboxTrackColor.gridy = 3;
        panelTrackOptions.add((Component)selectorForTracks, gbcCmbboxTrackColor);
        FlowLayout flowLayout = new FlowLayout(0, 5, 2);
        JPanel panelDrawingZDepth = new JPanel(flowLayout);
        panelDrawingZDepth.setBorder(new LineBorder(BORDER_COLOR, 1, true));
        GridBagConstraints gbcPanelDrawingZDepth = new GridBagConstraints();
        gbcPanelDrawingZDepth.gridwidth = 2;
        gbcPanelDrawingZDepth.insets = new Insets(0, 5, 5, 5);
        gbcPanelDrawingZDepth.fill = 2;
        gbcPanelDrawingZDepth.gridx = 0;
        gbcPanelDrawingZDepth.gridy = 5;
        this.add((Component)panelDrawingZDepth, gbcPanelDrawingZDepth);
        JCheckBox chckbxLimitZDepth = new JCheckBox("Limit drawing Z depth");
        chckbxLimitZDepth.setFont(Fonts.SMALL_FONT);
        panelDrawingZDepth.add(chckbxLimitZDepth);
        double minZDrawingDepth = 0.5;
        double maxZDrawingDepth = 5000.0;
        double zDrawingDepth = Math.min(Math.max(ds.getZDrawingDepth(), 0.5), 5000.0);
        SpinnerNumberModel numberModelDrawingZDepth = new SpinnerNumberModel(zDrawingDepth, 0.5, 5000.0, 0.5);
        JSpinner spinnerDrawingZDepth = new JSpinner(numberModelDrawingZDepth);
        spinnerDrawingZDepth.setFont(Fonts.SMALL_FONT);
        panelDrawingZDepth.add(spinnerDrawingZDepth);
        JLabel lblDrawingZDepthUnits = new JLabel(spaceUnits);
        lblDrawingZDepthUnits.setFont(Fonts.SMALL_FONT);
        panelDrawingZDepth.add(lblDrawingZDepthUnits);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new WrapLayout());
        JButton btnShowTrackScheme = new JButton(launchTrackSchemeAction);
        panelButtons.add(btnShowTrackScheme);
        btnShowTrackScheme.setFont(Fonts.FONT);
        JButton btnShowTrackTables = new JButton(showTrackTablesAction);
        panelButtons.add(btnShowTrackTables);
        btnShowTrackTables.setFont(Fonts.FONT);
        JButton btnShowSpotTable = new JButton(showSpotTableAction);
        panelButtons.add(btnShowSpotTable);
        btnShowSpotTable.setFont(Fonts.FONT);
        if (TMUtils.isClassPresent("sc.fiji.labkit.ui.LabkitFrame") && launchLabKitAction.isEnabled()) {
            JButton btnLabKit = new JButton(launchLabKitAction);
            btnLabKit.setFont(Fonts.FONT);
            btnLabKit.setText("Launch spot editor");
            btnLabKit.setIcon(GuiUtils.scaleImage(Icons.SEGMENTATION_EDITOR_ICON_64x64, 16, 16));
            btnLabKit.setToolTipText("<html>Launch the Labkit editor to edit spot segmentation<br>on the time-point currently displayed in the main<br>view.<p>Shift + click will launch the editor on all the<br>time-points in the movie.</html>");
            panelButtons.add(btnLabKit);
        }
        panelButtons.setSize(new Dimension(300, 1));
        GridBagConstraints gbcPanelButtons = new GridBagConstraints();
        gbcPanelButtons.gridwidth = 2;
        gbcPanelButtons.anchor = 15;
        gbcPanelButtons.fill = 2;
        gbcPanelButtons.gridx = 0;
        gbcPanelButtons.gridy = 7;
        this.add((Component)panelButtons, gbcPanelButtons);
        this.setSize(new Dimension(300, 1));
        chkboxDisplaySpots.addActionListener(e -> {
            ConfigureViewsPanel.setEnabled(panelSpotOptions, chkboxDisplaySpots.isSelected());
            chkboxDisplaySpotsAsRois.setEnabled(chkboxDisplaySpots.isSelected());
        });
        chkboxDisplayTracks.addActionListener(e -> {
            ConfigureViewsPanel.setEnabled(panelTrackOptions, chkboxDisplayTracks.isSelected());
            cmbboxTrackDisplayMode.setEnabled(chkboxDisplayTracks.isSelected());
        });
        ActionListener fadeTrackBtnEnable = e -> {
            boolean shouldBeEnabled = chkboxDisplayTracks.isSelected() && cmbboxTrackDisplayMode.getSelectedItem() != DisplaySettings.TrackDisplayMode.FULL;
            chkboxFadeTracks.setEnabled(shouldBeEnabled);
        };
        chkboxDisplayTracks.addActionListener(fadeTrackBtnEnable);
        cmbboxTrackDisplayMode.addActionListener(fadeTrackBtnEnable);
        ActionListener fadeTrackRangeEnable = e -> {
            boolean shouldBeEnabled = chkboxDisplayTracks.isSelected() && cmbboxTrackDisplayMode.getSelectedItem() != DisplaySettings.TrackDisplayMode.FULL && chkboxFadeTracks.isSelected();
            spinnerFadeRange.setEnabled(shouldBeEnabled);
        };
        cmbboxTrackDisplayMode.addActionListener(fadeTrackRangeEnable);
        chkboxDisplayTracks.addActionListener(fadeTrackRangeEnable);
        chkboxFadeTracks.addActionListener(fadeTrackRangeEnable);
        chckbxLimitZDepth.addActionListener(e -> spinnerDrawingZDepth.setEnabled(chckbxLimitZDepth.isSelected()));
        chkboxDisplaySpots.addActionListener(e -> ds.setSpotVisible(chkboxDisplaySpots.isSelected()));
        ftfSpotRadius.addPropertyChangeListener("value", e -> ds.setSpotDisplayRadius(((Number)ftfSpotRadius.getValue()).doubleValue()));
        chkboxSpotNames.addActionListener(e -> ds.setSpotShowName(chkboxSpotNames.isSelected()));
        chkboxDisplayTracks.addActionListener(e -> ds.setTrackVisible(chkboxDisplayTracks.isSelected()));
        chkboxFadeTracks.addActionListener(e -> ds.setFadeTracks(chkboxFadeTracks.isSelected()));
        fadeTrackDepthModel.addChangeListener(e -> ds.setFadeTrackRange(fadeTrackDepthModel.getNumber().intValue()));
        numberModelDrawingZDepth.addChangeListener(e -> ds.setZDrawingDepth(((Number)numberModelDrawingZDepth.getValue()).doubleValue()));
        chckbxLimitZDepth.addActionListener(e -> ds.setZDrawingDepthLimited(chckbxLimitZDepth.isSelected()));
        DisplaySettings.UpdateListener l = () -> {
            chkboxDisplaySpots.setSelected(ds.isSpotVisible());
            chkboxDisplaySpotsAsRois.setSelected(ds.isSpotDisplayedAsRoi());
            chkboxSpotNames.setSelected(ds.isSpotShowName());
            chkboxDisplayTracks.setSelected(ds.isTrackVisible());
            chkboxFadeTracks.setSelected(ds.isFadeTracks());
            chckbxLimitZDepth.setSelected(ds.isZDrawingDepthLimited());
            ftfSpotRadius.setValue(ds.getSpotDisplayRadius());
            fadeTrackDepthModel.setValue(ds.getFadeTrackRange());
            numberModelDrawingZDepth.setValue(ds.getZDrawingDepth());
            cmbboxTrackDisplayMode.setSelectedItem((Object)ds.getTrackDisplayMode());
            ConfigureViewsPanel.setEnabled(panelSpotOptions, chkboxDisplaySpots.isSelected());
            ConfigureViewsPanel.setEnabled(panelTrackOptions, chkboxDisplayTracks.isSelected());
        };
        l.displaySettingsChanged();
        ds.listeners().add((Object)l);
        spinnerDrawingZDepth.setEnabled(chckbxLimitZDepth.isSelected());
        fadeTrackBtnEnable.actionPerformed(null);
    }

    private static final void setEnabled(Container container, boolean enabled) {
        for (Component component : container.getComponents()) {
            if (component instanceof JSpinner || component instanceof JCheckBox) continue;
            component.setEnabled(enabled);
            if (!(component instanceof Container)) continue;
            ConfigureViewsPanel.setEnabled((Container)component, enabled);
        }
    }
}

