/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.tracking.kdtree.NearestNeighborTrackerFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class NearestNeighborTrackerSettingsPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private JFormattedTextField maxDistField;
    private final String infoText;
    private final String trackerName;
    private final String spaceUnits;

    public NearestNeighborTrackerSettingsPanel(String trackerName, String infoText, String spaceUnits) {
        this.trackerName = trackerName;
        this.infoText = infoText;
        this.spaceUnits = spaceUnits;
        this.initGUI();
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("LINKING_MAX_DISTANCE", ((Number)this.maxDistField.getValue()).doubleValue());
        return settings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.maxDistField.setValue(settings.get("LINKING_MAX_DISTANCE"));
    }

    private void initGUI() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{164, 40, 54, 0};
        gridBagLayout.rowHeights = new int[]{0, 40, 225, 30, 60};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblSettingsForTracker = new JLabel();
        lblSettingsForTracker.setFont(Fonts.FONT);
        GridBagConstraints gbcLblSettingsForTracker = new GridBagConstraints();
        gbcLblSettingsForTracker.fill = 1;
        gbcLblSettingsForTracker.insets = new Insets(0, 0, 5, 0);
        gbcLblSettingsForTracker.gridwidth = 3;
        gbcLblSettingsForTracker.gridx = 0;
        gbcLblSettingsForTracker.gridy = 0;
        this.add((Component)lblSettingsForTracker, gbcLblSettingsForTracker);
        JLabel labelTracker = new JLabel(this.trackerName, NearestNeighborTrackerFactory.ICON, 0);
        labelTracker.setFont(Fonts.BIG_FONT);
        GridBagConstraints gbcLabelTracker = new GridBagConstraints();
        gbcLabelTracker.fill = 1;
        gbcLabelTracker.insets = new Insets(0, 0, 5, 0);
        gbcLabelTracker.gridwidth = 3;
        gbcLabelTracker.gridx = 0;
        gbcLabelTracker.gridy = 1;
        this.add((Component)labelTracker, gbcLabelTracker);
        GridBagConstraints gbcLabelTrackerDescription = new GridBagConstraints();
        gbcLabelTrackerDescription.anchor = 11;
        gbcLabelTrackerDescription.fill = 1;
        gbcLabelTrackerDescription.insets = new Insets(0, 0, 5, 0);
        gbcLabelTrackerDescription.gridwidth = 3;
        gbcLabelTrackerDescription.gridx = 0;
        gbcLabelTrackerDescription.gridy = 2;
        this.add((Component)GuiUtils.textInScrollPanel(GuiUtils.infoDisplay(this.infoText)), gbcLabelTrackerDescription);
        JLabel lblMaximalLinkingDistance = new JLabel("Maximal linking distance: ");
        lblMaximalLinkingDistance.setFont(Fonts.FONT);
        GridBagConstraints gbcLblMaximalLinkingDistance = new GridBagConstraints();
        gbcLblMaximalLinkingDistance.fill = 1;
        gbcLblMaximalLinkingDistance.insets = new Insets(0, 0, 0, 5);
        gbcLblMaximalLinkingDistance.gridx = 0;
        gbcLblMaximalLinkingDistance.gridy = 3;
        this.add((Component)lblMaximalLinkingDistance, gbcLblMaximalLinkingDistance);
        this.maxDistField = new JFormattedTextField(15.0);
        this.maxDistField.setHorizontalAlignment(0);
        this.maxDistField.setFont(Fonts.FONT);
        GridBagConstraints gbcMaxDistField = new GridBagConstraints();
        gbcMaxDistField.fill = 1;
        gbcMaxDistField.insets = new Insets(0, 0, 0, 5);
        gbcMaxDistField.gridx = 1;
        gbcMaxDistField.gridy = 3;
        this.add((Component)this.maxDistField, gbcMaxDistField);
        GuiUtils.selectAllOnFocus(this.maxDistField);
        JLabel labelUnits = new JLabel(this.spaceUnits);
        labelUnits.setFont(Fonts.FONT);
        GridBagConstraints gbcLabelUnits = new GridBagConstraints();
        gbcLabelUnits.anchor = 17;
        gbcLabelUnits.fill = 3;
        gbcLabelUnits.gridx = 2;
        gbcLabelUnits.gridy = 3;
        this.add((Component)labelUnits, gbcLabelUnits);
    }

    @Override
    public void clean() {
    }
}

