/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.jdom2.Element;

public class DisplaySettingsIO {
    private static File userDefaultFile = new File(new File(System.getProperty("user.home"), ".trackmate"), "userdefaultsettings.json");

    public static void toXML(DisplaySettings ds, Element dsel) {
        dsel.setText(DisplaySettingsIO.toJson(ds));
    }

    public static String toJson(DisplaySettings ds) {
        return DisplaySettingsIO.getGson().toJson((Object)ds);
    }

    public static DisplaySettings fromJson(String str) {
        DisplaySettings ds = str == null || str.isEmpty() ? DisplaySettingsIO.readUserDefault() : (DisplaySettings)DisplaySettingsIO.getGson().fromJson(str, DisplaySettings.class);
        double spotMin = ds.getSpotMin();
        double spotMax = ds.getSpotMax();
        ds.setSpotMinMax(Math.min(spotMin, spotMax), Math.max(spotMin, spotMax));
        double trackMin = ds.getTrackMin();
        double trackMax = ds.getTrackMax();
        ds.setTrackMinMax(Math.min(trackMin, trackMax), Math.max(trackMin, trackMax));
        return ds;
    }

    private static Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Colormap.class, (Object)new ColormapSerializer());
        builder.registerTypeAdapter(Color.class, (Object)new ColorSerializer());
        builder.registerTypeAdapter(Font.class, (Object)new FontTypeAdapter());
        return builder.setPrettyPrinting().create();
    }

    public static void saveToUserDefault(DisplaySettings ds) {
        String str = DisplaySettingsIO.toJson(ds);
        if (!userDefaultFile.exists()) {
            userDefaultFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(userDefaultFile);){
            writer.append(str);
        }
        catch (IOException e) {
            System.err.println("Could not write the user default settings to " + userDefaultFile);
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DisplaySettings readUserDefault() {
        if (!userDefaultFile.exists()) {
            DisplaySettings ds = DisplaySettings.defaultStyle().copy("User-default");
            DisplaySettingsIO.saveToUserDefault(ds);
            return ds;
        }
        try (FileReader reader = new FileReader(userDefaultFile);){
            String str = Files.lines(Paths.get(userDefaultFile.getAbsolutePath(), new String[0])).collect(Collectors.joining(System.lineSeparator()));
            DisplaySettings displaySettings = DisplaySettingsIO.fromJson(str);
            return displaySettings;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not find the user default settings file: " + userDefaultFile + ". Using built-in default setting.");
            e.printStackTrace();
            return DisplaySettings.defaultStyle().copy();
        }
        catch (IOException e) {
            System.err.println("Could not read the user default settings file: " + userDefaultFile + ". Using built-in default setting.");
            e.printStackTrace();
        }
        return DisplaySettings.defaultStyle().copy();
    }

    public static void main(String[] args) {
        System.out.println(DisplaySettingsIO.readUserDefault());
    }

    private static final class ColorSerializer
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        private ColorSerializer() {
        }

        public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
            String colorStr = String.format("%d, %d, %d, %d", src.getRed(), src.getGreen(), src.getBlue(), src.getAlpha());
            return new JsonPrimitive(colorStr);
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String str = json.getAsString();
            String[] split = str.split(",");
            if (split.length != 4) {
                return Color.WHITE;
            }
            try {
                int[] rgba = new int[4];
                for (int i = 0; i < rgba.length; ++i) {
                    rgba[i] = Integer.parseInt(split[i].trim());
                }
                return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return Color.WHITE;
            }
        }
    }

    private static final class ColormapSerializer
    implements JsonSerializer<Colormap>,
    JsonDeserializer<Colormap> {
        private ColormapSerializer() {
        }

        public JsonElement serialize(Colormap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonPrimitive cmapObj = new JsonPrimitive(src.getName());
            return cmapObj;
        }

        public Colormap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsString();
            for (Colormap colormap : Colormap.getAvailableLUTs()) {
                if (!colormap.getName().equals(name)) continue;
                return colormap;
            }
            return DisplaySettings.defaultStyle().getColormap();
        }
    }

    private static class FontTypeAdapter
    extends TypeAdapter<Font> {
        private FontTypeAdapter() {
        }

        public void write(JsonWriter out, Font value) throws IOException {
            out.beginObject();
            out.name("name").value(value.getName());
            out.name("style").value((long)value.getStyle());
            out.name("size").value((long)value.getSize());
            out.endObject();
        }

        public Font read(JsonReader in) throws IOException {
            String name = null;
            int style = 0;
            int size = 12;
            in.beginObject();
            block10: while (in.hasNext()) {
                String fieldName;
                switch (fieldName = in.nextName()) {
                    case "name": {
                        name = in.nextString();
                        continue block10;
                    }
                    case "style": {
                        style = in.nextInt();
                        continue block10;
                    }
                    case "size": {
                        size = in.nextInt();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Font(name, style, size);
        }
    }
}

