/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapManager;
import bdv.util.BdvOptions;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMBasicLabelingComponent;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMKeymapManager;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitActions;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabelPanel;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMImageLabelingModel;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMLabKitModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.imglib2.Dimensions;
import net.imglib2.util.Intervals;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.MouseAndKeyHandler;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.LabelingModel;
import sc.fiji.labkit.ui.panel.GuiUtils;
import sc.fiji.labkit.ui.utils.Notifier;

public class TMLabKitFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    static final String KEYMAP_HOME = new File(new File(System.getProperty("user.home"), ".trackmate"), "editor").getAbsolutePath();
    static final String KEY_CONFIG_CONTEXT = "trackmate-labkit";
    static final CommandDescriptionProvider.Scope KEY_CONFIG_SCOPE = new CommandDescriptionProvider.Scope("trackmate-labkit");
    private final Notifier onCloseListeners = new Notifier();

    public TMLabKitFrame(TMLabKitModel model) {
        TMImageLabelingModel imageLabelingModel = model.imageLabelingModel();
        AppearanceManager appearanceManager = new AppearanceManager(KEYMAP_HOME);
        KeymapManager bdvKeymapManager = new KeymapManager();
        Keymap bdvKeymap = bdvKeymapManager.getForwardSelectedKeymap();
        bdvKeymap.set(TMKeymapManager.loadBDVKeymap());
        BdvOptions options = BdvOptions.options().inputTriggerConfig(bdvKeymap.getConfig()).keymapManager(bdvKeymapManager).appearanceManager(appearanceManager);
        if (imageLabelingModel.spatialDimensions().numDimensions() < 3) {
            options.is2D();
        }
        TMBasicLabelingComponent mainPanel = new TMBasicLabelingComponent(this, imageLabelingModel, options);
        JPanel leftPanel = new JPanel();
        BoxLayout layout = new BoxLayout(leftPanel, 3);
        leftPanel.setLayout(layout);
        JPanel trackmatePanel = TMLabKitFrame.createTrackMatePanel();
        leftPanel.add(trackmatePanel);
        leftPanel.add(Box.createVerticalStrut(5));
        JPanel imageInfoPanel = TMLabKitFrame.newFramedImageInfoPanel(imageLabelingModel, mainPanel);
        imageInfoPanel.getComponents()[1].setBackground(UIManager.getColor("Panel.background"));
        leftPanel.add(imageInfoPanel);
        JPanel labelInfoPanel = GuiUtils.createCheckboxGroupedPanel((Holder)imageLabelingModel.labelingVisibility(), (String)"Spots", (JComponent)new TMLabelPanel((LabelingModel)imageLabelingModel));
        leftPanel.add(labelInfoPanel);
        InputActionBindings keybindings = new InputActionBindings();
        TriggerBehaviourBindings triggerbindings = new TriggerBehaviourBindings();
        SwingUtilities.replaceUIActionMap(this.getRootPane(), keybindings.getConcatenatedActionMap());
        SwingUtilities.replaceUIInputMap(this.getRootPane(), 1, keybindings.getConcatenatedInputMap());
        MouseAndKeyHandler mouseAndKeyHandler = new MouseAndKeyHandler();
        mouseAndKeyHandler.setInputMap(triggerbindings.getConcatenatedInputTriggerMap());
        mouseAndKeyHandler.setBehaviourMap(triggerbindings.getConcatenatedBehaviourMap());
        this.addHandler(mouseAndKeyHandler);
        TMKeymapManager keymapManager = new TMKeymapManager();
        InputTriggerConfig inputTriggerConfig = keymapManager.getForwardSelectedKeymap().getConfig();
        Actions myActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{KEY_CONFIG_CONTEXT});
        myActions.install(keybindings, "trackmate-labkit-actions");
        myActions.install(mainPanel.getBdvHandle().getKeybindings(), "trackmate-labkit-actions");
        Behaviours myBehaviours = new Behaviours((InputTriggerAdder.Factory)inputTriggerConfig, new String[]{KEY_CONFIG_CONTEXT});
        myBehaviours.install(triggerbindings, "trackmate-labkit-actions");
        myBehaviours.install(mainPanel.getBdvHandle().getTriggerbindings(), "trackmate-labkit-actions");
        Keymap keymap = keymapManager.getForwardSelectedKeymap();
        keymap.updateListeners().add(() -> {
            myActions.updateKeyConfig(keymap.getConfig());
            myBehaviours.updateKeyConfig(keymap.getConfig());
        });
        myActions.updateKeyConfig(keymap.getConfig());
        myBehaviours.updateKeyConfig(keymap.getConfig());
        TMLabKitActions.install(myActions, model, this, keybindings, keymapManager, appearanceManager);
        mainPanel.install(myActions, myBehaviours);
        this.add(this.initGui(mainPanel, leftPanel));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                TMLabKitFrame.this.onCloseListeners.notifyListeners();
            }
        });
    }

    public Notifier onCloseListeners() {
        return this.onCloseListeners;
    }

    private static JPanel createTrackMatePanel() {
        JPanel dark = new JPanel();
        dark.setLayout(new BorderLayout());
        JPanel title = new JPanel();
        title.setBackground(new Color(200, 200, 200));
        title.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 8pt, fillx", "10[][]10"));
        title.add((Component)new JLabel("TrackMate"), "push");
        dark.setBackground(new Color(200, 200, 200));
        dark.add((Component)title, "First");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        String c = "<html><body style='width: 100%'><p>Close and send to TrackMate</p>";
        panel.add(Box.createHorizontalStrut(5));
        panel.add(new JLabel("<html><body style='width: 100%'><p>Close and send to TrackMate</p>"));
        panel.add(TMLabKitFrame.createCloseButton());
        panel.add(Box.createHorizontalStrut(5));
        dark.add((Component)panel, "Center");
        dark.setMaximumSize(new Dimension(1000, 220));
        return dark;
    }

    private static final JButton createCloseButton() {
        Image img = Icons.TRACKMATE_ICON.getImage();
        Image img2 = img.getScaledInstance(32, 32, 4);
        JButton button = new JButton(new ImageIcon(img2));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = SwingUtilities.getWindowAncestor((Component)e.getSource());
                if (window != null) {
                    window.dispose();
                }
            }
        });
        return button;
    }

    private static JPanel newFramedImageInfoPanel(ImageLabelingModel imageLabelingModel, TMBasicLabelingComponent labelingComponent) {
        JPanel info = GuiUtils.createCheckboxGroupedPanel((Holder)imageLabelingModel.imageVisibility(), (String)"Image", (JComponent)TMLabKitFrame.createDimensionsInfo((Dimensions)imageLabelingModel.labeling().get(), labelingComponent));
        info.setMaximumSize(new Dimension(1000, 200));
        return info;
    }

    private static JComponent createDimensionsInfo(Dimensions interval, TMBasicLabelingComponent labelingComponent) {
        Color background = UIManager.getColor("List.background");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 8, gap 8", "10[grow][grow]", ""));
        panel.setBackground(background);
        JLabel label = new JLabel("Dimensions: " + Arrays.toString(Intervals.dimensionsAsLongArray((Dimensions)interval)));
        panel.add((Component)label, "grow, span, wrap");
        if (labelingComponent != null) {
            JButton button = new JButton("auto contrast");
            button.setFocusable(false);
            button.addActionListener(ignore -> labelingComponent.autoContrast());
            panel.add((Component)button, "grow");
            JButton settingsButton = new JButton("settings");
            settingsButton.setFocusable(false);
            settingsButton.addActionListener(ignore -> labelingComponent.toggleContrastSettings());
            panel.add((Component)settingsButton, "grow, wrap");
        }
        return panel;
    }

    private JSplitPane initGui(JPanel mainPanel, JPanel labelPanel) {
        JSplitPane panel = new JSplitPane();
        panel.setOneTouchExpandable(true);
        panel.setLeftComponent(labelPanel);
        panel.setRightComponent(mainPanel);
        panel.setBorder(BorderFactory.createEmptyBorder());
        return panel;
    }

    public void addHandler(Object h) {
        if (h instanceof KeyListener) {
            this.addKeyListener((KeyListener)h);
        }
        if (h instanceof MouseMotionListener) {
            this.addMouseMotionListener((MouseMotionListener)h);
        }
        if (h instanceof MouseListener) {
            this.addMouseListener((MouseListener)h);
        }
        if (h instanceof MouseWheelListener) {
            this.addMouseWheelListener((MouseWheelListener)h);
        }
        if (h instanceof FocusListener) {
            this.addFocusListener((FocusListener)h);
        }
    }
}

