/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.util.Affine3DHelpers;
import bdv.util.BdvHandle;
import bdv.viewer.ViewerPanel;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Timer;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.Type;
import net.imglib2.util.Intervals;
import net.imglib2.util.LinAlgHelpers;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.ScrollBehaviour;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.Behaviours;
import sc.fiji.labkit.ui.brush.BdvMouseBehaviourUtils;
import sc.fiji.labkit.ui.brush.BrushCursor;
import sc.fiji.labkit.ui.brush.neighborhood.Ellipsoid;
import sc.fiji.labkit.ui.brush.neighborhood.RealPoints;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.LabelingModel;
import sc.fiji.labkit.ui.panel.GuiUtils;
import sc.fiji.labkit.ui.utils.Notifier;

public class TMLabelBrushController {
    private static final String PREF_KEY_PAINT_MODE = "tm.labkit.brush.paintMode";
    private static final String PREF_KEY_ERASE_MODE = "tm.labkit.brush.eraseMode";
    private static final String PREF_KEY_BRUSH_DIAMETER = "tm.labkit.brush.diameter";
    private final BdvHandle bdv;
    private final ViewerPanel viewer;
    private final LabelingModel model;
    private final BrushCursor brushCursor;
    private final MoveBrush moveBrushBehaviour = new MoveBrush();
    private final MouseAdapter moveBrushAdapter = GuiUtils.toMouseListener((DragBehaviour)this.moveBrushBehaviour);
    private final PaintBehavior paintBehaviour = new PaintBehavior(true);
    private final PaintBehavior eraseBehaviour = new PaintBehavior(false);
    private PaintBrushMode paintBrushMode;
    private EraseBrushMode eraseBrushMode;
    private double brushDiameter;
    private final Notifier brushDiameterListeners = new Notifier();
    private boolean keepBrushCursorVisible = false;
    private boolean planarMode = false;
    private static final String PAINT = "paint";
    private static final String ERASE = "erase";
    private static final String CHANGE_BRUSH_RADIUS = "change brush radius";
    private static final String MOVE_BRUSH = "move brush";
    private static final String INCREASE_BRUSH_RADIUS = "increase brush radius";
    private static final String DECREASE_BRUSH_RADIUS = "decrease brush radius";
    private static final String INCREASE_BRUSH_RADIUS_FAST = "increase brush radius fast";
    private static final String DECREASE_BRUSH_RADIUS_FAST = "decrease brush radius fast";
    private static final String[] PAINT_KEYS = new String[]{"A button1", "SPACE button1"};
    private static final String[] ERASE_KEYS = new String[]{"D button1", "SPACE button2", "SPACE button3"};
    private static final String[] CHANGE_BRUSH_RADIUS_KEYS = new String[]{"A scroll", "D scroll", "SPACE scroll"};
    private static final String[] MOVE_BRUSH_KEYS = new String[]{"A", "D", "SPACE"};
    private static final String[] INCREASE_BRUSH_RADIUS_KEYS = new String[]{"E"};
    private static final String[] DECREASE_BRUSH_RADIUS_KEYS = new String[]{"Q"};
    private static final String[] INCREASE_BRUSH_RADIUS_FAST_KEYS = new String[]{"shift E"};
    private static final String[] DECREASE_BRUSH_RADIUS_FAST_KEYS = new String[]{"shift Q"};

    public TMLabelBrushController(BdvHandle bdv, LabelingModel model) {
        this.bdv = bdv;
        this.viewer = bdv.getViewerPanel();
        this.brushCursor = new BrushCursor(model);
        this.model = model;
        this.updateBrushOverlayRadius();
        this.viewer.getDisplay().overlays().add((Object)this.brushCursor);
        this.viewer.transformListeners().add(affineTransform3D -> this.updateBrushOverlayRadius());
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        this.brushDiameter = prefs.getDouble(TMLabelBrushController.class, PREF_KEY_BRUSH_DIAMETER, 1.0);
        this.paintBrushMode = PaintBrushMode.valueOf(prefs.get(TMLabelBrushController.class, PREF_KEY_PAINT_MODE, PaintBrushMode.REPLACE.name()));
        this.eraseBrushMode = EraseBrushMode.valueOf(prefs.get(TMLabelBrushController.class, PREF_KEY_ERASE_MODE, EraseBrushMode.REMOVE_ALL.name()));
    }

    public void setBrushActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive((BdvHandle)this.bdv, (Behaviour)this.paintBehaviour, (boolean)active);
        this.setBrushCursorActive(active);
        this.keepBrushCursorVisible = active;
    }

    public void setEraserActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive((BdvHandle)this.bdv, (Behaviour)this.eraseBehaviour, (boolean)active);
        this.setBrushCursorActive(active);
        this.keepBrushCursorVisible = active;
    }

    private void setBrushCursorActive(boolean visible) {
        if (visible) {
            this.viewer.getDisplay().addMouseListener((MouseListener)this.moveBrushAdapter);
            this.viewer.getDisplay().addMouseMotionListener((MouseMotionListener)this.moveBrushAdapter);
        } else {
            this.viewer.getDisplay().removeMouseListener((MouseListener)this.moveBrushAdapter);
            this.viewer.getDisplay().removeMouseMotionListener((MouseMotionListener)this.moveBrushAdapter);
        }
    }

    public void setBrushDiameter(double brushDiameter) {
        this.brushDiameter = brushDiameter;
        this.updateBrushOverlayRadius();
        this.triggerBrushOverlayRepaint();
        this.brushDiameterListeners.notifyListeners();
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        prefs.put(TMLabelBrushController.class, PREF_KEY_BRUSH_DIAMETER, brushDiameter);
    }

    private void updateBrushOverlayRadius() {
        this.brushCursor.setRadius(this.getBrushDisplayRadius());
    }

    private void triggerBrushOverlayRepaint() {
        this.viewer.getDisplay().repaint();
    }

    public double getBrushDiameter() {
        return this.brushDiameter;
    }

    public Notifier brushDiameterListeners() {
        return this.brushDiameterListeners;
    }

    public void setPaintBrushMode(PaintBrushMode paintBrushMode) {
        this.paintBrushMode = paintBrushMode;
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        prefs.put(TMLabelBrushController.class, PREF_KEY_PAINT_MODE, paintBrushMode.name());
    }

    public void setEraseBrushMode(EraseBrushMode eraseBrushMode) {
        this.eraseBrushMode = eraseBrushMode;
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        prefs.put(TMLabelBrushController.class, PREF_KEY_ERASE_MODE, eraseBrushMode.name());
    }

    public PaintBrushMode getPaintBrushMode() {
        return this.paintBrushMode;
    }

    public EraseBrushMode getEraseBrushMode() {
        return this.eraseBrushMode;
    }

    public void setPlanarMode(boolean planarMode) {
        this.planarMode = planarMode;
    }

    private void makeLabelVisible() {
        Label label = (Label)this.model.selectedLabel().get();
        if (label == null) {
            return;
        }
        if (label.isVisible() && ((Boolean)this.model.labelingVisibility().get()).booleanValue()) {
            return;
        }
        label.setVisible(true);
        this.model.labelingVisibility().set((Object)true);
        this.model.labeling().notifier().notifyListeners();
    }

    private double getBrushDisplayRadius() {
        return this.brushDiameter * 0.5 * this.getScale(this.model.labelTransformation()) * this.getScale(this.paintBehaviour.viewerTransformation());
    }

    private double getScale(AffineTransform3D transformation) {
        return Affine3DHelpers.extractScale((AffineTransform3D)transformation, (int)0);
    }

    private RandomAccessibleInterval<LabelingType<Label>> getFrame() {
        RandomAccessibleInterval frame = (RandomAccessibleInterval)this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)frame, (int)(frame.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return frame;
    }

    private void fireBitmapChanged(RealPoint a, RealPoint b, double radius) {
        radius = radius * (this.brushDiameter + 2.0) / this.brushDiameter;
        long[] min = new long[2];
        long[] max = new long[2];
        for (int d = 0; d < 2; ++d) {
            min[d] = (long)(Math.min(a.getDoublePosition(d), b.getDoublePosition(d)) - radius);
            max[d] = (long)(Math.ceil(Math.max(a.getDoublePosition(d), b.getDoublePosition(d))) + radius);
        }
        this.model.dataChangedNotifier().notifyListeners((Object)new FinalInterval(min, max));
    }

    public void install(Actions actions, Behaviours behaviors) {
        actions.namedAction((AbstractNamedAction)new ChangeBrushRadiusAction(INCREASE_BRUSH_RADIUS, 1.0), INCREASE_BRUSH_RADIUS_KEYS);
        actions.namedAction((AbstractNamedAction)new ChangeBrushRadiusAction(DECREASE_BRUSH_RADIUS, -1.0), DECREASE_BRUSH_RADIUS_KEYS);
        actions.namedAction((AbstractNamedAction)new ChangeBrushRadiusAction(INCREASE_BRUSH_RADIUS_FAST, 5.0), INCREASE_BRUSH_RADIUS_FAST_KEYS);
        actions.namedAction((AbstractNamedAction)new ChangeBrushRadiusAction(DECREASE_BRUSH_RADIUS_FAST, -5.0), DECREASE_BRUSH_RADIUS_FAST_KEYS);
        behaviors.behaviour((Behaviour)this.paintBehaviour, PAINT, PAINT_KEYS);
        behaviors.behaviour((Behaviour)this.eraseBehaviour, ERASE, ERASE_KEYS);
        behaviors.behaviour((Behaviour)new ChangeBrushRadius(), CHANGE_BRUSH_RADIUS, CHANGE_BRUSH_RADIUS_KEYS);
        behaviors.behaviour((Behaviour)this.moveBrushBehaviour, MOVE_BRUSH, MOVE_BRUSH_KEYS);
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(TMLabKitFrame.KEY_CONFIG_SCOPE, new String[]{"trackmate-labkit"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(TMLabelBrushController.PAINT, PAINT_KEYS, "Paint the currently selected label at the mouse position.");
            descriptions.add(TMLabelBrushController.ERASE, ERASE_KEYS, "Erase the currently selected label at the mouse position.");
            descriptions.add(TMLabelBrushController.CHANGE_BRUSH_RADIUS, CHANGE_BRUSH_RADIUS_KEYS, "Change the brush radius.");
            descriptions.add(TMLabelBrushController.MOVE_BRUSH, MOVE_BRUSH_KEYS, "Move the brush.");
            descriptions.add(TMLabelBrushController.INCREASE_BRUSH_RADIUS, INCREASE_BRUSH_RADIUS_KEYS, "Increase the brush radius.");
            descriptions.add(TMLabelBrushController.DECREASE_BRUSH_RADIUS, DECREASE_BRUSH_RADIUS_KEYS, "Decrease the brush radius.");
            descriptions.add(TMLabelBrushController.INCREASE_BRUSH_RADIUS_FAST, INCREASE_BRUSH_RADIUS_FAST_KEYS, "Increase the brush radius fast.");
            descriptions.add(TMLabelBrushController.DECREASE_BRUSH_RADIUS_FAST, DECREASE_BRUSH_RADIUS_FAST_KEYS, "Decrease the brush radius fast.");
        }
    }

    private class MoveBrush
    implements DragBehaviour {
        private MoveBrush() {
        }

        public void init(int x, int y) {
            TMLabelBrushController.this.brushCursor.setPosition(x, y);
            TMLabelBrushController.this.brushCursor.setVisible(true);
            TMLabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(1));
            TMLabelBrushController.this.triggerBrushOverlayRepaint();
        }

        public void drag(int x, int y) {
            TMLabelBrushController.this.brushCursor.setPosition(x, y);
        }

        public void end(int x, int y) {
            TMLabelBrushController.this.brushCursor.setPosition(x, y);
            if (!TMLabelBrushController.this.keepBrushCursorVisible) {
                TMLabelBrushController.this.brushCursor.setVisible(false);
                TMLabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(0));
            }
            TMLabelBrushController.this.triggerBrushOverlayRepaint();
        }
    }

    private class ChangeBrushRadiusAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 1L;
        private final double distance;
        private final Timer timer;

        public ChangeBrushRadiusAction(String name, double distance) {
            super(name);
            this.timer = new Timer(1000, event -> {
                TMLabelBrushController.this.brushCursor.setVisible(false);
                TMLabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(0));
                TMLabelBrushController.this.triggerBrushOverlayRepaint();
            });
            this.distance = distance;
            this.timer.setRepeats(false);
        }

        public void actionPerformed(ActionEvent e) {
            TMLabelBrushController.this.setBrushDiameter(Math.min(Math.max(1.0, TMLabelBrushController.this.brushDiameter + this.distance), 50.0));
            if (TMLabelBrushController.this.viewer.getDisplay().getMousePosition() == null) {
                return;
            }
            int x = ((TMLabelBrushController)TMLabelBrushController.this).viewer.getDisplay().getMousePosition().x;
            int y = ((TMLabelBrushController)TMLabelBrushController.this).viewer.getDisplay().getMousePosition().y;
            TMLabelBrushController.this.brushCursor.setPosition(x, y);
            TMLabelBrushController.this.brushCursor.setVisible(true);
            TMLabelBrushController.this.viewer.setCursor(Cursor.getPredefinedCursor(1));
            TMLabelBrushController.this.triggerBrushOverlayRepaint();
            this.timer.restart();
        }
    }

    private class ChangeBrushRadius
    implements ScrollBehaviour {
        private ChangeBrushRadius() {
        }

        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            if (!isHorizontal) {
                int sign = wheelRotation < 0.0 ? 1 : -1;
                double distance = Math.max(1.0, TMLabelBrushController.this.brushDiameter * 0.1);
                TMLabelBrushController.this.setBrushDiameter(Math.min(Math.max(1.0, TMLabelBrushController.this.brushDiameter + (double)sign * distance), 50.0));
            }
        }
    }

    private class PaintBehavior
    implements DragBehaviour {
        private final boolean paint;
        private RealPoint before;

        public PaintBehavior(boolean paint) {
            this.paint = paint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(RealLocalizable screenCoordinates) {
            ViewerPanel viewerPanel = TMLabelBrushController.this.viewer;
            synchronized (viewerPanel) {
                MixedTransformView extended = this.extendLabelingType((RandomAccessibleInterval<LabelingType<Label>>)TMLabelBrushController.this.getFrame());
                double radius = Math.max(0.0, (TMLabelBrushController.this.brushDiameter - 1.0) * 0.5);
                AffineTransform3D m = this.displayToImageTransformation();
                double[] screen = new double[]{screenCoordinates.getDoublePosition(0), screenCoordinates.getDoublePosition(1), 0.0};
                double[] center = new double[3];
                m.apply(screen, center);
                if (extended.numDimensions() == 3 && TMLabelBrushController.this.planarMode) {
                    extended = Views.hyperSlice(extended, (int)2, (long)Math.round(center[2]));
                }
                AffineTransform3D labelTransform = TMLabelBrushController.this.model.labelTransformation();
                double pixelWidth = RealPoints.length((RealLocalizable)labelTransform.d(0));
                double pixelHeight = RealPoints.length((RealLocalizable)labelTransform.d(1));
                double pixelDepth = RealPoints.length((RealLocalizable)labelTransform.d(2));
                double[] axes = new double[]{radius, radius * pixelWidth / pixelHeight, radius * pixelWidth / pixelDepth};
                if (extended.numDimensions() == 2) {
                    center = Arrays.copyOf(center, 2);
                    axes = Arrays.copyOf(axes, 2);
                }
                IterableRegion region = Ellipsoid.asIterableRegion((double[])center, (double[])axes);
                Regions.sample((IterableRegion)region, (RandomAccessible)extended).forEach(this.pixelOperation());
            }
        }

        private Consumer<LabelingType<Label>> pixelOperation() {
            Label label = (Label)TMLabelBrushController.this.model.selectedLabel().get();
            if (this.paint) {
                if (label != null) {
                    switch (TMLabelBrushController.this.paintBrushMode) {
                        case REPLACE: {
                            return pixel -> {
                                pixel.clear();
                                pixel.add((Object)label);
                            };
                        }
                        case ADD: {
                            return pixel -> pixel.add((Object)label);
                        }
                        case DONT_OVERWRITE: {
                            return pixel -> {
                                if (pixel.isEmpty()) {
                                    pixel.add((Object)label);
                                }
                            };
                        }
                    }
                    throw new IllegalArgumentException("Unknown paint brush mode: " + (Object)((Object)TMLabelBrushController.this.paintBrushMode));
                }
                return pixel -> {};
            }
            switch (TMLabelBrushController.this.eraseBrushMode) {
                case REMOVE_SELECTED: {
                    if (label != null) {
                        return pixel -> pixel.remove((Object)label);
                    }
                }
                case REMOVE_ALL: {
                    List<Label> visibleLabels = this.getVisibleLabels();
                    return pixel -> pixel.removeAll((Collection)visibleLabels);
                }
            }
            throw new IllegalArgumentException("Unknown erase brush mode: " + (Object)((Object)TMLabelBrushController.this.eraseBrushMode));
        }

        private List<Label> getVisibleLabels() {
            List<Label> visibleLabels = ((Labeling)TMLabelBrushController.this.model.labeling().get()).getLabels().stream().filter(Label::isVisible).collect(Collectors.toList());
            return visibleLabels;
        }

        private RandomAccessible<LabelingType<Label>> extendLabelingType(RandomAccessibleInterval<LabelingType<Label>> slice) {
            LabelingType variable = ((LabelingType)slice.randomAccess().setPositionAndGet(Intervals.minAsLongArray(slice))).createVariable();
            variable.clear();
            ExtendedRandomAccessibleInterval extended = Views.extendValue(slice, (Type)variable);
            return extended;
        }

        private AffineTransform3D displayToImageTransformation() {
            AffineTransform3D m = new AffineTransform3D();
            m.concatenate(TMLabelBrushController.this.model.labelTransformation().inverse());
            m.concatenate(this.viewerTransformation().inverse());
            return m;
        }

        private AffineTransform3D viewerTransformation() {
            AffineTransform3D t = new AffineTransform3D();
            TMLabelBrushController.this.viewer.state().getViewerTransform(t);
            return t;
        }

        private void paint(RealLocalizable a, RealLocalizable b) {
            long distance = (long)(4.0 * (this.distance(a, b) + 1.0));
            long step = (long)Math.max(TMLabelBrushController.this.brushDiameter, 1.0);
            for (long i = 0L; i < distance; i += step) {
                this.paint(this.interpolate((double)i / (double)distance, a, b));
            }
        }

        RealLocalizable interpolate(double ratio, RealLocalizable a, RealLocalizable b) {
            RealPoint result = new RealPoint(a.numDimensions());
            for (int d = 0; d < result.numDimensions(); ++d) {
                result.setPosition(ratio * a.getDoublePosition(d) + (1.0 - ratio) * b.getDoublePosition(d), d);
            }
            return result;
        }

        double distance(RealLocalizable a, RealLocalizable b) {
            return LinAlgHelpers.distance((double[])this.asArray(a), (double[])this.asArray(b));
        }

        private double[] asArray(RealLocalizable a) {
            double[] result = new double[a.numDimensions()];
            a.localize(result);
            return result;
        }

        public void init(int x, int y) {
            RealPoint coords;
            TMLabelBrushController.this.brushCursor.setPosition(x, y);
            TMLabelBrushController.this.brushCursor.setFontVisible(false);
            TMLabelBrushController.this.makeLabelVisible();
            this.before = coords = new RealPoint(new float[]{x, y});
            this.paint((RealLocalizable)coords);
            double radius = TMLabelBrushController.this.getBrushDisplayRadius();
            TMLabelBrushController.this.fireBitmapChanged(coords, coords, radius);
        }

        public void drag(int x, int y) {
            TMLabelBrushController.this.brushCursor.setPosition(x, y);
            RealPoint coords = new RealPoint(new float[]{x, y});
            this.paint((RealLocalizable)this.before, (RealLocalizable)coords);
            double radius = TMLabelBrushController.this.getBrushDisplayRadius();
            TMLabelBrushController.this.fireBitmapChanged(this.before, coords, radius);
            this.before = coords;
        }

        public void end(int x, int y) {
            TMLabelBrushController.this.brushCursor.setPosition(x, y);
            TMLabelBrushController.this.brushCursor.setFontVisible(true);
        }
    }

    public static enum EraseBrushMode {
        REMOVE_SELECTED("Selected label", "Remove only the selected label."),
        REMOVE_ALL("All labels", "Remove all labels present at the brush location.");

        private final String name;
        private final String tooltip;

        private EraseBrushMode(String name, String tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        public String toString() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    public static enum PaintBrushMode {
        REPLACE("Replace", "Paint over existing labels."),
        ADD("Add", "Add selected label to existing ones."),
        DONT_OVERWRITE("Preserve", "Don't overwrite existing labels, only paint on background.");

        private final String name;
        private final String tooltip;

        private PaintBrushMode(String name, String tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        public String toString() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }
}

