/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DetectionUtils;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.imagej.ImgPlus;
import net.imagej.ImgPlusMetadata;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.display.imagej.ImgPlusViews;
import net.imglib2.type.Type;
import net.imglib2.util.Util;
import org.scijava.Context;
import org.scijava.util.DoubleArray;

public class TMUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private static Context context;

    public static Interval createROIInterval(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null) {
            return null;
        }
        boolean is3D = !DetectionUtils.is2D(imp);
        long[] min = new long[is3D ? 3 : 2];
        long[] max = new long[min.length];
        min[0] = roi.getBounds().x;
        max[0] = roi.getBounds().x + roi.getBounds().width - 1;
        min[1] = roi.getBounds().y;
        max[1] = roi.getBounds().y + roi.getBounds().height - 1;
        if (is3D) {
            min[2] = 0L;
            max[2] = imp.getNSlices();
        }
        return new FinalInterval(min, max);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, final Comparator<V> comparator) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Comparator c = new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Comparable val1 = (Comparable)o1.getValue();
                Comparable val2 = (Comparable)o2.getValue();
                return comparator.compare(val1, val2);
            }
        };
        Collections.sort(list, c);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static final String echoMap(Map<String, Object> map, int indent) {
        StringBuilder builder = new StringBuilder();
        for (String key : map.keySet()) {
            for (int i = 0; i < indent; ++i) {
                builder.append(" ");
            }
            builder.append("- ");
            builder.append(key.toLowerCase().replace("_", " "));
            builder.append(": ");
            Object obj = map.get(key);
            if (obj instanceof Map) {
                builder.append('\n');
                Map submap = (Map)obj;
                builder.append(TMUtils.echoMap(submap, indent + 2));
                continue;
            }
            if (obj instanceof Logger) {
                builder.append(obj.getClass().getSimpleName());
                builder.append('\n');
                continue;
            }
            builder.append(obj);
            builder.append('\n');
        }
        return builder.toString();
    }

    public static final ImgPlus rawWraps(ImagePlus imp) {
        ImgPlus img;
        ImgPlus raw = img = ImagePlusAdapter.wrapImgPlus((ImagePlus)imp);
        return raw;
    }

    public static final <T> boolean checkMapKeys(Map<T, ?> map, Collection<T> mandatoryKeys, Collection<T> optionalKeys, StringBuilder errorHolder) {
        if (null == optionalKeys) {
            optionalKeys = new ArrayList<T>();
        }
        if (null == mandatoryKeys) {
            mandatoryKeys = new ArrayList<T>();
        }
        boolean ok = true;
        Set<T> keySet = map.keySet();
        for (T key : keySet) {
            if (mandatoryKeys.contains(key) || optionalKeys.contains(key)) continue;
            ok = false;
            errorHolder.append("Map contains unexpected key: " + key + ".\n");
        }
        for (T key : mandatoryKeys) {
            if (keySet.contains(key)) continue;
            ok = false;
            errorHolder.append("Mandatory key " + key + " was not found in the map.\n");
        }
        return ok;
    }

    public static final String checkSettings(Map<String, Object> settings, Map<String, Object> defaultSettings) {
        for (String key : defaultSettings.keySet()) {
            if (!settings.containsKey(key)) {
                return "Missing setting: " + key + ". This is required by the detector.";
            }
            Object value = settings.get(key);
            Class<?> expectedType = defaultSettings.get(key).getClass();
            if (expectedType.isInstance(value)) continue;
            return "Setting " + key + " is of type " + value.getClass().getSimpleName() + ", but expected type is " + expectedType.getSimpleName() + ".";
        }
        return null;
    }

    public static final boolean checkParameter(Map<String, Object> map, String key, Class<?> expectedClass, StringBuilder errorHolder) {
        Object obj = map.get(key);
        if (null == obj) {
            errorHolder.append("Parameter " + key + " could not be found in settings map, or is null.\n");
            return false;
        }
        if (!expectedClass.isInstance(obj)) {
            errorHolder.append("Value for parameter " + key + " is not of the right class. Expected " + expectedClass.getName() + ", got " + obj.getClass().getName() + ".\n");
            return false;
        }
        return true;
    }

    public static final <J, K> List<K> getArrayFromMaping(Collection<J> keys, Map<J, K> mapping) {
        ArrayList<K> names = new ArrayList<K>(keys.size());
        for (J key : keys) {
            names.add(mapping.get(key));
        }
        return names;
    }

    public static final double[] getSpatialCalibration(ImgPlusMetadata img) {
        double[] calibration = Util.getArrayFromValue((double)1.0, (int)3);
        for (int d = 0; d < img.numDimensions(); ++d) {
            if (((CalibratedAxis)img.axis(d)).type() == Axes.X) {
                calibration[0] = img.averageScale(d);
                continue;
            }
            if (((CalibratedAxis)img.axis(d)).type() == Axes.Y) {
                calibration[1] = img.averageScale(d);
                continue;
            }
            if (((CalibratedAxis)img.axis(d)).type() != Axes.Z) continue;
            calibration[2] = img.averageScale(d);
        }
        return calibration;
    }

    public static double[] getSpatialCalibration(ImagePlus imp) {
        double[] calibration = Util.getArrayFromValue((double)1.0, (int)3);
        calibration[0] = imp.getCalibration().pixelWidth;
        calibration[1] = imp.getCalibration().pixelHeight;
        if (imp.getNSlices() > 1) {
            calibration[2] = imp.getCalibration().pixelDepth;
        }
        return calibration;
    }

    public static final double getPercentile(double[] values, double p) {
        int size = values.length;
        if (p > 1.0 || p <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        if (size == 0) {
            return Double.NaN;
        }
        if (size == 1) {
            return values[0];
        }
        double n = size;
        double pos = p * (n + 1.0);
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted = new double[size];
        System.arraycopy(values, 0, sorted, 0, size);
        Arrays.sort(sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= n) {
            return sorted[size - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    private static final double[] getRange(double[] data) {
        if (data.length == 0) {
            return new double[]{1.0, 0.0, 1.0};
        }
        double min = Arrays.stream(data).min().getAsDouble();
        double max = Arrays.stream(data).max().getAsDouble();
        return new double[]{max - min, min, max};
    }

    public static final int getNBins(double[] values, int minBinNumber, int maxBinNumber) {
        int size = values.length;
        double q1 = TMUtils.getPercentile(values, 0.25);
        double q3 = TMUtils.getPercentile(values, 0.75);
        double iqr = q3 - q1;
        double binWidth = 2.0 * iqr * Math.pow(size, -0.33);
        double[] range = TMUtils.getRange(values);
        int nBin = (int)(range[0] / binWidth + 1.0);
        if (nBin > maxBinNumber) {
            nBin = maxBinNumber;
        } else if (nBin < minBinNumber) {
            nBin = minBinNumber;
        }
        return nBin;
    }

    private static final int getNBins(double[] values) {
        return TMUtils.getNBins(values, 8, 256);
    }

    private static final int[] histogram(double[] data, int nBins) {
        double[] range = TMUtils.getRange(data);
        double binWidth = range[0] / (double)nBins;
        int[] hist = new int[nBins];
        if (nBins > 0) {
            for (int i = 0; i < data.length; ++i) {
                int index;
                int n = index = Math.min((int)Math.floor((data[i] - range[1]) / binWidth), nBins - 1);
                hist[n] = hist[n] + 1;
            }
        }
        return hist;
    }

    public static final double otsuThreshold(double[] data) {
        return TMUtils.otsuThreshold(data, TMUtils.getNBins(data));
    }

    private static final double otsuThreshold(double[] data, int nBins) {
        int[] hist = TMUtils.histogram(data, nBins);
        int thresholdIndex = TMUtils.otsuThresholdIndex(hist, data.length);
        double[] range = TMUtils.getRange(data);
        double binWidth = range[0] / (double)nBins;
        return range[1] + binWidth * (double)thresholdIndex;
    }

    private static final int otsuThresholdIndex(int[] hist, int nPoints) {
        int total = nPoints;
        double sum = 0.0;
        for (int t = 0; t < hist.length; ++t) {
            sum += (double)(t * hist[t]);
        }
        double sumB = 0.0;
        int wB = 0;
        int wF = 0;
        double varMax = 0.0;
        int threshold = 0;
        for (int t = 0; t < hist.length; ++t) {
            double mF;
            double varBetween;
            if ((wB += hist[t]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            double mB = (sumB += (double)(t * hist[t])) / (double)wB;
            if (!((varBetween = (double)(wB * wF) * (mB - (mF = (sum - sumB) / (double)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = t;
        }
        return threshold;
    }

    public static final String getUnitsFor(Dimension dimension, String spaceUnits, String timeUnits) {
        switch (dimension) {
            case ANGLE: {
                return "radians";
            }
            case INTENSITY: {
                return "counts";
            }
            case INTENSITY_SQUARED: {
                return "counts^2";
            }
            case NONE: {
                return "";
            }
            case POSITION: 
            case LENGTH: {
                return spaceUnits;
            }
            case AREA: {
                return spaceUnits + "^2";
            }
            case QUALITY: {
                return "quality";
            }
            case COST: {
                return "cost";
            }
            case TIME: {
                return timeUnits;
            }
            case VELOCITY: {
                return spaceUnits + "/" + timeUnits;
            }
            case RATE: {
                return "/" + timeUnits;
            }
            case ANGLE_RATE: {
                return "rad/" + timeUnits;
            }
        }
        return null;
    }

    public static final String getCurrentTimeString() {
        return DATE_FORMAT.format(new Date());
    }

    public static <T extends Type<T>> ImgPlus<T> hyperSlice(ImgPlus<T> img, long channel, long frame) {
        int timeDim = img.dimensionIndex(Axes.TIME);
        ImgPlus imgT = timeDim < 0 ? img : ImgPlusViews.hyperSlice(img, (int)timeDim, (long)frame);
        int channelDim = imgT.dimensionIndex(Axes.CHANNEL);
        ImgPlus imgTC = channelDim < 0 ? imgT : ImgPlusViews.hyperSlice((ImgPlus)imgT, (int)channelDim, (long)channel);
        int zDim = imgTC.dimensionIndex(Axes.Z);
        ImgPlus imgTCZ = zDim >= 0 && imgTC.dimension(zDim) <= 1L ? ImgPlusViews.hyperSlice((ImgPlus)imgTC, (int)zDim, (long)imgTC.min(zDim)) : imgTC;
        return imgTCZ;
    }

    public static final Interval getIntervalWithTime(ImgPlus<?> img, Settings settings) {
        long[] min2;
        long[] max2;
        int cindex;
        int tindex;
        long[] max = new long[img.numDimensions()];
        long[] min = new long[img.numDimensions()];
        int xindex = img.dimensionIndex(Axes.X);
        min[xindex] = settings.getXstart();
        max[xindex] = settings.getXend();
        int yindex = img.dimensionIndex(Axes.Y);
        min[yindex] = settings.getYstart();
        max[yindex] = settings.getYend();
        int zindex = img.dimensionIndex(Axes.Z);
        if (zindex >= 0) {
            min[zindex] = settings.zstart;
            max[zindex] = settings.zend;
        }
        if ((tindex = img.dimensionIndex(Axes.TIME)) >= 0) {
            min[tindex] = settings.tstart;
            max[tindex] = settings.tend;
        }
        if ((cindex = img.dimensionIndex(Axes.CHANNEL)) >= 0) {
            max2 = new long[img.numDimensions() - 1];
            min2 = new long[img.numDimensions() - 1];
            int d2 = 0;
            for (int d = 0; d < min.length; ++d) {
                if (d == cindex) continue;
                min2[d2] = Math.max(0L, min[d]);
                max2[d2] = Math.min(img.max(d), max[d]);
                ++d2;
            }
        } else {
            min2 = new long[min.length];
            max2 = new long[min.length];
            for (int d = 0; d < min.length; ++d) {
                min2[d] = Math.max(0L, min[d]);
                max2[d] = Math.min(img.max(d), max[d]);
            }
        }
        FinalInterval interval = new FinalInterval(min2, max2);
        return interval;
    }

    public static final Interval getInterval(ImgPlus<?> img, Settings settings) {
        long[] intervalMax;
        long[] intervalMin;
        int tindex;
        int cindex;
        long[] max = new long[img.numDimensions()];
        long[] min = new long[img.numDimensions()];
        int xindex = img.dimensionIndex(Axes.X);
        min[xindex] = settings.getXstart();
        max[xindex] = settings.getXend();
        int yindex = img.dimensionIndex(Axes.Y);
        min[yindex] = settings.getYstart();
        max[yindex] = settings.getYend();
        int zindex = img.dimensionIndex(Axes.Z);
        if (zindex >= 0) {
            min[zindex] = settings.zstart;
            max[zindex] = settings.zend;
        }
        if ((cindex = img.dimensionIndex(Axes.CHANNEL)) >= 0) {
            Integer c = (Integer)settings.detectorSettings.get("TARGET_CHANNEL");
            if (null == c) {
                c = 1;
            }
            min[cindex] = c - 1;
            max[cindex] = min[cindex];
        }
        if ((tindex = img.dimensionIndex(Axes.TIME)) >= 0) {
            intervalMin = new long[min.length - 1];
            intervalMax = new long[min.length - 1];
            int nindex = -1;
            for (int d = 0; d < min.length; ++d) {
                if (d == tindex) continue;
                intervalMin[++nindex] = Math.max(0L, min[d]);
                intervalMax[nindex] = Math.min(img.max(d), max[d]);
            }
        } else {
            intervalMin = new long[min.length];
            intervalMax = new long[min.length];
            for (int d = 0; d < min.length; ++d) {
                intervalMin[d] = Math.max(0L, min[d]);
                intervalMax[d] = Math.min(img.max(d), max[d]);
            }
        }
        FinalInterval interval = new FinalInterval(intervalMin, intervalMax);
        return interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        Context localContext = context;
        if (localContext != null) {
            return localContext;
        }
        Class<TMUtils> clazz = TMUtils.class;
        synchronized (TMUtils.class) {
            if (context == null) {
                context = (Context)IJ.runPlugIn((String)"org.scijava.Context", (String)"");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return context;
        }
    }

    public static File proposeTrackMateSaveFile(Settings settings, Logger logger) {
        File file;
        File folder;
        if (null != settings.imp && null != settings.imp.getOriginalFileInfo() && null != settings.imp.getOriginalFileInfo().directory) {
            String directory = settings.imp.getOriginalFileInfo().directory;
            folder = Paths.get(directory, new String[0]).toAbsolutePath().toFile();
            settings.imageFolder = settings.imp.getOriginalFileInfo().directory;
        } else if (null != settings.imageFolder && !settings.imageFolder.isEmpty()) {
            String absolutePath = FileSystems.getDefault().getPath(settings.imageFolder, new String[0]).normalize().toAbsolutePath().toString();
            folder = new File(absolutePath);
        } else {
            folder = new File(System.getProperty("user.dir"));
            logger.error("Warning: The source image does not match a file on the system.TrackMate won't be able to reload it when opening this XML file.\nTo fix this, save the source image to a TIF file before saving the TrackMate session.\n");
            settings.imageFolder = "";
        }
        try {
            file = new File(folder.getPath(), settings.imp.getShortTitle() + ".xml");
        }
        catch (NullPointerException npe) {
            if (settings.imageFileName.isEmpty()) {
                file = new File(folder, "TrackMateData.xml");
            }
            String imName = settings.imageFileName;
            int i = imName.lastIndexOf(46);
            String xmlName = i < 0 ? imName + ".xml" : imName.substring(0, i) + ".xml";
            file = new File(folder, xmlName);
        }
        return file;
    }

    public static final double variance(double[] data) {
        double mean = Util.average((double[])data);
        double variance = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double dx = data[i] - mean;
            variance += dx * dx;
        }
        return variance /= (double)(data.length - 1);
    }

    public static final double standardDeviation(double[] data) {
        return Math.sqrt(TMUtils.variance(data));
    }

    public static double sum(double[] data) {
        return Arrays.stream(data).sum();
    }

    public static double average(DoubleArray data) {
        return TMUtils.sum(data) / (double)data.size();
    }

    public static double sum(DoubleArray data) {
        double sum = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            sum += data.getArray()[i];
        }
        return sum;
    }

    public static final double variance(DoubleArray data) {
        double mean = TMUtils.average(data);
        double variance = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            double dx = data.getArray()[i] - mean;
            variance += dx * dx;
        }
        return variance /= (double)(data.size() - 1);
    }

    public static double standardDeviation(DoubleArray data) {
        return Math.sqrt(TMUtils.variance(data));
    }

    public static String getImagePathWithoutExtension(Settings settings) {
        String imageFolder = settings.imageFolder == null ? System.getProperty("user.home") : settings.imageFolder;
        String imageFileName = settings.imageFileName;
        if (imageFileName != null) {
            int lastIndexOf = imageFileName.lastIndexOf(".");
            if (lastIndexOf > 0) {
                return imageFolder + imageFileName.substring(0, imageFileName.lastIndexOf("."));
            }
            return imageFolder + imageFileName;
        }
        return imageFolder + File.separator + "TrackMate";
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, TMUtils.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private TMUtils() {
    }
}

