/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.swing.util.mxGraphActions;
import fiji.plugin.trackmate.util.TrackNavigator;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeActions;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeGraphComponent;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TrackSchemeKeyboardHandler {
    private final TrackNavigator navigator;
    private final TrackSchemeGraphComponent graphComponent;

    public TrackSchemeKeyboardHandler(TrackSchemeGraphComponent graphComponent, TrackNavigator navigator) {
        this.graphComponent = graphComponent;
        this.navigator = navigator;
    }

    public void installKeyboardActions(JComponent component) {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(component, 0, inputMap);
        SwingUtilities.replaceUIActionMap(component, this.createActionMap());
    }

    protected InputMap getInputMap(int condition) {
        InputMap map = condition == 1 ? (InputMap)UIManager.get("ScrollPane.ancestorInputMap") : new InputMap();
        map.put(KeyStroke.getKeyStroke("F2"), "edit");
        map.put(KeyStroke.getKeyStroke("DELETE"), "delete");
        map.put(KeyStroke.getKeyStroke("HOME"), "home");
        map.put(KeyStroke.getKeyStroke("END"), "end");
        map.put(KeyStroke.getKeyStroke("ADD"), "zoomIn");
        map.put(KeyStroke.getKeyStroke("EQUALS"), "zoomIn");
        map.put(KeyStroke.getKeyStroke("SUBTRACT"), "zoomOut");
        map.put(KeyStroke.getKeyStroke("MINUS"), "zoomOut");
        map.put(KeyStroke.getKeyStroke("shift EQUALS"), "resetZoom");
        map.put(KeyStroke.getKeyStroke(100, 0), "panLeft");
        map.put(KeyStroke.getKeyStroke(102, 0), "panRight");
        map.put(KeyStroke.getKeyStroke(104, 0), "panUp");
        map.put(KeyStroke.getKeyStroke(98, 0), "panDown");
        map.put(KeyStroke.getKeyStroke(105, 0), "panUpRight");
        map.put(KeyStroke.getKeyStroke(99, 0), "panDownRight");
        map.put(KeyStroke.getKeyStroke(97, 0), "panDownLeft");
        map.put(KeyStroke.getKeyStroke(103, 0), "panUpLeft");
        map.put(KeyStroke.getKeyStroke("control A"), "selectAll");
        map.put(KeyStroke.getKeyStroke("control shift A"), "selectNone");
        map.put(KeyStroke.getKeyStroke("UP"), "selectPreviousInTime");
        map.put(KeyStroke.getKeyStroke("DOWN"), "selectNextInTime");
        map.put(KeyStroke.getKeyStroke("RIGHT"), "selectNextSibling");
        map.put(KeyStroke.getKeyStroke("LEFT"), "selectPreviousSibling");
        map.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "selectNextTrack");
        map.put(KeyStroke.getKeyStroke("PAGE_UP"), "selectPreviousTrack");
        return map;
    }

    protected ActionMap createActionMap() {
        ActionMap map = (ActionMap)UIManager.get("ScrollPane.actionMap");
        map.put("edit", TrackSchemeActions.getEditAction(this.graphComponent));
        map.put("delete", mxGraphActions.getDeleteAction());
        map.put("home", TrackSchemeActions.getHomeAction(this.graphComponent));
        map.put("end", TrackSchemeActions.getEndAction(this.graphComponent));
        map.put("zoomIn", TrackSchemeActions.getZoomInAction(this.graphComponent));
        map.put("zoomOut", TrackSchemeActions.getZoomOutAction(this.graphComponent));
        map.put("resetZoom", TrackSchemeActions.getResetZoomAction(this.graphComponent));
        map.put("panUp", TrackSchemeActions.getPanUpAction(this.graphComponent));
        map.put("panDown", TrackSchemeActions.getPanDownAction(this.graphComponent));
        map.put("panLeft", TrackSchemeActions.getPanLeftAction(this.graphComponent));
        map.put("panRight", TrackSchemeActions.getPanRightAction(this.graphComponent));
        map.put("panUpLeft", TrackSchemeActions.getPanUpLeftAction(this.graphComponent));
        map.put("panDownLeft", TrackSchemeActions.getPanDownLeftAction(this.graphComponent));
        map.put("panUpRight", TrackSchemeActions.getPanUpRightAction(this.graphComponent));
        map.put("panDownRight", TrackSchemeActions.getPanDownRightAction(this.graphComponent));
        map.put("selectNone", TrackSchemeActions.getSelectNoneAction());
        map.put("selectAll", TrackSchemeActions.getSelectAllAction());
        map.put("selectPreviousInTime", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TrackSchemeKeyboardHandler.this.navigator.previousInTime();
            }
        });
        map.put("selectNextInTime", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TrackSchemeKeyboardHandler.this.navigator.nextInTime();
            }
        });
        map.put("selectNextSibling", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TrackSchemeKeyboardHandler.this.navigator.nextSibling();
            }
        });
        map.put("selectPreviousSibling", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TrackSchemeKeyboardHandler.this.navigator.previousSibling();
            }
        });
        map.put("selectNextTrack", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TrackSchemeKeyboardHandler.this.navigator.nextTrack();
            }
        });
        map.put("selectPreviousTrack", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TrackSchemeKeyboardHandler.this.navigator.previousTrack();
            }
        });
        return map;
    }
}

